use strict;

BEGIN {
  die "The Win32::Setupsup module works only on Windows NT\nOS unsupported\n"
      unless eval { Win32::IsWinNT() };

  if ($] < 5.006) {
    print STDERR <<"";
  This Makefile.PL requires Perl 5.6 or better.
  Use Win32::Setupsup 1.01 with older versions of Perl:
    http://www.cpan.org/modules/by-module/Win32/setupsup.1.0.1.0.zip

    exit 1;
  } # end if version too small
}

use warnings;

use Config qw(%Config);
use ExtUtils::MakeMaker 6.30;

if ($Config{cc} =~ /gcc/i) {
  print STDERR <<"";
  Sorry, but Win32::Setupsup uses Microsoft's Structured Exception Handling,
  which is not supported by MinGW's gcc.  Therefore, it does not work with
  Strawberry Perl.  Porting help is welcome.

  die "OS unsupported\n";
}

#---------------------------------------------------------------------

my %args = (
  NAME           => 'Win32::Setupsup',
  AUTHOR         => 'Christopher J. Madsen <perl@cjmweb.net>',
  ABSTRACT       => 'Remote control for Windows applications',
  DEFINE         => '-DPERL_5_6_0',
  OBJECT => 'list.obj misc.obj plmisc.obj setupsup.obj wstring.obj resource.res',
  VERSION_FROM   => 'Setupsup.pm', # finds $VERSION
  'BUILD_REQUIRES' => {
    'Test::More' => '0',
    'Win32::TieRegistry' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'PREREQ_PM' => {
    'DynaLoader' => '0',
    'Exporter' => '0',
    'Win32::Registry' => '0'
  },
  'LICENSE' => 'gpl',
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $args{BUILD_REQUIRES};
  my $pp = $args{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $args{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

delete $args{LICENSE}
  unless eval { ExtUtils::MakeMaker->VERSION(6.31) };

my $mm = WriteMakefile(%args);

#---------------------------------------------------------------------
print "Exporting version number to afxres.h\n";

my $version = $mm->{VERSION};
$version =~ /^(\d+)\.(\d+)(\d)/ or die "Can't understand version '$version'";
my $versionnum = "$1,$2,$3,0";

open(VER, '>afxres.h') or die "Can't create afxres.h: $!";
print VER <<"";
// This file was automatically generated by Makefile.PL\n
#include "winres.h"\n
#define SETUPSUP_VERSION    "$version"
#define SETUPSUP_VERSION_NUM $versionnum

close VER;
