// Code generated by cuelang.org/go/pkg/gen. DO NOT EDIT.

package strconv

import (
	"cuelang.org/go/internal/core/adt"
	"cuelang.org/go/internal/pkg"
)

func init() {
	pkg.Register("strconv", p)
}

var _ = adt.TopKind // in case the adt package isn't used

var p = &pkg.Package{
	Native: []*pkg.Builtin{{
		Name: "Unquote",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret, c.Err = Unquote(s)
			}
		},
	}, {
		Name: "ParseBool",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.BoolKind,
		Func: func(c *pkg.CallCtxt) {
			str := c.String(0)
			if c.Do() {
				c.Ret, c.Err = ParseBool(str)
			}
		},
	}, {
		Name: "FormatBool",
		Params: []pkg.Param{
			{Kind: adt.BoolKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			b := c.Bool(0)
			if c.Do() {
				c.Ret = FormatBool(b)
			}
		},
	}, {
		Name: "ParseFloat",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			s, bitSize := c.String(0), c.Int(1)
			if c.Do() {
				c.Ret, c.Err = ParseFloat(s, bitSize)
			}
		},
	}, {
		Name:  "IntSize",
		Const: "64",
	}, {
		Name: "ParseUint",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			s, base, bitSize := c.String(0), c.Int(1), c.Int(2)
			if c.Do() {
				c.Ret, c.Err = ParseUint(s, base, bitSize)
			}
		},
	}, {
		Name: "ParseInt",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			s, base, bitSize := c.String(0), c.Int(1), c.Int(2)
			if c.Do() {
				c.Ret, c.Err = ParseInt(s, base, bitSize)
			}
		},
	}, {
		Name: "Atoi",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret, c.Err = Atoi(s)
			}
		},
	}, {
		Name: "FormatFloat",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			f, fmt, prec, bitSize := c.Float64(0), c.Byte(1), c.Int(2), c.Int(3)
			if c.Do() {
				c.Ret = FormatFloat(f, fmt, prec, bitSize)
			}
		},
	}, {
		Name: "FormatUint",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			i, base := c.BigInt(0), c.Int(1)
			if c.Do() {
				c.Ret = FormatUint(i, base)
			}
		},
	}, {
		Name: "FormatInt",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			i, base := c.BigInt(0), c.Int(1)
			if c.Do() {
				c.Ret = FormatInt(i, base)
			}
		},
	}, {
		Name: "Quote",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = Quote(s)
			}
		},
	}, {
		Name: "QuoteToASCII",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = QuoteToASCII(s)
			}
		},
	}, {
		Name: "QuoteToGraphic",
		Params: []pkg.Param{
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			s := c.String(0)
			if c.Do() {
				c.Ret = QuoteToGraphic(s)
			}
		},
	}, {
		Name: "QuoteRune",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			r := c.Rune(0)
			if c.Do() {
				c.Ret = QuoteRune(r)
			}
		},
	}, {
		Name: "QuoteRuneToASCII",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			r := c.Rune(0)
			if c.Do() {
				c.Ret = QuoteRuneToASCII(r)
			}
		},
	}, {
		Name: "QuoteRuneToGraphic",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			r := c.Rune(0)
			if c.Do() {
				c.Ret = QuoteRuneToGraphic(r)
			}
		},
	}, {
		Name: "IsPrint",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.BoolKind,
		Func: func(c *pkg.CallCtxt) {
			r := c.Rune(0)
			if c.Do() {
				c.Ret = IsPrint(r)
			}
		},
	}, {
		Name: "IsGraphic",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.BoolKind,
		Func: func(c *pkg.CallCtxt) {
			r := c.Rune(0)
			if c.Do() {
				c.Ret = IsGraphic(r)
			}
		},
	}},
}
