# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=lunarlake -instruction-tables < %s | FileCheck %s

crc32b      %al, %ecx
crc32b      (%rax), %ecx

crc32l      %eax, %ecx
crc32l      (%rax), %ecx

crc32w      %ax, %ecx
crc32w      (%rax), %ecx

crc32b      %al, %rcx
crc32b      (%rax), %rcx

crc32q      %rax, %rcx
crc32q      (%rax), %rcx

pcmpestri   $1, %xmm0, %xmm2
pcmpestri   $1, (%rax), %xmm2

pcmpestrm   $1, %xmm0, %xmm2
pcmpestrm   $1, (%rax), %xmm2

pcmpistri   $1, %xmm0, %xmm2
pcmpistri   $1, (%rax), %xmm2

pcmpistrm   $1, %xmm0, %xmm2
pcmpistrm   $1, (%rax), %xmm2

pcmpgtq     %xmm0, %xmm2
pcmpgtq     (%rax), %xmm2

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                        crc32b	%al, %ecx
# CHECK-NEXT:  1      7     1.33    *                   crc32b	(%rax), %ecx
# CHECK-NEXT:  1      3     1.00                        crc32l	%eax, %ecx
# CHECK-NEXT:  1      7     1.33    *                   crc32l	(%rax), %ecx
# CHECK-NEXT:  1      3     1.00                        crc32w	%ax, %ecx
# CHECK-NEXT:  1      7     1.33    *                   crc32w	(%rax), %ecx
# CHECK-NEXT:  1      3     1.00                        crc32b	%al, %rcx
# CHECK-NEXT:  1      7     1.33    *                   crc32b	(%rax), %rcx
# CHECK-NEXT:  1      3     1.00                        crc32q	%rax, %rcx
# CHECK-NEXT:  1      7     1.33    *                   crc32q	(%rax), %rcx
# CHECK-NEXT:  8      16    3.00                        pcmpestri	$1, %xmm0, %xmm2
# CHECK-NEXT:  8      31    3.00    *                   pcmpestri	$1, (%rax), %xmm2
# CHECK-NEXT:  9      16    3.00                        pcmpestrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  9      17    3.00    *                   pcmpestrm	$1, (%rax), %xmm2
# CHECK-NEXT:  3      11    3.00                        pcmpistri	$1, %xmm0, %xmm2
# CHECK-NEXT:  4      31    3.00    *                   pcmpistri	$1, (%rax), %xmm2
# CHECK-NEXT:  3      11    3.00                        pcmpistrm	$1, %xmm0, %xmm2
# CHECK-NEXT:  4      15    3.00    *                   pcmpistrm	$1, (%rax), %xmm2
# CHECK-NEXT:  1      3     1.50                        pcmpgtq	%xmm0, %xmm2
# CHECK-NEXT:  1      9     2.00    *                   pcmpgtq	(%rax), %xmm2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - LNLPPort00
# CHECK-NEXT: [1]   - LNLPPort01
# CHECK-NEXT: [2]   - LNLPPort02
# CHECK-NEXT: [3]   - LNLPPort03
# CHECK-NEXT: [4]   - LNLPPort04
# CHECK-NEXT: [5]   - LNLPPort05
# CHECK-NEXT: [6]   - LNLPPort10
# CHECK-NEXT: [7]   - LNLPPort11
# CHECK-NEXT: [8]   - LNLPPort20
# CHECK-NEXT: [9]   - LNLPPort21
# CHECK-NEXT: [10]  - LNLPPort22
# CHECK-NEXT: [11]  - LNLPPort25
# CHECK-NEXT: [12]  - LNLPPort26
# CHECK-NEXT: [13]  - LNLPPort27
# CHECK-NEXT: [14]  - LNLPPortInvalid
# CHECK-NEXT: [15]  - LNLPVPort00
# CHECK-NEXT: [16]  - LNLPVPort01
# CHECK-NEXT: [17]  - LNLPVPort02
# CHECK-NEXT: [18]  - LNLPVPort03

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]
# CHECK-NEXT: 25.67  15.00  1.67   15.00  1.67   15.00   -      -     10.00  10.00  10.00   -      -      -      -      -      -     3.00   3.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]   Instructions:
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     crc32b	%al, %ecx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -     1.33   1.33   1.33    -      -      -      -      -      -      -      -     crc32b	(%rax), %ecx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     crc32l	%eax, %ecx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -     1.33   1.33   1.33    -      -      -      -      -      -      -      -     crc32l	(%rax), %ecx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     crc32w	%ax, %ecx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -     1.33   1.33   1.33    -      -      -      -      -      -      -      -     crc32w	(%rax), %ecx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     crc32b	%al, %rcx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -     1.33   1.33   1.33    -      -      -      -      -      -      -      -     crc32b	(%rax), %rcx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     crc32q	%rax, %rcx
# CHECK-NEXT:  -     1.00    -     1.00    -     1.00    -      -     1.33   1.33   1.33    -      -      -      -      -      -      -      -     crc32q	(%rax), %rcx
# CHECK-NEXT: 3.67   1.00   0.67   1.00   0.67   1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     pcmpestri	$1, %xmm0, %xmm2
# CHECK-NEXT: 3.17   1.17   0.17   1.17   0.17   1.17    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     pcmpestri	$1, (%rax), %xmm2
# CHECK-NEXT: 3.50   1.50   0.50   1.50   0.50   1.50    -      -      -      -      -      -      -      -      -      -      -      -      -     pcmpestrm	$1, %xmm0, %xmm2
# CHECK-NEXT: 3.33   1.33   0.33   1.33   0.33   1.33    -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     pcmpestrm	$1, (%rax), %xmm2
# CHECK-NEXT: 3.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     pcmpistri	$1, %xmm0, %xmm2
# CHECK-NEXT: 3.00    -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     pcmpistri	$1, (%rax), %xmm2
# CHECK-NEXT: 3.00    -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     pcmpistrm	$1, %xmm0, %xmm2
# CHECK-NEXT: 3.00    -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -      -      -     pcmpistrm	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.50   1.50   pcmpgtq	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -     1.50   1.50   pcmpgtq	(%rax), %xmm2
