/* generic.c -- generic system code for ifconfig
  Copyright (C) 2001-2025 Free Software Foundation, Inc.

  This file is part of GNU Inetutils.

  GNU Inetutils is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or (at
  your option) any later version.

  GNU Inetutils is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see `http://www.gnu.org/licenses/'. */

/* Written by Marcus Brinkmann.  */

#include <config.h>

#include "../ifconfig.h"

#include <attribute.h>


/* Output format stuff.  */

const char *system_default_format;


/* Argument parsing stuff.  */

const char *system_help;

struct argp_child system_argp_child;

int
system_parse_opt (struct ifconfig **ifp MAYBE_UNUSED,
		  char option MAYBE_UNUSED, char *optarg MAYBE_UNUSED)
{
  return 0;
}

int
system_parse_opt_rest (struct ifconfig **ifp MAYBE_UNUSED,
		       int argc MAYBE_UNUSED, MAYBE_UNUSED char *argv[])
{
  return 0;
}

int
system_preconfigure (int sfd MAYBE_UNUSED, struct ifreq *ifr MAYBE_UNUSED)
{
  return 0;
}

int
system_configure (int sfd MAYBE_UNUSED,
		  struct ifreq *ifr MAYBE_UNUSED,
		  struct system_ifconfig *ifs MAYBE_UNUSED)
{
  return 0;
}

#ifdef __CYGWIN__
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#define MAXIFS 256
unsigned
cygwin_if_nametoindex(const char *name)
{
  FILE *f;
  static char if_name[MAXIFS][IFNAMSIZ];
  static unsigned if_index[MAXIFS];
  static int num_entry = 0;

  if (num_entry == 0) {
    f = fopen ("/proc/net/if_inet6", "r");
    do {
      if (2 != fscanf (f, "%*s%02x%*x%*x%*x%s\n", &if_index[num_entry], if_name[num_entry])) break;
      if (num_entry < MAXIFS) num_entry++;
    } while (1);
    fclose (f);
  }

  for (int i = 0; i < num_entry; i++) {
    if (!strcmp (if_name[i], name)) return if_index[i];
  }
  return 0;
}

static struct if_nameindex *
cygwin_if_nameindex (void)
{
  struct if_nameindex *idx;
  struct if_nameindex *idx_tmp;
  int num = 0;
  idx = if_nameindex();
  if (!idx) return NULL;
  idx_tmp = malloc (MAXIFS * sizeof (*idx_tmp));
  if (!idx_tmp) return NULL;
  for (int i = 0; idx[i].if_name; i++) {
    unsigned index = cygwin_if_nametoindex (idx[i].if_name);
    if (index) {
      idx_tmp[num].if_name = idx[i].if_name;
      idx_tmp[num].if_index = index;
      if (num < MAXIFS) num++;
    }
  }
  idx_tmp[num].if_name = NULL;
  idx_tmp[num].if_index = 0;
  memcpy(idx, idx_tmp, (num + 1) * sizeof (*idx));
  free(idx_tmp);
  return idx;
}

struct if_nameindex *(*system_if_nameindex) (void) = cygwin_if_nameindex;
#else
struct if_nameindex *(*system_if_nameindex) (void) = if_nameindex;
#endif
