//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// UNSUPPORTED: c++03, c++11, c++14, c++17
// UNSUPPORTED: no-filesystem, no-localization, no-tzdb

// XFAIL: libcpp-has-no-experimental-tzdb
// XFAIL: availability-tzdb-missing

// <chrono>

// template<class Duration1, class Duration2, class TimeZonePtr>
//  bool operator==(const zoned_time<Duration1, TimeZonePtr>& x,
//                  const zoned_time<Duration2, TimeZonePtr>& y);
//
// Note operator!= is generated by the compiler

#include <chrono>

#include "test_comparisons.h"

int main(int, char**) {
  {
    std::chrono::zoned_time zt;
    assert(testEquality(zt, zt, true));
  }
  {
    std::chrono::zoned_time lhs{"UTC"};
    std::chrono::zoned_time rhs{"Europe/Berlin"};
    assert(testEquality(lhs, rhs, false));
  }
  {
    std::chrono::zoned_time lhs{"UTC", std::chrono::sys_time<std::chrono::seconds>{std::chrono::seconds{123}}};

    assert(testEquality(lhs,
                        std::chrono::zoned_time{
                            std::chrono::sys_time<std::chrono::nanoseconds>{std::chrono::nanoseconds{123'000'000'000}}},
                        true));
    assert(testEquality(lhs,
                        std::chrono::zoned_time{
                            std::chrono::sys_time<std::chrono::nanoseconds>{std::chrono::nanoseconds{123'000'000'001}}},
                        false));

    assert(testEquality(lhs,
                        std::chrono::zoned_time{
                            std::chrono::sys_time<std::chrono::microseconds>{std::chrono::microseconds{123'000'000}}},
                        true));
    assert(testEquality(lhs,
                        std::chrono::zoned_time{
                            std::chrono::sys_time<std::chrono::microseconds>{std::chrono::microseconds{123'000'001}}},
                        false));

    assert(testEquality(
        lhs,
        std::chrono::zoned_time{std::chrono::sys_time<std::chrono::milliseconds>{std::chrono::milliseconds{123'000}}},
        true));
    assert(testEquality(
        lhs,
        std::chrono::zoned_time{std::chrono::sys_time<std::chrono::milliseconds>{std::chrono::milliseconds{123'001}}},
        false));
  }

  return 0;
}
