/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MT_SPM_SMC_H
#define MT_SPM_SMC_H

/*
 * SPM dispatcher's smc id definition
 * Please adding custom smc id here for spm dispatcher
 */
#define MT_SPM_STATUS_SUSPEND_SLEEP	BIT(27)

enum mt_spm_smc_uid {
	MT_SPM_SMC_UID_STATUS,
	MT_SPM_SMC_UID_PCM_WDT,
	MT_SPM_SMC_UID_PCM_TIMER,
	MT_SPM_SMC_UID_FW_TYPE,
	MT_SPM_SMC_UID_PHYPLL_MODE,
	MT_SPM_SMC_UID_SET_PENDING_IRQ_INIT,
	MT_SPM_SMC_UID_FW_INIT = 0x5731,
};

/*
 * SPM dbg dispatcher's smc id definition
 * Please adding custom smc id here for spm dbg dispatcher
 */
enum mt_spm_dbg_smc_uid {
	MT_SPM_DBG_SMC_UID_IDLE_PWR_CTRL,
	MT_SPM_DBG_SMC_UID_IDLE_CNT,
	MT_SPM_DBG_SMC_UID_SUSPEND_PWR_CTRL,
	MT_SPM_DBG_SMC_UID_SUSPEND_DBG_CTRL,
	MT_SPM_DBG_SMC_UID_FS,
	MT_SPM_DBG_SMC_UID_RC_SWITCH,
	MT_SPM_DBG_SMC_UID_RC_CNT,
	MT_SPM_DBG_SMC_UID_COND_CHECK,
	MT_SPM_DBG_SMC_UID_COND_BLOCK,
	MT_SPM_DBG_SMC_UID_BLOCK_LATCH,
	MT_SPM_DBG_SMC_UID_BLOCK_DETAIL,
	MT_SPM_DBG_SMC_UID_RES_NUM,
	MT_SPM_DBG_SMC_UID_RES_REQ,
	MT_SPM_DBG_SMC_UID_RES_USAGE,
	MT_SPM_DBG_SMC_UID_RES_USER_NUM,
	MT_SPM_DBG_SMC_UID_RES_USER_VALID,
	MT_SPM_DBG_SMC_UID_RES_USER_NAME,
	MT_SPM_DBG_SMC_UID_DOE_RESOURCE_CTRL,
	MT_SPM_DBG_SMC_UID_DOE_RC,
	MT_SPM_DBG_SMC_UID_RC_COND_CTRL,
	MT_SPM_DBG_SMC_UID_RC_RES_CTRL,
	MT_SPM_DBG_SMC_UID_RC_RES_INFO,
	MT_SPM_DBG_SMC_UID_RC_BBLPM,
	MT_SPM_DBG_SMC_UID_RC_TRACE,
	MT_SPM_DBG_SMC_UID_RC_TRACE_TIME,
	MT_SPM_DBG_SMC_UID_DUMP_PLL,
	MT_SPM_DBG_SMC_HWCG_NUM,
	MT_SPM_DBG_SMC_HWCG_STATUS,
	MT_SPM_DBG_SMC_HWCG_SETTING,
	MT_SPM_DBG_SMC_HWCG_DEF_SETTING,
	MT_SPM_DBG_SMC_HWCG_RES_NAME,
	MT_SPM_DBG_SMC_UID_RC_NOTIFY_CTRL,
	MT_SPM_DBG_SMC_VCORE_LP_ENABLE,
	MT_SPM_DBG_SMC_VCORE_LP_VOLT,
	MT_SPM_DBG_SMC_VSRAM_LP_ENABLE,
	MT_SPM_DBG_SMC_VSRAM_LP_VOLT,
	MT_SPM_DBG_SMC_PERI_REQ_NUM,
	MT_SPM_DBG_SMC_PERI_REQ_STATUS,
	MT_SPM_DBG_SMC_PERI_REQ_SETTING,
	MT_SPM_DBG_SMC_PERI_REQ_DEF_SETTING,
	MT_SPM_DBG_SMC_PERI_REQ_RES_NAME,
	MT_SPM_DBG_SMC_PERI_REQ_STATUS_RAW,
	MT_SPM_DBG_SMC_IDLE_PWR_STAT,
	MT_SPM_DBG_SMC_SUSPEND_PWR_STAT,
	MT_SPM_DBG_SMC_LP_REQ_STAT,
	MT_SPM_DBG_SMC_COMMON_SODI_CTRL,
	MT_SPM_DBG_SMC_SPM_TIMESTAMP,
	MT_SPM_DBG_SMC_SPM_TIMESTAMP_SIZE,
	MT_SPM_DBG_SMC_UID_COMMON_SODI_PWR_CTRL,
};

enum wake_status_enum {
	WAKE_STA_ASSERT_PC,
	WAKE_STA_R12,
	WAKE_STA_R12_EXT,
	WAKE_STA_RAW_STA,
	WAKE_STA_RAW_EXT_STA,
	WAKE_STA_WAKE_MISC,
	WAKE_STA_TIMER_OUT,
	WAKE_STA_R13,
	WAKE_STA_IDLE_STA,
	WAKE_STA_REQ_STA,
	WAKE_STA_DEBUG_FLAG,
	WAKE_STA_DEBUG_FLAG1,
	WAKE_STA_EVENT_REG,
	WAKE_STA_ISR,
	WAKE_STA_MAX_COUNT,
};

#endif /* MT_SPM_SMC_H */
