//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopmode?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type CFRunLoopMode = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloop?language=objc)
#[doc(alias = "CFRunLoopRef")]
#[repr(C)]
pub struct CFRunLoop {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFRunLoop {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFRunLoop"> for CFRunLoop {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopsource?language=objc)
#[doc(alias = "CFRunLoopSourceRef")]
#[repr(C)]
pub struct CFRunLoopSource {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFRunLoopSource {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFRunLoopSource"> for CFRunLoopSource {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopobserver?language=objc)
#[doc(alias = "CFRunLoopObserverRef")]
#[repr(C)]
pub struct CFRunLoopObserver {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFRunLoopObserver {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFRunLoopObserver"> for CFRunLoopObserver {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooptimer?language=objc)
///
/// This is toll-free bridged with `NSTimer`.
#[doc(alias = "CFRunLoopTimerRef")]
#[repr(C)]
pub struct CFRunLoopTimer {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFRunLoopTimer {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFRunLoopTimer"> for CFRunLoopTimer {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooprunresult?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFRunLoopRunResult(pub i32);
impl CFRunLoopRunResult {
    #[doc(alias = "kCFRunLoopRunFinished")]
    pub const Finished: Self = Self(1);
    #[doc(alias = "kCFRunLoopRunStopped")]
    pub const Stopped: Self = Self(2);
    #[doc(alias = "kCFRunLoopRunTimedOut")]
    pub const TimedOut: Self = Self(3);
    #[doc(alias = "kCFRunLoopRunHandledSource")]
    pub const HandledSource: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFRunLoopRunResult {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFRunLoopRunResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopactivity?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFRunLoopActivity(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFRunLoopActivity: CFOptionFlags {
        #[doc(alias = "kCFRunLoopEntry")]
        const Entry = 1<<0;
        #[doc(alias = "kCFRunLoopBeforeTimers")]
        const BeforeTimers = 1<<1;
        #[doc(alias = "kCFRunLoopBeforeSources")]
        const BeforeSources = 1<<2;
        #[doc(alias = "kCFRunLoopBeforeWaiting")]
        const BeforeWaiting = 1<<5;
        #[doc(alias = "kCFRunLoopAfterWaiting")]
        const AfterWaiting = 1<<6;
        #[doc(alias = "kCFRunLoopExit")]
        const Exit = 1<<7;
        #[doc(alias = "kCFRunLoopAllActivities")]
        const AllActivities = 0x0FFFFFFF;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFRunLoopActivity {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFRunLoopActivity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfrunloopdefaultmode?language=objc)
    pub static kCFRunLoopDefaultMode: Option<&'static CFRunLoopMode>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfrunloopcommonmodes?language=objc)
    pub static kCFRunLoopCommonModes: Option<&'static CFRunLoopMode>;
}

unsafe impl ConcreteType for CFRunLoop {
    #[doc(alias = "CFRunLoopGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopGetTypeID() }
    }
}

impl CFRunLoop {
    #[doc(alias = "CFRunLoopGetCurrent")]
    #[inline]
    pub fn current() -> Option<CFRetained<CFRunLoop>> {
        extern "C-unwind" {
            fn CFRunLoopGetCurrent() -> Option<NonNull<CFRunLoop>>;
        }
        let ret = unsafe { CFRunLoopGetCurrent() };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFRunLoopGetMain")]
    #[inline]
    pub fn main() -> Option<CFRetained<CFRunLoop>> {
        extern "C-unwind" {
            fn CFRunLoopGetMain() -> Option<NonNull<CFRunLoop>>;
        }
        let ret = unsafe { CFRunLoopGetMain() };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFRunLoopCopyCurrentMode")]
    #[inline]
    pub fn current_mode(&self) -> Option<CFRetained<CFRunLoopMode>> {
        extern "C-unwind" {
            fn CFRunLoopCopyCurrentMode(rl: &CFRunLoop) -> Option<NonNull<CFRunLoopMode>>;
        }
        let ret = unsafe { CFRunLoopCopyCurrentMode(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFRunLoopCopyAllModes")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn all_modes(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFRunLoopCopyAllModes(rl: &CFRunLoop) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFRunLoopCopyAllModes(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFRunLoopAddCommonMode")]
    #[inline]
    pub fn add_common_mode(&self, mode: Option<&CFRunLoopMode>) {
        extern "C-unwind" {
            fn CFRunLoopAddCommonMode(rl: &CFRunLoop, mode: Option<&CFRunLoopMode>);
        }
        unsafe { CFRunLoopAddCommonMode(self, mode) }
    }

    #[doc(alias = "CFRunLoopGetNextTimerFireDate")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn next_timer_fire_date(&self, mode: Option<&CFRunLoopMode>) -> CFAbsoluteTime {
        extern "C-unwind" {
            fn CFRunLoopGetNextTimerFireDate(
                rl: &CFRunLoop,
                mode: Option<&CFRunLoopMode>,
            ) -> CFAbsoluteTime;
        }
        unsafe { CFRunLoopGetNextTimerFireDate(self, mode) }
    }

    #[doc(alias = "CFRunLoopRun")]
    #[inline]
    pub fn run() {
        extern "C-unwind" {
            fn CFRunLoopRun();
        }
        unsafe { CFRunLoopRun() }
    }

    #[doc(alias = "CFRunLoopRunInMode")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn run_in_mode(
        mode: Option<&CFRunLoopMode>,
        seconds: CFTimeInterval,
        return_after_source_handled: bool,
    ) -> CFRunLoopRunResult {
        extern "C-unwind" {
            fn CFRunLoopRunInMode(
                mode: Option<&CFRunLoopMode>,
                seconds: CFTimeInterval,
                return_after_source_handled: Boolean,
            ) -> CFRunLoopRunResult;
        }
        unsafe { CFRunLoopRunInMode(mode, seconds, return_after_source_handled as _) }
    }

    #[doc(alias = "CFRunLoopIsWaiting")]
    #[inline]
    pub fn is_waiting(&self) -> bool {
        extern "C-unwind" {
            fn CFRunLoopIsWaiting(rl: &CFRunLoop) -> Boolean;
        }
        let ret = unsafe { CFRunLoopIsWaiting(self) };
        ret != 0
    }

    #[doc(alias = "CFRunLoopWakeUp")]
    #[inline]
    pub fn wake_up(&self) {
        extern "C-unwind" {
            fn CFRunLoopWakeUp(rl: &CFRunLoop);
        }
        unsafe { CFRunLoopWakeUp(self) }
    }

    #[doc(alias = "CFRunLoopStop")]
    #[inline]
    pub fn stop(&self) {
        extern "C-unwind" {
            fn CFRunLoopStop(rl: &CFRunLoop);
        }
        unsafe { CFRunLoopStop(self) }
    }

    /// # Safety
    ///
    /// - `rl` possibly has additional threading requirements.
    /// - `mode` should be of the correct type.
    /// - `mode` might not allow `None`.
    /// - `block` might not allow `None`.
    #[doc(alias = "CFRunLoopPerformBlock")]
    #[cfg(feature = "block2")]
    #[inline]
    pub unsafe fn perform_block(
        &self,
        mode: Option<&CFType>,
        block: Option<&block2::DynBlock<dyn Fn()>>,
    ) {
        extern "C-unwind" {
            fn CFRunLoopPerformBlock(
                rl: &CFRunLoop,
                mode: Option<&CFType>,
                block: Option<&block2::DynBlock<dyn Fn()>>,
            );
        }
        unsafe { CFRunLoopPerformBlock(self, mode, block) }
    }

    #[doc(alias = "CFRunLoopContainsSource")]
    #[inline]
    pub fn contains_source(
        &self,
        source: Option<&CFRunLoopSource>,
        mode: Option<&CFRunLoopMode>,
    ) -> bool {
        extern "C-unwind" {
            fn CFRunLoopContainsSource(
                rl: &CFRunLoop,
                source: Option<&CFRunLoopSource>,
                mode: Option<&CFRunLoopMode>,
            ) -> Boolean;
        }
        let ret = unsafe { CFRunLoopContainsSource(self, source, mode) };
        ret != 0
    }

    #[doc(alias = "CFRunLoopAddSource")]
    #[inline]
    pub fn add_source(&self, source: Option<&CFRunLoopSource>, mode: Option<&CFRunLoopMode>) {
        extern "C-unwind" {
            fn CFRunLoopAddSource(
                rl: &CFRunLoop,
                source: Option<&CFRunLoopSource>,
                mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFRunLoopAddSource(self, source, mode) }
    }

    #[doc(alias = "CFRunLoopRemoveSource")]
    #[inline]
    pub fn remove_source(&self, source: Option<&CFRunLoopSource>, mode: Option<&CFRunLoopMode>) {
        extern "C-unwind" {
            fn CFRunLoopRemoveSource(
                rl: &CFRunLoop,
                source: Option<&CFRunLoopSource>,
                mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFRunLoopRemoveSource(self, source, mode) }
    }

    #[doc(alias = "CFRunLoopContainsObserver")]
    #[inline]
    pub fn contains_observer(
        &self,
        observer: Option<&CFRunLoopObserver>,
        mode: Option<&CFRunLoopMode>,
    ) -> bool {
        extern "C-unwind" {
            fn CFRunLoopContainsObserver(
                rl: &CFRunLoop,
                observer: Option<&CFRunLoopObserver>,
                mode: Option<&CFRunLoopMode>,
            ) -> Boolean;
        }
        let ret = unsafe { CFRunLoopContainsObserver(self, observer, mode) };
        ret != 0
    }

    #[doc(alias = "CFRunLoopAddObserver")]
    #[inline]
    pub fn add_observer(&self, observer: Option<&CFRunLoopObserver>, mode: Option<&CFRunLoopMode>) {
        extern "C-unwind" {
            fn CFRunLoopAddObserver(
                rl: &CFRunLoop,
                observer: Option<&CFRunLoopObserver>,
                mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFRunLoopAddObserver(self, observer, mode) }
    }

    #[doc(alias = "CFRunLoopRemoveObserver")]
    #[inline]
    pub fn remove_observer(
        &self,
        observer: Option<&CFRunLoopObserver>,
        mode: Option<&CFRunLoopMode>,
    ) {
        extern "C-unwind" {
            fn CFRunLoopRemoveObserver(
                rl: &CFRunLoop,
                observer: Option<&CFRunLoopObserver>,
                mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFRunLoopRemoveObserver(self, observer, mode) }
    }

    #[doc(alias = "CFRunLoopContainsTimer")]
    #[inline]
    pub fn contains_timer(
        &self,
        timer: Option<&CFRunLoopTimer>,
        mode: Option<&CFRunLoopMode>,
    ) -> bool {
        extern "C-unwind" {
            fn CFRunLoopContainsTimer(
                rl: &CFRunLoop,
                timer: Option<&CFRunLoopTimer>,
                mode: Option<&CFRunLoopMode>,
            ) -> Boolean;
        }
        let ret = unsafe { CFRunLoopContainsTimer(self, timer, mode) };
        ret != 0
    }

    #[doc(alias = "CFRunLoopAddTimer")]
    #[inline]
    pub fn add_timer(&self, timer: Option<&CFRunLoopTimer>, mode: Option<&CFRunLoopMode>) {
        extern "C-unwind" {
            fn CFRunLoopAddTimer(
                rl: &CFRunLoop,
                timer: Option<&CFRunLoopTimer>,
                mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFRunLoopAddTimer(self, timer, mode) }
    }

    #[doc(alias = "CFRunLoopRemoveTimer")]
    #[inline]
    pub fn remove_timer(&self, timer: Option<&CFRunLoopTimer>, mode: Option<&CFRunLoopMode>) {
        extern "C-unwind" {
            fn CFRunLoopRemoveTimer(
                rl: &CFRunLoop,
                timer: Option<&CFRunLoopTimer>,
                mode: Option<&CFRunLoopMode>,
            );
        }
        unsafe { CFRunLoopRemoveTimer(self, timer, mode) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopsourcecontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopSourceContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
    pub equal: Option<unsafe extern "C-unwind" fn(*const c_void, *const c_void) -> Boolean>,
    pub hash: Option<unsafe extern "C-unwind" fn(*const c_void) -> CFHashCode>,
    pub schedule:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut CFRunLoop, *const CFRunLoopMode)>,
    pub cancel:
        Option<unsafe extern "C-unwind" fn(*mut c_void, *mut CFRunLoop, *const CFRunLoopMode)>,
    pub perform: Option<unsafe extern "C-unwind" fn(*mut c_void)>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFRunLoopSourceContext {
    const ENCODING: Encoding = Encoding::Struct("?", &[
        <CFIndex>::ENCODING,
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const c_void>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const CFString>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,*const c_void,) -> Boolean>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> CFHashCode>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut CFRunLoop,*const CFRunLoopMode,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,*mut CFRunLoop,*const CFRunLoopMode,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,)>>::ENCODING,
    ]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFRunLoopSourceContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopsourcecontext1?language=objc)
#[cfg(feature = "libc")]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopSourceContext1 {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
    pub equal: Option<unsafe extern "C-unwind" fn(*const c_void, *const c_void) -> Boolean>,
    pub hash: Option<unsafe extern "C-unwind" fn(*const c_void) -> CFHashCode>,
    pub getPort: Option<unsafe extern "C-unwind" fn(*mut c_void) -> libc::mach_port_t>,
    pub perform: Option<
        unsafe extern "C-unwind" fn(
            *mut c_void,
            CFIndex,
            *const CFAllocator,
            *mut c_void,
        ) -> *mut c_void,
    >,
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl Encode for CFRunLoopSourceContext1 {
    const ENCODING: Encoding = Encoding::Struct("?", &[
        <CFIndex>::ENCODING,
        <*mut c_void>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const c_void>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> *const CFString>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,*const c_void,) -> Boolean>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*const c_void,) -> CFHashCode>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,) -> libc::mach_port_t>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(*mut c_void,CFIndex,*const CFAllocator,*mut c_void,) -> *mut c_void>>::ENCODING,
    ]);
}

#[cfg(all(feature = "libc", feature = "objc2"))]
unsafe impl RefEncode for CFRunLoopSourceContext1 {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CFRunLoopSource {
    #[doc(alias = "CFRunLoopSourceGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopSourceGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopSourceGetTypeID() }
    }
}

impl CFRunLoopSource {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFRunLoopSourceCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        order: CFIndex,
        context: *mut CFRunLoopSourceContext,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn CFRunLoopSourceCreate(
                allocator: Option<&CFAllocator>,
                order: CFIndex,
                context: *mut CFRunLoopSourceContext,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe { CFRunLoopSourceCreate(allocator, order, context) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFRunLoopSourceGetOrder")]
    #[inline]
    pub fn order(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFRunLoopSourceGetOrder(source: &CFRunLoopSource) -> CFIndex;
        }
        unsafe { CFRunLoopSourceGetOrder(self) }
    }

    #[doc(alias = "CFRunLoopSourceInvalidate")]
    #[inline]
    pub fn invalidate(&self) {
        extern "C-unwind" {
            fn CFRunLoopSourceInvalidate(source: &CFRunLoopSource);
        }
        unsafe { CFRunLoopSourceInvalidate(self) }
    }

    #[doc(alias = "CFRunLoopSourceIsValid")]
    #[inline]
    pub fn is_valid(&self) -> bool {
        extern "C-unwind" {
            fn CFRunLoopSourceIsValid(source: &CFRunLoopSource) -> Boolean;
        }
        let ret = unsafe { CFRunLoopSourceIsValid(self) };
        ret != 0
    }

    /// # Safety
    ///
    /// `context` must be a valid pointer.
    #[doc(alias = "CFRunLoopSourceGetContext")]
    #[inline]
    pub unsafe fn context(&self, context: *mut CFRunLoopSourceContext) {
        extern "C-unwind" {
            fn CFRunLoopSourceGetContext(
                source: &CFRunLoopSource,
                context: *mut CFRunLoopSourceContext,
            );
        }
        unsafe { CFRunLoopSourceGetContext(self, context) }
    }

    #[doc(alias = "CFRunLoopSourceSignal")]
    #[inline]
    pub fn signal(&self) {
        extern "C-unwind" {
            fn CFRunLoopSourceSignal(source: &CFRunLoopSource);
        }
        unsafe { CFRunLoopSourceSignal(self) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopobservercontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopObserverContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFRunLoopObserverContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFRunLoopObserverContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunloopobservercallback?language=objc)
pub type CFRunLoopObserverCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFRunLoopObserver, CFRunLoopActivity, *mut c_void)>;

unsafe impl ConcreteType for CFRunLoopObserver {
    #[doc(alias = "CFRunLoopObserverGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopObserverGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopObserverGetTypeID() }
    }
}

impl CFRunLoopObserver {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `callout` must be implemented correctly.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFRunLoopObserverCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        activities: CFOptionFlags,
        repeats: bool,
        order: CFIndex,
        callout: CFRunLoopObserverCallBack,
        context: *mut CFRunLoopObserverContext,
    ) -> Option<CFRetained<CFRunLoopObserver>> {
        extern "C-unwind" {
            fn CFRunLoopObserverCreate(
                allocator: Option<&CFAllocator>,
                activities: CFOptionFlags,
                repeats: Boolean,
                order: CFIndex,
                callout: CFRunLoopObserverCallBack,
                context: *mut CFRunLoopObserverContext,
            ) -> Option<NonNull<CFRunLoopObserver>>;
        }
        let ret = unsafe {
            CFRunLoopObserverCreate(allocator, activities, repeats as _, order, callout, context)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `block` might not allow `None`.
    #[doc(alias = "CFRunLoopObserverCreateWithHandler")]
    #[cfg(feature = "block2")]
    #[inline]
    pub unsafe fn with_handler(
        allocator: Option<&CFAllocator>,
        activities: CFOptionFlags,
        repeats: bool,
        order: CFIndex,
        block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopObserver, CFRunLoopActivity)>>,
    ) -> Option<CFRetained<CFRunLoopObserver>> {
        extern "C-unwind" {
            fn CFRunLoopObserverCreateWithHandler(
                allocator: Option<&CFAllocator>,
                activities: CFOptionFlags,
                repeats: Boolean,
                order: CFIndex,
                block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopObserver, CFRunLoopActivity)>>,
            ) -> Option<NonNull<CFRunLoopObserver>>;
        }
        let ret = unsafe {
            CFRunLoopObserverCreateWithHandler(allocator, activities, repeats as _, order, block)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFRunLoopObserverGetActivities")]
    #[inline]
    pub fn activities(&self) -> CFOptionFlags {
        extern "C-unwind" {
            fn CFRunLoopObserverGetActivities(observer: &CFRunLoopObserver) -> CFOptionFlags;
        }
        unsafe { CFRunLoopObserverGetActivities(self) }
    }

    #[doc(alias = "CFRunLoopObserverDoesRepeat")]
    #[inline]
    pub fn does_repeat(&self) -> bool {
        extern "C-unwind" {
            fn CFRunLoopObserverDoesRepeat(observer: &CFRunLoopObserver) -> Boolean;
        }
        let ret = unsafe { CFRunLoopObserverDoesRepeat(self) };
        ret != 0
    }

    #[doc(alias = "CFRunLoopObserverGetOrder")]
    #[inline]
    pub fn order(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFRunLoopObserverGetOrder(observer: &CFRunLoopObserver) -> CFIndex;
        }
        unsafe { CFRunLoopObserverGetOrder(self) }
    }

    #[doc(alias = "CFRunLoopObserverInvalidate")]
    #[inline]
    pub fn invalidate(&self) {
        extern "C-unwind" {
            fn CFRunLoopObserverInvalidate(observer: &CFRunLoopObserver);
        }
        unsafe { CFRunLoopObserverInvalidate(self) }
    }

    #[doc(alias = "CFRunLoopObserverIsValid")]
    #[inline]
    pub fn is_valid(&self) -> bool {
        extern "C-unwind" {
            fn CFRunLoopObserverIsValid(observer: &CFRunLoopObserver) -> Boolean;
        }
        let ret = unsafe { CFRunLoopObserverIsValid(self) };
        ret != 0
    }

    /// # Safety
    ///
    /// `context` must be a valid pointer.
    #[doc(alias = "CFRunLoopObserverGetContext")]
    #[inline]
    pub unsafe fn context(&self, context: *mut CFRunLoopObserverContext) {
        extern "C-unwind" {
            fn CFRunLoopObserverGetContext(
                observer: &CFRunLoopObserver,
                context: *mut CFRunLoopObserverContext,
            );
        }
        unsafe { CFRunLoopObserverGetContext(self, context) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooptimercontext?language=objc)
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRunLoopTimerContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*const c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFRunLoopTimerContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFRunLoopTimerContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrunlooptimercallback?language=objc)
pub type CFRunLoopTimerCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFRunLoopTimer, *mut c_void)>;

unsafe impl ConcreteType for CFRunLoopTimer {
    #[doc(alias = "CFRunLoopTimerGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFRunLoopTimerGetTypeID() -> CFTypeID;
        }
        unsafe { CFRunLoopTimerGetTypeID() }
    }
}

impl CFRunLoopTimer {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `callout` must be implemented correctly.
    /// - `context` must be a valid pointer.
    #[doc(alias = "CFRunLoopTimerCreate")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        fire_date: CFAbsoluteTime,
        interval: CFTimeInterval,
        flags: CFOptionFlags,
        order: CFIndex,
        callout: CFRunLoopTimerCallBack,
        context: *mut CFRunLoopTimerContext,
    ) -> Option<CFRetained<CFRunLoopTimer>> {
        extern "C-unwind" {
            fn CFRunLoopTimerCreate(
                allocator: Option<&CFAllocator>,
                fire_date: CFAbsoluteTime,
                interval: CFTimeInterval,
                flags: CFOptionFlags,
                order: CFIndex,
                callout: CFRunLoopTimerCallBack,
                context: *mut CFRunLoopTimerContext,
            ) -> Option<NonNull<CFRunLoopTimer>>;
        }
        let ret = unsafe {
            CFRunLoopTimerCreate(
                allocator, fire_date, interval, flags, order, callout, context,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `block` might not allow `None`.
    #[doc(alias = "CFRunLoopTimerCreateWithHandler")]
    #[cfg(all(feature = "CFDate", feature = "block2"))]
    #[inline]
    pub unsafe fn with_handler(
        allocator: Option<&CFAllocator>,
        fire_date: CFAbsoluteTime,
        interval: CFTimeInterval,
        flags: CFOptionFlags,
        order: CFIndex,
        block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopTimer)>>,
    ) -> Option<CFRetained<CFRunLoopTimer>> {
        extern "C-unwind" {
            fn CFRunLoopTimerCreateWithHandler(
                allocator: Option<&CFAllocator>,
                fire_date: CFAbsoluteTime,
                interval: CFTimeInterval,
                flags: CFOptionFlags,
                order: CFIndex,
                block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopTimer)>>,
            ) -> Option<NonNull<CFRunLoopTimer>>;
        }
        let ret = unsafe {
            CFRunLoopTimerCreateWithHandler(allocator, fire_date, interval, flags, order, block)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFRunLoopTimerGetNextFireDate")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn next_fire_date(&self) -> CFAbsoluteTime {
        extern "C-unwind" {
            fn CFRunLoopTimerGetNextFireDate(timer: &CFRunLoopTimer) -> CFAbsoluteTime;
        }
        unsafe { CFRunLoopTimerGetNextFireDate(self) }
    }

    #[doc(alias = "CFRunLoopTimerSetNextFireDate")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn set_next_fire_date(&self, fire_date: CFAbsoluteTime) {
        extern "C-unwind" {
            fn CFRunLoopTimerSetNextFireDate(timer: &CFRunLoopTimer, fire_date: CFAbsoluteTime);
        }
        unsafe { CFRunLoopTimerSetNextFireDate(self, fire_date) }
    }

    #[doc(alias = "CFRunLoopTimerGetInterval")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn interval(&self) -> CFTimeInterval {
        extern "C-unwind" {
            fn CFRunLoopTimerGetInterval(timer: &CFRunLoopTimer) -> CFTimeInterval;
        }
        unsafe { CFRunLoopTimerGetInterval(self) }
    }

    #[doc(alias = "CFRunLoopTimerDoesRepeat")]
    #[inline]
    pub fn does_repeat(&self) -> bool {
        extern "C-unwind" {
            fn CFRunLoopTimerDoesRepeat(timer: &CFRunLoopTimer) -> Boolean;
        }
        let ret = unsafe { CFRunLoopTimerDoesRepeat(self) };
        ret != 0
    }

    #[doc(alias = "CFRunLoopTimerGetOrder")]
    #[inline]
    pub fn order(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFRunLoopTimerGetOrder(timer: &CFRunLoopTimer) -> CFIndex;
        }
        unsafe { CFRunLoopTimerGetOrder(self) }
    }

    #[doc(alias = "CFRunLoopTimerInvalidate")]
    #[inline]
    pub fn invalidate(&self) {
        extern "C-unwind" {
            fn CFRunLoopTimerInvalidate(timer: &CFRunLoopTimer);
        }
        unsafe { CFRunLoopTimerInvalidate(self) }
    }

    #[doc(alias = "CFRunLoopTimerIsValid")]
    #[inline]
    pub fn is_valid(&self) -> bool {
        extern "C-unwind" {
            fn CFRunLoopTimerIsValid(timer: &CFRunLoopTimer) -> Boolean;
        }
        let ret = unsafe { CFRunLoopTimerIsValid(self) };
        ret != 0
    }

    /// # Safety
    ///
    /// `context` must be a valid pointer.
    #[doc(alias = "CFRunLoopTimerGetContext")]
    #[inline]
    pub unsafe fn context(&self, context: *mut CFRunLoopTimerContext) {
        extern "C-unwind" {
            fn CFRunLoopTimerGetContext(
                timer: &CFRunLoopTimer,
                context: *mut CFRunLoopTimerContext,
            );
        }
        unsafe { CFRunLoopTimerGetContext(self, context) }
    }

    #[doc(alias = "CFRunLoopTimerGetTolerance")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn tolerance(&self) -> CFTimeInterval {
        extern "C-unwind" {
            fn CFRunLoopTimerGetTolerance(timer: &CFRunLoopTimer) -> CFTimeInterval;
        }
        unsafe { CFRunLoopTimerGetTolerance(self) }
    }

    #[doc(alias = "CFRunLoopTimerSetTolerance")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn set_tolerance(&self, tolerance: CFTimeInterval) {
        extern "C-unwind" {
            fn CFRunLoopTimerSetTolerance(timer: &CFRunLoopTimer, tolerance: CFTimeInterval);
        }
        unsafe { CFRunLoopTimerSetTolerance(self, tolerance) }
    }
}

#[deprecated = "renamed to `CFRunLoop::current`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopGetCurrent() -> Option<CFRetained<CFRunLoop>> {
    extern "C-unwind" {
        fn CFRunLoopGetCurrent() -> Option<NonNull<CFRunLoop>>;
    }
    let ret = unsafe { CFRunLoopGetCurrent() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFRunLoop::main`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopGetMain() -> Option<CFRetained<CFRunLoop>> {
    extern "C-unwind" {
        fn CFRunLoopGetMain() -> Option<NonNull<CFRunLoop>>;
    }
    let ret = unsafe { CFRunLoopGetMain() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFRunLoop::current_mode`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopCopyCurrentMode(
    rl: &CFRunLoop,
) -> Option<CFRetained<CFRunLoopMode>> {
    extern "C-unwind" {
        fn CFRunLoopCopyCurrentMode(rl: &CFRunLoop) -> Option<NonNull<CFRunLoopMode>>;
    }
    let ret = unsafe { CFRunLoopCopyCurrentMode(rl) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFRunLoop::all_modes`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopCopyAllModes(rl: &CFRunLoop) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFRunLoopCopyAllModes(rl: &CFRunLoop) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFRunLoopCopyAllModes(rl) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFRunLoop::add_common_mode`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopAddCommonMode(rl: &CFRunLoop, mode: Option<&CFRunLoopMode>) {
    extern "C-unwind" {
        fn CFRunLoopAddCommonMode(rl: &CFRunLoop, mode: Option<&CFRunLoopMode>);
    }
    unsafe { CFRunLoopAddCommonMode(rl, mode) }
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFRunLoop::next_timer_fire_date`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopGetNextTimerFireDate(
    rl: &CFRunLoop,
    mode: Option<&CFRunLoopMode>,
) -> CFAbsoluteTime {
    extern "C-unwind" {
        fn CFRunLoopGetNextTimerFireDate(
            rl: &CFRunLoop,
            mode: Option<&CFRunLoopMode>,
        ) -> CFAbsoluteTime;
    }
    unsafe { CFRunLoopGetNextTimerFireDate(rl, mode) }
}

#[deprecated = "renamed to `CFRunLoop::run`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopRun() {
    extern "C-unwind" {
        fn CFRunLoopRun();
    }
    unsafe { CFRunLoopRun() }
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFRunLoop::run_in_mode`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopRunInMode(
    mode: Option<&CFRunLoopMode>,
    seconds: CFTimeInterval,
    return_after_source_handled: bool,
) -> CFRunLoopRunResult {
    extern "C-unwind" {
        fn CFRunLoopRunInMode(
            mode: Option<&CFRunLoopMode>,
            seconds: CFTimeInterval,
            return_after_source_handled: Boolean,
        ) -> CFRunLoopRunResult;
    }
    unsafe { CFRunLoopRunInMode(mode, seconds, return_after_source_handled as _) }
}

#[deprecated = "renamed to `CFRunLoop::is_waiting`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopIsWaiting(rl: &CFRunLoop) -> bool {
    extern "C-unwind" {
        fn CFRunLoopIsWaiting(rl: &CFRunLoop) -> Boolean;
    }
    let ret = unsafe { CFRunLoopIsWaiting(rl) };
    ret != 0
}

#[deprecated = "renamed to `CFRunLoop::wake_up`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopWakeUp(rl: &CFRunLoop) {
    extern "C-unwind" {
        fn CFRunLoopWakeUp(rl: &CFRunLoop);
    }
    unsafe { CFRunLoopWakeUp(rl) }
}

#[deprecated = "renamed to `CFRunLoop::stop`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopStop(rl: &CFRunLoop) {
    extern "C-unwind" {
        fn CFRunLoopStop(rl: &CFRunLoop);
    }
    unsafe { CFRunLoopStop(rl) }
}

extern "C-unwind" {
    #[cfg(feature = "block2")]
    #[deprecated = "renamed to `CFRunLoop::perform_block`"]
    pub fn CFRunLoopPerformBlock(
        rl: &CFRunLoop,
        mode: Option<&CFType>,
        block: Option<&block2::DynBlock<dyn Fn()>>,
    );
}

#[deprecated = "renamed to `CFRunLoop::contains_source`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopContainsSource(
    rl: &CFRunLoop,
    source: Option<&CFRunLoopSource>,
    mode: Option<&CFRunLoopMode>,
) -> bool {
    extern "C-unwind" {
        fn CFRunLoopContainsSource(
            rl: &CFRunLoop,
            source: Option<&CFRunLoopSource>,
            mode: Option<&CFRunLoopMode>,
        ) -> Boolean;
    }
    let ret = unsafe { CFRunLoopContainsSource(rl, source, mode) };
    ret != 0
}

#[deprecated = "renamed to `CFRunLoop::add_source`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopAddSource(
    rl: &CFRunLoop,
    source: Option<&CFRunLoopSource>,
    mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFRunLoopAddSource(
            rl: &CFRunLoop,
            source: Option<&CFRunLoopSource>,
            mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFRunLoopAddSource(rl, source, mode) }
}

#[deprecated = "renamed to `CFRunLoop::remove_source`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopRemoveSource(
    rl: &CFRunLoop,
    source: Option<&CFRunLoopSource>,
    mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFRunLoopRemoveSource(
            rl: &CFRunLoop,
            source: Option<&CFRunLoopSource>,
            mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFRunLoopRemoveSource(rl, source, mode) }
}

#[deprecated = "renamed to `CFRunLoop::contains_observer`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopContainsObserver(
    rl: &CFRunLoop,
    observer: Option<&CFRunLoopObserver>,
    mode: Option<&CFRunLoopMode>,
) -> bool {
    extern "C-unwind" {
        fn CFRunLoopContainsObserver(
            rl: &CFRunLoop,
            observer: Option<&CFRunLoopObserver>,
            mode: Option<&CFRunLoopMode>,
        ) -> Boolean;
    }
    let ret = unsafe { CFRunLoopContainsObserver(rl, observer, mode) };
    ret != 0
}

#[deprecated = "renamed to `CFRunLoop::add_observer`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopAddObserver(
    rl: &CFRunLoop,
    observer: Option<&CFRunLoopObserver>,
    mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFRunLoopAddObserver(
            rl: &CFRunLoop,
            observer: Option<&CFRunLoopObserver>,
            mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFRunLoopAddObserver(rl, observer, mode) }
}

#[deprecated = "renamed to `CFRunLoop::remove_observer`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopRemoveObserver(
    rl: &CFRunLoop,
    observer: Option<&CFRunLoopObserver>,
    mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFRunLoopRemoveObserver(
            rl: &CFRunLoop,
            observer: Option<&CFRunLoopObserver>,
            mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFRunLoopRemoveObserver(rl, observer, mode) }
}

#[deprecated = "renamed to `CFRunLoop::contains_timer`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopContainsTimer(
    rl: &CFRunLoop,
    timer: Option<&CFRunLoopTimer>,
    mode: Option<&CFRunLoopMode>,
) -> bool {
    extern "C-unwind" {
        fn CFRunLoopContainsTimer(
            rl: &CFRunLoop,
            timer: Option<&CFRunLoopTimer>,
            mode: Option<&CFRunLoopMode>,
        ) -> Boolean;
    }
    let ret = unsafe { CFRunLoopContainsTimer(rl, timer, mode) };
    ret != 0
}

#[deprecated = "renamed to `CFRunLoop::add_timer`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopAddTimer(
    rl: &CFRunLoop,
    timer: Option<&CFRunLoopTimer>,
    mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFRunLoopAddTimer(
            rl: &CFRunLoop,
            timer: Option<&CFRunLoopTimer>,
            mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFRunLoopAddTimer(rl, timer, mode) }
}

#[deprecated = "renamed to `CFRunLoop::remove_timer`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopRemoveTimer(
    rl: &CFRunLoop,
    timer: Option<&CFRunLoopTimer>,
    mode: Option<&CFRunLoopMode>,
) {
    extern "C-unwind" {
        fn CFRunLoopRemoveTimer(
            rl: &CFRunLoop,
            timer: Option<&CFRunLoopTimer>,
            mode: Option<&CFRunLoopMode>,
        );
    }
    unsafe { CFRunLoopRemoveTimer(rl, timer, mode) }
}

#[deprecated = "renamed to `CFRunLoopSource::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopSourceCreate(
    allocator: Option<&CFAllocator>,
    order: CFIndex,
    context: *mut CFRunLoopSourceContext,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFRunLoopSourceCreate(
            allocator: Option<&CFAllocator>,
            order: CFIndex,
            context: *mut CFRunLoopSourceContext,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CFRunLoopSourceCreate(allocator, order, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFRunLoopSource::order`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopSourceGetOrder(source: &CFRunLoopSource) -> CFIndex {
    extern "C-unwind" {
        fn CFRunLoopSourceGetOrder(source: &CFRunLoopSource) -> CFIndex;
    }
    unsafe { CFRunLoopSourceGetOrder(source) }
}

#[deprecated = "renamed to `CFRunLoopSource::invalidate`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopSourceInvalidate(source: &CFRunLoopSource) {
    extern "C-unwind" {
        fn CFRunLoopSourceInvalidate(source: &CFRunLoopSource);
    }
    unsafe { CFRunLoopSourceInvalidate(source) }
}

#[deprecated = "renamed to `CFRunLoopSource::is_valid`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopSourceIsValid(source: &CFRunLoopSource) -> bool {
    extern "C-unwind" {
        fn CFRunLoopSourceIsValid(source: &CFRunLoopSource) -> Boolean;
    }
    let ret = unsafe { CFRunLoopSourceIsValid(source) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFRunLoopSource::context`"]
    pub fn CFRunLoopSourceGetContext(
        source: &CFRunLoopSource,
        context: *mut CFRunLoopSourceContext,
    );
}

#[deprecated = "renamed to `CFRunLoopSource::signal`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopSourceSignal(source: &CFRunLoopSource) {
    extern "C-unwind" {
        fn CFRunLoopSourceSignal(source: &CFRunLoopSource);
    }
    unsafe { CFRunLoopSourceSignal(source) }
}

#[deprecated = "renamed to `CFRunLoopObserver::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopObserverCreate(
    allocator: Option<&CFAllocator>,
    activities: CFOptionFlags,
    repeats: bool,
    order: CFIndex,
    callout: CFRunLoopObserverCallBack,
    context: *mut CFRunLoopObserverContext,
) -> Option<CFRetained<CFRunLoopObserver>> {
    extern "C-unwind" {
        fn CFRunLoopObserverCreate(
            allocator: Option<&CFAllocator>,
            activities: CFOptionFlags,
            repeats: Boolean,
            order: CFIndex,
            callout: CFRunLoopObserverCallBack,
            context: *mut CFRunLoopObserverContext,
        ) -> Option<NonNull<CFRunLoopObserver>>;
    }
    let ret = unsafe {
        CFRunLoopObserverCreate(allocator, activities, repeats as _, order, callout, context)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "block2")]
#[deprecated = "renamed to `CFRunLoopObserver::with_handler`"]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopObserverCreateWithHandler(
    allocator: Option<&CFAllocator>,
    activities: CFOptionFlags,
    repeats: bool,
    order: CFIndex,
    block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopObserver, CFRunLoopActivity)>>,
) -> Option<CFRetained<CFRunLoopObserver>> {
    extern "C-unwind" {
        fn CFRunLoopObserverCreateWithHandler(
            allocator: Option<&CFAllocator>,
            activities: CFOptionFlags,
            repeats: Boolean,
            order: CFIndex,
            block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopObserver, CFRunLoopActivity)>>,
        ) -> Option<NonNull<CFRunLoopObserver>>;
    }
    let ret = unsafe {
        CFRunLoopObserverCreateWithHandler(allocator, activities, repeats as _, order, block)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFRunLoopObserver::activities`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopObserverGetActivities(
    observer: &CFRunLoopObserver,
) -> CFOptionFlags {
    extern "C-unwind" {
        fn CFRunLoopObserverGetActivities(observer: &CFRunLoopObserver) -> CFOptionFlags;
    }
    unsafe { CFRunLoopObserverGetActivities(observer) }
}

#[deprecated = "renamed to `CFRunLoopObserver::does_repeat`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopObserverDoesRepeat(observer: &CFRunLoopObserver) -> bool {
    extern "C-unwind" {
        fn CFRunLoopObserverDoesRepeat(observer: &CFRunLoopObserver) -> Boolean;
    }
    let ret = unsafe { CFRunLoopObserverDoesRepeat(observer) };
    ret != 0
}

#[deprecated = "renamed to `CFRunLoopObserver::order`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopObserverGetOrder(observer: &CFRunLoopObserver) -> CFIndex {
    extern "C-unwind" {
        fn CFRunLoopObserverGetOrder(observer: &CFRunLoopObserver) -> CFIndex;
    }
    unsafe { CFRunLoopObserverGetOrder(observer) }
}

#[deprecated = "renamed to `CFRunLoopObserver::invalidate`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopObserverInvalidate(observer: &CFRunLoopObserver) {
    extern "C-unwind" {
        fn CFRunLoopObserverInvalidate(observer: &CFRunLoopObserver);
    }
    unsafe { CFRunLoopObserverInvalidate(observer) }
}

#[deprecated = "renamed to `CFRunLoopObserver::is_valid`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopObserverIsValid(observer: &CFRunLoopObserver) -> bool {
    extern "C-unwind" {
        fn CFRunLoopObserverIsValid(observer: &CFRunLoopObserver) -> Boolean;
    }
    let ret = unsafe { CFRunLoopObserverIsValid(observer) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFRunLoopObserver::context`"]
    pub fn CFRunLoopObserverGetContext(
        observer: &CFRunLoopObserver,
        context: *mut CFRunLoopObserverContext,
    );
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFRunLoopTimer::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopTimerCreate(
    allocator: Option<&CFAllocator>,
    fire_date: CFAbsoluteTime,
    interval: CFTimeInterval,
    flags: CFOptionFlags,
    order: CFIndex,
    callout: CFRunLoopTimerCallBack,
    context: *mut CFRunLoopTimerContext,
) -> Option<CFRetained<CFRunLoopTimer>> {
    extern "C-unwind" {
        fn CFRunLoopTimerCreate(
            allocator: Option<&CFAllocator>,
            fire_date: CFAbsoluteTime,
            interval: CFTimeInterval,
            flags: CFOptionFlags,
            order: CFIndex,
            callout: CFRunLoopTimerCallBack,
            context: *mut CFRunLoopTimerContext,
        ) -> Option<NonNull<CFRunLoopTimer>>;
    }
    let ret = unsafe {
        CFRunLoopTimerCreate(
            allocator, fire_date, interval, flags, order, callout, context,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFDate", feature = "block2"))]
#[deprecated = "renamed to `CFRunLoopTimer::with_handler`"]
#[inline]
pub unsafe extern "C-unwind" fn CFRunLoopTimerCreateWithHandler(
    allocator: Option<&CFAllocator>,
    fire_date: CFAbsoluteTime,
    interval: CFTimeInterval,
    flags: CFOptionFlags,
    order: CFIndex,
    block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopTimer)>>,
) -> Option<CFRetained<CFRunLoopTimer>> {
    extern "C-unwind" {
        fn CFRunLoopTimerCreateWithHandler(
            allocator: Option<&CFAllocator>,
            fire_date: CFAbsoluteTime,
            interval: CFTimeInterval,
            flags: CFOptionFlags,
            order: CFIndex,
            block: Option<&block2::DynBlock<dyn Fn(*mut CFRunLoopTimer)>>,
        ) -> Option<NonNull<CFRunLoopTimer>>;
    }
    let ret = unsafe {
        CFRunLoopTimerCreateWithHandler(allocator, fire_date, interval, flags, order, block)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFRunLoopTimer::next_fire_date`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerGetNextFireDate(timer: &CFRunLoopTimer) -> CFAbsoluteTime {
    extern "C-unwind" {
        fn CFRunLoopTimerGetNextFireDate(timer: &CFRunLoopTimer) -> CFAbsoluteTime;
    }
    unsafe { CFRunLoopTimerGetNextFireDate(timer) }
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFRunLoopTimer::set_next_fire_date`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerSetNextFireDate(
    timer: &CFRunLoopTimer,
    fire_date: CFAbsoluteTime,
) {
    extern "C-unwind" {
        fn CFRunLoopTimerSetNextFireDate(timer: &CFRunLoopTimer, fire_date: CFAbsoluteTime);
    }
    unsafe { CFRunLoopTimerSetNextFireDate(timer, fire_date) }
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFRunLoopTimer::interval`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerGetInterval(timer: &CFRunLoopTimer) -> CFTimeInterval {
    extern "C-unwind" {
        fn CFRunLoopTimerGetInterval(timer: &CFRunLoopTimer) -> CFTimeInterval;
    }
    unsafe { CFRunLoopTimerGetInterval(timer) }
}

#[deprecated = "renamed to `CFRunLoopTimer::does_repeat`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerDoesRepeat(timer: &CFRunLoopTimer) -> bool {
    extern "C-unwind" {
        fn CFRunLoopTimerDoesRepeat(timer: &CFRunLoopTimer) -> Boolean;
    }
    let ret = unsafe { CFRunLoopTimerDoesRepeat(timer) };
    ret != 0
}

#[deprecated = "renamed to `CFRunLoopTimer::order`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerGetOrder(timer: &CFRunLoopTimer) -> CFIndex {
    extern "C-unwind" {
        fn CFRunLoopTimerGetOrder(timer: &CFRunLoopTimer) -> CFIndex;
    }
    unsafe { CFRunLoopTimerGetOrder(timer) }
}

#[deprecated = "renamed to `CFRunLoopTimer::invalidate`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerInvalidate(timer: &CFRunLoopTimer) {
    extern "C-unwind" {
        fn CFRunLoopTimerInvalidate(timer: &CFRunLoopTimer);
    }
    unsafe { CFRunLoopTimerInvalidate(timer) }
}

#[deprecated = "renamed to `CFRunLoopTimer::is_valid`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerIsValid(timer: &CFRunLoopTimer) -> bool {
    extern "C-unwind" {
        fn CFRunLoopTimerIsValid(timer: &CFRunLoopTimer) -> Boolean;
    }
    let ret = unsafe { CFRunLoopTimerIsValid(timer) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFRunLoopTimer::context`"]
    pub fn CFRunLoopTimerGetContext(timer: &CFRunLoopTimer, context: *mut CFRunLoopTimerContext);
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFRunLoopTimer::tolerance`"]
#[inline]
pub extern "C-unwind" fn CFRunLoopTimerGetTolerance(timer: &CFRunLoopTimer) -> CFTimeInterval {
    extern "C-unwind" {
        fn CFRunLoopTimerGetTolerance(timer: &CFRunLoopTimer) -> CFTimeInterval;
    }
    unsafe { CFRunLoopTimerGetTolerance(timer) }
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    #[deprecated = "renamed to `CFRunLoopTimer::set_tolerance`"]
    pub fn CFRunLoopTimerSetTolerance(timer: &CFRunLoopTimer, tolerance: CFTimeInterval);
}
