/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public final class AsyncFunctionBodyNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    private JavaScriptNode functionBody;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContext;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncResult;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapability;
    private final String functionName;
    @CompilerDirectives.CompilationFinal
    private volatile CallTarget resumptionTarget;
    @Node.Child
    private volatile DirectCallNode asyncCallNode;

    public AsyncFunctionBodyNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncContext, JSWriteFrameSlotNode asyncResult, String functionName) {
        this.context = context;
        this.functionBody = body;
        this.writeAsyncContext = asyncContext;
        this.writeAsyncResult = asyncResult;
        this.newPromiseCapability = NewPromiseCapabilityNode.create(context);
        this.functionName = functionName;
        AsyncFunctionBodyNode.transferSourceSection(body, this);
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncVar, JSWriteFrameSlotNode asyncResult, String functionName) {
        return new AsyncFunctionBodyNode(context, body, asyncVar, asyncResult, functionName);
    }

    private JSContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.AsyncFunction.name());
    }

    private void initializeAsyncCallTarget() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            if (this.asyncCallTargetInitializationRequired()) {
                AsyncFunctionRootNode asyncRootNode = new AsyncFunctionRootNode(this.getContext(), this.functionBody, this.writeAsyncResult, this.getRootNode().getSourceSection(), this.functionName);
                this.resumptionTarget = Truffle.getRuntime().createCallTarget((RootNode)asyncRootNode);
                this.asyncCallNode = (DirectCallNode)this.insert((Node)DirectCallNode.create((CallTarget)this.resumptionTarget));
                this.functionBody = null;
                this.writeAsyncResult = null;
            }
        });
    }

    private boolean asyncCallTargetInitializationRequired() {
        return this.resumptionTarget == null || this.asyncCallNode == null;
    }

    private void ensureAsyncCallTargetInitialized() {
        if (this.asyncCallTargetInitializationRequired()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initializeAsyncCallTarget();
        }
    }

    private void asyncFunctionStart(VirtualFrame frame, PromiseCapabilityRecord promiseCapability) {
        this.writeAsyncContext.executeWrite(frame, new Object[]{this.resumptionTarget, promiseCapability, frame.materialize()});
        Object unusedInitialResult = null;
        this.asyncCallNode.call(new Object[]{frame.materialize(), promiseCapability, unusedInitialResult});
    }

    @Override
    public Object execute(VirtualFrame frame) {
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability.executeDefault();
        this.ensureAsyncCallTargetInitialized();
        this.asyncFunctionStart(frame, promiseCapability);
        return promiseCapability.getPromise();
    }

    private static void promiseCapabilityResolve(JSFunctionCallNode promiseCallNode, PromiseCapabilityRecord promiseCapability, Object result) {
        promiseCallNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), result));
    }

    private static void promiseCapabilityReject(JSFunctionCallNode promiseCallNode, PromiseCapabilityRecord promiseCapability, Object result) {
        promiseCallNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), result));
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return (JavaScriptNode)((Object)this.atomic(() -> {
            if (this.resumptionTarget == null) {
                return AsyncFunctionBodyNode.create(this.getContext(), AsyncFunctionBodyNode.cloneUninitialized(this.functionBody, materializedTags), AsyncFunctionBodyNode.cloneUninitialized(this.writeAsyncContext, materializedTags), AsyncFunctionBodyNode.cloneUninitialized(this.writeAsyncResult, materializedTags), this.functionName);
            }
            AsyncFunctionRootNode asyncFunctionRoot = (AsyncFunctionRootNode)((RootCallTarget)this.resumptionTarget).getRootNode();
            return AsyncFunctionBodyNode.create(this.getContext(), AsyncFunctionBodyNode.cloneUninitialized(asyncFunctionRoot.functionBody, materializedTags), AsyncFunctionBodyNode.cloneUninitialized(this.writeAsyncContext, materializedTags), AsyncFunctionBodyNode.cloneUninitialized(asyncFunctionRoot.writeAsyncResult, materializedTags), this.functionName);
        }));
    }

    @NodeInfo(cost=NodeCost.NONE, language="JavaScript", description="The root node of async functions in JavaScript.")
    public static final class AsyncFunctionRootNode
    extends JavaScriptRootNode {
        private final JSContext context;
        private final String functionName;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSWriteFrameSlotNode writeAsyncResult;
        @Node.Child
        private JSFunctionCallNode callResolveNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
        private final ValueProfile typeProfile = ValueProfile.createClassProfile();

        AsyncFunctionRootNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncResult, SourceSection functionSourceSection, String functionName) {
            super(context.getLanguage(), functionSourceSection, null);
            this.context = context;
            this.functionBody = body;
            this.writeAsyncResult = asyncResult;
            this.callResolveNode = JSFunctionCallNode.createCall();
            this.functionName = functionName;
        }

        public Object execute(VirtualFrame frame) {
            MaterializedFrame asyncFrame = JSFrameUtil.castMaterializedFrame(frame.getArguments()[0]);
            PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)frame.getArguments()[1];
            Completion resumptionValue = (Completion)frame.getArguments()[2];
            this.writeAsyncResult.executeWrite((VirtualFrame)asyncFrame, resumptionValue);
            try {
                Object result = this.functionBody.execute((VirtualFrame)asyncFrame);
                AsyncFunctionBodyNode.promiseCapabilityResolve(this.callResolveNode, promiseCapability, result);
            }
            catch (YieldException e) {
                assert (e.isAwait());
            }
            catch (Throwable e) {
                if (this.shouldCatch(e)) {
                    AsyncFunctionBodyNode.promiseCapabilityReject(this.callRejectNode, promiseCapability, this.getErrorObjectNode.execute(e));
                }
                throw e;
            }
            return Undefined.instance;
        }

        private boolean shouldCatch(Throwable exception) {
            if (this.getErrorObjectNode == null || this.callRejectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return TryCatchNode.shouldCatch(exception, this.typeProfile);
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        public String getName() {
            if (this.functionName != null && !"".equals(this.functionName)) {
                return this.functionName;
            }
            return ":async";
        }
    }
}

