/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.ant.tasks;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.codehaus.plexus.util.FileUtils;

public class AttachArtifactTask
extends Task {
    private String mavenProjectRefId = "maven.project";
    private String mavenProjectHelperRefId = "maven.project.helper";
    private File file;
    private String classifier;
    private String type;

    public void execute() {
        if (this.file == null) {
            throw new BuildException("File is a required parameter.");
        }
        if (!this.file.exists()) {
            throw new BuildException("File does not exist: " + this.file);
        }
        if (this.getProject().getReference(this.mavenProjectRefId) == null) {
            throw new BuildException("Maven project reference not found: " + this.mavenProjectRefId);
        }
        if (this.type == null) {
            this.type = FileUtils.getExtension((String)this.file.getName());
        }
        MavenProject mavenProject = (MavenProject)this.getProject().getReference(this.mavenProjectRefId);
        if (this.getProject().getReference(this.mavenProjectHelperRefId) == null) {
            throw new BuildException("Maven project helper reference not found: " + this.mavenProjectHelperRefId);
        }
        this.log("Attaching " + this.file + " as an attached artifact", 3);
        MavenProjectHelper projectHelper = (MavenProjectHelper)this.getProject().getReference(this.mavenProjectHelperRefId);
        projectHelper.attachArtifact(mavenProject, this.type, this.classifier, this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getMavenProjectRefId() {
        return this.mavenProjectRefId;
    }

    public void setMavenProjectRefId(String mavenProjectRefId) {
        this.mavenProjectRefId = mavenProjectRefId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

