/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.collections;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.collections.AbstractComponentCollection;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;

public class ComponentMap<T>
extends AbstractComponentCollection<T>
implements Map<String, T> {
    private Map<String, T> components;
    private Map<String, T> customAdditions = new LinkedHashMap<String, T>();

    public ComponentMap(MutablePlexusContainer container, Class<T> type, String role, List<String> roleHints, String hostComponent) {
        super(container, type, role, roleHints, hostComponent);
    }

    @Override
    public int size() {
        return this.getComponentDescriptorMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getComponentDescriptorMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getComponentDescriptorMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public T get(Object k) {
        return this.getMap().get(k);
    }

    @Override
    public synchronized T put(String key, T value) {
        this.logger.warn("Custom " + this.role + " implementations should NOT be added directly to this Map. Instead, add them as Plexus components.");
        T prev = this.customAdditions.put(key, value);
        if (prev == null) {
            prev = this.getComponentMap().get(key);
        }
        return prev;
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends T> map) {
        this.logger.warn("Custom " + this.role + " implementations should NOT be added directly to this Map. Instead, add them as Plexus components.");
        this.customAdditions.putAll(map);
    }

    @Override
    public Set<String> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<T> values() {
        return this.getMap().values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map object = (Map)o;
        return this.getMap().equals(object);
    }

    @Override
    public int hashCode() {
        return this.getMap().hashCode();
    }

    @Override
    public synchronized T remove(Object key) {
        this.logger.warn("Items in this Map should NOT be removed directly. If the matching entry is a component, it will NOT be removed.");
        if (key instanceof String && this.customAdditions.containsKey(key)) {
            return this.customAdditions.remove(key);
        }
        return null;
    }

    private synchronized Map<String, T> getMap() {
        Map<String, T> result = this.getComponentMap();
        if (!this.customAdditions.isEmpty()) {
            result.putAll(this.customAdditions);
        }
        return result;
    }

    private synchronized Map<String, T> getComponentMap() {
        if (this.components == null || this.checkUpdate()) {
            LinkedHashMap<String, T> componentMap = new LinkedHashMap<String, T>();
            Map descriptorMap = this.getComponentDescriptorMap();
            if (this.roleHints != null) {
                for (String roleHint : this.roleHints) {
                    ComponentDescriptor componentDescriptor = descriptorMap.get(roleHint);
                    Object component = this.lookup(componentDescriptor);
                    if (component == null) continue;
                    componentMap.put(roleHint, component);
                }
            } else {
                for (Map.Entry entry : descriptorMap.entrySet()) {
                    String roleHint = entry.getKey();
                    ComponentDescriptor componentDescriptor = entry.getValue();
                    Object component = this.lookup(componentDescriptor);
                    if (component == null) continue;
                    componentMap.put(roleHint, component);
                }
            }
            this.components = componentMap;
        }
        return this.components;
    }

    @Override
    protected boolean checkUpdate() {
        if (super.checkUpdate()) {
            this.components = null;
            return true;
        }
        return false;
    }

    @Override
    protected void releaseAllCallback() {
        if (this.components != null) {
            try {
                this.container.releaseAll(this.components);
            }
            catch (ComponentLifecycleException e) {
                this.logger.debug("Error releasing components in active collection: " + e.getMessage(), e);
            }
            this.components = null;
        }
    }
}

