/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.twiki.TWikiMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class TWikiSink
extends AbstractTextSink
implements TWikiMarkup {
    private final PrintWriter out;
    private StringWriter writer;
    private boolean boldFlag;
    private boolean headFlag;
    private int levelList = 0;
    private final Stack<String> listStyles;
    protected Stack<Boolean> boldStack = new Stack();
    protected Stack<List<String>> inlineStack = new Stack();

    protected TWikiSink(Writer writer) {
        this.out = new PrintWriter(writer);
        this.listStyles = new Stack();
        this.init();
    }

    public void anchor(String name) {
        this.write(EOL);
        this.write('#' + name);
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        this.anchor(name);
    }

    public void anchor_() {
    }

    public void author() {
    }

    public void author(SinkEventAttributes attributes) {
        this.author();
    }

    public void author_() {
    }

    public void body() {
    }

    public void body(SinkEventAttributes attributes) {
        this.body();
    }

    public void body_() {
    }

    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    public void bold_() {
        this.inline_();
    }

    public void comment(String comment) {
    }

    public void close() {
        this.out.write(this.writer.toString());
        this.out.close();
        this.init();
    }

    public void date() {
    }

    public void date(SinkEventAttributes attributes) {
        this.date();
    }

    public void date_() {
    }

    public void definedTerm() {
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.definedTerm();
    }

    public void definedTerm_() {
    }

    public void definition() {
        this.write(": ");
    }

    public void definition(SinkEventAttributes attributes) {
        this.definition();
    }

    public void definition_() {
        this.writeEOL();
    }

    public void definitionList() {
    }

    public void definitionList(SinkEventAttributes attributes) {
        this.definitionList();
    }

    public void definitionList_() {
    }

    public void definitionListItem() {
        this.write("   $ ");
    }

    public void definitionListItem(SinkEventAttributes attributes) {
        this.definitionListItem();
    }

    public void definitionListItem_() {
    }

    public void figure() {
        this.write('<' + HTML.Tag.IMG.toString() + ' ');
    }

    public void figure(SinkEventAttributes attributes) {
        this.figure();
    }

    public void figure_() {
        this.write('/' + String.valueOf('>'));
    }

    public void figureCaption() {
        this.write(HTML.Attribute.ALT.toString() + '=' + '\"');
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.figureCaption();
    }

    public void figureCaption_() {
        this.write('\"' + String.valueOf(' '));
    }

    public void figureGraphics(String name) {
        this.write(HTML.Attribute.SRC.toString() + '=' + '\"' + name + '\"' + ' ');
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        this.figureGraphics(src);
    }

    public void flush() {
        this.close();
        this.writer.flush();
    }

    public void head() {
        this.init();
        this.headFlag = true;
    }

    public void head(SinkEventAttributes attributes) {
        this.head();
    }

    public void head_() {
        this.headFlag = false;
    }

    public void horizontalRule() {
        this.writeEOL(true);
        this.write("---");
        this.writeEOL(true);
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.horizontalRule();
    }

    public void inline() {
        this.inline(null);
    }

    public void inline(SinkEventAttributes attributes) {
        ArrayList<String> tags = new ArrayList<String>();
        this.boldStack.push(this.boldFlag);
        if (attributes != null) {
            String tmp;
            if (attributes.containsAttribute((Object)"semantics", (Object)"bold")) {
                this.boldFlag = true;
                this.write("*");
                tags.add(0, "*");
            }
            if (attributes.containsAttribute((Object)"semantics", (Object)"italic")) {
                if (this.boldFlag) {
                    tmp = this.writer.toString();
                    this.writer = new StringWriter();
                    this.writer.write(tmp.substring(0, tmp.length() - 1));
                    this.write("__");
                    tags.add(0, "__");
                } else {
                    this.write("_");
                    tags.add("_");
                }
            }
            if (attributes.containsAttribute((Object)"semantics", (Object)"code")) {
                if (this.boldFlag) {
                    tmp = this.writer.toString();
                    this.writer = new StringWriter();
                    this.writer.write(tmp.substring(0, tmp.length() - 1));
                    this.write("==");
                    tags.add(0, "==");
                } else {
                    this.write("=");
                    tags.add(0, "=");
                }
            }
        }
        this.inlineStack.push(tags);
    }

    public void inline_() {
        for (String tag : this.inlineStack.pop()) {
            this.write(tag);
        }
        this.boldFlag = this.boldStack.pop();
    }

    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    public void italic_() {
        this.inline_();
    }

    public void lineBreak() {
    }

    public void lineBreak(SinkEventAttributes attributes) {
        this.lineBreak();
    }

    public void link(String name) {
        this.write("[[" + name + "][");
    }

    public void link(String name, SinkEventAttributes attributes) {
        this.link(name);
    }

    public void link_() {
        this.write("]]");
    }

    public void list() {
        if (!this.writer.toString().endsWith(EOL + EOL)) {
            this.writeEOL(true);
        }
        ++this.levelList;
    }

    public void list(SinkEventAttributes attributes) {
        this.list();
    }

    public void list_() {
        --this.levelList;
    }

    public void listItem() {
        String indent = StringUtils.repeat((String)"   ", (int)this.levelList);
        this.write(indent + "* ");
    }

    public void listItem(SinkEventAttributes attributes) {
        this.listItem();
    }

    public void listItem_() {
        this.writeEOL(true);
    }

    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    public void monospaced_() {
        this.inline_();
    }

    public void nonBreakingSpace() {
    }

    public void numberedList(int numbering) {
        String style;
        ++this.levelList;
        switch (numbering) {
            case 2: {
                style = "A.";
                break;
            }
            case 1: {
                style = "a.";
                break;
            }
            case 4: {
                style = "I.";
                break;
            }
            case 3: {
                style = "i.";
                break;
            }
            default: {
                style = "1.";
            }
        }
        this.listStyles.push(style);
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        this.numberedList(numbering);
    }

    public void numberedList_() {
        --this.levelList;
        this.listStyles.pop();
    }

    public void numberedListItem() {
        this.writeEOL(true);
        String style = this.listStyles.peek();
        String indent = StringUtils.repeat((String)"   ", (int)this.levelList);
        this.write(indent + style + ' ');
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.numberedListItem();
    }

    public void numberedListItem_() {
        this.writeEOL(true);
    }

    public void pageBreak() {
    }

    public void paragraph() {
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.paragraph();
    }

    public void paragraph_() {
        this.writeEOL(true);
        this.writeEOL();
    }

    public void rawText(String text) {
    }

    public void section(int level, SinkEventAttributes attributes) {
    }

    public void section1() {
    }

    public void section1_() {
    }

    public void section2() {
    }

    public void section2_() {
    }

    public void section3() {
    }

    public void section3_() {
    }

    public void section4() {
    }

    public void section4_() {
    }

    public void section5() {
    }

    public void section5_() {
    }

    public void section_(int level) {
    }

    public void sectionTitle() {
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        if (level > 0 && level < 6) {
            this.write(StringUtils.repeat((String)"-", (int)3) + StringUtils.repeat((String)"+", (int)level));
        }
    }

    public void sectionTitle1() {
        this.sectionTitle(1, null);
    }

    public void sectionTitle1_() {
        this.sectionTitle_(1);
    }

    public void sectionTitle2() {
        this.sectionTitle(2, null);
    }

    public void sectionTitle2_() {
        this.sectionTitle_(2);
    }

    public void sectionTitle3() {
        this.sectionTitle(3, null);
    }

    public void sectionTitle3_() {
        this.sectionTitle_(3);
    }

    public void sectionTitle4() {
        this.sectionTitle(4, null);
    }

    public void sectionTitle4_() {
        this.sectionTitle_(4);
    }

    public void sectionTitle5() {
        this.sectionTitle(5, null);
    }

    public void sectionTitle5_() {
        this.sectionTitle_(5);
    }

    public void sectionTitle_() {
    }

    public void sectionTitle_(int level) {
        this.writeEOL(true);
        this.writeEOL();
    }

    public void table() {
    }

    public void table(SinkEventAttributes attributes) {
        this.table();
    }

    public void table_() {
    }

    public void tableCaption() {
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.tableCaption();
    }

    public void tableCaption_() {
    }

    public void tableCell() {
        this.write(" ");
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell();
    }

    public void tableCell(String width) {
        this.tableCell();
    }

    public void tableCell_() {
        this.write(" |");
    }

    public void tableHeaderCell() {
        this.write(" *");
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableHeaderCell();
    }

    public void tableHeaderCell(String width) {
        this.tableHeaderCell();
    }

    public void tableHeaderCell_() {
        this.write("* |");
    }

    public void tableRow() {
        this.write("|");
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.tableRow();
    }

    public void tableRow_() {
        this.writeEOL(true);
    }

    public void tableRows(int[] justification, boolean grid) {
    }

    public void tableRows_() {
    }

    public void text(String text) {
        if (this.headFlag) {
            return;
        }
        this.content(text);
    }

    public void text(String text, SinkEventAttributes attributes) {
        if (attributes == null) {
            this.text(text);
        } else {
            if (attributes.containsAttribute((Object)"decoration", (Object)"underline")) {
                this.writeStartTag(HTML.Tag.U);
            }
            if (attributes.containsAttribute((Object)"decoration", (Object)"line-through")) {
                this.writeStartTag(HTML.Tag.S);
            }
            if (attributes.containsAttribute((Object)"valign", (Object)"sub")) {
                this.writeStartTag(HTML.Tag.SUB);
            }
            if (attributes.containsAttribute((Object)"valign", (Object)"sup")) {
                this.writeStartTag(HTML.Tag.SUP);
            }
            this.text(text);
            if (attributes.containsAttribute((Object)"valign", (Object)"sup")) {
                this.writeEndTag(HTML.Tag.SUP);
            }
            if (attributes.containsAttribute((Object)"valign", (Object)"sub")) {
                this.writeEndTag(HTML.Tag.SUB);
            }
            if (attributes.containsAttribute((Object)"decoration", (Object)"line-through")) {
                this.writeEndTag(HTML.Tag.S);
            }
            if (attributes.containsAttribute((Object)"decoration", (Object)"underline")) {
                this.writeEndTag(HTML.Tag.U);
            }
        }
    }

    public void title() {
    }

    public void title(SinkEventAttributes attributes) {
        this.title();
    }

    public void title_() {
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
    }

    public void verbatim(boolean boxed) {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (boxed) {
            att.addAttribute((Object)"decoration", (Object)"boxed");
        }
        this.verbatim((SinkEventAttributes)att);
    }

    public void verbatim(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_VERBATIM_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        boolean boxed = false;
        if (atts.isDefined("decoration")) {
            boxed = "boxed".equals(atts.getAttribute("decoration").toString());
        }
        if (boxed) {
            atts.addAttribute(HTML.Attribute.CLASS, "source");
        }
        atts.removeAttribute("decoration");
        String width = (String)atts.getAttribute(HTML.Attribute.WIDTH.toString());
        atts.removeAttribute(HTML.Attribute.WIDTH.toString());
        this.writeStartTag(HTML.Tag.DIV, atts);
        this.writeEOL(true);
        if (width != null) {
            atts.addAttribute(HTML.Attribute.WIDTH.toString(), width);
        }
        atts.removeAttribute(HTML.Attribute.ALIGN.toString());
        atts.removeAttribute(HTML.Attribute.CLASS.toString());
        this.writeStartTag(VERBATIM_TAG, atts);
    }

    public void verbatim_() {
        this.writeEndTag(VERBATIM_TAG);
        this.writeEOL(true);
        this.writeEndTag(HTML.Tag.DIV);
        this.writeEOL(true);
    }

    private void write(String text) {
        this.writer.write(TWikiSink.unifyEOLs((String)text));
    }

    private void writeStartTag(HTML.Tag t) {
        this.writeStartTag(t, null);
    }

    private void writeStartTag(HTML.Tag t, MutableAttributeSet att) {
        this.writeStartTag(t, att, false);
    }

    private void writeStartTag(HTML.Tag t, MutableAttributeSet att, boolean isSimpleTag) {
        if (t == null) {
            throw new IllegalArgumentException("A tag is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(t.toString());
        sb.append(SinkUtils.getAttributeString((AttributeSet)att));
        if (isSimpleTag) {
            sb.append(' ').append('/');
        }
        sb.append('>');
        this.write(sb.toString());
    }

    private void writeEOL() {
        this.write(EOL);
    }

    private void writeEOL(boolean trim) {
        if (!trim) {
            this.writeEOL();
            return;
        }
        String tmp = this.writer.toString().trim();
        this.writer = new StringWriter();
        this.writer.write(tmp);
        this.write(EOL);
    }

    private void writeEndTag(HTML.Tag t) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append('/');
        sb.append(t.toString());
        sb.append('>');
        this.write(sb.toString());
    }

    protected void content(String text) {
        this.write(TWikiSink.escapeHTML(text));
    }

    protected void init() {
        super.init();
        this.writer = new StringWriter();
        this.headFlag = false;
        this.levelList = 0;
        this.listStyles.clear();
        this.boldFlag = false;
    }

    protected static String escapeHTML(String text) {
        return HtmlTools.escapeHTML((String)text);
    }
}

