/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import java.util.HashMap;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;

class DispatchHandler
implements ElementHandler {
    private boolean atRoot = true;
    private String path = "/";
    private ArrayList pathStack = new ArrayList();
    private ArrayList handlerStack = new ArrayList();
    private HashMap handlers = new HashMap();
    private ElementHandler defaultHandler;

    public void addHandler(String path, ElementHandler handler) {
        this.handlers.put(path, handler);
    }

    public String getPath() {
        return this.path;
    }

    public void onEnd(ElementPath elementPath) {
        if (this.handlers != null && this.handlers.containsKey(this.path)) {
            ElementHandler handler = (ElementHandler)this.handlers.get(this.path);
            this.handlerStack.remove(this.handlerStack.size() - 1);
            handler.onEnd(elementPath);
        } else if (this.handlerStack.isEmpty() && this.defaultHandler != null) {
            this.defaultHandler.onEnd(elementPath);
        }
        this.path = (String)this.pathStack.remove(this.pathStack.size() - 1);
    }

    public void onStart(ElementPath elementPath) {
        Element element = elementPath.getCurrent();
        this.pathStack.add(this.path);
        if (this.atRoot) {
            this.path = String.valueOf(this.path) + element.getName();
            this.atRoot = false;
        } else {
            this.path = String.valueOf(this.path) + "/" + element.getName();
        }
        if (this.handlers != null && this.handlers.containsKey(this.path)) {
            ElementHandler handler = (ElementHandler)this.handlers.get(this.path);
            this.handlerStack.add(handler);
            handler.onStart(elementPath);
        } else if (this.handlerStack.isEmpty() && this.defaultHandler != null) {
            this.defaultHandler.onStart(elementPath);
        }
    }

    public ElementHandler removeHandler(String path) {
        return (ElementHandler)this.handlers.remove(path);
    }

    public void setDefaultHandler(ElementHandler handler) {
        this.defaultHandler = handler;
    }
}

