untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8A6lzNqPOO1dcZohfpUCMjfyGhacNsY2bPOKsoiRShRos6o1rxz4FVLUFUMRyuG4L+nM8jhrcXESyzJaOGna+wI=

OpenBSD 7.2 errata 016, January 21, 2023:

vmd(8) exposed unsupported cpuid feature flags to guests.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 016_vmd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install vmd:
    cd /usr/src/usr.sbin/vmd
    make obj
    make
    make install

Index: usr.sbin/vmd/vmd.c
===================================================================
RCS file: /cvs/src/usr.sbin/vmd/vmd.c,v
diff -u -p -u -r1.132 vmd.c
--- usr.sbin/vmd/vmd.c	13 Sep 2022 10:28:19 -0000	1.132
+++ usr.sbin/vmd/vmd.c	19 Jan 2023 15:29:54 -0000
@@ -665,8 +665,9 @@ vmd_check_vmh(struct vm_dump_header *vmh
 				    code, leaf);
 				return (-1);
 			}
-			if ((vmh->vmh_cpuids[i].c & c & VMM_SEFF0ECX_MASK) !=
-			    (vmh->vmh_cpuids[i].c & VMM_SEFF0ECX_MASK)) {
+#define VMM_SEFF0ECX_MASK_T (SEFF0ECX_UMIP)
+			if ((vmh->vmh_cpuids[i].c & c & VMM_SEFF0ECX_MASK_T) !=
+			    (vmh->vmh_cpuids[i].c & VMM_SEFF0ECX_MASK_T)) {
 				log_debug("%s: incompatible cpu features "
 				    "code: 0x%x leaf: 0x%x  reg: d", __func__,
 				    code, leaf);
