untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT3TThgQiq2HdT7FAYv5cled4KUjgqIgZTO8TP4k0TyYknYO9o/X0LNPj6f7FAHY0j9s0zcyOGhzr35whT4ycNQs=

OpenBSD 6.5 errata 005, June 10, 2019:

TLS handshake fails if a client supporting TLS 1.3 tries to connect to
an OpenBSD server and sends a key share extension that does not include
X25519.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 005_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
    cd /usr/src/lib/libssl
    make obj
    make
    make install

Index: lib/libssl/ssl_tlsext.c
===================================================================
RCS file: /cvs/src/lib/libssl/ssl_tlsext.c,v
retrieving revision 1.44.2.1
diff -u -p -r1.44.2.1 ssl_tlsext.c
--- lib/libssl/ssl_tlsext.c	15 May 2019 19:25:15 -0000	1.44.2.1
+++ lib/libssl/ssl_tlsext.c	5 Jun 2019 14:26:13 -0000
@@ -1269,7 +1269,6 @@ tlsext_keyshare_server_parse(SSL *s, CBS
 	CBS key_exchange;
 	uint16_t group;
 	size_t out_len;
-	int ret = 0;
 
 	if (!CBS_get_u16_length_prefixed(cbs, &client_shares))
 		goto err;
@@ -1301,11 +1300,9 @@ tlsext_keyshare_server_parse(SSL *s, CBS
 		if (!CBS_stow(&key_exchange, &S3I(s)->hs_tls13.x25519_peer_public,
 		    &out_len))
 			goto err;
-
-		ret = 1;
 	}
 
-	return ret;
+	return 1;
 
  err:
 	*alert = SSL_AD_DECODE_ERROR;
