/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.registry.json;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

class JsonTimer
extends AbstractTimer {
    private static final TimeUnit INTERNAL_STORAGE_UNIT = TimeUnit.NANOSECONDS;
    private final LongAdder elapsedTime;
    private final LongAdder count = new LongAdder();

    protected JsonTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        super(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, false);
        this.elapsedTime = new LongAdder();
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        this.elapsedTime.add(INTERNAL_STORAGE_UNIT.convert(amount, unit));
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalTime(TimeUnit unit) {
        return unit.convert(this.elapsedTime.longValue(), INTERNAL_STORAGE_UNIT);
    }

    public double max(TimeUnit unit) {
        return 0.0;
    }
}

