/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo2_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("2.2.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo2_2_0.class);

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        RealmModel sessionRealm = session.getContext().getRealm();
        session.realms().getRealmsStream().forEach(realm -> {
            session.getContext().setRealm(realm);
            this.addIdentityProviderAuthenticator(session, (RealmModel)realm);
        });
        session.getContext().setRealm(sessionRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        RealmModel sessionRealm = session.getContext().getRealm();
        session.getContext().setRealm(realm);
        this.addIdentityProviderAuthenticator(session, realm);
        session.getContext().setRealm(sessionRealm);
    }

    private void addIdentityProviderAuthenticator(KeycloakSession session, RealmModel realm) {
        String defaultProvider = session.identityProviders().getAllStream(Map.of("enabled", "true", "authenticateByDefault", "true"), Integer.valueOf(0), Integer.valueOf(1)).map(IdentityProviderModel::getAlias).findFirst().orElse(null);
        DefaultAuthenticationFlows.addIdentityProviderAuthenticator((RealmModel)realm, (String)defaultProvider);
    }
}

