/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Optional;
import javax.crypto.KeyAgreement;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.ObjectSupport;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.ECPrivateKeyWithName;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.util.ByteArrayOutputStream;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.component.VariableEntry;

public final class PKeyEC
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 1L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public PKeyEC allocate(Ruby runtime, RubyClass klass) {
            return new PKeyEC(runtime, klass);
        }
    };
    private transient Group group;
    private ECPublicKey publicKey;
    private transient PrivateKey privateKey;
    private String curveName;

    static void createPKeyEC(Ruby runtime, RubyModule PKey2, RubyClass PKeyPKey, RubyClass OpenSSLError) {
        RubyClass EC = PKey2.defineClassUnder("EC", PKeyPKey, ALLOCATOR);
        RubyClass PKeyError = PKey2.getClass("PKeyError");
        PKey2.defineClassUnder("ECError", PKeyError, PKeyError.getAllocator());
        EC.defineAnnotatedMethods(PKeyEC.class);
        EC.setConstant("NAMED_CURVE", (IRubyObject)runtime.newFixnum(1));
        Point.createPoint(runtime, EC, OpenSSLError);
        Group.createGroup(runtime, EC, OpenSSLError);
    }

    static RubyClass _EC(Ruby runtime) {
        return PKeyEC._PKey(runtime).getClass("EC");
    }

    private static RaiseException newECError(Ruby runtime, String message) {
        return Utils.newError(runtime, PKeyEC._PKey(runtime).getClass("ECError"), message);
    }

    private static RaiseException newECError(Ruby runtime, String message, Exception cause) {
        return Utils.newError(runtime, PKeyEC._PKey(runtime).getClass("ECError"), message, cause);
    }

    @JRubyMethod(meta=true)
    public static RubyArray builtin_curves(ThreadContext context2, IRubyObject self) {
        RubyString desc;
        String name2;
        Ruby runtime = context2.runtime;
        RubyArray curves = runtime.newArray();
        Enumeration names = X962NamedCurves.getNames();
        while (names.hasMoreElements()) {
            name2 = (String)names.nextElement();
            desc = name2.startsWith("prime") ? RubyString.newString((Ruby)runtime, (String)"X9.62 curve over a xxx bit prime field") : RubyString.newString((Ruby)runtime, (String)"X9.62 curve over a xxx bit binary field");
            curves.append((IRubyObject)RubyArray.newArrayNoCopy((Ruby)runtime, (IRubyObject[])new IRubyObject[]{RubyString.newString((Ruby)runtime, (String)name2), desc}));
        }
        names = SECNamedCurves.getNames();
        while (names.hasMoreElements()) {
            name2 = RubyString.newString((Ruby)runtime, (String)((String)names.nextElement()));
            desc = RubyString.newString((Ruby)runtime, (String)"SECG curve over a xxx bit binary field");
            curves.append((IRubyObject)RubyArray.newArrayNoCopy((Ruby)runtime, (IRubyObject[])new IRubyObject[]{name2, desc}));
        }
        names = NISTNamedCurves.getNames();
        while (names.hasMoreElements()) {
            name2 = RubyString.newString((Ruby)runtime, (String)((String)names.nextElement()));
            IRubyObject[] nameAndDesc = new IRubyObject[]{name2, RubyString.newEmptyString((Ruby)runtime)};
            curves.append((IRubyObject)RubyArray.newArrayNoCopy((Ruby)runtime, (IRubyObject[])nameAndDesc));
        }
        names = TeleTrusTNamedCurves.getNames();
        while (names.hasMoreElements()) {
            name2 = RubyString.newString((Ruby)runtime, (String)((String)names.nextElement()));
            desc = RubyString.newString((Ruby)runtime, (String)"RFC 5639 curve over a xxx bit prime field");
            curves.append((IRubyObject)RubyArray.newArrayNoCopy((Ruby)runtime, (IRubyObject[])new IRubyObject[]{name2, desc}));
        }
        return curves;
    }

    private static Optional<ASN1ObjectIdentifier> getCurveOID(String curveName) {
        if (curveName == null) {
            return Optional.empty();
        }
        if (curveName.indexOf(32) == curveName.length() - 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(ECUtil.getNamedCurveOid((String)curveName));
    }

    private static boolean isCurveName(String curveName) {
        return PKeyEC.getCurveOID(curveName).isPresent();
    }

    private static String getCurveName(ASN1ObjectIdentifier oid2) {
        String name2 = ECUtil.getCurveName((ASN1ObjectIdentifier)oid2);
        if (name2 == null) {
            throw new IllegalStateException("could not identify curve name from: " + oid2);
        }
        return name2;
    }

    public PKeyEC(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    PKeyEC(Ruby runtime, PublicKey pubKey) {
        this(runtime, PKeyEC._EC(runtime), null, pubKey);
    }

    PKeyEC(Ruby runtime, RubyClass type, PrivateKey privKey, PublicKey pubKey) {
        super(runtime, type);
        this.publicKey = (ECPublicKey)pubKey;
        if (privKey instanceof java.security.interfaces.ECPrivateKey) {
            this.setPrivateKey((java.security.interfaces.ECPrivateKey)privKey);
        } else {
            this.privateKey = privKey;
            this.setCurveNameFromPublicKeyIfNeeded();
        }
    }

    private String getCurveName() {
        if (this.curveName == null && this.group != null) {
            this.curveName = this.group.getCurveName();
        }
        return this.curveName;
    }

    private ECNamedCurveParameterSpec getParameterSpec() {
        return ECNamedCurveTable.getParameterSpec((String)this.getCurveName());
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getAlgorithm() {
        return "ECDSA";
    }

    @Override
    public String getKeyType() {
        return "EC";
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args, Block block) {
        KeyFactory ecdsaFactory;
        Ruby runtime = context2.runtime;
        this.privateKey = null;
        this.publicKey = null;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2) == 0) {
            return this;
        }
        IRubyObject arg = args[0];
        if (arg instanceof Group) {
            this.setGroup((Group)arg);
            return this;
        }
        IRubyObject pass = null;
        if (args.length > 1) {
            pass = args[1];
        }
        char[] passwd = PKeyEC.password(context2, pass, block);
        RubyString str = PKeyEC.readInitArg(context2, arg);
        String strJava = str.toString();
        if (PKeyEC.isCurveName(strJava)) {
            this.curveName = strJava;
            return this;
        }
        Serializable key = null;
        try {
            ecdsaFactory = SecurityHelper.getKeyFactory("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (EC)");
        }
        catch (RuntimeException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (EC) " + e);
        }
        boolean noClassDef = false;
        if (key == null && !noClassDef) {
            try {
                key = PKeyEC.readPrivateKey(strJava, passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (PEMInputOutput.PasswordRequiredException retry) {
                if (PKeyEC.ttySTDIN(context2)) {
                    try {
                        key = PKeyEC.readPrivateKey(str, PKeyEC.passwordPrompt(context2));
                    }
                    catch (Exception e) {
                        OpenSSL.debugStackTrace(runtime, e);
                    }
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readECPublicKey(new StringReader(strJava), passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readECPubKey(new StringReader(strJava));
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readECPrivateKey(ecdsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (IOException | InvalidKeySpecException e) {
                OpenSSL.debug(runtime, "PKeyEC could not read private key", e);
            }
            catch (RuntimeException e) {
                if (PKeyEC.isKeyGenerationFailure(e)) {
                    OpenSSL.debug(runtime, "PKeyEC could not read private key", e);
                }
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null) {
            key = this.tryPKCS8EncodedKey(runtime, ecdsaFactory, str.getBytes());
        }
        if (key == null) {
            key = this.tryX509EncodedKey(runtime, ecdsaFactory, str.getBytes());
        }
        if (key instanceof KeyPair) {
            PublicKey pubKey = ((KeyPair)key).getPublic();
            PrivateKey privKey = ((KeyPair)key).getPrivate();
            if (!(privKey instanceof java.security.interfaces.ECPrivateKey)) {
                if (privKey == null) {
                    throw PKeyEC.newECError(runtime, "Neither PUB key nor PRIV key: (private key is null)");
                }
                throw PKeyEC.newECError(runtime, "Neither PUB key nor PRIV key: (invalid key type " + privKey.getClass().getName() + ")");
            }
            this.publicKey = (ECPublicKey)pubKey;
            this.setPrivateKey((java.security.interfaces.ECPrivateKey)privKey);
        } else if (key instanceof java.security.interfaces.ECPrivateKey) {
            this.setPrivateKey((java.security.interfaces.ECPrivateKey)key);
        } else if (key instanceof ECPublicKey) {
            this.publicKey = (ECPublicKey)key;
            this.privateKey = null;
        } else {
            throw PKeyEC.newECError(runtime, "Neither PUB key nor PRIV key: ");
        }
        this.setCurveNameFromPublicKeyIfNeeded();
        return this;
    }

    private void setCurveNameFromPublicKeyIfNeeded() {
        String oid2;
        Optional<ASN1ObjectIdentifier> curveId;
        if (this.curveName == null && this.publicKey != null && (curveId = PKeyEC.getCurveOID(oid2 = PKeyEC.getCurveNameObjectIdFromKey(this.getRuntime(), this.publicKey))).isPresent()) {
            this.curveName = PKeyEC.getCurveName(curveId.get());
        }
    }

    void setPrivateKey(java.security.interfaces.ECPrivateKey key) {
        this.privateKey = key;
        this.unwrapPrivateKeyWithName();
    }

    private void unwrapPrivateKeyWithName() {
        java.security.interfaces.ECPrivateKey privKey = (java.security.interfaces.ECPrivateKey)this.privateKey;
        if (privKey instanceof ECPrivateKeyWithName) {
            this.privateKey = ((ECPrivateKeyWithName)privKey).unwrap();
            this.curveName = PKeyEC.getCurveName(((ECPrivateKeyWithName)privKey).getCurveNameOID());
        }
    }

    private static String getCurveNameObjectIdFromKey(Ruby runtime, ECPublicKey key) {
        try {
            AlgorithmParameters algParams = AlgorithmParameters.getInstance("EC");
            algParams.init(key.getParams());
            return algParams.getParameterSpec(ECGenParameterSpec.class).getName();
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException ex) {
            throw PKeyEC.newECError(runtime, ex.getMessage());
        }
        catch (Exception ex) {
            throw (RaiseException)PKeyEC.newECError(runtime, ex.toString()).initCause((Throwable)ex);
        }
    }

    private void setGroup(Group group2) {
        this.group = group2;
        this.curveName = this.group.getCurveName();
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        PKeyEC that = (PKeyEC)original;
        this.publicKey = that.publicKey;
        this.privateKey = that.privateKey;
        this.curveName = that.curveName;
        this.group = that.group;
        return this;
    }

    @JRubyMethod
    public IRubyObject check_key(ThreadContext context2) {
        return context2.runtime.getTrue();
    }

    @JRubyMethod(name={"generate_key!"}, alias={"generate_key"})
    public PKeyEC generate_key(ThreadContext context2) {
        try {
            ECGenParameterSpec genSpec = new ECGenParameterSpec(this.getCurveName());
            KeyPairGenerator gen = SecurityHelper.getKeyPairGenerator("EC");
            gen.initialize(genSpec, OpenSSL.getSecureRandom(context2));
            KeyPair pair = gen.generateKeyPair();
            this.publicKey = (ECPublicKey)pair.getPublic();
            this.privateKey = pair.getPrivate();
        }
        catch (GeneralSecurityException ex) {
            throw PKeyEC.newECError(context2.runtime, ex.toString());
        }
        return this;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject generate(ThreadContext context2, IRubyObject self, IRubyObject group2) {
        PKeyEC randomKey = new PKeyEC(context2.runtime, (RubyClass)self);
        if (group2 instanceof Group) {
            randomKey.setGroup((Group)group2);
        } else {
            randomKey.curveName = group2.convertToString().toString();
        }
        return randomKey.generate_key(context2);
    }

    @JRubyMethod(name={"dsa_sign_asn1"})
    public IRubyObject dsa_sign_asn1(ThreadContext context2, IRubyObject data) {
        if (this.privateKey == null) {
            throw PKeyEC.newECError(context2.runtime, "Private EC key needed!");
        }
        try {
            ECNamedCurveParameterSpec params2 = this.getParameterSpec();
            ECDSASigner signer = new ECDSASigner();
            signer.init(true, (CipherParameters)new ECPrivateKeyParameters(((java.security.interfaces.ECPrivateKey)this.privateKey).getS(), new ECDomainParameters(params2.getCurve(), params2.getG(), params2.getN(), params2.getH())));
            BigInteger[] signature = signer.generateSignature(data.convertToString().getBytes());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ASN1OutputStream asn1 = ASN1OutputStream.create((OutputStream)bytes, (String)"DER");
            ASN1EncodableVector v = new ASN1EncodableVector(2);
            v.add((ASN1Encodable)new ASN1Integer(signature[0]));
            v.add((ASN1Encodable)new ASN1Integer(signature[1]));
            asn1.writeObject((ASN1Primitive)new DERSequence(v));
            asn1.close();
            return StringHelper.newString(context2.runtime, bytes.buffer(), bytes.size());
        }
        catch (IOException ex) {
            throw PKeyEC.newECError(context2.runtime, ex.getMessage());
        }
        catch (Exception ex) {
            throw PKeyEC.newECError(context2.runtime, ex.toString(), ex);
        }
    }

    @JRubyMethod(name={"dsa_verify_asn1"})
    public IRubyObject dsa_verify_asn1(ThreadContext context2, IRubyObject data, IRubyObject sign2) {
        Ruby runtime = context2.runtime;
        try {
            ECNamedCurveParameterSpec params2 = this.getParameterSpec();
            ECDSASigner signer = new ECDSASigner();
            signer.init(false, (CipherParameters)new ECPublicKeyParameters(EC5Util.convertPoint((ECParameterSpec)this.publicKey.getParams(), (ECPoint)this.publicKey.getW()), new ECDomainParameters(params2.getCurve(), params2.getG(), params2.getN(), params2.getH())));
            ASN1Primitive vec = new ASN1InputStream(sign2.convertToString().getBytes()).readObject();
            if (!(vec instanceof ASN1Sequence)) {
                throw PKeyEC.newECError(runtime, "invalid signature (not a sequence)");
            }
            ASN1Sequence seq = (ASN1Sequence)vec;
            ASN1Integer r = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
            ASN1Integer s2 = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
            boolean verify2 = signer.verifySignature(data.convertToString().getBytes(), r.getPositiveValue(), s2.getPositiveValue());
            return runtime.newBoolean(verify2);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException ex) {
            throw PKeyEC.newECError(runtime, "invalid signature: " + ex.getMessage(), ex);
        }
    }

    @JRubyMethod(name={"dh_compute_key"})
    public IRubyObject dh_compute_key(ThreadContext context2, IRubyObject point) {
        try {
            KeyAgreement agreement = SecurityHelper.getKeyAgreement("ECDH");
            agreement.init(this.getPrivateKey());
            if (point.isNil()) {
                agreement.doPhase(this.getPublicKey(), true);
            } else {
                ECPoint ecPoint = ((Point)point).asECPoint();
                String name2 = this.getCurveName();
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                ECParameterSpec spec = PKeyEC.getParamSpec(name2);
                ECPublicKey ecPublicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(ecPoint, spec));
                agreement.doPhase(ecPublicKey, true);
            }
            byte[] secret = agreement.generateSecret();
            return StringHelper.newString(context2.runtime, secret);
        }
        catch (InvalidKeyException ex) {
            throw PKeyEC.newECError(context2.runtime, "invalid key: " + ex.getMessage());
        }
        catch (GeneralSecurityException ex) {
            throw PKeyEC.newECError(context2.runtime, ex.toString());
        }
    }

    @JRubyMethod
    public IRubyObject oid() {
        return this.getRuntime().newString("id-ecPublicKey");
    }

    private Group getGroup(boolean required) {
        if (this.group == null) {
            this.group = new Group(this.getRuntime(), this);
            return this.group;
        }
        return this.group;
    }

    @JRubyMethod
    public IRubyObject group() {
        Group group2 = this.getGroup(false);
        return group2 == null ? this.getRuntime().getNil() : group2;
    }

    @JRubyMethod(name={"group="})
    public IRubyObject set_group(IRubyObject group2) {
        this.group = group2.isNil() ? null : (Group)group2;
        return group2;
    }

    @JRubyMethod
    public IRubyObject public_key(ThreadContext context2) {
        if (this.publicKey == null) {
            return context2.nil;
        }
        return new Point(context2.runtime, this.publicKey, this.getGroup(true));
    }

    @JRubyMethod(name={"public_key="})
    public IRubyObject set_public_key(ThreadContext context2, IRubyObject arg) {
        if (!(arg instanceof Point)) {
            throw context2.runtime.newTypeError(arg, PKeyEC._EC(context2.runtime).getClass("Point"));
        }
        Point point = (Point)arg;
        ECPublicKeySpec keySpec = new ECPublicKeySpec(point.asECPoint(), this.getParamSpec());
        try {
            this.publicKey = (ECPublicKey)SecurityHelper.getKeyFactory("EC").generatePublic(keySpec);
            return arg;
        }
        catch (GeneralSecurityException ex) {
            throw PKeyEC.newECError(context2.runtime, ex.getMessage());
        }
    }

    private static ECParameterSpec getParamSpec(String curveName) {
        ECNamedCurveParameterSpec ecCurveParamSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        EllipticCurve curve = EC5Util.convertCurve((ECCurve)ecCurveParamSpec.getCurve(), (byte[])ecCurveParamSpec.getSeed());
        return EC5Util.convertSpec((EllipticCurve)curve, (org.bouncycastle.jce.spec.ECParameterSpec)ecCurveParamSpec);
    }

    private ECParameterSpec getParamSpec() {
        return PKeyEC.getParamSpec(this.getCurveName());
    }

    @JRubyMethod
    public IRubyObject private_key(ThreadContext context2) {
        if (this.privateKey == null) {
            return context2.nil;
        }
        return BN.newBN(context2.runtime, ((java.security.interfaces.ECPrivateKey)this.privateKey).getS());
    }

    @JRubyMethod(name={"private_key="})
    public IRubyObject set_private_key(ThreadContext context2, IRubyObject arg) {
        BigInteger s2 = arg instanceof BN ? ((BN)arg).getValue() : (BigInteger)arg;
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(s2, this.getParamSpec());
        try {
            this.privateKey = SecurityHelper.getKeyFactory("EC").generatePrivate(keySpec);
            return arg;
        }
        catch (GeneralSecurityException ex) {
            throw PKeyEC.newECError(context2.runtime, ex.getMessage());
        }
    }

    @JRubyMethod(name={"public?"}, alias={"public_key?"})
    public RubyBoolean public_p() {
        return this.publicKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"}, alias={"private_key?"})
    public RubyBoolean private_p() {
        return this.privateKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString public_to_der(ThreadContext context2) {
        return this.public_to_der(context2.runtime);
    }

    private RubyString public_to_der(Ruby runtime) {
        byte[] bytes;
        try {
            bytes = this.publicKey.getEncoded();
        }
        catch (Exception e) {
            throw PKeyEC.newECError(runtime, e.getMessage(), e);
        }
        return StringHelper.newString(runtime, bytes);
    }

    @Override
    @JRubyMethod(name={"to_der"})
    public RubyString to_der() {
        Ruby runtime = this.getRuntime();
        if (this.publicKey != null && this.privateKey == null) {
            return this.public_to_der(runtime);
        }
        if (this.privateKey == null) {
            throw new IllegalStateException("private key as well as public key are null");
        }
        try {
            byte[] encoded = PKeyEC.toPrivateKeyStructure((java.security.interfaces.ECPrivateKey)this.privateKey, this.publicKey, false).getEncoded("DER");
            return StringHelper.newString(runtime, encoded);
        }
        catch (Exception e) {
            throw PKeyEC.newECError(runtime, e.getMessage(), e);
        }
    }

    @JRubyMethod
    public RubyString private_to_der(ThreadContext context2) {
        return this.private_to_der(context2.runtime);
    }

    private RubyString private_to_der(Ruby runtime) {
        byte[] encoded;
        if (this.privateKey instanceof java.security.interfaces.ECPrivateKey) {
            try {
                encoded = PKeyEC.toPrivateKeyInfo((java.security.interfaces.ECPrivateKey)this.privateKey, this.publicKey).getEncoded("DER");
            }
            catch (IOException e) {
                throw PKeyEC.newECError(runtime, e.getMessage(), e);
            }
        }
        try {
            encoded = this.privateKey.getEncoded();
        }
        catch (Exception e) {
            throw PKeyEC.newECError(runtime, e.getMessage(), e);
        }
        return StringHelper.newString(runtime, encoded);
    }

    private static ECPrivateKey toPrivateKeyStructure(java.security.interfaces.ECPrivateKey privateKey, ECPublicKey publicKey, boolean compressed) throws IOException {
        ProviderConfiguration configuration = BouncyCastleProvider.CONFIGURATION;
        ECParameterSpec ecSpec = privateKey.getParams();
        X962Parameters params2 = PKeyEC.getDomainParametersFromName(ecSpec, compressed);
        int orderBitLength = ECUtil.getOrderBitLength((ProviderConfiguration)configuration, (BigInteger)(ecSpec == null ? null : ecSpec.getOrder()), (BigInteger)privateKey.getS());
        if (publicKey == null) {
            return new ECPrivateKey(orderBitLength, privateKey.getS(), (ASN1Encodable)params2);
        }
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])publicKey.getEncoded()));
        return new ECPrivateKey(orderBitLength, privateKey.getS(), info.getPublicKeyData(), (ASN1Encodable)params2);
    }

    private static PrivateKeyInfo toPrivateKeyInfo(java.security.interfaces.ECPrivateKey privateKey, ECPublicKey publicKey) throws IOException {
        ECParameterSpec ecSpec = privateKey.getParams();
        X962Parameters params2 = PKeyEC.getDomainParametersFromName(ecSpec, false);
        ECPrivateKey keyStructure = PKeyEC.toPrivateKeyStructure(privateKey, publicKey, false);
        return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params2), (ASN1Encodable)keyStructure);
    }

    private static X962Parameters getDomainParametersFromName(ECParameterSpec ecSpec, boolean compressed) {
        if (ecSpec instanceof ECNamedCurveSpec) {
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid((String)((ECNamedCurveSpec)ecSpec).getName());
            if (curveOid == null) {
                curveOid = new ASN1ObjectIdentifier(((ECNamedCurveSpec)ecSpec).getName());
            }
            return new X962Parameters(curveOid);
        }
        if (ecSpec == null) {
            return new X962Parameters((ASN1Null)DERNull.INSTANCE);
        }
        ECCurve curve = EC5Util.convertCurve((EllipticCurve)ecSpec.getCurve());
        X9ECParameters ecParameters = new X9ECParameters(curve, new X9ECPoint(EC5Util.convertPoint((ECCurve)curve, (ECPoint)ecSpec.getGenerator()), compressed), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
        return new X962Parameters(ecParameters);
    }

    @Override
    @JRubyMethod(name={"to_pem"}, alias={"export"}, rest=true)
    public RubyString to_pem(ThreadContext context2, IRubyObject[] args) {
        Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)0, (int)2);
        CipherSpec spec = null;
        char[] passwd = null;
        if (args.length > 0) {
            spec = PKeyEC.cipherSpec(args[0]);
            if (args.length > 1) {
                passwd = PKeyEC.password(context2, args[1], null);
            }
        }
        if (this.privateKey == null) {
            return this.public_to_pem(context2);
        }
        try {
            StringWriter writer = new StringWriter();
            PEMInputOutput.writeECPrivateKey(writer, (java.security.interfaces.ECPrivateKey)this.privateKey, spec, passwd);
            return RubyString.newString((Ruby)context2.runtime, (CharSequence)writer.getBuffer());
        }
        catch (IOException ex) {
            throw PKeyEC.newECError(context2.runtime, ex.getMessage());
        }
    }

    @JRubyMethod
    public RubyString public_to_pem(ThreadContext context2) {
        try {
            StringWriter writer = new StringWriter();
            PEMInputOutput.writeECPublicKey(writer, this.publicKey);
            return RubyString.newString((Ruby)context2.runtime, (CharSequence)writer.getBuffer());
        }
        catch (IOException ex) {
            throw PKeyEC.newECError(context2.runtime, ex.getMessage());
        }
    }

    @JRubyMethod
    public RubyString to_text() {
        StringBuilder result = new StringBuilder();
        ECParameterSpec spec = this.getParamSpec();
        result.append("Private-Key: (").append(spec.getOrder().bitLength()).append(" bit)").append('\n');
        if (this.privateKey instanceof java.security.interfaces.ECPrivateKey) {
            result.append("priv:");
            PKeyEC.addSplittedAndFormatted(result, ((java.security.interfaces.ECPrivateKey)this.privateKey).getS());
        }
        if (this.publicKey != null) {
            result.append("pub:");
            byte[] pubBytes = PKeyEC.encodeCompressed(this.publicKey.getW());
            StringBuilder hexBytes = new StringBuilder(pubBytes.length * 2);
            for (byte b : pubBytes) {
                hexBytes.append(Integer.toHexString(Byte.toUnsignedInt(b)));
            }
            PKeyEC.addSplittedAndFormatted(result, hexBytes);
        }
        result.append("ASN1 OID: ").append(this.getCurveName()).append('\n');
        return RubyString.newString((Ruby)this.getRuntime(), (CharSequence)result);
    }

    private static BigInteger getBigInteger(ThreadContext context2, IRubyObject arg1) {
        BigInteger bn;
        if (arg1 instanceof RubyFixnum) {
            bn = BigInteger.valueOf(arg1.convertToInteger().getLongValue());
        } else if (arg1 instanceof RubyBignum) {
            bn = ((RubyBignum)arg1).getValue();
        } else if (arg1 instanceof BN) {
            bn = ((BN)arg1).getValue();
        } else {
            Ruby runtime = context2.runtime;
            throw runtime.newTypeError(arg1, runtime.getInteger());
        }
        return bn;
    }

    static byte[] encode(ECPublicKey pubKey) {
        return PKeyEC.encodeUncompressed(pubKey.getParams().getOrder().bitLength(), pubKey.getW());
    }

    private static byte[] encodeUncompressed(int fieldSize, ECPoint point) {
        if (point == ECPoint.POINT_INFINITY) {
            return new byte[1];
        }
        int expLength = (fieldSize + 7) / 8;
        byte[] encoded = new byte[1 + expLength + expLength];
        encoded[0] = 4;
        PKeyEC.addIntBytes(point.getAffineX(), expLength, encoded, 1);
        PKeyEC.addIntBytes(point.getAffineY(), expLength, encoded, 1 + expLength);
        return encoded;
    }

    private static byte[] encodeCompressed(ECPoint point) {
        if (point == ECPoint.POINT_INFINITY) {
            return new byte[1];
        }
        int bytesLength = point.getAffineX().bitLength() / 8 + 1;
        byte[] encoded = new byte[1 + bytesLength];
        encoded[0] = (byte)(point.getAffineY().testBit(0) ? 3 : 2);
        PKeyEC.addIntBytes(point.getAffineX(), bytesLength, encoded, 1);
        return encoded;
    }

    private static void addIntBytes(BigInteger value2, int length, byte[] dest, int destOffset) {
        byte[] in = value2.toByteArray();
        if (length < in.length) {
            System.arraycopy(in, in.length - length, dest, destOffset, length);
        } else if (length > in.length) {
            System.arraycopy(in, 0, dest, destOffset + (length - in.length), in.length);
        } else {
            System.arraycopy(in, 0, dest, destOffset, length);
        }
    }

    @JRubyClass(name={"OpenSSL::PKey::EC::Point"})
    public static final class Point
    extends RubyObject {
        private ECPoint point;
        private Group group;

        static void createPoint(Ruby runtime, RubyClass EC, RubyClass OpenSSLError) {
            RubyClass Point2 = EC.defineClassUnder("Point", runtime.getObject(), Point::new);
            Point2.defineClassUnder("Error", OpenSSLError, OpenSSLError.getAllocator());
            Point2.defineAnnotatedMethods(Point.class);
        }

        public Point(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        Point(Ruby runtime, ECPublicKey publicKey, Group group2) {
            this(runtime, PKeyEC._EC(runtime).getClass("Point"));
            this.point = publicKey.getW();
            this.group = group2;
        }

        Point(Ruby runtime, ECPoint point, Group group2) {
            this(runtime, PKeyEC._EC(runtime).getClass("Point"));
            this.point = point;
            this.group = group2;
        }

        private static RaiseException newError(Ruby runtime, String message) {
            RubyClass Error2 = PKeyEC._EC(runtime).getClass("Point").getClass("Error");
            return Utils.newError(runtime, Error2, message);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject groupOrPoint) {
            this.getPointAndGroup(context2, groupOrPoint);
            return this;
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject groupOrPoint, IRubyObject bn) {
            if (this.getPointAndGroup(context2, groupOrPoint)) {
                return this;
            }
            byte[] encoded = bn instanceof BN ? ((BN)bn).getValue().abs().toByteArray() : bn.convertToString().getBytes();
            try {
                this.point = ECPointUtil.decodePoint((EllipticCurve)this.group.getCurve(), (byte[])encoded);
            }
            catch (IllegalArgumentException ex) {
                throw Point.newError(context2.runtime, ex.getMessage());
            }
            return this;
        }

        private boolean getPointAndGroup(ThreadContext context2, IRubyObject groupOrPoint) {
            Ruby runtime = context2.runtime;
            if (groupOrPoint instanceof Point) {
                this.group = ((Point)groupOrPoint).group;
                this.point = ((Point)groupOrPoint).point;
                return true;
            }
            if (!(groupOrPoint instanceof Group)) {
                throw runtime.newTypeError(groupOrPoint, PKeyEC._EC(runtime).getClass("Group"));
            }
            this.group = (Group)groupOrPoint;
            this.point = this.group.getParamSpec().getGenerator();
            return false;
        }

        @JRubyMethod(name={"==", "eql?"})
        public IRubyObject op_equal(ThreadContext context2, IRubyObject obj) {
            if (obj instanceof Point) {
                Point that = (Point)obj;
                boolean equals = this.point.equals(that.point);
                return context2.runtime.newBoolean(equals);
            }
            return context2.runtime.getFalse();
        }

        @JRubyMethod
        public IRubyObject group() {
            return this.group == null ? this.getRuntime().getNil() : this.group;
        }

        private ECPoint asECPoint() {
            return this.point;
        }

        private PointConversion getPointConversionForm() {
            if (this.group == null) {
                return null;
            }
            return this.group.conversionForm;
        }

        @JRubyMethod
        public BN to_bn(ThreadContext context2) {
            return this.toBN(context2, this.getPointConversionForm());
        }

        @JRubyMethod
        public BN to_bn(ThreadContext context2, IRubyObject conversion_form) {
            return this.toBN(context2, Group.parse_point_conversion_form(context2.runtime, conversion_form));
        }

        private BN toBN(ThreadContext context2, PointConversion conversionForm) {
            byte[] encoded = this.encodePoint(conversionForm);
            return BN.newBN(context2.runtime, new BigInteger(1, encoded));
        }

        private byte[] encodePoint(PointConversion conversionForm) {
            byte[] encoded;
            switch (conversionForm) {
                case UNCOMPRESSED: {
                    assert (this.group != null);
                    encoded = PKeyEC.encodeUncompressed(this.group.getBitLength(), this.point);
                    break;
                }
                case COMPRESSED: {
                    encoded = PKeyEC.encodeCompressed(this.point);
                    break;
                }
                case HYBRID: {
                    throw this.getRuntime().newNotImplementedError(":hybrid compression not implemented");
                }
                default: {
                    throw new AssertionError((Object)("unexpected conversion form: " + (Object)((Object)conversionForm)));
                }
            }
            return encoded;
        }

        @JRubyMethod
        public IRubyObject to_octet_string(ThreadContext context2, IRubyObject conversion_form) {
            PointConversion conversionForm = Group.parse_point_conversion_form(context2.runtime, conversion_form);
            return StringHelper.newString(context2.runtime, this.encodePoint(conversionForm));
        }

        private boolean isInfinity() {
            return this.point == ECPoint.POINT_INFINITY;
        }

        @JRubyMethod(name={"infinity?"})
        public RubyBoolean infinity_p() {
            return this.getRuntime().newBoolean(this.isInfinity());
        }

        @JRubyMethod(name={"set_to_infinity!"})
        public IRubyObject set_to_infinity_b() {
            this.point = ECPoint.POINT_INFINITY;
            return this;
        }

        @JRubyMethod
        public IRubyObject inspect() {
            VariableEntry entry = new VariableEntry("group", this.group == null ? "nil" : this.group);
            return ObjectSupport.inspect((RubyBasicObject)this, Collections.singletonList(entry));
        }

        @JRubyMethod(name={"add"})
        public IRubyObject add(ThreadContext context2, IRubyObject other) {
            Ruby runtime = context2.runtime;
            Group groupV = this.group;
            ECCurve selfCurve = EC5Util.convertCurve((EllipticCurve)groupV.getCurve());
            org.bouncycastle.math.ec.ECPoint pointSelf = EC5Util.convertPoint((ECCurve)selfCurve, (ECPoint)this.asECPoint());
            Point otherPoint = (Point)other;
            ECCurve otherCurve = EC5Util.convertCurve((EllipticCurve)otherPoint.group.getCurve());
            org.bouncycastle.math.ec.ECPoint pointOther = EC5Util.convertPoint((ECCurve)otherCurve, (ECPoint)otherPoint.asECPoint());
            org.bouncycastle.math.ec.ECPoint pointResult = pointSelf.add(pointOther);
            if (pointResult == null) {
                PKeyEC.newECError(runtime, "EC_POINT_add");
            }
            Point result = new Point(runtime, EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)pointResult), this.group);
            return result;
        }

        @JRubyMethod(name={"mul"})
        public IRubyObject mul(ThreadContext context2, IRubyObject bn1) {
            BigInteger bn;
            Ruby runtime = context2.runtime;
            if (bn1 instanceof RubyArray) {
                throw runtime.newNotImplementedError("calling #mul with arrays is not supported by this OpenSSL version");
            }
            Group groupV = this.group;
            ECCurve selfCurve = EC5Util.convertCurve((EllipticCurve)groupV.getCurve());
            org.bouncycastle.math.ec.ECPoint pointSelf = EC5Util.convertPoint((ECCurve)selfCurve, (ECPoint)this.asECPoint());
            org.bouncycastle.math.ec.ECPoint mulPoint = ECAlgorithms.referenceMultiply((org.bouncycastle.math.ec.ECPoint)pointSelf, (BigInteger)(bn = PKeyEC.getBigInteger(context2, bn1)));
            if (mulPoint == null) {
                throw PKeyEC.newECError(runtime, "bad multiply result");
            }
            return new Point(runtime, EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)mulPoint), groupV);
        }

        @JRubyMethod(name={"mul"})
        public IRubyObject mul(ThreadContext context2, IRubyObject bn1, IRubyObject bn2) {
            Ruby runtime = context2.runtime;
            if (bn1 instanceof RubyArray) {
                throw runtime.newNotImplementedError("calling #mul with arrays is not supported by this OpenSSL version");
            }
            Group groupV = this.group;
            ECCurve selfCurve = EC5Util.convertCurve((EllipticCurve)groupV.getCurve());
            org.bouncycastle.math.ec.ECPoint pointSelf = EC5Util.convertPoint((ECCurve)selfCurve, (ECPoint)this.asECPoint());
            ECCurve resultCurve = EC5Util.convertCurve((EllipticCurve)groupV.getCurve());
            org.bouncycastle.math.ec.ECPoint pointResult = EC5Util.convertPoint((ECCurve)resultCurve, (ECPoint)((Point)groupV.generator(context2)).asECPoint());
            BigInteger bn = PKeyEC.getBigInteger(context2, bn1);
            BigInteger bn_g = PKeyEC.getBigInteger(context2, bn2);
            org.bouncycastle.math.ec.ECPoint mulPoint = ECAlgorithms.sumOfTwoMultiplies((org.bouncycastle.math.ec.ECPoint)pointResult, (BigInteger)bn_g, (org.bouncycastle.math.ec.ECPoint)pointSelf, (BigInteger)bn);
            if (mulPoint == null) {
                throw PKeyEC.newECError(runtime, "bad multiply result");
            }
            return new Point(runtime, EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)mulPoint), groupV);
        }

        @JRubyMethod(name={"mul"})
        public IRubyObject mul(ThreadContext context2, IRubyObject bns, IRubyObject points, IRubyObject bn2) {
            throw context2.runtime.newNotImplementedError("calling #mul with arrays is not supported by this OpenSSL version");
        }

        @Deprecated
        public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
            int argc = Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)1, (int)2);
            switch (argc) {
                case 1: {
                    return this.initialize(context2, args[0]);
                }
                case 2: {
                    return this.initialize(context2, args[0], args[1]);
                }
            }
            throw context2.runtime.newArgumentError(args.length, 1);
        }
    }

    @JRubyClass(name={"OpenSSL::PKey::EC::Group"})
    public static final class Group
    extends RubyObject {
        private transient ECParameterSpec paramSpec;
        private PointConversion conversionForm = PointConversion.UNCOMPRESSED;
        private String curveName;
        private RubyString impl_curve_name;

        static void createGroup(Ruby runtime, RubyClass EC, RubyClass OpenSSLError) {
            RubyClass Group2 = EC.defineClassUnder("Group", runtime.getObject(), Group::new);
            Group2.defineClassUnder("Error", OpenSSLError, OpenSSLError.getAllocator());
            Group2.defineAnnotatedMethods(Group.class);
        }

        public Group(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        Group(Ruby runtime, PKeyEC key) {
            this(runtime, PKeyEC._EC(runtime).getClass("Group"));
            this.setCurveName(runtime, key.getCurveName());
        }

        @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
            Ruby runtime = context2.runtime;
            if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)4) == 1) {
                IRubyObject arg = args[0];
                if (arg instanceof Group) {
                    this.curveName = ((Group)arg).curveName;
                    return this;
                }
                this.impl_curve_name = arg.convertToString();
            }
            return this;
        }

        private String getCurveName() {
            if (this.curveName == null) {
                assert (this.impl_curve_name != null);
                return this.impl_curve_name.asJavaString();
            }
            return this.curveName;
        }

        @JRubyMethod(name={"==", "eql?"})
        public IRubyObject op_equal(ThreadContext context2, IRubyObject obj) {
            Ruby runtime = context2.runtime;
            if (obj instanceof Group) {
                Group that = (Group)obj;
                return context2.runtime.newBoolean(this.implCurveName(runtime).equals((Object)that.implCurveName(runtime)));
            }
            return context2.runtime.getFalse();
        }

        @JRubyMethod
        public IRubyObject curve_name(ThreadContext context2) {
            return this.implCurveName(context2.runtime).dup();
        }

        private RubyString implCurveName(Ruby runtime) {
            if (this.impl_curve_name == null && this.curveName != null) {
                this.setCurveName(runtime, this.curveName);
            }
            return this.impl_curve_name;
        }

        private void setCurveName(Ruby runtime, String curveName) {
            assert (curveName != null);
            this.curveName = curveName;
            String prefix = "brainpoolp";
            if (curveName.startsWith("brainpoolp")) {
                curveName = "brainpoolP" + curveName.substring(prefix.length());
            }
            this.impl_curve_name = RubyString.newString((Ruby)runtime, (String)curveName);
        }

        @JRubyMethod
        public IRubyObject order(ThreadContext context2) {
            return BN.newBN(context2.runtime, this.getParamSpec().getOrder());
        }

        @JRubyMethod
        public IRubyObject cofactor(ThreadContext context2) {
            return context2.runtime.newFixnum(this.getParamSpec().getCofactor());
        }

        @JRubyMethod
        public IRubyObject seed(ThreadContext context2) {
            byte[] seed2 = this.getCurve().getSeed();
            return seed2 == null ? context2.nil : StringHelper.newString(context2.runtime, seed2);
        }

        @JRubyMethod
        public IRubyObject degree(ThreadContext context2) {
            int fieldSize = this.getCurve().getField().getFieldSize();
            return context2.runtime.newFixnum(fieldSize);
        }

        @JRubyMethod
        public IRubyObject generator(ThreadContext context2) {
            ECPoint generator2 = this.getParamSpec().getGenerator();
            return new Point(context2.runtime, generator2, this);
        }

        @JRubyMethod(name={"to_pem"}, alias={"export"}, rest=true)
        public RubyString to_pem(ThreadContext context2, IRubyObject[] args) {
            Arity.checkArgumentCount((Ruby)context2.runtime, (IRubyObject[])args, (int)0, (int)2);
            CipherSpec spec = null;
            char[] passwd = null;
            if (args.length > 0) {
                spec = org.jruby.ext.openssl.PKey.cipherSpec(args[0]);
                if (args.length > 1) {
                    passwd = org.jruby.ext.openssl.PKey.password(context2, args[1], null);
                }
            }
            try {
                StringWriter writer = new StringWriter();
                ASN1ObjectIdentifier oid2 = (ASN1ObjectIdentifier)PKeyEC.getCurveOID(this.getCurveName()).orElseThrow(() -> PKeyEC.newECError(context2.runtime, "invalid curve name: " + this.getCurveName()));
                PEMInputOutput.writeECParameters(writer, oid2, spec, passwd);
                return RubyString.newString((Ruby)context2.runtime, (CharSequence)writer.getBuffer());
            }
            catch (IOException ex) {
                throw PKeyEC.newECError(context2.runtime, ex.getMessage());
            }
        }

        private ECParameterSpec getParamSpec() {
            if (this.paramSpec == null) {
                this.paramSpec = PKeyEC.getParamSpec(this.getCurveName());
            }
            return this.paramSpec;
        }

        EllipticCurve getCurve() {
            return this.getParamSpec().getCurve();
        }

        int getBitLength() {
            return this.getParamSpec().getOrder().bitLength();
        }

        @JRubyMethod
        public RubySymbol point_conversion_form(ThreadContext context2) {
            return context2.runtime.newSymbol(this.conversionForm.toRubyString());
        }

        @JRubyMethod(name={"point_conversion_form="})
        public IRubyObject set_point_conversion_form(ThreadContext context2, IRubyObject form) {
            this.conversionForm = Group.parse_point_conversion_form(context2.runtime, form);
            return form;
        }

        static PointConversion parse_point_conversion_form(Ruby runtime, IRubyObject form) {
            if (form instanceof RubySymbol) {
                String pointConversionForm = ((RubySymbol)form).asJavaString();
                if ("uncompressed".equals(pointConversionForm)) {
                    return PointConversion.UNCOMPRESSED;
                }
                if ("compressed".equals(pointConversionForm)) {
                    return PointConversion.COMPRESSED;
                }
                if ("hybrid".equals(pointConversionForm)) {
                    return PointConversion.HYBRID;
                }
            }
            throw runtime.newArgumentError("unsupported point conversion form: " + form.inspect());
        }
    }

    private static enum PointConversion {
        COMPRESSED,
        UNCOMPRESSED,
        HYBRID;


        String toRubyString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

