/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.NameType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.SNIEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerNameIndicationExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ServerNameIndicationExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ServerNameIndicationExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNameIndicationExtensionHandler
extends ExtensionHandler<ServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerNameIndicationExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public void adjustTLSExtensionContext(ServerNameIndicationExtensionMessage message) {
        LinkedList<SNIEntry> sniEntryList = new LinkedList<SNIEntry>();
        for (ServerNamePair pair : message.getServerNameList()) {
            NameType type = NameType.getNameType((Byte)pair.getServerNameType().getValue());
            if (type != null) {
                sniEntryList.add(new SNIEntry(new String((byte[])pair.getServerName().getValue()), type));
                continue;
            }
            LOGGER.warn("Unknown SNI Type:" + pair.getServerNameType().getValue());
        }
        this.context.setClientSNIEntryList(sniEntryList);
    }

    @Override
    public ServerNameIndicationExtensionParser getParser(byte[] message, int pointer) {
        return new ServerNameIndicationExtensionParser(pointer, message);
    }

    public ServerNameIndicationExtensionPreparator getPreparator(ServerNameIndicationExtensionMessage message) {
        return new ServerNameIndicationExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public ServerNameIndicationExtensionSerializer getSerializer(ServerNameIndicationExtensionMessage message) {
        return new ServerNameIndicationExtensionSerializer(message);
    }
}

