/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS;
import sun.security.pkcs11.wrapper.CK_TLS_PRF_PARAMS;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11TlsPrfGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private TlsPrfParameterSpec spec;
    private P11Key p11Key;
    private static final SecretKey NULL_KEY = new SecretKey(){

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public String getAlgorithm() {
            return "Generic";
        }
    };

    P11TlsPrfGenerator(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsPrfParameterSpec)algorithmParameterSpec;
        SecretKey secretKey = this.spec.getSecret();
        if (secretKey == null) {
            secretKey = NULL_KEY;
        }
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, secretKey, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        byte[] byArray = this.spec.getSeed();
        if (this.mechanism == 996L) {
            Object var2_2 = null;
            int n = 0;
            if (this.spec.getLabel().equals("server finished")) {
                n = 1;
            }
            if (this.spec.getLabel().equals("client finished")) {
                n = 2;
            }
            if (n != 0) {
                CK_TLS_MAC_PARAMS cK_TLS_MAC_PARAMS = new CK_TLS_MAC_PARAMS(Functions.getHashMechId(this.spec.getPRFHashAlg()), this.spec.getOutputLength(), n);
                Session session = null;
                long l = this.p11Key.getKeyID();
                try {
                    session = this.token.getOpSession();
                    this.token.p11.C_SignInit(session.id(), new CK_MECHANISM(this.mechanism, cK_TLS_MAC_PARAMS), l);
                    this.token.p11.C_SignUpdate(session.id(), 0L, byArray, 0, byArray.length);
                    byte[] byArray2 = this.token.p11.C_SignFinal(session.id(), this.spec.getOutputLength());
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "TlsPrf");
                    return secretKeySpec;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    throw new ProviderException("Could not calculate PRF", pKCS11Exception);
                }
                finally {
                    this.p11Key.releaseKeyID();
                    this.token.releaseSession(session);
                }
            }
            throw new ProviderException("Only Finished message authentication code generation supported for TLS 1.2.");
        }
        byte[] byArray3 = P11Util.getBytesUTF8(this.spec.getLabel());
        if (this.mechanism == 2147484531L) {
            Session session = null;
            long l = this.p11Key.getKeyID();
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SignInit(session.id(), new CK_MECHANISM(this.mechanism), l);
                this.token.p11.C_SignUpdate(session.id(), 0L, byArray3, 0, byArray3.length);
                this.token.p11.C_SignUpdate(session.id(), 0L, byArray, 0, byArray.length);
                byte[] byArray4 = this.token.p11.C_SignFinal(session.id(), this.spec.getOutputLength());
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "TlsPrf");
                return secretKeySpec;
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new ProviderException("Could not calculate PRF", pKCS11Exception);
            }
            finally {
                this.p11Key.releaseKeyID();
                this.token.releaseSession(session);
            }
        }
        byte[] byArray5 = new byte[this.spec.getOutputLength()];
        CK_TLS_PRF_PARAMS cK_TLS_PRF_PARAMS = new CK_TLS_PRF_PARAMS(byArray, byArray3, byArray5);
        Session session = null;
        long l = this.p11Key.getKeyID();
        try {
            session = this.token.getOpSession();
            this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, cK_TLS_PRF_PARAMS), l, null);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray5, "TlsPrf");
            return secretKeySpec;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not calculate PRF", pKCS11Exception);
        }
        finally {
            this.p11Key.releaseKeyID();
            this.token.releaseSession(session);
        }
    }
}

