# How you can help ATTinyCore

## Report Bugs
Please report bugs! That's how things get fixed - I am almost never aware of a problem until it is reported. Use the GitHub issues system, preferably. If not that, either via email (spencekonde@gmail.com) or via post on the Arduino forum, Microcontrollers section. **The objective of these cores is to be the most thoroughly featured, best functioning core possible** for all supported parts.

## Fix Bugs and PR!
If you have already fixed a bug in my core for yourself, you can submit those changes via github as a "pull request". If you try to "edit" a file in this repo (and you're not me), it will automatically create a fork in your github account, where you can make changes, and then send them back to me as a PR. Just please don't forget to do that last step :-) I am also very happy to accept fixes via email or any other mode of communication short of wrapping them around bricks and throwing them through my window. Github just very clearly gives you credit for the submission :-)

Note that the above includes spelling/grammar check - I write these in code editors without spell check, and I have a tendency to change how I structure sentences halfway through writing them, and not notice.

## Library Listing
There are open issues on ATTinyCore and megaTinyCore for information on which libraries are and are not compatible. Thus far, I have not gotten any feedback on this, which is disappointing. It would be, I think, a great help to users if there were a list of which libraries do and do not work with these cores (and, for cases where they do not work - any information on alternatives to those libraries). For libraries that are particular priorities, I can intervene to try to add support or get support added (I recently did that with OneWire for the megaTinyCore parts (as well as non-4809 megaAVR 0-series and new Dx-series). Similarly, if you're a library designer wondering how to make their libraries work with any of my cores, I am more than happy to assist!

## Spread the word
They say that "big news travels fast" - tinyNews needs all the help it can get. Tell your maker friends about ATTinyCore, megaTinyCore, and DxCore. There are a lot of tutorials and guides out there that point people to other cores, cores which are now minimally maintained, if they are maintained at all - so there's plenty of word-spreading to be done. The more people using ATTinyCore, the more people will be finding, reporting and/or fixing bugs, and the faster ATTinyCore will get better - so everyone wins here.

## Last but by no means least - give me money!
I will be launching a Patreon in the near future. Additionally, you can support me buy buying things from my Tindie store. Everyone needs prototyping board - and even if **you** don't, they make a great gift for your loved ones! And for your unloved ones, for that matter...

## Rewards?
While I can't promise anything beyond ecognition for pull requests or other contributions - if you submit a particularly large or impactful contribution. that's a good way to get some free stuff from my Tindie store ;-) Which, naturally, is focused on thing relating to the parts my cores supports, so it should be of particular use to you.
