/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.addsequence;

import java.util.Hashtable;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.addsequence.AddSequenceData;
import org.pentaho.di.trans.steps.addsequence.AddSequenceMeta;
import org.pentaho.di.trans.steps.addsequence.Messages;

public class AddSequence
extends BaseStep
implements StepInterface {
    private AddSequenceMeta meta;
    private AddSequenceData data;

    public AddSequence(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] addSequence(RowMetaInterface inputRowMeta, Object[] inputRowData) throws KettleException {
        Long next = null;
        if (this.meta.isCounterUsed()) {
            Counter counter = this.data.counter;
            synchronized (counter) {
                long prev = this.data.counter.getCounter();
                long nval = prev + this.data.increment;
                if (this.data.increment > 0L && this.data.maximum > this.data.start && nval > this.data.maximum) {
                    nval = this.data.start;
                }
                if (this.data.increment < 0L && this.data.maximum < this.data.start && nval < this.data.maximum) {
                    nval = this.data.start;
                }
                this.data.counter.setCounter(nval);
                next = prev;
            }
        } else if (this.meta.isDatabaseUsed()) {
            try {
                next = this.data.getDb().getNextSequenceValue(this.data.realSchemaName, this.data.realSequenceName, this.meta.getValuename());
            }
            catch (KettleDatabaseException dbe) {
                throw new KettleStepException(Messages.getString("AddSequence.Exception.ErrorReadingSequence", this.data.realSequenceName), (Throwable)dbe);
            }
        } else {
            throw new KettleStepException(Messages.getString("AddSequence.Exception.NoSpecifiedMethod"));
        }
        if (next != null) {
            Object[] outputRowData = inputRowData;
            if (inputRowData.length < inputRowMeta.size() + 1) {
                outputRowData = RowDataUtil.resizeArray((Object[])inputRowData, (int)(inputRowMeta.size() + 1));
            }
            outputRowData[inputRowMeta.size()] = next;
            return outputRowData;
        }
        throw new KettleStepException(Messages.getString("AddSequence.Exception.CouldNotFindNextValueForSequence") + this.meta.getValuename());
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AddSequenceMeta)smi;
        this.data = (AddSequenceData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
        }
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), Messages.getString("AddSequence.Log.ReadRow") + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r), new Object[0]);
        }
        try {
            this.putRow(this.data.outputRowMeta, this.addSequence(this.getInputRowMeta(), r));
            if (this.log.isRowLevel()) {
                this.log.logRowlevel(this.toString(), Messages.getString("AddSequence.Log.WriteRow") + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r), new Object[0]);
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(Messages.getString("AddSequence.Log.LineNumber") + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError(Messages.getString("AddSequence.Log.ErrorInStep") + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AddSequenceMeta)smi;
        this.data = (AddSequenceData)sdi;
        if (super.init(smi, sdi)) {
            this.data.realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
            this.data.realSequenceName = this.environmentSubstitute(this.meta.getSequenceName());
            if (this.meta.isDatabaseUsed()) {
                Database db = new Database(this.meta.getDatabase());
                db.shareVariablesWith((VariableSpace)this);
                this.data.setDb(db);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.getDb().connect(this.getTrans().getThreadName(), this.getPartitionID());
                        }
                    } else {
                        this.data.getDb().connect(this.getPartitionID());
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("AddSequence.Log.ConnectedDB"));
                    }
                    return true;
                }
                catch (KettleDatabaseException dbe) {
                    this.logError(Messages.getString("AddSequence.Log.CouldNotConnectToDB") + dbe.getMessage());
                }
            } else if (this.meta.isCounterUsed()) {
                boolean doAbort = false;
                try {
                    this.data.start = Long.parseLong(this.environmentSubstitute(this.meta.getStartAt()));
                }
                catch (NumberFormatException ex) {
                    this.logError(Messages.getString("AddSequence.Log.CouldNotParseCounterValue", "start", this.meta.getStartAt(), this.environmentSubstitute(this.meta.getStartAt()), ex.getMessage()));
                    doAbort = true;
                }
                try {
                    this.data.increment = Long.parseLong(this.environmentSubstitute(this.meta.getIncrementBy()));
                }
                catch (NumberFormatException ex) {
                    this.logError(Messages.getString("AddSequence.Log.CouldNotParseCounterValue", "increment", this.meta.getIncrementBy(), this.environmentSubstitute(this.meta.getIncrementBy()), ex.getMessage()));
                    doAbort = true;
                }
                try {
                    this.data.maximum = Long.parseLong(this.environmentSubstitute(this.meta.getMaxValue()));
                }
                catch (NumberFormatException ex) {
                    this.logError(Messages.getString("AddSequence.Log.CouldNotParseCounterValue", "increment", this.meta.getMaxValue(), this.environmentSubstitute(this.meta.getMaxValue()), ex.getMessage()));
                    doAbort = true;
                }
                if (doAbort) {
                    return false;
                }
                String realCounterName = this.environmentSubstitute(this.meta.getCounterName());
                if (!Const.isEmpty((String)realCounterName)) {
                    this.data.setLookup("@@sequence:" + this.meta.getCounterName());
                } else {
                    this.data.setLookup("@@sequence:" + this.meta.getValuename());
                }
                if (this.getTransMeta().getCounters() != null) {
                    Hashtable<String, Counter> hashtable = this.getTransMeta().getCounters();
                    synchronized (hashtable) {
                        this.data.counter = this.getTransMeta().getCounters().get(this.data.getLookup());
                        if (this.data.counter == null) {
                            this.data.counter = new Counter(this.data.start, this.data.increment, this.data.maximum);
                            this.getTransMeta().getCounters().put(this.data.getLookup(), this.data.counter);
                        } else if (this.data.counter.getStart() != this.data.start || this.data.counter.getIncrement() != this.data.increment || this.data.counter.getMaximum() != this.data.maximum) {
                            this.logError(Messages.getString("AddSequence.Log.CountersWithDifferentCharacteristics", this.data.getLookup()));
                            return false;
                        }
                    }
                    return true;
                }
                this.logError(Messages.getString("AddSequence.Log.TransformationCountersHashtableNotAllocated"));
            } else {
                this.logError(Messages.getString("AddSequence.Log.NeedToSelectSequence"));
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.meta.isCounterUsed()) {
            this.getTransMeta().getCounters().remove(this.data.getLookup());
            this.data.counter = null;
        }
        this.meta = (AddSequenceMeta)smi;
        this.data = (AddSequenceData)sdi;
        if (this.meta.isDatabaseUsed() && this.data.getDb() != null) {
            this.data.getDb().disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

