/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, 0l, 0l)
 * (0l / i64vec3(167l, 66l, 187l)) => i64vec3(0l, 0l, 0l)
 * (3l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, 0l, 0l)
 * (3l / i64vec3(167l, 66l, 187l)) => i64vec3(0l, 0l, 0l)
 * (-1192l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, -14l, -12l)
 * (-1192l / i64vec3(167l, 66l, 187l)) => i64vec3(-7l, -18l, -6l)
 * (1048576l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, 12336l, 11155l)
 * (1048576l / i64vec3(167l, 66l, 187l)) => i64vec3(6278l, 15887l, 5607l)
 * (4251475l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, 50017l, 45228l)
 * (4251475l / i64vec3(167l, 66l, 187l)) => i64vec3(25457l, 64416l, 22735l)
 * (29852643761l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, 351207573l, 317581316l)
 * (29852643761l / i64vec3(167l, 66l, 187l)) => i64vec3(178758345l, 452312784l, 159639806l)
 * (-4398046511104l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, -51741723660l, -46787728841l)
 * (-4398046511104l / i64vec3(167l, 66l, 187l)) => i64vec3(-26335607850l, -66637068350l, -23518965300l)
 * (-3948976685146l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, -46458549237l, -42010390267l)
 * (-3948976685146l / i64vec3(167l, 66l, 187l)) => i64vec3(-23646566976l, -59832980077l, -21117522380l)
 * (-135763469567146206l / i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, -1597217289025249l, -1444292229437725l)
 * (-135763469567146206l / i64vec3(167l, 66l, 187l)) => i64vec3(-812954907587701l, -2057022266168881l, -726007858647840l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, 0l, 0l))) ? 1 : -1] array0;
  float[all(equal((0l / i64vec3(167l, 66l, 187l)), i64vec3(0l, 0l, 0l))) ? 1 : -1] array1;
  float[all(equal((3l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, 0l, 0l))) ? 1 : -1] array2;
  float[all(equal((3l / i64vec3(167l, 66l, 187l)), i64vec3(0l, 0l, 0l))) ? 1 : -1] array3;
  float[all(equal((-1192l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, -14l, -12l))) ? 1 : -1] array4;
  float[all(equal((-1192l / i64vec3(167l, 66l, 187l)), i64vec3(-7l, -18l, -6l))) ? 1 : -1] array5;
  float[all(equal((1048576l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, 12336l, 11155l))) ? 1 : -1] array6;
  float[all(equal((1048576l / i64vec3(167l, 66l, 187l)), i64vec3(6278l, 15887l, 5607l))) ? 1 : -1] array7;
  float[all(equal((4251475l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, 50017l, 45228l))) ? 1 : -1] array8;
  float[all(equal((4251475l / i64vec3(167l, 66l, 187l)), i64vec3(25457l, 64416l, 22735l))) ? 1 : -1] array9;
  float[all(equal((29852643761l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, 351207573l, 317581316l))) ? 1 : -1] array10;
  float[all(equal((29852643761l / i64vec3(167l, 66l, 187l)), i64vec3(178758345l, 452312784l, 159639806l))) ? 1 : -1] array11;
  float[all(equal((-4398046511104l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, -51741723660l, -46787728841l))) ? 1 : -1] array12;
  float[all(equal((-4398046511104l / i64vec3(167l, 66l, 187l)), i64vec3(-26335607850l, -66637068350l, -23518965300l))) ? 1 : -1] array13;
  float[all(equal((-3948976685146l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, -46458549237l, -42010390267l))) ? 1 : -1] array14;
  float[all(equal((-3948976685146l / i64vec3(167l, 66l, 187l)), i64vec3(-23646566976l, -59832980077l, -21117522380l))) ? 1 : -1] array15;
  float[all(equal((-135763469567146206l / i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, -1597217289025249l, -1444292229437725l))) ? 1 : -1] array16;
  float[all(equal((-135763469567146206l / i64vec3(167l, 66l, 187l)), i64vec3(-812954907587701l, -2057022266168881l, -726007858647840l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
