/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThanEqual(dvec2(-1.5lf, -1.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(true, true)
 * lessThanEqual(dvec2(-1.5lf, -1.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(true, true)
 * lessThanEqual(dvec2(-0.5lf, -0.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(false, true)
 * lessThanEqual(dvec2(-0.5lf, -0.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(true, true)
 * lessThanEqual(dvec2(0.5lf, 0.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(false, false)
 * lessThanEqual(dvec2(0.5lf, 0.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(true, true)
 * lessThanEqual(dvec2(1.5lf, 1.5lf), dvec2(-1.5lf, -0.5lf)) => bvec2(false, false)
 * lessThanEqual(dvec2(1.5lf, 1.5lf), dvec2(0.5lf, 1.5lf)) => bvec2(false, true)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[all(equal(lessThanEqual(dvec2(-1.5lf, -1.5lf), dvec2(-1.5lf, -0.5lf)), bvec2(true, true))) ? 1 : -1] array0;
  double[all(equal(lessThanEqual(dvec2(-1.5lf, -1.5lf), dvec2(0.5lf, 1.5lf)), bvec2(true, true))) ? 1 : -1] array1;
  double[all(equal(lessThanEqual(dvec2(-0.5lf, -0.5lf), dvec2(-1.5lf, -0.5lf)), bvec2(false, true))) ? 1 : -1] array2;
  double[all(equal(lessThanEqual(dvec2(-0.5lf, -0.5lf), dvec2(0.5lf, 1.5lf)), bvec2(true, true))) ? 1 : -1] array3;
  double[all(equal(lessThanEqual(dvec2(0.5lf, 0.5lf), dvec2(-1.5lf, -0.5lf)), bvec2(false, false))) ? 1 : -1] array4;
  double[all(equal(lessThanEqual(dvec2(0.5lf, 0.5lf), dvec2(0.5lf, 1.5lf)), bvec2(true, true))) ? 1 : -1] array5;
  double[all(equal(lessThanEqual(dvec2(1.5lf, 1.5lf), dvec2(-1.5lf, -0.5lf)), bvec2(false, false))) ? 1 : -1] array6;
  double[all(equal(lessThanEqual(dvec2(1.5lf, 1.5lf), dvec2(0.5lf, 1.5lf)), bvec2(false, true))) ? 1 : -1] array7;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
