/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.common.annotation.Blocking;
import jakarta.enterprise.event.Observes;
import jakarta.ws.rs.ApplicationPath;
import org.keycloak.config.BootstrapAdminOptions;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.platform.Platform;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractNonServerCommand;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PropertyMappingInterceptor;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.utils.StringUtil;

@ApplicationPath(value="/")
@Blocking
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    private static final String KEYCLOAK_ADMIN_ENV_VAR = "KEYCLOAK_ADMIN";
    private static final String KEYCLOAK_ADMIN_PASSWORD_ENV_VAR = "KEYCLOAK_ADMIN_PASSWORD";

    void onStartupEvent(@Observes StartupEvent event) {
        QuarkusPlatform platform = (QuarkusPlatform)Platform.getPlatform();
        platform.started();
        this.startup();
        Environment.getParsedCommand().ifPresent(ac -> {
            if (ac instanceof AbstractNonServerCommand) {
                ((AbstractNonServerCommand)ac).onStart(this);
            }
        });
    }

    void onShutdownEvent(@Observes ShutdownEvent event) {
        this.shutdown();
    }

    public KeycloakSessionFactory createSessionFactory() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        instance.init();
        return instance;
    }

    protected void loadConfig() {
    }

    protected void createTemporaryAdmin(KeycloakSession session) {
        String adminUsername = this.getOption(BootstrapAdminOptions.USERNAME.getKey(), KEYCLOAK_ADMIN_ENV_VAR);
        String adminPassword = this.getOption(BootstrapAdminOptions.PASSWORD.getKey(), KEYCLOAK_ADMIN_PASSWORD_ENV_VAR);
        String clientId = Configuration.getOptionalKcValue(BootstrapAdminOptions.CLIENT_ID.getKey()).orElse(null);
        String clientSecret = Configuration.getOptionalKcValue(BootstrapAdminOptions.CLIENT_SECRET.getKey()).orElse(null);
        try {
            if (StringUtil.isNotBlank((String)adminPassword) && !this.createTemporaryMasterRealmAdminUser(adminUsername, adminPassword, session)) {
                throw new RuntimeException("Aborting startup and the creation of the master realm, because the temporary admin user account could not be created.");
            }
            if (StringUtil.isNotBlank((String)clientSecret) && !this.createTemporaryMasterRealmAdminService(clientId, clientSecret, session)) {
                throw new RuntimeException("Aborting startup and the creation of the master realm, because the temporary admin service account could not be created.");
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid admin expiration value provided. An integer is expected.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOption(String option, String envVar) {
        PropertyMappingInterceptor.disable();
        try {
            String string = Configuration.getOptionalKcValue(option).orElseGet(() -> {
                String value = System.getenv(envVar);
                if (value != null) {
                    ServicesLogger.LOGGER.usingDeprecatedEnvironmentVariable(envVar, Configuration.toEnvVarFormat("kc." + option));
                }
                return value;
            });
            return string;
        }
        finally {
            PropertyMappingInterceptor.enable();
        }
    }

    public boolean createTemporaryMasterRealmAdminUser(String adminUserName, String adminPassword, KeycloakSession session) {
        return new ApplianceBootstrap(session).createTemporaryMasterRealmAdminUser(adminUserName, adminPassword, false);
    }

    public boolean createTemporaryMasterRealmAdminService(String clientId, String clientSecret, KeycloakSession session) {
        return new ApplianceBootstrap(session).createTemporaryMasterRealmAdminService(clientId, clientSecret);
    }
}

