/*
 * This declarations of the PIC18F44J11 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:29 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F44J11_H__
#define __PIC18F44J11_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0EC6) __sfr RPOR0;
extern __at(0x0EC7) __sfr RPOR1;
extern __at(0x0EC8) __sfr RPOR2;
extern __at(0x0EC9) __sfr RPOR3;
extern __at(0x0ECA) __sfr RPOR4;
extern __at(0x0ECB) __sfr RPOR5;
extern __at(0x0ECC) __sfr RPOR6;
extern __at(0x0ECD) __sfr RPOR7;
extern __at(0x0ECE) __sfr RPOR8;
extern __at(0x0ECF) __sfr RPOR9;
extern __at(0x0ED0) __sfr RPOR10;
extern __at(0x0ED1) __sfr RPOR11;
extern __at(0x0ED2) __sfr RPOR12;
extern __at(0x0ED3) __sfr RPOR13;
extern __at(0x0ED4) __sfr RPOR14;
extern __at(0x0ED5) __sfr RPOR15;
extern __at(0x0ED6) __sfr RPOR16;
extern __at(0x0ED7) __sfr RPOR17;
extern __at(0x0ED8) __sfr RPOR18;
extern __at(0x0ED9) __sfr RPOR19;
extern __at(0x0EDA) __sfr RPOR20;
extern __at(0x0EDB) __sfr RPOR21;
extern __at(0x0EDC) __sfr RPOR22;
extern __at(0x0EDD) __sfr RPOR23;
extern __at(0x0EDE) __sfr RPOR24;
extern __at(0x0EE7) __sfr RPINR1;
extern __at(0x0EE8) __sfr RPINR2;
extern __at(0x0EE9) __sfr RPINR3;
extern __at(0x0EEA) __sfr RPINR4;
extern __at(0x0EEC) __sfr RPINR6;
extern __at(0x0EED) __sfr RPINR7;
extern __at(0x0EEE) __sfr RPINR8;
extern __at(0x0EF2) __sfr RPINR12;
extern __at(0x0EF3) __sfr RPINR13;
extern __at(0x0EF6) __sfr RPINR16;
extern __at(0x0EF7) __sfr RPINR17;
extern __at(0x0EFB) __sfr RPINR21;
extern __at(0x0EFC) __sfr RPINR22;
extern __at(0x0EFD) __sfr RPINR23;
extern __at(0x0EFE) __sfr RPINR24;

//==============================================================================
//        PPSCON Bits

extern __at(0x0EFF) __sfr PPSCON;

typedef struct
  {
  unsigned IOLOCK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSCONbits_t;

extern __at(0x0EFF) volatile __PPSCONbits_t PPSCONbits;

#define _IOLOCK                 0x01

//==============================================================================


//==============================================================================
//        PADCFG1 Bits

extern __at(0x0F3C) __sfr PADCFG1;

typedef union
  {
  struct
    {
    unsigned PMPTTL             : 1;
    unsigned RTSECSEL0          : 1;
    unsigned RTSECSEL1          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned RTSECSEL           : 2;
    unsigned                    : 5;
    };
  } __PADCFG1bits_t;

extern __at(0x0F3C) volatile __PADCFG1bits_t PADCFG1bits;

#define _PMPTTL                 0x01
#define _RTSECSEL0              0x02
#define _RTSECSEL1              0x04

//==============================================================================


//==============================================================================
//        REFOCON Bits

extern __at(0x0F3D) __sfr REFOCON;

typedef union
  {
  struct
    {
    unsigned RODIV0             : 1;
    unsigned RODIV1             : 1;
    unsigned RODIV2             : 1;
    unsigned RODIV3             : 1;
    unsigned ROSEL              : 1;
    unsigned ROSSLP             : 1;
    unsigned                    : 1;
    unsigned ROON               : 1;
    };

  struct
    {
    unsigned RODIV              : 4;
    unsigned                    : 4;
    };
  } __REFOCONbits_t;

extern __at(0x0F3D) volatile __REFOCONbits_t REFOCONbits;

#define _RODIV0                 0x01
#define _RODIV1                 0x02
#define _RODIV2                 0x04
#define _RODIV3                 0x08
#define _ROSEL                  0x10
#define _ROSSLP                 0x20
#define _ROON                   0x80

//==============================================================================


//==============================================================================
//        RTCCAL Bits

extern __at(0x0F3E) __sfr RTCCAL;

typedef struct
  {
  unsigned CAL0                 : 1;
  unsigned CAL1                 : 1;
  unsigned CAL2                 : 1;
  unsigned CAL3                 : 1;
  unsigned CAL4                 : 1;
  unsigned CAL5                 : 1;
  unsigned CAL6                 : 1;
  unsigned CAL7                 : 1;
  } __RTCCALbits_t;

extern __at(0x0F3E) volatile __RTCCALbits_t RTCCALbits;

#define _CAL0                   0x01
#define _CAL1                   0x02
#define _CAL2                   0x04
#define _CAL3                   0x08
#define _CAL4                   0x10
#define _CAL5                   0x20
#define _CAL6                   0x40
#define _CAL7                   0x80

//==============================================================================


//==============================================================================
//        RTCCFG Bits

extern __at(0x0F3F) __sfr RTCCFG;

typedef union
  {
  struct
    {
    unsigned RTCPTR0            : 1;
    unsigned RTCPTR1            : 1;
    unsigned RTCOE              : 1;
    unsigned HALFSEC            : 1;
    unsigned RTCSYNC            : 1;
    unsigned RTCWREN            : 1;
    unsigned                    : 1;
    unsigned RTCEN              : 1;
    };

  struct
    {
    unsigned RTCPTR             : 2;
    unsigned                    : 6;
    };
  } __RTCCFGbits_t;

extern __at(0x0F3F) volatile __RTCCFGbits_t RTCCFGbits;

#define _RTCPTR0                0x01
#define _RTCPTR1                0x02
#define _RTCOE                  0x04
#define _HALFSEC                0x08
#define _RTCSYNC                0x10
#define _RTCWREN                0x20
#define _RTCEN                  0x80

//==============================================================================


//==============================================================================
//        ODCON3 Bits

extern __at(0x0F40) __sfr ODCON3;

typedef struct
  {
  unsigned SPI1OD               : 1;
  unsigned SPI2OD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCON3bits_t;

extern __at(0x0F40) volatile __ODCON3bits_t ODCON3bits;

#define _SPI1OD                 0x01
#define _SPI2OD                 0x02

//==============================================================================


//==============================================================================
//        ODCON2 Bits

extern __at(0x0F41) __sfr ODCON2;

typedef struct
  {
  unsigned U1OD                 : 1;
  unsigned U2OD                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCON2bits_t;

extern __at(0x0F41) volatile __ODCON2bits_t ODCON2bits;

#define _U1OD                   0x01
#define _U2OD                   0x02

//==============================================================================


//==============================================================================
//        ODCON1 Bits

extern __at(0x0F42) __sfr ODCON1;

typedef struct
  {
  unsigned ECCP1OD              : 1;
  unsigned ECCP2OD              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCON1bits_t;

extern __at(0x0F42) volatile __ODCON1bits_t ODCON1bits;

#define _ECCP1OD                0x01
#define _ECCP2OD                0x02

//==============================================================================


//==============================================================================
//        ANCON0 Bits

extern __at(0x0F48) __sfr ANCON0;

typedef struct
  {
  unsigned PCFG0                : 1;
  unsigned PCFG1                : 1;
  unsigned PCFG2                : 1;
  unsigned PCFG3                : 1;
  unsigned PCFG4                : 1;
  unsigned PCFG5                : 1;
  unsigned PCFG6                : 1;
  unsigned PCFG7                : 1;
  } __ANCON0bits_t;

extern __at(0x0F48) volatile __ANCON0bits_t ANCON0bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04
#define _PCFG3                  0x08
#define _PCFG4                  0x10
#define _PCFG5                  0x20
#define _PCFG6                  0x40
#define _PCFG7                  0x80

//==============================================================================


//==============================================================================
//        ANCON1 Bits

extern __at(0x0F49) __sfr ANCON1;

typedef struct
  {
  unsigned PCFG8                : 1;
  unsigned PCFG9                : 1;
  unsigned PCFG10               : 1;
  unsigned PCFG11               : 1;
  unsigned PCFG12               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned VBGEN                : 1;
  } __ANCON1bits_t;

extern __at(0x0F49) volatile __ANCON1bits_t ANCON1bits;

#define _PCFG8                  0x01
#define _PCFG9                  0x02
#define _PCFG10                 0x04
#define _PCFG11                 0x08
#define _PCFG12                 0x10
#define _VBGEN                  0x80

//==============================================================================


//==============================================================================
//        DSWAKEL Bits

extern __at(0x0F4A) __sfr DSWAKEL;

typedef struct
  {
  unsigned DSPOR                : 1;
  unsigned                      : 1;
  unsigned DSMCLR               : 1;
  unsigned DSRTC                : 1;
  unsigned DSWDT                : 1;
  unsigned DSULP                : 1;
  unsigned                      : 1;
  unsigned DSFLT                : 1;
  } __DSWAKELbits_t;

extern __at(0x0F4A) volatile __DSWAKELbits_t DSWAKELbits;

#define _DSPOR                  0x01
#define _DSMCLR                 0x04
#define _DSRTC                  0x08
#define _DSWDT                  0x10
#define _DSULP                  0x20
#define _DSFLT                  0x80

//==============================================================================


//==============================================================================
//        DSWAKEH Bits

extern __at(0x0F4B) __sfr DSWAKEH;

typedef struct
  {
  unsigned DSINT0               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __DSWAKEHbits_t;

extern __at(0x0F4B) volatile __DSWAKEHbits_t DSWAKEHbits;

#define _DSINT0                 0x01

//==============================================================================


//==============================================================================
//        DSCONL Bits

extern __at(0x0F4C) __sfr DSCONL;

typedef struct
  {
  unsigned RELEASE              : 1;
  unsigned DSBOR                : 1;
  unsigned ULPWDIS              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __DSCONLbits_t;

extern __at(0x0F4C) volatile __DSCONLbits_t DSCONLbits;

#define _RELEASE                0x01
#define _DSBOR                  0x02
#define _ULPWDIS                0x04

//==============================================================================


//==============================================================================
//        DSCONH Bits

extern __at(0x0F4D) __sfr DSCONH;

typedef struct
  {
  unsigned RTCWDIS              : 1;
  unsigned DSULPEN              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned DSEN                 : 1;
  } __DSCONHbits_t;

extern __at(0x0F4D) volatile __DSCONHbits_t DSCONHbits;

#define _RTCWDIS                0x01
#define _DSULPEN                0x02
#define _DSEN                   0x80

//==============================================================================

extern __at(0x0F4E) __sfr DSGPR0;
extern __at(0x0F4F) __sfr DSGPR1;

//==============================================================================
//        TCLKCON Bits

extern __at(0x0F52) __sfr TCLKCON;

typedef struct
  {
  unsigned T3CCP1               : 1;
  unsigned T3CCP2               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned T1RUN                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TCLKCONbits_t;

extern __at(0x0F52) volatile __TCLKCONbits_t TCLKCONbits;

#define _T3CCP1                 0x01
#define _T3CCP2                 0x02
#define _T1RUN                  0x10

//==============================================================================


//==============================================================================
//        CVRCON Bits

extern __at(0x0F53) __sfr CVRCON;

typedef union
  {
  struct
    {
    unsigned CVR0               : 1;
    unsigned CVR1               : 1;
    unsigned CVR2               : 1;
    unsigned CVR3               : 1;
    unsigned CVRSS              : 1;
    unsigned CVRR               : 1;
    unsigned CVROE              : 1;
    unsigned CVREN              : 1;
    };

  struct
    {
    unsigned CVR                : 4;
    unsigned                    : 4;
    };
  } __CVRCONbits_t;

extern __at(0x0F53) volatile __CVRCONbits_t CVRCONbits;

#define _CVR0                   0x01
#define _CVR1                   0x02
#define _CVR2                   0x04
#define _CVR3                   0x08
#define _CVRSS                  0x10
#define _CVRR                   0x20
#define _CVROE                  0x40
#define _CVREN                  0x80

//==============================================================================


//==============================================================================
//        PMSTATL Bits

extern __at(0x0F54) __sfr PMSTATL;

typedef struct
  {
  unsigned OB0E                 : 1;
  unsigned OB1E                 : 1;
  unsigned OB2E                 : 1;
  unsigned OB3E                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned OBUF                 : 1;
  unsigned OBE                  : 1;
  } __PMSTATLbits_t;

extern __at(0x0F54) volatile __PMSTATLbits_t PMSTATLbits;

#define _OB0E                   0x01
#define _OB1E                   0x02
#define _OB2E                   0x04
#define _OB3E                   0x08
#define _OBUF                   0x40
#define _OBE                    0x80

//==============================================================================


//==============================================================================
//        PMSTATH Bits

extern __at(0x0F55) __sfr PMSTATH;

typedef struct
  {
  unsigned IB0F                 : 1;
  unsigned IB1F                 : 1;
  unsigned IB2F                 : 1;
  unsigned IB3F                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IBOV                 : 1;
  unsigned IBF                  : 1;
  } __PMSTATHbits_t;

extern __at(0x0F55) volatile __PMSTATHbits_t PMSTATHbits;

#define _IB0F                   0x01
#define _IB1F                   0x02
#define _IB2F                   0x04
#define _IB3F                   0x08
#define _IBOV                   0x40
#define _IBF                    0x80

//==============================================================================


//==============================================================================
//        PMEL Bits

extern __at(0x0F56) __sfr PMEL;

typedef struct
  {
  unsigned PTEN0                : 1;
  unsigned PTEN1                : 1;
  unsigned PTEN2                : 1;
  unsigned PTEN3                : 1;
  unsigned PTEN4                : 1;
  unsigned PTEN5                : 1;
  unsigned PTEN6                : 1;
  unsigned PTEN7                : 1;
  } __PMELbits_t;

extern __at(0x0F56) volatile __PMELbits_t PMELbits;

#define _PTEN0                  0x01
#define _PTEN1                  0x02
#define _PTEN2                  0x04
#define _PTEN3                  0x08
#define _PTEN4                  0x10
#define _PTEN5                  0x20
#define _PTEN6                  0x40
#define _PTEN7                  0x80

//==============================================================================


//==============================================================================
//        PMEH Bits

extern __at(0x0F57) __sfr PMEH;

typedef struct
  {
  unsigned PTEN8                : 1;
  unsigned PTEN9                : 1;
  unsigned PTEN10               : 1;
  unsigned PTEN11               : 1;
  unsigned PTEN12               : 1;
  unsigned PTEN13               : 1;
  unsigned PTEN14               : 1;
  unsigned PTEN15               : 1;
  } __PMEHbits_t;

extern __at(0x0F57) volatile __PMEHbits_t PMEHbits;

#define _PTEN8                  0x01
#define _PTEN9                  0x02
#define _PTEN10                 0x04
#define _PTEN11                 0x08
#define _PTEN12                 0x10
#define _PTEN13                 0x20
#define _PTEN14                 0x40
#define _PTEN15                 0x80

//==============================================================================

extern __at(0x0F58) __sfr PMDIN2L;
extern __at(0x0F59) __sfr PMDIN2H;
extern __at(0x0F5A) __sfr PMDOUT2L;
extern __at(0x0F5B) __sfr PMDOUT2H;

//==============================================================================
//        PMMODEL Bits

extern __at(0x0F5C) __sfr PMMODEL;

typedef union
  {
  struct
    {
    unsigned WAITE0             : 1;
    unsigned WAITE1             : 1;
    unsigned WAITM0             : 1;
    unsigned WAITM1             : 1;
    unsigned WAITM2             : 1;
    unsigned WAITM3             : 1;
    unsigned WAITB0             : 1;
    unsigned WAITB1             : 1;
    };

  struct
    {
    unsigned WAITE              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned WAITM              : 4;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned WAITB              : 2;
    };
  } __PMMODELbits_t;

extern __at(0x0F5C) volatile __PMMODELbits_t PMMODELbits;

#define _WAITE0                 0x01
#define _WAITE1                 0x02
#define _WAITM0                 0x04
#define _WAITM1                 0x08
#define _WAITM2                 0x10
#define _WAITM3                 0x20
#define _WAITB0                 0x40
#define _WAITB1                 0x80

//==============================================================================


//==============================================================================
//        PMMODEH Bits

extern __at(0x0F5D) __sfr PMMODEH;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE16             : 1;
    unsigned INCM0              : 1;
    unsigned INCM1              : 1;
    unsigned IRQM0              : 1;
    unsigned IRQM1              : 1;
    unsigned BUSY               : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned INCM               : 2;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 5;
    unsigned IRQM               : 2;
    unsigned                    : 1;
    };
  } __PMMODEHbits_t;

extern __at(0x0F5D) volatile __PMMODEHbits_t PMMODEHbits;

#define _MODE0                  0x01
#define _MODE1                  0x02
#define _MODE16                 0x04
#define _INCM0                  0x08
#define _INCM1                  0x10
#define _IRQM0                  0x20
#define _IRQM1                  0x40
#define _BUSY                   0x80

//==============================================================================


//==============================================================================
//        PMCONL Bits

extern __at(0x0F5E) __sfr PMCONL;

typedef union
  {
  struct
    {
    unsigned RDSP               : 1;
    unsigned WRSP               : 1;
    unsigned BEP                : 1;
    unsigned CS1P               : 1;
    unsigned CS2P               : 1;
    unsigned ALP                : 1;
    unsigned CSF0               : 1;
    unsigned CSF1               : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CSF                : 2;
    };
  } __PMCONLbits_t;

extern __at(0x0F5E) volatile __PMCONLbits_t PMCONLbits;

#define _RDSP                   0x01
#define _WRSP                   0x02
#define _BEP                    0x04
#define _CS1P                   0x08
#define _CS2P                   0x10
#define _ALP                    0x20
#define _CSF0                   0x40
#define _CSF1                   0x80

//==============================================================================


//==============================================================================
//        PMCONH Bits

extern __at(0x0F5F) __sfr PMCONH;

typedef union
  {
  struct
    {
    unsigned PTRDEN             : 1;
    unsigned PTWREN             : 1;
    unsigned PTBEEN             : 1;
    unsigned ADRMUX0            : 1;
    unsigned ADRMUX1            : 1;
    unsigned PSIDL              : 1;
    unsigned                    : 1;
    unsigned PMPEN              : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ADRMUX             : 2;
    unsigned                    : 3;
    };
  } __PMCONHbits_t;

extern __at(0x0F5F) volatile __PMCONHbits_t PMCONHbits;

#define _PTRDEN                 0x01
#define _PTWREN                 0x02
#define _PTBEEN                 0x04
#define _ADRMUX0                0x08
#define _ADRMUX1                0x10
#define _PSIDL                  0x20
#define _PMPEN                  0x80

//==============================================================================

extern __at(0x0F66) __sfr DMABCH;
extern __at(0x0F67) __sfr DMABCL;
extern __at(0x0F68) __sfr RXADDRH;
extern __at(0x0F69) __sfr RXADDRL;
extern __at(0x0F6A) __sfr TXADDRH;
extern __at(0x0F6B) __sfr TXADDRL;
extern __at(0x0F6C) __sfr PMDIN1L;
extern __at(0x0F6D) __sfr PMDIN1H;
extern __at(0x0F6E) __sfr PMADDRL;
extern __at(0x0F6E) __sfr PMDOUT1L;

//==============================================================================
//        PMADDRH Bits

extern __at(0x0F6F) __sfr PMADDRH;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CS1                  : 1;
  unsigned                      : 1;
  } __PMADDRHbits_t;

extern __at(0x0F6F) volatile __PMADDRHbits_t PMADDRHbits;

#define _CS1                    0x40

//==============================================================================

extern __at(0x0F6F) __sfr PMDOUT1H;

//==============================================================================
//        CMSTAT Bits

extern __at(0x0F70) __sfr CMSTAT;

typedef struct
  {
  unsigned COUT1                : 1;
  unsigned COUT2                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMSTATbits_t;

extern __at(0x0F70) volatile __CMSTATbits_t CMSTATbits;

#define _COUT1                  0x01
#define _COUT2                  0x02

//==============================================================================


//==============================================================================
//        CMSTATUS Bits

extern __at(0x0F70) __sfr CMSTATUS;

typedef struct
  {
  unsigned COUT1                : 1;
  unsigned COUT2                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMSTATUSbits_t;

extern __at(0x0F70) volatile __CMSTATUSbits_t CMSTATUSbits;

#define _CMSTATUS_COUT1         0x01
#define _CMSTATUS_COUT2         0x02

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x0F71) __sfr SSP2CON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP2CON2bits_t;

extern __at(0x0F71) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_ADMSK1        0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_ADMSK2        0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ADMSK3        0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ADMSK4        0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ADMSK5        0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x0F72) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x0F72) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2STAT Bits

extern __at(0x0F73) __sfr SSP2STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP2STATbits_t;

extern __at(0x0F73) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================


//==============================================================================
//        SSP2ADD Bits

extern __at(0x0F74) __sfr SSP2ADD;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP2ADDbits_t;

extern __at(0x0F74) volatile __SSP2ADDbits_t SSP2ADDbits;

#define _SSP2ADD_MSK0           0x01
#define _SSP2ADD_MSK1           0x02
#define _SSP2ADD_MSK2           0x04
#define _SSP2ADD_MSK3           0x08
#define _SSP2ADD_MSK4           0x10
#define _SSP2ADD_MSK5           0x20
#define _SSP2ADD_MSK6           0x40
#define _SSP2ADD_MSK7           0x80

//==============================================================================


//==============================================================================
//        SSP2MSK Bits

extern __at(0x0F74) __sfr SSP2MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP2MSKbits_t;

extern __at(0x0F74) volatile __SSP2MSKbits_t SSP2MSKbits;

#define _SSP2MSK_MSK0           0x01
#define _SSP2MSK_MSK1           0x02
#define _SSP2MSK_MSK2           0x04
#define _SSP2MSK_MSK3           0x08
#define _SSP2MSK_MSK4           0x10
#define _SSP2MSK_MSK5           0x20
#define _SSP2MSK_MSK6           0x40
#define _SSP2MSK_MSK7           0x80

//==============================================================================

extern __at(0x0F75) __sfr SSP2BUF;

//==============================================================================
//        T4CON Bits

extern __at(0x0F76) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0F76) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x0F77) __sfr PR4;
extern __at(0x0F78) __sfr TMR4;

//==============================================================================
//        T3CON Bits

extern __at(0x0F79) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned RD16               : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0F79) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_RD16             0x02
#define _T3CON_T3SYNC           0x04
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_TMR3CS0          0x40
#define _T3CON_TMR3CS1          0x80

//==============================================================================

extern __at(0x0F7A) __sfr TMR3;
extern __at(0x0F7A) __sfr TMR3L;
extern __at(0x0F7B) __sfr TMR3H;

//==============================================================================
//        BAUDCON2 Bits

extern __at(0x0F7C) __sfr BAUDCON2;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON2bits_t;

extern __at(0x0F7C) volatile __BAUDCON2bits_t BAUDCON2bits;

#define _BAUDCON2_ABDEN         0x01
#define _BAUDCON2_WUE           0x02
#define _BAUDCON2_BRG16         0x08
#define _BAUDCON2_TXCKP         0x10
#define _BAUDCON2_RXDTP         0x20
#define _BAUDCON2_RCIDL         0x40
#define _BAUDCON2_ABDOVF        0x80

//==============================================================================

extern __at(0x0F7D) __sfr SPBRGH2;

//==============================================================================
//        BAUDCON Bits

extern __at(0x0F7E) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x0F7E) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _TXCKP                  0x10
#define _RXDTP                  0x20
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x0F7E) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x0F7E) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_TXCKP         0x10
#define _BAUDCON1_RXDTP         0x20
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0F7E) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned TXCKP                : 1;
  unsigned RXDTP                : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x0F7E) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_TXCKP          0x10
#define _BAUDCTL_RXDTP          0x20
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================

extern __at(0x0F7F) __sfr SPBRGH;
extern __at(0x0F7F) __sfr SPBRGH1;

//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned                    : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned                    : 1;
    unsigned AN4                : 1;
    unsigned OSC2               : 1;
    unsigned OSC1               : 1;
    };

  struct
    {
    unsigned C1INA              : 1;
    unsigned C2INA              : 1;
    unsigned VREF_MINUS         : 1;
    unsigned VREF_PLUS          : 1;
    unsigned                    : 1;
    unsigned NOT_SS1            : 1;
    unsigned CLKO               : 1;
    unsigned CLKI               : 1;
    };

  struct
    {
    unsigned PMA6               : 1;
    unsigned PMA7               : 1;
    unsigned CVREF_MINUS        : 1;
    unsigned C1INB              : 1;
    unsigned                    : 1;
    unsigned HLVDIN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned C2INB              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCV                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ULPWU              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RP2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _AN0                    0x01
#define _C1INA                  0x01
#define _PMA6                   0x01
#define _RP0                    0x01
#define _ULPWU                  0x01
#define _RA1                    0x02
#define _AN1                    0x02
#define _C2INA                  0x02
#define _PMA7                   0x02
#define _RP1                    0x02
#define _RA2                    0x04
#define _AN2                    0x04
#define _VREF_MINUS             0x04
#define _CVREF_MINUS            0x04
#define _C2INB                  0x04
#define _RA3                    0x08
#define _AN3                    0x08
#define _VREF_PLUS              0x08
#define _C1INB                  0x08
#define _RA5                    0x20
#define _AN4                    0x20
#define _NOT_SS1                0x20
#define _HLVDIN                 0x20
#define _RCV                    0x20
#define _RP2                    0x20
#define _RA6                    0x40
#define _OSC2                   0x40
#define _CLKO                   0x40
#define _RA7                    0x80
#define _OSC1                   0x80
#define _CLKI                   0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned AN12               : 1;
    unsigned AN10               : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned PMA1               : 1;
    unsigned PMA0               : 1;
    unsigned KBI2               : 1;
    unsigned KBI3               : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned PMPBE              : 1;
    unsigned CTEDG1             : 1;
    unsigned CTEDG2             : 1;
    unsigned KBI0               : 1;
    unsigned KBI1               : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned RP3                : 1;
    unsigned RTCC               : 1;
    unsigned PMA3               : 1;
    unsigned PMA2               : 1;
    unsigned RP7                : 1;
    unsigned RP8                : 1;
    unsigned RP9                : 1;
    unsigned RP10               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned RP4                : 1;
    unsigned REFO               : 1;
    unsigned RP6                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RP5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned KBI                : 4;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _AN12                   0x01
#define _INT0                   0x01
#define _RP3                    0x01
#define _RB1                    0x02
#define _AN10                   0x02
#define _PMPBE                  0x02
#define _RTCC                   0x02
#define _RP4                    0x02
#define _RB2                    0x04
#define _AN8                    0x04
#define _CTEDG1                 0x04
#define _PMA3                   0x04
#define _REFO                   0x04
#define _RP5                    0x04
#define _RB3                    0x08
#define _AN9                    0x08
#define _CTEDG2                 0x08
#define _PMA2                   0x08
#define _RP6                    0x08
#define _RB4                    0x10
#define _PMA1                   0x10
#define _KBI0                   0x10
#define _RP7                    0x10
#define _RB5                    0x20
#define _PMA0                   0x20
#define _KBI1                   0x20
#define _RP8                    0x20
#define _RB6                    0x40
#define _KBI2                   0x40
#define _PGC                    0x40
#define _RP9                    0x40
#define _RB7                    0x80
#define _KBI3                   0x80
#define _PGD                    0x80
#define _RP10                   0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned AN11               : 1;
    unsigned SCK1               : 1;
    unsigned SDI1               : 1;
    unsigned SDO1               : 1;
    unsigned PMA5               : 1;
    unsigned PMA4               : 1;
    };

  struct
    {
    unsigned T1CKI              : 1;
    unsigned RP12               : 1;
    unsigned CTPLS              : 1;
    unsigned SCL1               : 1;
    unsigned RP15               : 1;
    unsigned RP16               : 1;
    unsigned TX1                : 1;
    unsigned RX1                : 1;
    };

  struct
    {
    unsigned RP11               : 1;
    unsigned                    : 1;
    unsigned RP13               : 1;
    unsigned RP14               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CK1                : 1;
    unsigned DT1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RP17               : 1;
    unsigned RP18               : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _T1OSO                  0x01
#define _T1CKI                  0x01
#define _RP11                   0x01
#define _RC1                    0x02
#define _T1OSI                  0x02
#define _RP12                   0x02
#define _RC2                    0x04
#define _AN11                   0x04
#define _CTPLS                  0x04
#define _RP13                   0x04
#define _RC3                    0x08
#define _SCK1                   0x08
#define _SCL1                   0x08
#define _RP14                   0x08
#define _RC4                    0x10
#define _SDI1                   0x10
#define _RP15                   0x10
#define _RC5                    0x20
#define _SDO1                   0x20
#define _RP16                   0x20
#define _RC6                    0x40
#define _PMA5                   0x40
#define _TX1                    0x40
#define _CK1                    0x40
#define _RP17                   0x40
#define _RC7                    0x80
#define _PMA4                   0x80
#define _RX1                    0x80
#define _DT1                    0x80
#define _RP18                   0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0F83) __sfr PORTD;

typedef union
  {
  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };

  struct
    {
    unsigned PMD0               : 1;
    unsigned PMD1               : 1;
    unsigned PMD2               : 1;
    unsigned PMD3               : 1;
    unsigned PMD4               : 1;
    unsigned PMD5               : 1;
    unsigned PMD6               : 1;
    unsigned PMD7               : 1;
    };

  struct
    {
    unsigned SCL2               : 1;
    unsigned SDA2               : 1;
    unsigned RP19               : 1;
    unsigned RP20               : 1;
    unsigned RP21               : 1;
    unsigned RP22               : 1;
    unsigned RP23               : 1;
    unsigned RP24               : 1;
    };
  } __PORTDbits_t;

extern __at(0x0F83) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _PMD0                   0x01
#define _SCL2                   0x01
#define _RD1                    0x02
#define _PMD1                   0x02
#define _SDA2                   0x02
#define _RD2                    0x04
#define _PMD2                   0x04
#define _RP19                   0x04
#define _RD3                    0x08
#define _PMD3                   0x08
#define _RP20                   0x08
#define _RD4                    0x10
#define _PMD4                   0x10
#define _RP21                   0x10
#define _RD5                    0x20
#define _PMD5                   0x20
#define _RP22                   0x20
#define _RD6                    0x40
#define _PMD6                   0x40
#define _RP23                   0x40
#define _RD7                    0x80
#define _PMD7                   0x80
#define _RP24                   0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned REPU               : 1;
    unsigned RDPU               : 1;
    };

  struct
    {
    unsigned AN5                : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PMPRD              : 1;
    unsigned PMPWR              : 1;
    unsigned PMPCS              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 3;
    unsigned                    : 5;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _AN5                    0x01
#define _PMPRD                  0x01
#define _RE1                    0x02
#define _AN6                    0x02
#define _PMPWR                  0x02
#define _RE2                    0x04
#define _AN7                    0x04
#define _PMPCS                  0x04
#define _REPU                   0x40
#define _RDPU                   0x80

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0F85) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned BGVST              : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0F85) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _HLVDL1                 0x02
#define _HLVDL2                 0x04
#define _HLVDL3                 0x08
#define _HLVDEN                 0x10
#define _IRVST                  0x20
#define _BGVST                  0x40
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        DMACON2 Bits

extern __at(0x0F86) __sfr DMACON2;

typedef union
  {
  struct
    {
    unsigned INTLVL0            : 1;
    unsigned INTLVL1            : 1;
    unsigned INTLVL2            : 1;
    unsigned INTLVL3            : 1;
    unsigned DLYCYC0            : 1;
    unsigned DLYCYC1            : 1;
    unsigned DLYCYC2            : 1;
    unsigned DLYCYC3            : 1;
    };

  struct
    {
    unsigned INTLVL             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DLYCYC             : 4;
    };
  } __DMACON2bits_t;

extern __at(0x0F86) volatile __DMACON2bits_t DMACON2bits;

#define _INTLVL0                0x01
#define _INTLVL1                0x02
#define _INTLVL2                0x04
#define _INTLVL3                0x08
#define _DLYCYC0                0x10
#define _DLYCYC1                0x20
#define _DLYCYC2                0x40
#define _DLYCYC3                0x80

//==============================================================================


//==============================================================================
//        DMACON1 Bits

extern __at(0x0F88) __sfr DMACON1;

typedef union
  {
  struct
    {
    unsigned DMAEN              : 1;
    unsigned DLYINTEN           : 1;
    unsigned DUPLEX0            : 1;
    unsigned DUPLEX1            : 1;
    unsigned RXINC              : 1;
    unsigned TXINC              : 1;
    unsigned SSCON0             : 1;
    unsigned SSCON1             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DUPLEX             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 6;
    unsigned SSCON              : 2;
    };
  } __DMACON1bits_t;

extern __at(0x0F88) volatile __DMACON1bits_t DMACON1bits;

#define _DMAEN                  0x01
#define _DLYINTEN               0x02
#define _DUPLEX0                0x04
#define _DUPLEX1                0x08
#define _RXINC                  0x10
#define _TXINC                  0x20
#define _SSCON0                 0x40
#define _SSCON1                 0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned                      : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x0F8C) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x0F8C) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0F8D) __sfr LATE;

typedef union
  {
  struct
    {
    unsigned LATE0              : 1;
    unsigned LATE1              : 1;
    unsigned LATE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATE               : 3;
    unsigned                    : 5;
    };
  } __LATEbits_t;

extern __at(0x0F8D) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04

//==============================================================================

extern __at(0x0F8E) __sfr ALRMVALL;
extern __at(0x0F8F) __sfr ALRMVALH;

//==============================================================================
//        ALRMRPT Bits

extern __at(0x0F90) __sfr ALRMRPT;

typedef struct
  {
  unsigned ARPT0                : 1;
  unsigned ARPT1                : 1;
  unsigned ARPT2                : 1;
  unsigned ARPT3                : 1;
  unsigned ARPT4                : 1;
  unsigned ARPT5                : 1;
  unsigned ARPT6                : 1;
  unsigned ARPT7                : 1;
  } __ALRMRPTbits_t;

extern __at(0x0F90) volatile __ALRMRPTbits_t ALRMRPTbits;

#define _ARPT0                  0x01
#define _ARPT1                  0x02
#define _ARPT2                  0x04
#define _ARPT3                  0x08
#define _ARPT4                  0x10
#define _ARPT5                  0x20
#define _ARPT6                  0x40
#define _ARPT7                  0x80

//==============================================================================


//==============================================================================
//        ALRMCFG Bits

extern __at(0x0F91) __sfr ALRMCFG;

typedef union
  {
  struct
    {
    unsigned ALRMPTR0           : 1;
    unsigned ALRMPTR1           : 1;
    unsigned AMASK0             : 1;
    unsigned AMASK1             : 1;
    unsigned AMASK2             : 1;
    unsigned AMASK3             : 1;
    unsigned CHIME              : 1;
    unsigned ALRMEN             : 1;
    };

  struct
    {
    unsigned ALRMPTR            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned AMASK              : 4;
    unsigned                    : 2;
    };
  } __ALRMCFGbits_t;

extern __at(0x0F91) volatile __ALRMCFGbits_t ALRMCFGbits;

#define _ALRMPTR0               0x01
#define _ALRMPTR1               0x02
#define _AMASK0                 0x04
#define _AMASK1                 0x08
#define _AMASK2                 0x10
#define _AMASK3                 0x20
#define _CHIME                  0x40
#define _ALRMEN                 0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned                      : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0F95) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x0F95) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0F96) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISE              : 3;
    unsigned                    : 5;
    };
  } __TRISEbits_t;

extern __at(0x0F96) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x0F97) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_T3DONE       : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3DONE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0F97) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_T3DONE           0x08
#define _T3GGO                  0x08
#define _T3DONE                 0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================

extern __at(0x0F98) __sfr RTCVALL;
extern __at(0x0F99) __sfr RTCVALH;

//==============================================================================
//        T1GCON Bits

extern __at(0x0F9A) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_T1DONE       : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1DONE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0F9A) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_T1DONE           0x08
#define _T1GGO                  0x08
#define _T1DONE                 0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned PLLEN              : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _PLLEN                  0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        RCSTA2 Bits

extern __at(0x0F9C) __sfr RCSTA2;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D2              : 1;
    unsigned OERR2              : 1;
    unsigned FERR2              : 1;
    unsigned ADDEN2             : 1;
    unsigned CREN2              : 1;
    unsigned SREN2              : 1;
    unsigned RX92               : 1;
    unsigned SPEN2              : 1;
    };
  } __RCSTA2bits_t;

extern __at(0x0F9C) volatile __RCSTA2bits_t RCSTA2bits;

#define _RCSTA2_RX9D            0x01
#define _RCSTA2_RX9D2           0x01
#define _RCSTA2_OERR            0x02
#define _RCSTA2_OERR2           0x02
#define _RCSTA2_FERR            0x04
#define _RCSTA2_FERR2           0x04
#define _RCSTA2_ADDEN           0x08
#define _RCSTA2_ADDEN2          0x08
#define _RCSTA2_CREN            0x10
#define _RCSTA2_CREN2           0x10
#define _RCSTA2_SREN            0x20
#define _RCSTA2_SREN2           0x20
#define _RCSTA2_RX9             0x40
#define _RCSTA2_RX92            0x40
#define _RCSTA2_SPEN            0x80
#define _RCSTA2_SPEN2           0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned ADIE               : 1;
    unsigned PMPIE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _SSPIE                  0x08
#define _TX1IE                  0x10
#define _TXIE                   0x10
#define _RC1IE                  0x20
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _PMPIE                  0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned ADIF               : 1;
    unsigned PMPIF              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _SSPIF                  0x08
#define _TX1IF                  0x10
#define _TXIF                   0x10
#define _RC1IF                  0x20
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _PMPIF                  0x80

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned CCP1IP             : 1;
    unsigned SSP1IP             : 1;
    unsigned TX1IP              : 1;
    unsigned RC1IP              : 1;
    unsigned ADIP               : 1;
    unsigned PMPIP              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIP              : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSP1IP                 0x08
#define _SSPIP                  0x08
#define _TX1IP                  0x10
#define _TXIP                   0x10
#define _RC1IP                  0x20
#define _RCIP                   0x20
#define _ADIP                   0x40
#define _PMPIP                  0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned CCP2IE             : 1;
    unsigned TMR3IE             : 1;
    unsigned LVDIE              : 1;
    unsigned BCL1IE             : 1;
    unsigned                    : 1;
    unsigned CM1IE              : 1;
    unsigned CM2IE              : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BCLIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR3IE                 0x02
#define _LVDIE                  0x04
#define _BCL1IE                 0x08
#define _BCLIE                  0x08
#define _CM1IE                  0x20
#define _CM2IE                  0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned CCP2IF             : 1;
    unsigned TMR3IF             : 1;
    unsigned LVDIF              : 1;
    unsigned BCL1IF             : 1;
    unsigned                    : 1;
    unsigned CM1IF              : 1;
    unsigned CM2IF              : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BCLIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR3IF                 0x02
#define _LVDIF                  0x04
#define _BCL1IF                 0x08
#define _BCLIF                  0x08
#define _CM1IF                  0x20
#define _CM2IF                  0x40
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned CCP2IP             : 1;
    unsigned TMR3IP             : 1;
    unsigned LVDIP              : 1;
    unsigned BCL1IP             : 1;
    unsigned                    : 1;
    unsigned CM1IP              : 1;
    unsigned CM2IP              : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BCLIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _CCP2IP                 0x01
#define _TMR3IP                 0x02
#define _LVDIP                  0x04
#define _BCL1IP                 0x08
#define _BCLIP                  0x08
#define _CM1IP                  0x20
#define _CM2IP                  0x40
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned RTCCIE               : 1;
  unsigned TMR3GIE              : 1;
  unsigned CTMUIE               : 1;
  unsigned TMR4IE               : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned BCL2IE               : 1;
  unsigned SSP2IE               : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _RTCCIE                 0x01
#define _TMR3GIE                0x02
#define _CTMUIE                 0x04
#define _TMR4IE                 0x08
#define _TX2IE                  0x10
#define _RC2IE                  0x20
#define _BCL2IE                 0x40
#define _SSP2IE                 0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned RTCCIF               : 1;
  unsigned TMR3GIF              : 1;
  unsigned CTMUIF               : 1;
  unsigned TMR4IF               : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned BCL2IF               : 1;
  unsigned SSP2IF               : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _RTCCIF                 0x01
#define _TMR3GIF                0x02
#define _CTMUIF                 0x04
#define _TMR4IF                 0x08
#define _TX2IF                  0x10
#define _RC2IF                  0x20
#define _BCL2IF                 0x40
#define _SSP2IF                 0x80

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned RTCCIP               : 1;
  unsigned TMR3GIP              : 1;
  unsigned CTMUIP               : 1;
  unsigned TMR4IP               : 1;
  unsigned TX2IP                : 1;
  unsigned RC2IP                : 1;
  unsigned BCL2IP               : 1;
  unsigned SSP2IP               : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _RTCCIP                 0x01
#define _TMR3GIP                0x02
#define _CTMUIP                 0x04
#define _TMR4IP                 0x08
#define _TX2IP                  0x10
#define _RC2IP                  0x20
#define _BCL2IP                 0x40
#define _SSP2IP                 0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned                      : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned WPROG                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _WPROG                  0x20

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;

//==============================================================================
//        TXSTA2 Bits

extern __at(0x0FA8) __sfr TXSTA2;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D2              : 1;
    unsigned TRMT2              : 1;
    unsigned BRGH2              : 1;
    unsigned SENDB2             : 1;
    unsigned SYNC2              : 1;
    unsigned TXEN2              : 1;
    unsigned TX92               : 1;
    unsigned CSRC2              : 1;
    };
  } __TXSTA2bits_t;

extern __at(0x0FA8) volatile __TXSTA2bits_t TXSTA2bits;

#define _TXSTA2_TX9D            0x01
#define _TXSTA2_TX9D2           0x01
#define _TXSTA2_TRMT            0x02
#define _TXSTA2_TRMT2           0x02
#define _TXSTA2_BRGH            0x04
#define _TXSTA2_BRGH2           0x04
#define _TXSTA2_SENDB           0x08
#define _TXSTA2_SENDB2          0x08
#define _TXSTA2_SYNC            0x10
#define _TXSTA2_SYNC2           0x10
#define _TXSTA2_TXEN            0x20
#define _TXSTA2_TXEN2           0x20
#define _TXSTA2_TX9             0x40
#define _TXSTA2_TX92            0x40
#define _TXSTA2_CSRC            0x80
#define _TXSTA2_CSRC2           0x80

//==============================================================================

extern __at(0x0FA9) __sfr TXREG2;
extern __at(0x0FAA) __sfr RCREG2;
extern __at(0x0FAB) __sfr SPBRG2;

//==============================================================================
//        RCSTA Bits

extern __at(0x0FAC) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAC) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _RX9D1                  0x01
#define _OERR                   0x02
#define _OERR1                  0x02
#define _FERR                   0x04
#define _FERR1                  0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _ADDEN1                 0x08
#define _CREN                   0x10
#define _CREN1                  0x10
#define _SREN                   0x20
#define _SREN1                  0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _NOT_RC8                0x40
#define _RC8_9                  0x40
#define _RX91                   0x40
#define _SPEN                   0x80
#define _SPEN1                  0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x0FAC) __sfr RCSTA1;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTA1bits_t;

extern __at(0x0FAC) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_RCD8            0x01
#define _RCSTA1_RX9D1           0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_OERR1           0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_FERR1           0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_ADEN            0x08
#define _RCSTA1_ADDEN1          0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_CREN1           0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_SREN1           0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_RC9             0x40
#define _RCSTA1_NOT_RC8         0x40
#define _RCSTA1_RC8_9           0x40
#define _RCSTA1_RX91            0x40
#define _RCSTA1_SPEN            0x80
#define _RCSTA1_SPEN1           0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAD) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0FAD) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TX9D1                  0x01
#define _TRMT                   0x02
#define _TRMT1                  0x02
#define _BRGH                   0x04
#define _BRGH1                  0x04
#define _SENDB                  0x08
#define _SENDB1                 0x08
#define _SYNC                   0x10
#define _SYNC1                  0x10
#define _TXEN                   0x20
#define _TXEN1                  0x20
#define _TX9                    0x40
#define _TX8_9                  0x40
#define _NOT_TX8                0x40
#define _TX91                   0x40
#define _CSRC                   0x80
#define _CSRC1                  0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x0FAD) __sfr TXSTA1;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTA1bits_t;

extern __at(0x0FAD) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TXD8            0x01
#define _TXSTA1_TX9D1           0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_TRMT1           0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_BRGH1           0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SENDB1          0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_SYNC1           0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TXEN1           0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_TX8_9           0x40
#define _TXSTA1_NOT_TX8         0x40
#define _TXSTA1_TX91            0x40
#define _TXSTA1_CSRC            0x80
#define _TXSTA1_CSRC1           0x80

//==============================================================================

extern __at(0x0FAE) __sfr TXREG;
extern __at(0x0FAE) __sfr TXREG1;
extern __at(0x0FAF) __sfr RCREG;
extern __at(0x0FAF) __sfr RCREG1;
extern __at(0x0FB0) __sfr SPBRG;
extern __at(0x0FB0) __sfr SPBRG1;

//==============================================================================
//        CTMUICON Bits

extern __at(0x0FB1) __sfr CTMUICON;

typedef union
  {
  struct
    {
    unsigned IRNG0              : 1;
    unsigned IRNG1              : 1;
    unsigned ITRIM0             : 1;
    unsigned ITRIM1             : 1;
    unsigned ITRIM2             : 1;
    unsigned ITRIM3             : 1;
    unsigned ITRIM4             : 1;
    unsigned ITRIM5             : 1;
    };

  struct
    {
    unsigned IRNG               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ITRIM              : 6;
    };
  } __CTMUICONbits_t;

extern __at(0x0FB1) volatile __CTMUICONbits_t CTMUICONbits;

#define _IRNG0                  0x01
#define _IRNG1                  0x02
#define _ITRIM0                 0x04
#define _ITRIM1                 0x08
#define _ITRIM2                 0x10
#define _ITRIM3                 0x20
#define _ITRIM4                 0x40
#define _ITRIM5                 0x80

//==============================================================================


//==============================================================================
//        CTMUCONL Bits

extern __at(0x0FB2) __sfr CTMUCONL;

typedef union
  {
  struct
    {
    unsigned EDG1STAT           : 1;
    unsigned EDG2STAT           : 1;
    unsigned EDG1SEL0           : 1;
    unsigned EDG1SEL1           : 1;
    unsigned EDG1POL            : 1;
    unsigned EDG2SEL0           : 1;
    unsigned EDG2SEL1           : 1;
    unsigned EDG2POL            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned EDG1SEL            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned EDG2SEL            : 2;
    unsigned                    : 1;
    };
  } __CTMUCONLbits_t;

extern __at(0x0FB2) volatile __CTMUCONLbits_t CTMUCONLbits;

#define _EDG1STAT               0x01
#define _EDG2STAT               0x02
#define _EDG1SEL0               0x04
#define _EDG1SEL1               0x08
#define _EDG1POL                0x10
#define _EDG2SEL0               0x20
#define _EDG2SEL1               0x40
#define _EDG2POL                0x80

//==============================================================================


//==============================================================================
//        CTMUCONH Bits

extern __at(0x0FB3) __sfr CTMUCONH;

typedef struct
  {
  unsigned CTTRIG               : 1;
  unsigned IDISSEN              : 1;
  unsigned EDGSEQEN             : 1;
  unsigned EDGEN                : 1;
  unsigned TGEN                 : 1;
  unsigned CTMUSIDL             : 1;
  unsigned                      : 1;
  unsigned CTMUEN               : 1;
  } __CTMUCONHbits_t;

extern __at(0x0FB3) volatile __CTMUCONHbits_t CTMUCONHbits;

#define _CTTRIG                 0x01
#define _IDISSEN                0x02
#define _EDGSEQEN               0x04
#define _EDGEN                  0x08
#define _TGEN                   0x10
#define _CTMUSIDL               0x20
#define _CTMUEN                 0x80

//==============================================================================


//==============================================================================
//        CCP2CON Bits

extern __at(0x0FB4) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0FB4) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20
#define _P2M0                   0x40
#define _P2M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP2CON Bits

extern __at(0x0FB4) __sfr ECCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __ECCP2CONbits_t;

extern __at(0x0FB4) volatile __ECCP2CONbits_t ECCP2CONbits;

#define _ECCP2CON_CCP2M0        0x01
#define _ECCP2CON_CCP2M1        0x02
#define _ECCP2CON_CCP2M2        0x04
#define _ECCP2CON_CCP2M3        0x08
#define _ECCP2CON_DC2B0         0x10
#define _ECCP2CON_CCP2Y         0x10
#define _ECCP2CON_DC2B1         0x20
#define _ECCP2CON_CCP2X         0x20
#define _ECCP2CON_P2M0          0x40
#define _ECCP2CON_P2M1          0x80

//==============================================================================

extern __at(0x0FB5) __sfr CCPR2;
extern __at(0x0FB5) __sfr CCPR2L;
extern __at(0x0FB6) __sfr CCPR2H;

//==============================================================================
//        ECCP2DEL Bits

extern __at(0x0FB7) __sfr ECCP2DEL;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };
  } __ECCP2DELbits_t;

extern __at(0x0FB7) volatile __ECCP2DELbits_t ECCP2DELbits;

#define _P2DC0                  0x01
#define _P2DC1                  0x02
#define _P2DC2                  0x04
#define _P2DC3                  0x08
#define _P2DC4                  0x10
#define _P2DC5                  0x20
#define _P2DC6                  0x40
#define _P2RSEN                 0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0FB7) __sfr PWM2CON;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };
  } __PWM2CONbits_t;

extern __at(0x0FB7) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2CON_P2DC0          0x01
#define _PWM2CON_P2DC1          0x02
#define _PWM2CON_P2DC2          0x04
#define _PWM2CON_P2DC3          0x08
#define _PWM2CON_P2DC4          0x10
#define _PWM2CON_P2DC5          0x20
#define _PWM2CON_P2DC6          0x40
#define _PWM2CON_P2RSEN         0x80

//==============================================================================


//==============================================================================
//        ECCP2AS Bits

extern __at(0x0FB8) __sfr ECCP2AS;

typedef union
  {
  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned ECCP2AS0           : 1;
    unsigned ECCP2AS1           : 1;
    unsigned ECCP2AS2           : 1;
    unsigned ECCP2ASE           : 1;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP2AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP2ASbits_t;

extern __at(0x0FB8) volatile __ECCP2ASbits_t ECCP2ASbits;

#define _PSS2BD0                0x01
#define _PSS2BD1                0x02
#define _PSS2AC0                0x04
#define _PSS2AC1                0x08
#define _ECCP2AS0               0x10
#define _ECCP2AS1               0x20
#define _ECCP2AS2               0x40
#define _ECCP2ASE               0x80

//==============================================================================


//==============================================================================
//        PSTR2CON Bits

extern __at(0x0FB9) __sfr PSTR2CON;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned STRSYNC            : 1;
    unsigned P2DC5              : 1;
    unsigned CMPL0              : 1;
    unsigned CMPL1              : 1;
    };

  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC52             : 1;
    unsigned P2DC6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P2DC02             : 1;
    unsigned P2DC12             : 1;
    unsigned P2DC22             : 1;
    unsigned P2DC32             : 1;
    unsigned P2DC42             : 1;
    unsigned                    : 1;
    unsigned P2DC62             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CMPL               : 2;
    };
  } __PSTR2CONbits_t;

extern __at(0x0FB9) volatile __PSTR2CONbits_t PSTR2CONbits;

#define _PSTR2CON_STRA          0x01
#define _PSTR2CON_P2DC0         0x01
#define _PSTR2CON_P2DC02        0x01
#define _PSTR2CON_STRB          0x02
#define _PSTR2CON_P2DC1         0x02
#define _PSTR2CON_P2DC12        0x02
#define _PSTR2CON_STRC          0x04
#define _PSTR2CON_P2DC2         0x04
#define _PSTR2CON_P2DC22        0x04
#define _PSTR2CON_STRD          0x08
#define _PSTR2CON_P2DC3         0x08
#define _PSTR2CON_P2DC32        0x08
#define _PSTR2CON_STRSYNC       0x10
#define _PSTR2CON_P2DC4         0x10
#define _PSTR2CON_P2DC42        0x10
#define _PSTR2CON_P2DC5         0x20
#define _PSTR2CON_P2DC52        0x20
#define _PSTR2CON_CMPL0         0x40
#define _PSTR2CON_P2DC6         0x40
#define _PSTR2CON_P2DC62        0x40
#define _PSTR2CON_CMPL1         0x80

//==============================================================================


//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBA) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBA) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP1CON Bits

extern __at(0x0FBA) __sfr ECCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __ECCP1CONbits_t;

extern __at(0x0FBA) volatile __ECCP1CONbits_t ECCP1CONbits;

#define _ECCP1CON_CCP1M0        0x01
#define _ECCP1CON_CCP1M1        0x02
#define _ECCP1CON_CCP1M2        0x04
#define _ECCP1CON_CCP1M3        0x08
#define _ECCP1CON_DC1B0         0x10
#define _ECCP1CON_CCP1Y         0x10
#define _ECCP1CON_DC1B1         0x20
#define _ECCP1CON_CCP1X         0x20
#define _ECCP1CON_P1M0          0x40
#define _ECCP1CON_P1M1          0x80

//==============================================================================

extern __at(0x0FBB) __sfr CCPR1;
extern __at(0x0FBB) __sfr CCPR1L;
extern __at(0x0FBC) __sfr CCPR1H;

//==============================================================================
//        ECCP1DEL Bits

extern __at(0x0FBD) __sfr ECCP1DEL;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __ECCP1DELbits_t;

extern __at(0x0FBD) volatile __ECCP1DELbits_t ECCP1DELbits;

#define _P1DC0                  0x01
#define _P1DC1                  0x02
#define _P1DC2                  0x04
#define _P1DC3                  0x08
#define _P1DC4                  0x10
#define _P1DC5                  0x20
#define _P1DC6                  0x40
#define _P1RSEN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0FBD) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0FBD) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1CON_P1DC0          0x01
#define _PWM1CON_P1DC1          0x02
#define _PWM1CON_P1DC2          0x04
#define _PWM1CON_P1DC3          0x08
#define _PWM1CON_P1DC4          0x10
#define _PWM1CON_P1DC5          0x20
#define _PWM1CON_P1DC6          0x40
#define _PWM1CON_P1RSEN         0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FBE) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned ECCP1AS0           : 1;
    unsigned ECCP1AS1           : 1;
    unsigned ECCP1AS2           : 1;
    unsigned ECCP1ASE           : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP1AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FBE) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _PSS1BD0                0x01
#define _PSS1BD1                0x02
#define _PSS1AC0                0x04
#define _PSS1AC1                0x08
#define _ECCP1AS0               0x10
#define _ECCP1AS1               0x20
#define _ECCP1AS2               0x40
#define _ECCP1ASE               0x80

//==============================================================================


//==============================================================================
//        PSTR1CON Bits

extern __at(0x0FBF) __sfr PSTR1CON;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned STRSYNC            : 1;
    unsigned                    : 1;
    unsigned CMPL0              : 1;
    unsigned CMPL1              : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CMPL               : 2;
    };
  } __PSTR1CONbits_t;

extern __at(0x0FBF) volatile __PSTR1CONbits_t PSTR1CONbits;

#define _STRA                   0x01
#define _STRB                   0x02
#define _STRC                   0x04
#define _STRD                   0x08
#define _STRSYNC                0x10
#define _CMPL0                  0x40
#define _CMPL1                  0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FC0) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned ULPSINK            : 1;
    unsigned ULPEN              : 1;
    unsigned DS                 : 1;
    unsigned                    : 1;
    unsigned ULPLVL             : 1;
    unsigned LVDSTAT            : 1;
    unsigned REGSLP             : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FC0) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01
#define _ULPSINK                0x02
#define _ULPEN                  0x04
#define _DS                     0x08
#define _ULPLVL                 0x20
#define _LVDSTAT                0x40
#define _REGSLP                 0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned ADCAL              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADCAL                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned VCFG               : 2;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO_DONE                0x02
#define _DONE                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _VCFG0                  0x40
#define _VCFG1                  0x80

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0FC5) __sfr SSP1CON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1CON2bits_t;

extern __at(0x0FC5) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _ADMSK1                 0x02
#define _PEN                    0x04
#define _ADMSK2                 0x04
#define _RCEN                   0x08
#define _ADMSK3                 0x08
#define _ACKEN                  0x10
#define _ADMSK4                 0x10
#define _ACKDT                  0x20
#define _ADMSK5                 0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADMSK1             : 1;
    unsigned ADMSK2             : 1;
    unsigned ADMSK3             : 1;
    unsigned ADMSK4             : 1;
    unsigned ADMSK5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_ADMSK1         0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_ADMSK2         0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ADMSK3         0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ADMSK4         0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ADMSK5         0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0FC6) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0FC6) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0FC7) __sfr SSP1STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1STATbits_t;

extern __at(0x0FC7) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _R_W                    0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _READ_WRITE             0x04
#define _I2C_READ               0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _D_A                    0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _DATA_ADDRESS           0x20
#define _I2C_DAT                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_R              0x04
#define _SSPSTAT_R_W            0x04
#define _SSPSTAT_NOT_W          0x04
#define _SSPSTAT_NOT_WRITE      0x04
#define _SSPSTAT_READ_WRITE     0x04
#define _SSPSTAT_I2C_READ       0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_I2C_START      0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_I2C_STOP       0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_D              0x20
#define _SSPSTAT_D_A            0x20
#define _SSPSTAT_NOT_A          0x20
#define _SSPSTAT_NOT_ADDRESS    0x20
#define _SSPSTAT_DATA_ADDRESS   0x20
#define _SSPSTAT_I2C_DAT        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0FC8) __sfr SSP1ADD;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP1ADDbits_t;

extern __at(0x0FC8) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0FC8) __sfr SSP1MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP1MSKbits_t;

extern __at(0x0FC8) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK_MSK0           0x01
#define _SSP1MSK_MSK1           0x02
#define _SSP1MSK_MSK2           0x04
#define _SSP1MSK_MSK3           0x08
#define _SSP1MSK_MSK4           0x10
#define _SSP1MSK_MSK5           0x20
#define _SSP1MSK_MSK6           0x40
#define _SSP1MSK_MSK7           0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0FC8) __sfr SSPADD;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSPADDbits_t;

extern __at(0x0FC8) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_MSK0            0x01
#define _SSPADD_MSK1            0x02
#define _SSPADD_MSK2            0x04
#define _SSPADD_MSK3            0x08
#define _SSPADD_MSK4            0x10
#define _SSPADD_MSK5            0x20
#define _SSPADD_MSK6            0x40
#define _SSPADD_MSK7            0x80

//==============================================================================

extern __at(0x0FC9) __sfr SSP1BUF;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned RD16               : 1;
    unsigned T1SYNC             : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _RD16                   0x02
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned NOT_CM             : 1;
    unsigned                    : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned CM                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _NOT_CM                 0x20
#define _CM                     0x20
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        CM2CON Bits

extern __at(0x0FD1) __sfr CM2CON;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM2CONbits_t;

extern __at(0x0FD1) volatile __CM2CONbits_t CM2CONbits;

#define _CM2CON_CCH0            0x01
#define _CM2CON_CCH1            0x02
#define _CM2CON_CREF            0x04
#define _CM2CON_EVPOL0          0x08
#define _CM2CON_EVPOL1          0x10
#define _CM2CON_CPOL            0x20
#define _CM2CON_COE             0x40
#define _CM2CON_CON             0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0FD1) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM2CON1bits_t;

extern __at(0x0FD1) volatile __CM2CON1bits_t CM2CON1bits;

#define _CM2CON1_CCH0           0x01
#define _CM2CON1_CCH1           0x02
#define _CM2CON1_CREF           0x04
#define _CM2CON1_EVPOL0         0x08
#define _CM2CON1_EVPOL1         0x10
#define _CM2CON1_CPOL           0x20
#define _CM2CON1_COE            0x40
#define _CM2CON1_CON            0x80

//==============================================================================


//==============================================================================
//        CM1CON Bits

extern __at(0x0FD2) __sfr CM1CON;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM1CONbits_t;

extern __at(0x0FD2) volatile __CM1CONbits_t CM1CONbits;

#define _CCH0                   0x01
#define _CCH1                   0x02
#define _CREF                   0x04
#define _EVPOL0                 0x08
#define _EVPOL1                 0x10
#define _CPOL                   0x20
#define _COE                    0x40
#define _CON                    0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0FD2) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned EVPOL0             : 1;
    unsigned EVPOL1             : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned EVPOL              : 2;
    unsigned                    : 3;
    };
  } __CM1CON1bits_t;

extern __at(0x0FD2) volatile __CM1CON1bits_t CM1CON1bits;

#define _CM1CON1_CCH0           0x01
#define _CM1CON1_CCH1           0x02
#define _CM1CON1_CREF           0x04
#define _CM1CON1_EVPOL0         0x08
#define _CM1CON1_EVPOL1         0x10
#define _CM1CON1_CPOL           0x20
#define _CM1CON1_COE            0x40
#define _CM1CON1_CON            0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned INT3IF             : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned INT3IE             : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned INT3F              : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned INT3E              : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT3IF                 0x04
#define _INT3F                  0x04
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT3IE                 0x20
#define _INT3E                  0x20
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned INT3IP             : 1;
    unsigned TMR0IP             : 1;
    unsigned INTEDG3            : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT3P              : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _INT3IP                 0x02
#define _INT3P                  0x02
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG3                0x08
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _SP0                    0x01
#define _SP1                    0x02
#define _SP2                    0x04
#define _SP3                    0x08
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Addresses
//
//==============================================================================

#define __CONFIG1L              0x003FF8
#define __CONFIG1H              0x003FF9
#define __CONFIG2L              0x003FFA
#define __CONFIG2H              0x003FFB
#define __CONFIG3L              0x003FFC
#define __CONFIG3H              0x003FFD
#define __CONFIG4L              0x003FFE
#define __CONFIG4H              0x003FFF

//==============================================================================

#endif // #ifndef __PIC18F44J11_H__
