<?php
include('./common.php');

# Send headers
header('Date: ' . gmdate('D, d M Y H:i:s \G\M\T', time()));
header('Last-Modified: ' . gmdate('D, d M Y H:i:s \G\M\T', time()));
header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + $refresh));
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

echo "<html>\n";
echo "<!-- RTG Version $VERSION -->\n";
echo "<head>\n";

/* Connect to RTG MySQL Database */
$dbc = @mysqli_connect($host, $user, $pass, $db, $port) or 
	die ("MySQL Connection Failed, Check Configuration.");

# Global variables off by default in newer versions of PHP
if (!isset($PHP_SELF) || ($PHP_SELF == ""))
{
	$PHP_SELF = "view.php";
	$rid = isset($_GET['rid'])?$_GET['rid']:"";
	$iid = isset($_GET['iid'])?$_GET['iid']:"";
}

# Determine router, interface names as necessary
if (($rid != "") && ($iid != ""))
{
	$selectQuery = "SELECT `a`.`name`,`a`.`description`,`a`.`speed`,`b`.`name` " .
		"AS `router` FROM `interface` `a`,`router` `b` WHERE " .
		"`a`.`rid`=`b`.`rid` AND " .
		"`a`.`rid`=" . mysqli_real_escape_string($dbc, $rid) . " AND " .
		"`a`.`id`=" . mysqli_real_escape_string($dbc, $iid);
	$selectResult = mysqli_query($dbc, $selectQuery);
	$selectRow = mysqli_fetch_object($selectResult);
	$interfaces = mysqli_num_rows($selectResult);
	$name = $selectRow->name;
	$description = $selectRow->description;
	$speed = ($selectRow->speed)/1000000;
	$router = $selectRow->router;
} else if (($rid != "") && ($iid == ""))
{
	$selectQuery = "SELECT `name` AS `router` FROM `router` WHERE " .
		"`rid`=" . mysqli_real_escape_string($dbc, $rid);
	$selectResult = mysqli_query($dbc, $selectQuery);
	$selectRow = mysqli_fetch_object($selectResult);
	$router = $selectRow->router;
}

# Generate Title 
echo "<title>RTG: ";
if (($rid != "") && ($iid != ""))
	echo htmlentities($router) . ": " . htmlentities($name);
else if (($rid != "") && ($iid == ""))
	echo htmlentities($router);
echo "</title>\n";

echo "<meta http-equiv=\"Refresh\" content=\"$refresh\" />\n";
echo "<meta http-equiv=\"Pragma\" content=\"no-cache\" />\n";
echo "<meta http-equiv=\"Cache-Control\" content=\"no-cache\" />\n";
echo "<meta http-equiv=\"Expires\" content=\"" . gmdate('D, d M Y H:i:s \G\M\T', time() + $refresh) . "\" />\n";
echo "<meta http-equiv=\"Generator\" content=\"RTG $VERSION\" />\n";
echo "<meta http-equiv=\"Date\" content=\"" . gmdate('D, d M Y H:i:s \G\M\T', time()) . "\" />\n";
echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />\n";
?>

</head>
<body bgcolor="ffffff">
<a href="http://rtg.sourceforge.net"><img src="rtg.png" border="0" alt="[RTG Home Page]" /></a><p><hr />

<?php
echo "<form action=\"$PHP_SELF\" method=\"get\">\n";

$et = time();
 
if ($rid == "")
{
	echo "Monitored Devices: <p>\n";
	$selectQuery = "SELECT `rid`,`name` FROM `router`";
	$selectResult = mysqli_query($dbc, $selectQuery);
	if (mysqli_num_rows($selectResult) <= 0) 
		echo "<br />No Routers Found.<br />\n";
	else {
		echo "<ul>\n";
		while ($selectRow = mysqli_fetch_object($selectResult))
		{
			echo "<li><a href=\"$PHP_SELF?rid=" . $selectRow->rid . "\">";
			echo htmlentities($selectRow->name) . "</a><br />\n";
		}
		echo "</ul>\n";
	}
}

if (($rid != "") && ($iid != ""))
{
	if ($interfaces <= 0)
		echo "<br />Interface " . htmlentities($iid) . " Not Found for Router " .
			htmlentities($router) . " (ID: " . htmlentities($rid) . ").<br />\n";
	else {
		echo "<table>\n";
		echo "<tr><td>System:</td><td>" . htmlentities($router) . "</td></tr>\n";
		echo "<tr><td>Interface:</td><td>" . htmlentities($name) . "</td></tr>\n";
		echo "<tr><td>Description:</td><td>" . htmlentities($description) . "</td></tr>\n";
		echo "<tr><td>Speed:</td><td>" . htmlentities($speed) . " Mbps</td></tr>\n";
		echo "<tr><td>Page Generated:</td><td>" .gmdate('D, d M Y H:i:s \G\M\T', time()) . "</td></tr>\n";
		echo "</table><hr />\n";

		$bt = $et - (60*60*24);
		echo "<b>Day View:</b><br />\n";
		echo "<img src=\"rtgplot.cgi?t1=ifInOctets_" . urlencode($rid) . "&amp;t2=" .
			"ifOutOctets_" . urlencode($rid) . "&amp;iid=" . urlencode($iid) . 
			"&amp;begin=" . urlencode($bt) . "&amp;end=" . urlencode($et) . 
			"&amp;units=bits/s&amp;factor=8&amp;filled=yes" .
			"&amp;title=" . urlencode("$router: $name ($description)") . 
			"&amp;t1_name=" . urlencode("Input Octets") . 
			"&amp;t2_name=" . urlencode("Output Octets") . "\" />\n";
		echo "<br /><b>" . htmlentities($router) . ": " . htmlentities($name) . " (" . htmlentities($description) . ")</b>\n";
		echo "<br /><hr />\n";

		$bt = $et - (60*60*24*7);
		echo "<b>Week View:</b><br />\n";
		echo "<img src=\"rtgplot.cgi?t1=ifInOctets_" . urlencode($rid) . "&amp;t2=" .
			"ifOutOctets_" . urlencode($rid) . "&amp;iid=" . urlencode($iid) . 
			"&amp;begin=" . urlencode($bt) . "&amp;end=" . urlencode($et) . 
			"&amp;units=bits/s&amp;factor=8&amp;filled=yes" .
			"&amp;title=" . urlencode("$router: $name ($description)") . 
			"&amp;t1_name=" . urlencode("Input Octets") . 
			"&amp;t2_name=" . urlencode("Output Octets") . "\" />\n";
		echo "<br /><b>" . htmlentities($router) . ": " . htmlentities($name) . " (" . htmlentities($description) . ")</b>\n";
		echo "<br /><hr />\n";

		$bt = $et - (60*60*24*30);
		echo "<b>Month View:</b><br />\n";
		echo "<img src=\"rtgplot.cgi?t1=ifInOctets_" . urlencode($rid) . "&amp;t2=" .
			"ifOutOctets_" . urlencode($rid) . "&amp;iid=" . urlencode($iid) . 
			"&amp;begin=" . urlencode($bt) . "&amp;end=" . urlencode($et) . 
			"&amp;units=bits/s&amp;factor=8&amp;filled=yes" .
			"&amp;title=" . urlencode("$router: $name ($description)") . 
			"&amp;t1_name=" . urlencode("Input Octets") . 
			"&amp;t2_name=" . urlencode("Output Octets") . "\" />\n";
		echo "<br /><b>" . htmlentities($router) . ": " . htmlentities($name) . " (" . htmlentities($description) . ")</b>\n";
		echo "<br /><br />\n";
	}
	echo "<input type=\"submit\" value=\"Back to Main\" />\n";
}

if (($rid != "") && ($iid == ""))
{
	$selectQuery = "SELECT `id`,`name`,`description` FROM `interface` WHERE `rid`=" . mysqli_real_escape_string($dbc, $rid);
	$selectResult = mysqli_query($dbc, $selectQuery);
	$interfaces = mysqli_num_rows($selectResult);
	if ($interfaces <= 0) 
		echo "<br />No Interfaces Found for Router " . htmlentities($router) . " (ID: " . htmlentities($rid) . ").<br />\n";
	else {
		$bt = $et - (60*60*12);
		echo "<table>\n";
		echo "<tr><td>System:</td><td>" . htmlentities($router) . "</td></tr>\n";
		echo "<tr><td>Interfaces:</td><td>" . htmlentities($interfaces) . "</td></tr>\n";
		echo "<tr><td>Page Generated:</td><td>";
		echo gmdate('D, d M Y H:i:s \G\M\T', time()) . "</td></tr>\n";
		echo "</table><hr />\n";

		echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\">\n";
		echo "<tr>";
		$even = 0;
		while ($selectRow = mysqli_fetch_object($selectResult))
		{
			$ids[$selectRow->id] = $selectRow->name; 
			$desc[$selectRow->id] = $selectRow->description;
			$iid = $selectRow->id;
			echo "<td><a href=\"$PHP_SELF?rid=" . urlencode($rid) . "&amp;iid=" . urlencode($iid) . "\">";
			echo "<img height=\"135\" width=\"500\" src=\"rtgplot.cgi?t1=" .
				"ifInOctets_" . urlencode($rid) . "&amp;t2=" .
				"ifOutOctets_" . urlencode($rid) . "&amp;iid=" . urlencode($iid) . 
				"&amp;begin=" . urlencode($bt) . "&amp;end=" . urlencode($et) . 
				"&amp;units=bits/s&amp;factor=8&amp;filled=yes" . 
				"&amp;title=" . urlencode($router . ": " . $selectRow->name . " (" . $selectRow->description . ")") . 
				"&amp;t1_name=" . urlencode("Input Octets") . 
				"&amp;t2_name=" . urlencode("Output Octets") . "\" border=\"0\" />";
			echo "</a><br />\n";
			echo "<b>" . htmlentities($selectRow->name) . " (" . htmlentities($selectRow->description) . ")</b>\n";
			if ($even == 1)
			{
				$even = 0;
				print "</tr><tr>\n";
			} else
				$even = 1;
		}
		echo "</tr></table>\n";
	}
	echo "<input type=\"submit\" value=\"Back to Main\" />\n";
}

if ($dbc)
	mysqli_close($dbc);
echo "</form>\n";
?>

<hr />
<font face="Arial" size="2">
<?php
echo "<a href=\"http://rtg.sourceforge.net\">RTG</a> Version $VERSION</font>";
?>
</body>
</html>
