/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * step(vec4(-2.0, -2.0, -2.0, -2.0), vec4(-2.0, -0.6666667, 0.6666667, 2.0)) => vec4(1.0, 1.0, 1.0, 1.0)
 * step(vec4(-0.6666667, -0.6666667, -0.6666667, -0.6666667), vec4(-2.0, -0.6666667, 0.6666667, 2.0)) => vec4(0.0, 1.0, 1.0, 1.0)
 * step(vec4(0.6666667, 0.6666667, 0.6666667, 0.6666667), vec4(-2.0, -0.6666667, 0.6666667, 2.0)) => vec4(0.0, 0.0, 1.0, 1.0)
 * step(vec4(2.0, 2.0, 2.0, 2.0), vec4(-2.0, -0.6666667, 0.6666667, 2.0)) => vec4(0.0, 0.0, 0.0, 1.0)
 */
#version 120

void main()
{
  float[distance(step(vec4(-2.0, -2.0, -2.0, -2.0), vec4(-2.0, -0.6666667, 0.6666667, 2.0)), vec4(1.0, 1.0, 1.0, 1.0)) <= 2e-05 ? 1 : -1] array0;
  float[distance(step(vec4(-0.6666667, -0.6666667, -0.6666667, -0.6666667), vec4(-2.0, -0.6666667, 0.6666667, 2.0)), vec4(0.0, 1.0, 1.0, 1.0)) <= 1.7320508e-05 ? 1 : -1] array1;
  float[distance(step(vec4(0.6666667, 0.6666667, 0.6666667, 0.6666667), vec4(-2.0, -0.6666667, 0.6666667, 2.0)), vec4(0.0, 0.0, 1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array2;
  float[distance(step(vec4(2.0, 2.0, 2.0, 2.0), vec4(-2.0, -0.6666667, 0.6666667, 2.0)), vec4(0.0, 0.0, 0.0, 1.0)) <= 1e-05 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
