/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * fract(-2.0lf) => 0.0lf
 * fract(-0.6666666666666667lf) => 0.33333333333333326lf
 * fract(0.6666666666666665lf) => 0.6666666666666665lf
 * fract(2.0lf) => 0.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(fract(-2.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance(fract(-0.6666666666666667lf), 0.33333333333333326lf) <= 3.333333333333333e-06lf ? 1 : -1] array1;
  double[distance(fract(0.6666666666666665lf), 0.6666666666666665lf) <= 6.666666666666666e-06lf ? 1 : -1] array2;
  double[distance(fract(2.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
