/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentLocationMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int POSE;

    public XrSceneComponentLocationMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneComponentLocationMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long flags() {
        return XrSceneComponentLocationMSFT.nflags(this.address());
    }

    public XrPosef pose() {
        return XrSceneComponentLocationMSFT.npose(this.address());
    }

    public XrSceneComponentLocationMSFT flags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrSceneComponentLocationMSFT.nflags(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationMSFT pose(XrPosef value) {
        XrSceneComponentLocationMSFT.npose(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSceneComponentLocationMSFT set(long flags, XrPosef pose) {
        this.flags(flags);
        this.pose(pose);
        return this;
    }

    public XrSceneComponentLocationMSFT set(XrSceneComponentLocationMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneComponentLocationMSFT malloc() {
        return (XrSceneComponentLocationMSFT)XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneComponentLocationMSFT calloc() {
        return (XrSceneComponentLocationMSFT)XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneComponentLocationMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneComponentLocationMSFT)XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneComponentLocationMSFT create(long address) {
        return (XrSceneComponentLocationMSFT)XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneComponentLocationMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneComponentLocationMSFT)XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneComponentLocationMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneComponentLocationMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneComponentLocationMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentLocationMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneComponentLocationMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneComponentLocationMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneComponentLocationMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneComponentLocationMSFT malloc(MemoryStack stack) {
        return (XrSceneComponentLocationMSFT)XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentLocationMSFT calloc(MemoryStack stack) {
        return (XrSceneComponentLocationMSFT)XrSceneComponentLocationMSFT.wrap(XrSceneComponentLocationMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneComponentLocationMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneComponentLocationMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSceneComponentLocationMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneComponentLocationMSFT.__member((int)8), XrSceneComponentLocationMSFT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentLocationMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentLocationMSFT ELEMENT_FACTORY = XrSceneComponentLocationMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneComponentLocationMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long flags() {
            return XrSceneComponentLocationMSFT.nflags(this.address());
        }

        public XrPosef pose() {
            return XrSceneComponentLocationMSFT.npose(this.address());
        }

        public Buffer flags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrSceneComponentLocationMSFT.nflags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrSceneComponentLocationMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

