/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.fault;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.jdom.Element;

public class XFireFault
extends XFireException {
    private static final long serialVersionUID = 2L;
    private static final String ns12 = Soap12.getInstance().getNamespace();
    private static final String ns11 = Soap11.getInstance().getNamespace();
    public static final QName VERSION_MISMATCH = new QName(ns12, "VersionMismatch");
    public static final QName MUST_UNDERSTAND = new QName(ns12, "MustUnderstand");
    public static final QName DATA_ENCODING_UNKNOWN = new QName(ns12, "DataEncodingUnknown");
    public static final QName SENDER = new QName(ns12, "Sender");
    public static final QName RECEIVER = new QName(ns12, "Receiver");
    public static final QName SOAP11_SERVER = new QName(ns11, "Server");
    public static final QName SOAP11_CLIENT = new QName(ns11, "Client");
    public static final QName SOAP11_MUST_UNDERSTAND = new QName(ns11, "MustUnderstand");
    public static final QName SOAP11_VERSION_MISMATCH = new QName(ns11, "VersionMismatch");
    private QName faultCode;
    private QName subCode;
    private String message;
    private String role;
    private Element detail;
    private Map namespaces;

    public static XFireFault createFault(Throwable throwable) {
        XFireFault fault = null;
        fault = throwable instanceof XFireFault ? (XFireFault)throwable : new XFireFault(throwable);
        return fault;
    }

    protected XFireFault() {
    }

    public XFireFault(Throwable throwable) {
        this(throwable.getMessage(), throwable, RECEIVER);
    }

    public XFireFault(Throwable throwable, QName code) {
        this(throwable.getMessage(), throwable, code);
    }

    public XFireFault(String message, QName code) {
        this(message, null, code);
    }

    public XFireFault(String message, Throwable cause, QName code) {
        super(message, cause);
        this.message = message != null ? message : "Fault: " + cause.getClass().getName();
        this.faultCode = code;
        this.namespaces = new HashMap();
    }

    public void addNamespace(String prefix, String ns) {
        this.namespaces.put(prefix, ns);
    }

    public Element getDetail() {
        if (this.detail == null) {
            this.detail = new Element("detail");
        }
        return this.detail;
    }

    public void setDetail(Element details) {
        this.detail = details;
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public void setFaultCode(QName faultCode) {
        this.faultCode = faultCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public String getReason() {
        return this.getMessage();
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String actor) {
        this.role = actor;
    }

    public QName getSubCode() {
        return this.subCode;
    }

    public void setSubCode(QName subCode) {
        this.subCode = subCode;
    }

    public boolean hasDetails() {
        return this.detail != null;
    }
}

