/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class SanulProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 0;
    public static final int MSG_LOCATION = 1;
    public static final int MSG_RESPONSE = 5;

    public SanulProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(170);
            response.writeShortLE(34266);
            response.writeShortLE(15);
            response.writeByte(1);
            response.writeShortLE(5);
            response.writeShortLE(type);
            response.writeIntLE(0);
            response.writeByte(0);
            response.writeByte(0);
            response.writeIntLE(131072);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        buf.readUnsignedByte();
        int type = buf.readUnsignedShortLE();
        buf.readUnsignedIntLE();
        this.sendResponse(channel, type);
        if (type == 0) {
            this.getDeviceSession(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII).trim());
        } else if (type == 1) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            return position;
        }
        return null;
    }
}

