/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_str")
public class NkStr
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int LEN;

    public NkStr(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStr.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_buffer")
    public NkBuffer buffer() {
        return NkStr.nbuffer(this.address());
    }

    public int len() {
        return NkStr.nlen(this.address());
    }

    public static NkStr malloc() {
        return (NkStr)NkStr.wrap(NkStr.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkStr calloc() {
        return (NkStr)NkStr.wrap(NkStr.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkStr create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkStr)NkStr.wrap(NkStr.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkStr create(long address) {
        return (NkStr)NkStr.wrap(NkStr.class, (long)address);
    }

    @Nullable
    public static NkStr createSafe(long address) {
        return address == 0L ? null : (NkStr)NkStr.wrap(NkStr.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkStr.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkStr.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkStr.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStr.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkStr.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkStr.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkStr.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkStr mallocStack() {
        return NkStr.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStr callocStack() {
        return NkStr.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStr mallocStack(MemoryStack stack) {
        return NkStr.malloc(stack);
    }

    @Deprecated
    public static NkStr callocStack(MemoryStack stack) {
        return NkStr.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStr.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStr.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStr.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStr.calloc(capacity, stack);
    }

    public static NkStr malloc(MemoryStack stack) {
        return (NkStr)NkStr.wrap(NkStr.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStr calloc(MemoryStack stack) {
        return (NkStr)NkStr.wrap(NkStr.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStr.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkStr.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkBuffer nbuffer(long struct) {
        return NkBuffer.create(struct + (long)BUFFER);
    }

    public static int nlen(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEN);
    }

    static {
        Struct.Layout layout = NkStr.__struct((Struct.Member[])new Struct.Member[]{NkStr.__member((int)NkBuffer.SIZEOF, (int)NkBuffer.ALIGNOF), NkStr.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        LEN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStr, Buffer>
    implements NativeResource {
        private static final NkStr ELEMENT_FACTORY = NkStr.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStr getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_buffer")
        public NkBuffer buffer() {
            return NkStr.nbuffer(this.address());
        }

        public int len() {
            return NkStr.nlen(this.address());
        }
    }
}

