/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test;

import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.lwjgl.LWJGLException;
import org.lwjgl.util.WaveData;

public class WaveDataTest {
    String filePath = "Footsteps.wav";

    public void executeTest() throws LWJGLException {
        this.executeCreationTest();
        this.executeBrokenCreationTest();
        this.executeMidStreamCreationTest();
    }

    private void executeCreationTest() {
        WaveData wd = WaveData.create((String)this.filePath);
        if (wd != null) {
            System.out.println("executeCreationTest::success");
        }
    }

    private void executeBrokenCreationTest() {
        WaveData wd = WaveData.create((String)"");
        if (wd == null) {
            System.out.println("executeBrokenCreationTest::success");
        }
    }

    private void executeStreamCreationTest() {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(this.filePath));
            WaveData wd = WaveData.create((AudioInputStream)ais);
            if (wd == null) {
                System.out.println("executeMidStreamCreationTest::success");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeMidStreamCreationTest() {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(WaveDataTest.class.getClassLoader().getResource(this.filePath));
            int totalSize = ais.getFormat().getChannels() * (int)ais.getFrameLength() * ais.getFormat().getSampleSizeInBits() / 8;
            int skip = totalSize / 4;
            long skipped = ais.skip(skip);
            WaveData wd = WaveData.create((AudioInputStream)ais);
            if (wd == null) {
                System.out.println("executeMidStreamCreationTest::success");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pause(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws LWJGLException {
        new WaveDataTest().executeTest();
        System.exit(0);
    }
}

