/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.jitsi.utils.concurrent.CustomizableThreadFactory;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.json.simple.JSONObject;

public class TaskPools {
    private static final Logger classLogger = new LoggerImpl(TaskPools.class.getName());
    public static final ExecutorService IO_POOL = Executors.newCachedThreadPool(new CustomizableThreadFactory("Global IO pool", false));
    public static final ExecutorService CPU_POOL = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new CustomizableThreadFactory("Global CPU pool", false));
    private static final ScheduledExecutorService DEFAULT_SCHEDULED_POOL;
    public static ScheduledExecutorService SCHEDULED_POOL;

    public static void resetScheduledPool() {
        SCHEDULED_POOL = DEFAULT_SCHEDULED_POOL;
    }

    public static JSONObject getStatsJson(ExecutorService es) {
        JSONObject debugState = new JSONObject();
        debugState.put("executor_class", es.getClass().getSimpleName());
        if (es instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor ex = (ThreadPoolExecutor)es;
            debugState.put("pool_size", ex.getPoolSize());
            debugState.put("active_task_count", ex.getActiveCount());
            debugState.put("completed_task_count", ex.getCompletedTaskCount());
            debugState.put("core_pool_size", ex.getCorePoolSize());
            debugState.put("maximum_pool_size", ex.getMaximumPoolSize());
            debugState.put("largest_pool_size", ex.getLargestPoolSize());
            debugState.put("queue_class", ex.getQueue().getClass().getSimpleName());
            debugState.put("pending_task_count", ex.getQueue().size());
        }
        return debugState;
    }

    public static JSONObject getStatsJson() {
        JSONObject debugState = new JSONObject();
        debugState.put("IO_POOL", TaskPools.getStatsJson(IO_POOL));
        debugState.put("CPU_POOL", TaskPools.getStatsJson(CPU_POOL));
        return debugState;
    }

    static {
        SCHEDULED_POOL = DEFAULT_SCHEDULED_POOL = Executors.newSingleThreadScheduledExecutor(new CustomizableThreadFactory("Global scheduled pool", false));
        classLogger.info("TaskPools detected " + Runtime.getRuntime().availableProcessors() + " processors, creating the CPU pool with that many threads");
    }
}

