/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.findusages;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.ArtifactInfoStatus;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.almworks.tracklink.ModelCache;
import com.almworks.tracklink.PatternIndexer;
import com.almworks.tracklink.codelinks.CodeLink;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.codelinks.highlight.URLTextRange;
import com.almworks.tracklink.findusages.CodeLinkUsage;
import com.almworks.tracklink.findusages.FindUsagesActionUtil;
import com.almworks.tracklink.findusages.FindUsagesSettings;
import com.almworks.tracklink.findusages.IssueLinkUsageViewPresentation;
import com.almworks.tracklink.findusages.URLUsageTarget;
import com.almworks.tracklink.findusages.VCSLinkUsage;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.almworks.tracklink.vcslinks.cache.VCSCache;
import com.almworks.tracklink.vcslinks.cache.impl.VirtualFileRevision;
import com.almworks.util.Log;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUtils {
    @Nullable
    public static PatternIndexer getPatternIndexer() {
        return ModelCache.getInstance().getPatternIndexer();
    }

    private static void showIssueLinks(@Nullable Project project, FindUsagesSettings settings, String ... urls) {
        Log.debug("showIssueLinks");
        PatternIndexer provider = FindUtils.getPatternIndexer();
        if (project == null || provider == null) {
            return;
        }
        Usage[] usages = FindUtils.createUsages(project, settings.needSearchInCode(), settings.needSearchInVCS(), settings.getRefresh(), urls);
        IssueLinkUsageViewPresentation presentation = new IssueLinkUsageViewPresentation(settings.openInNewTab());
        UsageTarget[] targets = FindUtils.createUsageTargets(project, urls);
        FindUtils.showFindUsages(project, presentation, targets, usages);
    }

    private static List<Pair<PsiElement, URLTextRange>> filterProject(PatternIndexer provider, Project project, String ... urls) {
        CodeLinkType[] codeLinkTypes = FindUtils.filterCodeLinkTypes(provider.getIndexPatterns(), urls);
        PsiSearchHelper searchHelper = PsiManager.getInstance((Project)project).getSearchHelper();
        PsiFile[] files = searchHelper.findFilesWithTodoItems();
        ArrayList<Pair<PsiElement, URLTextRange>> foundFiles = new ArrayList<Pair<PsiElement, URLTextRange>>();
        for (String url : urls) {
            for (CodeLinkType codeLinkType : codeLinkTypes) {
                for (PsiFile file : files) {
                    if (IndexPatternSearch.getOccurrencesCount((PsiFile)file, (IndexPattern)codeLinkType) <= 0) continue;
                    Collection occurrences = IndexPatternSearch.search((PsiFile)file, (IndexPattern)codeLinkType).findAll();
                    for (IndexPatternOccurrence indexPatternOccurrence : occurrences) {
                        TextRange textRange = indexPatternOccurrence.getTextRange();
                        String codeFragment = file.getText().substring(textRange.getStartOffset(), textRange.getEndOffset());
                        String fragmentURL = codeLinkType.getPattern().matcher(codeFragment).replaceAll(codeLinkType.getReplacePattern());
                        if (!url.equals(fragmentURL)) continue;
                        URLTextRange urlTextRange = new URLTextRange(textRange.getStartOffset(), textRange.getEndOffset(), new CodeLink(codeFragment, fragmentURL), codeLinkType, false);
                        foundFiles.add((Pair<PsiElement, URLTextRange>)Pair.create((Object)file.findElementAt(textRange.getStartOffset() + 1), (Object)urlTextRange));
                    }
                }
            }
        }
        return foundFiles;
    }

    private static UsageTarget[] createUsageTargets(Project project, String ... urls) {
        ArtifactInfoCache cache = Utils.getArtifactInfoCache();
        UsageTarget[] result = new UsageTarget[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            ArtifactInfo info;
            String name = null;
            if (cache != null && (info = cache.getArtifactInfoSnapshot(urls[i])).getStatus() == ArtifactInfoStatus.OK) {
                name = (String)info.getPresentation(GenericKeys.ID) + " " + (String)info.getPresentation(GenericKeys.SUMMARY);
            }
            if (name == null || name.trim().length() == 0) {
                name = urls[i];
            }
            result[i] = new URLUsageTarget(project, name);
        }
        return result;
    }

    @NonNls
    private static Usage[] createUsages(final Project project, final boolean searchInCode, final boolean searchInVCS, final @Nullable Boolean refresh, final String ... urls) {
        Method method;
        Class<?> aClass;
        Log.debug("createUsages(urls #" + urls.length + ")");
        final ArrayList usages = new ArrayList();
        Runnable runnable = new Runnable(){

            public void run() {
                if (searchInCode) {
                    usages.addAll(FindUtils.createCodeLinkUsages(project, urls));
                }
                if (searchInVCS) {
                    usages.addAll(FindUtils.createVCSUsages(project, refresh, urls));
                }
            }
        };
        String title = StringBundle.get("find.progress.title", urls.length);
        boolean wasInvoked = false;
        String methodName = "runProcessWithProgressSynchronously";
        Class[] methodArguments = new Class[]{Runnable.class, String.class, Boolean.TYPE, Project.class};
        try {
            aClass = Class.forName("com.intellij.openapi.application.Application");
            method = aClass.getMethod(methodName, methodArguments);
            method.invoke((Object)ApplicationManager.getApplication(), runnable, title, true, project);
            wasInvoked = true;
            Log.debug("Build #4155 or earlier");
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (!wasInvoked) {
            try {
                aClass = Class.forName("com.intellij.openapi.progress.ProgressManager");
                method = aClass.getMethod(methodName, methodArguments);
                method.invoke((Object)ProgressManager.getInstance(), runnable, title, true, project);
                wasInvoked = true;
                Log.debug("Build #5201 or later");
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (!wasInvoked) {
            Log.error("Cannot invoke runProcessWithProgressSynchronously(), invoke without Progress");
            runnable.run();
        }
        Log.debug("createUsages(urls #" + urls.length + "): usages = #" + usages.size());
        return usages.toArray(new Usage[usages.size()]);
    }

    private static List<Usage> createCodeLinkUsages(Project project, String ... urls) {
        ArrayList<Usage> usages = new ArrayList<Usage>();
        List<Pair<PsiElement, URLTextRange>> foundElements = FindUtils.filterProject(FindUtils.getPatternIndexer(), project, urls);
        for (Pair<PsiElement, URLTextRange> pair : foundElements) {
            usages.add(new CodeLinkUsage(new UsageInfo((PsiElement)pair.getFirst()), (URLTextRange)pair.getSecond()));
        }
        return usages;
    }

    private static List<Usage> createVCSUsages(Project project, Boolean refresh, String ... urls) {
        Log.debug("createVCSUsages(urls #" + urls.length + ", " + refresh + ")");
        ArrayList<Usage> usages = new ArrayList<Usage>();
        VCSCache cache = Utils.getVCSCache(project);
        if (cache != null) {
            LinkedHashSet<VirtualFileRevision> allRevisions = new LinkedHashSet<VirtualFileRevision>();
            Boolean realRefresh = refresh;
            for (String url : urls) {
                Collection<VirtualFileRevision> revisions = cache.getFiles(url, realRefresh);
                if (revisions == null) continue;
                realRefresh = Boolean.FALSE;
                allRevisions.addAll(revisions);
            }
            Log.debug("createVCSUsages(urls #" + urls.length + ", " + refresh + "): revisions = #" + allRevisions.size());
            ArrayList<VCSLinkUsage> vcsLinkUsages = new ArrayList<VCSLinkUsage>();
            for (VirtualFileRevision revision : allRevisions) {
                UsageInfo usageInfo;
                VCSLinkUsage usage;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(revision.getVirtualFile());
                if (psiFile == null || psiFile.getTextRange() == null || (usage = VCSLinkUsage.create(usageInfo = new UsageInfo((PsiElement)psiFile), revision, project)) == null) continue;
                vcsLinkUsages.add(usage);
            }
            Collections.sort(vcsLinkUsages, new Comparator<VCSLinkUsage>(){

                @Override
                public int compare(VCSLinkUsage o1, VCSLinkUsage o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });
            usages.addAll(vcsLinkUsages);
        } else {
            Log.warn("no vcs cache");
        }
        return usages;
    }

    public static CodeLinkType[] filterCodeLinkTypes(CodeLinkType[] types, String ... urls) {
        ArrayList<CodeLinkType> result = new ArrayList<CodeLinkType>();
        for (String url : urls) {
            for (CodeLinkType linkType : types) {
                if (linkType.getVisualID(url) == null || result.contains((Object)linkType)) continue;
                result.add(linkType);
            }
        }
        return result.toArray(new CodeLinkType[result.size()]);
    }

    private static void showFindUsages(Project project, UsageViewPresentation presentation, UsageTarget[] targets, Usage[] usages) {
        if (usages.length != 0) {
            UsageViewManager uvm = UsageViewManager.getInstance((Project)project);
            UsageView usageView = uvm.showUsages(targets, usages, presentation);
        } else {
            Messages.showInfoMessage((Project)project, (String)StringBundle.get("usages.not.found", new Object[0]), (String)StringBundle.get("usages.not.found.title", new Object[0]));
        }
    }

    public static void findUsages(Project project, String ... urls) {
        Log.debug("findUsages");
        if (project == null) {
            project = (Project)DataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        }
        if (project == null) {
            assert (false) : urls;
            return;
        }
        FindUsagesSettings usagesSettings = FindUsagesActionUtil.getFindUsageSettings(project, urls);
        if (usagesSettings != null) {
            FindUtils.showIssueLinks(project, usagesSettings, urls);
        }
    }
}

