/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import [Ljava.lang.String;;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

public class WrapperSimpleApp
implements WrapperListener,
Runnable {
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private Method m_mainMethod;
    private String[] m_appArgs;
    private boolean m_mainStarted;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_ignoreMainExceptions;
    private boolean m_startComplete;
    private boolean m_initFailed;
    private String m_initError;
    private boolean m_initShowUsage;
    private Throwable m_initException;

    protected WrapperSimpleApp(String[] args) {
        String[] appArgs;
        String sunStdoutEncoding;
        Class wmClass = WrapperManager.class;
        this.m_mainMethod = null;
        boolean streamsSet = false;
        if ("true".equals(System.getProperty("wrapper.use_sun_encoding")) && (sunStdoutEncoding = System.getProperty("sun.stdout.encoding")) != null && !sunStdoutEncoding.equals(System.getProperty("file.encoding"))) {
            try {
                m_outInfo = new WrapperPrintStream(System.out, false, sunStdoutEncoding, "WrapperSimpleApp: ");
                m_outError = new WrapperPrintStream(System.out, false, sunStdoutEncoding, "WrapperSimpleApp Error: ");
                m_outDebug = new WrapperPrintStream(System.out, false, sunStdoutEncoding, "WrapperSimpleApp Debug: ");
                streamsSet = true;
            }
            catch (UnsupportedEncodingException e) {
                System.out.println(WrapperManager.getRes().getString("Failed to set the encoding ''{0}'' when creating a WrapperPrintStream.\n Make sure the value of sun.stdout.encoding is correct.", sunStdoutEncoding));
            }
        }
        if (!streamsSet) {
            m_outInfo = new WrapperPrintStream(System.out, "WrapperSimpleApp: ");
            m_outError = new WrapperPrintStream(System.out, "WrapperSimpleApp Error: ");
            m_outDebug = new WrapperPrintStream(System.out, "WrapperSimpleApp Debug: ");
        }
        if (args.length < 1) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Not enough arguments.  Minimum {0} required.", "1");
            this.m_initShowUsage = true;
            appArgs = new String[]{};
        } else {
            Class<?> mainClass;
            String mainMethodString;
            String mainClassString;
            String[] ar = args[0].split("/");
            if (ar.length > 1) {
                mainClassString = ar[0];
                mainMethodString = ar[1];
            } else {
                mainClassString = args[0];
                mainMethodString = "main";
            }
            try {
                mainClass = Class.forName(mainClassString);
            }
            catch (ClassNotFoundException e) {
                this.m_initFailed = true;
                this.m_initError = WrapperManager.getRes().getString("Unable to locate the class {0} : {1}", mainClassString, e);
                this.m_initShowUsage = true;
                mainClass = null;
            }
            catch (ExceptionInInitializerError e) {
                this.m_initFailed = true;
                this.m_initError = WrapperManager.getRes().getString("Class {0} found but could not be initialized due to:", mainClassString);
                this.m_initException = e;
                mainClass = null;
            }
            catch (LinkageError e) {
                this.m_initFailed = true;
                this.m_initError = WrapperManager.getRes().getString("Class {0} found but could not be initialized: {1}", mainClassString, e);
                mainClass = null;
            }
            if (!this.m_initFailed) {
                int modifiers;
                try {
                    this.m_mainMethod = mainClass.getMethod(mainMethodString, String;.class);
                }
                catch (NoSuchMethodException e) {
                    try {
                        this.m_mainMethod = mainClass.getMethod(mainMethodString, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (this.m_mainMethod == null) {
                        this.m_initFailed = true;
                        this.m_initError = WrapperManager.getRes().getString("Unable to locate a public static {2} method in class {0} : {1}", mainClassString, e, mainMethodString);
                    }
                }
                catch (SecurityException e) {
                    this.m_initFailed = true;
                    this.m_initError = WrapperManager.getRes().getString("Unable to locate a public static {2} method in class {0} : {1}", mainClassString, e, mainMethodString);
                }
                if (!(this.m_initFailed || Modifier.isPublic(modifiers = this.m_mainMethod.getModifiers()) && Modifier.isStatic(modifiers))) {
                    this.m_initFailed = true;
                    this.m_initError = WrapperManager.getRes().getString("The {1} method in class {0} must be declared public and static.", mainClassString, mainMethodString);
                }
            }
            appArgs = new String[args.length - 1];
            System.arraycopy(args, 1, appArgs, 0, appArgs.length);
        }
        WrapperManager.start(this, appArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throwable t;
        block22: {
            WrapperSimpleApp wrapperSimpleApp = this;
            synchronized (wrapperSimpleApp) {
                this.m_mainStarted = true;
                this.notifyAll();
            }
            t = null;
            try {
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println(WrapperManager.getRes().getString("invoking main method"));
                }
                try {
                    try {
                        this.m_mainMethod.invoke(null, new Object[]{this.m_appArgs});
                    }
                    catch (IllegalArgumentException iae) {
                        this.m_mainMethod.invoke(null, new Object[0]);
                    }
                    Object var4_9 = null;
                    Thread.currentThread().setPriority(10);
                }
                catch (Throwable throwable) {
                    Object var4_10 = null;
                    Thread.currentThread().setPriority(10);
                    throw throwable;
                }
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println(WrapperManager.getRes().getString("main method completed"));
                }
                WrapperSimpleApp iae = this;
                synchronized (iae) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                if (t != null) break block22;
                t = e;
            }
        }
        m_outInfo.println();
        m_outError.println(WrapperManager.getRes().getString("Encountered an error running main:"));
        t.printStackTrace(m_outError);
        WrapperSimpleApp wrapperSimpleApp = this;
        synchronized (wrapperSimpleApp) {
            if (this.m_ignoreMainExceptions) {
                if (!this.m_startComplete) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            if (this.m_startComplete) {
                WrapperManager.stop(1);
                return;
            }
            this.m_mainComplete = true;
            this.m_mainExitCode = new Integer(1);
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        int maxLoops;
        if (this.m_initFailed) {
            if (this.m_initError != null) {
                m_outError.println(this.m_initError);
            }
            if (this.m_initException != null) {
                this.m_initException.printStackTrace(m_outError);
            }
            if (this.m_initShowUsage) {
                this.showUsage();
            }
            return new Integer(1);
        }
        boolean waitForStartMain = WrapperSystemPropertyUtil.getBooleanProperty(WrapperSimpleApp.class.getName() + ".waitForStartMain", false);
        this.m_ignoreMainExceptions = WrapperSystemPropertyUtil.getBooleanProperty(WrapperSimpleApp.class.getName() + ".ignoreMainExceptions", false);
        int maxStartMainWait = WrapperSystemPropertyUtil.getIntProperty(WrapperSimpleApp.class.getName() + ".maxStartMainWait", 2);
        maxStartMainWait = Math.max(1, maxStartMainWait);
        if (waitForStartMain) {
            maxLoops = Integer.MAX_VALUE;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) Will wait indefinitely for the main method to complete."));
            }
        } else {
            maxLoops = maxStartMainWait;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) Will wait up to {0} seconds for the main method to complete.", new Integer(maxLoops)));
            }
        }
        Thread mainThread = new Thread((Runnable)this, "WrapperSimpleAppMain");
        WrapperSimpleApp wrapperSimpleApp = this;
        synchronized (wrapperSimpleApp) {
            this.m_appArgs = args;
            mainThread.start();
            Thread.currentThread().setPriority(10);
            while (!this.m_mainStarted) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            for (int loops = 0; loops < maxLoops && !this.m_mainComplete; ++loops) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_mainComplete) continue;
                WrapperManager.signalStarting(5000);
            }
            this.m_startComplete = true;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) end.  Main Completed={0}, exitCode={1}", new Boolean(this.m_mainComplete), this.m_mainExitCode));
            }
            return this.m_mainExitCode;
        }
    }

    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            m_outDebug.println(WrapperManager.getRes().getString("stop({0})", new Integer(exitCode)));
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        if (event == 202 && (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs())) {
            m_outInfo.println(WrapperManager.getRes().getString("User logged out.  Ignored."));
        } else {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("controlEvent({0}) Stopping", new Integer(event)));
            }
            WrapperManager.stop(0);
        }
    }

    protected void showUsage() {
        System.out.println();
        System.out.println(WrapperManager.getRes().getString("WrapperSimpleApp Usage:"));
        System.out.println(WrapperManager.getRes().getString("  java org.tanukisoftware.wrapper.WrapperSimpleApp '{'app_class'{'/app_method'}}' [app_arguments]"));
        System.out.println();
        System.out.println(WrapperManager.getRes().getString("Where:"));
        System.out.println(WrapperManager.getRes().getString("  app_class:      The fully qualified class name of the application to run."));
        System.out.println(WrapperManager.getRes().getString("  app_arguments:  The arguments that would normally be passed to the"));
        System.out.println(WrapperManager.getRes().getString("                  application."));
    }

    public static void main(String[] args) {
        new WrapperSimpleApp(args);
    }
}

