/* number.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */

#include <glib.h>
#include <glib-object.h>
#include "mpfr.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _NumberPrivate NumberPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef gint (*BitwiseFunc) (gint v1, gint v2, void* user_data);
typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Number {
	GObject parent_instance;
	NumberPrivate * priv;
};

struct _NumberClass {
	GObjectClass parent_class;
};

struct _NumberPrivate {
	__mpfr_struct _re_num;
	__mpfr_struct _im_num;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer number_parent_class = NULL;
static gulong number__precision;
static gulong number__precision = (gulong) 1000;
static gchar* number__error;
static gchar* number__error = NULL;

GType angle_unit_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
#define NUMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NUMBER, NumberPrivate))
enum  {
	NUMBER_DUMMY_PROPERTY
};
static void number_get_re_num (Number* self, __mpfr_struct* result);
static void number_get_im_num (Number* self, __mpfr_struct* result);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
gulong number_get_precision (void);
static void number_set_re_num (Number* self, __mpfr_struct* value);
static void number_set_im_num (Number* self, __mpfr_struct* value);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
Number* number_new_mpfloat (__mpfr_struct* value);
Number* number_construct_mpfloat (GType object_type, __mpfr_struct* value);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_multiply (Number* self, Number* y);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
gint64 number_to_integer (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gfloat number_to_float (Number* self);
gdouble number_to_double (Number* self);
gboolean number_is_zero (Number* self);
gboolean number_is_negative (Number* self);
gboolean number_is_integer (Number* self);
gboolean number_is_complex (Number* self);
gboolean number_is_positive_integer (Number* self);
gboolean number_is_natural (Number* self);
void number_check_flags (void);
const gchar* number_get_error (void);
void number_set_error (const gchar* value);
gboolean number_equals (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_sgn (Number* self);
Number* number_invert_sign (Number* self);
Number* number_abs (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_add (Number* self, Number* y);
Number* number_sqrt (Number* self);
Number* number_arg (Number* self, AngleUnit unit);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_divide (Number* self, Number* y);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_subtract (Number* self, Number* y);
static Number* number_from_radians (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
static Number* number_copy (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_fractional_part (Number* self);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_reciprocal (Number* self);
static Number* number_reciprocal_real (Number* self);
Number* number_epowy (Number* self);
static Number* number_epowy_real (Number* self);
Number* number_xpowy (Number* self, Number* y);
Number* number_root (Number* self, gint64 n);
static Number* number_pwr (Number* self, Number* y);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_ln (Number* self);
static Number* number_root_real (Number* self, gint64 n);
static Number* number_ln_real (Number* self);
Number* number_logarithm (Number* self, gint64 n);
Number* number_factorial (Number* self);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_add_real (Number* self, Number* y);
Number* number_multiply_real (Number* self, Number* y);
Number* number_modulus_divide (Number* self, Number* y);
Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod);
static Number* number_sin_real (Number* self, AngleUnit unit);
Number* number_cosh (Number* self);
static Number* number_cos_real (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_tan (Number* self, AngleUnit unit);
static Number* number_to_radians (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_and (Number* self, Number* y);
static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen);
static gint __lambda4_ (Number* self, gint v1, gint v2);
static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_or (Number* self, Number* y);
static gint __lambda5_ (Number* self, gint v1, gint v2);
static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_xor (Number* self, Number* y);
static gint __lambda6_ (Number* self, gint v1, gint v2);
static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_not (Number* self, gint wordlen);
static gint __lambda7_ (Number* self, gint v1, gint v2);
static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_mask (Number* self, Number* x, gint wordlen);
static gchar* number_to_hex_string (Number* self);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_shift (Number* self, gint count);
Number* number_ones_complement (Number* self, gint wordlen);
static gint __lambda8_ (Number* self, gint v1, gint v2);
static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_twos_complement (Number* self, gint wordlen);
GList* number_factorize (Number* self);
GList* number_factorize_uint64 (Number* self, guint64 n);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Number* number_new (void);
Number* number_construct (GType object_type);
static gint number_hex_to_int (Number* self, gchar digit);
GType serializer_get_type (void) G_GNUC_CONST;
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
gchar* serializer_to_string (Serializer* self, Number* x);
void number_set_precision (gulong value);
static void number_finalize (GObject* obj);
static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
Number* set_from_sexagesimal (const gchar* str);
gint char_val (gunichar c, gint number_base);
gboolean mp_is_overflow (Number* x, gint wordlen);


GType angle_unit_get_type (void) {
	static volatile gsize angle_unit_type_id__volatile = 0;
	if (g_once_init_enter (&angle_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
		GType angle_unit_type_id;
		angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
		g_once_init_leave (&angle_unit_type_id__volatile, angle_unit_type_id);
	}
	return angle_unit_type_id__volatile;
}


Number* number_construct_integer (GType object_type, gint64 value) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	gint64 _tmp2_ = 0LL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = value;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_si (&tmp, (glong) _tmp2_, MPFR_RNDN);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp3_);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_get_precision ();
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = tmp2;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp6_);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 303 "number.c"
}


Number* number_new_integer (gint64 value) {
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_integer (TYPE_NUMBER, value);
#line 310 "number.c"
}


Number* number_construct_unsigned_integer (GType object_type, guint64 x) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	guint64 _tmp2_ = 0ULL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = x;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp, (gulong) _tmp2_, MPFR_RNDN);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp3_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_get_precision ();
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = tmp2;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp6_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 355 "number.c"
}


Number* number_new_unsigned_integer (guint64 x) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_unsigned_integer (TYPE_NUMBER, x);
#line 362 "number.c"
}


Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator) {
	Number * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = denominator;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ < ((gint64) 0)) {
#line 375 "number.c"
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = numerator;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		numerator = -_tmp1_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = denominator;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		denominator = -_tmp2_;
#line 386 "number.c"
	}
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = numerator;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) number_construct_integer (object_type, _tmp3_);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = denominator;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_ != ((gint64) 1)) {
#line 396 "number.c"
		__mpfr_struct tmp = {0};
		__mpfr_struct _tmp5_ = {0};
		__mpfr_struct _tmp6_ = {0};
		gint64 _tmp7_ = 0LL;
		__mpfr_struct _tmp8_ = {0};
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = self->priv->_re_num;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp5_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = self->priv->_re_num;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = denominator;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mpfr_div_si (&tmp, &_tmp6_, (glong) _tmp7_, MPFR_RNDN);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = tmp;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_re_num (self, &_tmp8_);
#line 416 "number.c"
	}
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 420 "number.c"
}


Number* number_new_fraction (gint64 numerator, gint64 denominator) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
#line 427 "number.c"
}


Number* number_construct_mpfloat (GType object_type, __mpfr_struct* value) {
	Number * self = NULL;
	__mpfr_struct _tmp0_ = {0};
	__mpfr_struct tmp = {0};
	gulong _tmp1_ = 0UL;
	gulong _tmp2_ = 0UL;
	__mpfr_struct _tmp3_ = {0};
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (value != NULL, NULL);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = *value;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp0_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_get_precision ();
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp2_);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp3_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 460 "number.c"
}


Number* number_new_mpfloat (__mpfr_struct* value) {
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_mpfloat (TYPE_NUMBER, value);
#line 467 "number.c"
}


Number* number_construct_double (GType object_type, gdouble value) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	gdouble _tmp2_ = 0.0;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp4_ = 0UL;
	gulong _tmp5_ = 0UL;
	__mpfr_struct _tmp6_ = {0};
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = value;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_d (&tmp, _tmp2_, MPFR_RNDN);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp3_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_get_precision ();
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp5_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = tmp2;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp6_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 512 "number.c"
}


Number* number_new_double (gdouble value) {
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_double (TYPE_NUMBER, value);
#line 519 "number.c"
}


Number* number_construct_complex (GType object_type, Number* x, Number* y) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	Number* _tmp2_ = NULL;
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp5_ = 0UL;
	gulong _tmp6_ = 0UL;
	Number* _tmp7_ = NULL;
	__mpfr_struct _tmp8_ = {0};
	__mpfr_struct _tmp9_ = {0};
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = x;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_->priv->_re_num;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set (&tmp, &_tmp3_, MPFR_RNDN);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = tmp;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp4_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_get_precision ();
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp6_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = y;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_->priv->_re_num;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set (&tmp2, &_tmp8_, MPFR_RNDN);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = tmp2;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp9_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 577 "number.c"
}


Number* number_new_complex (Number* x, Number* y) {
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_complex (TYPE_NUMBER, x, y);
#line 584 "number.c"
}


Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit) {
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_ = NULL;
	AngleUnit _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	Number* y = NULL;
	Number* _tmp3_ = NULL;
	AngleUnit _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (theta != NULL, NULL);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = theta;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = unit;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_cos (_tmp0_, _tmp1_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x = _tmp2_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = theta;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = unit;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_sin (_tmp3_, _tmp4_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	y = _tmp5_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = r;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_multiply (x, _tmp6_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = r;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_multiply (y, _tmp9_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) number_construct_complex (object_type, _tmp8_, _tmp11_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp11_);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (y);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 648 "number.c"
}


Number* number_new_polar (Number* r, Number* theta, AngleUnit unit) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
#line 655 "number.c"
}


Number* number_construct_eulers (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct tmp3 = {0};
	gulong _tmp6_ = 0UL;
	gulong _tmp7_ = 0UL;
	__mpfr_struct _tmp8_ = {0};
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_get_precision ();
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp3_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 1, MPFR_RNDN);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = tmp2;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_exp (&tmp, &_tmp4_, MPFR_RNDN);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp5_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_get_precision ();
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = _tmp6_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp3, (mpfr_prec_t) _tmp7_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp3, (gulong) 0, MPFR_RNDN);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = tmp3;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp8_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 711 "number.c"
}


Number* number_new_eulers (void) {
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_eulers (TYPE_NUMBER);
#line 718 "number.c"
}


Number* number_construct_i (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_get_precision ();
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp3_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 1, MPFR_RNDN);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = tmp;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp4_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp2;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp5_);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 760 "number.c"
}


Number* number_new_i (void) {
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_i (TYPE_NUMBER);
#line 767 "number.c"
}


Number* number_construct_pi (GType object_type) {
	Number * self = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	__mpfr_struct tmp2 = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_const_pi (&tmp, MPFR_RNDN);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = tmp;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (self, &_tmp2_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_get_precision ();
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp4_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp2, (gulong) 0, MPFR_RNDN);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp2;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (self, &_tmp5_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 809 "number.c"
}


Number* number_new_pi (void) {
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_pi (TYPE_NUMBER);
#line 816 "number.c"
}


Number* number_construct_random (GType object_type) {
	Number * self = NULL;
	gdouble _tmp0_ = 0.0;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = g_random_double ();
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) number_construct_double (object_type, _tmp0_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 829 "number.c"
}


Number* number_new_random (void) {
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct_random (TYPE_NUMBER);
#line 836 "number.c"
}


gint64 number_to_integer (Number* self) {
	gint64 result = 0LL;
	__mpfr_struct _tmp0_ = {0};
	glong _tmp1_ = 0L;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = mpfr_get_si (&_tmp0_, MPFR_RNDN);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = (gint64) _tmp1_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 854 "number.c"
}


guint64 number_to_unsigned_integer (Number* self) {
	guint64 result = 0ULL;
	__mpfr_struct _tmp0_ = {0};
	gulong _tmp1_ = 0UL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0ULL);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = mpfr_get_ui (&_tmp0_, MPFR_RNDN);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = (guint64) _tmp1_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 872 "number.c"
}


gfloat number_to_float (Number* self) {
	gfloat result = 0.0F;
	__mpfr_struct _tmp0_ = {0};
	gfloat _tmp1_ = 0.0F;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = mpfr_get_flt (&_tmp0_, MPFR_RNDN);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 890 "number.c"
}


gdouble number_to_double (Number* self) {
	gdouble result = 0.0;
	__mpfr_struct _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = mpfr_get_d (&_tmp0_, MPFR_RNDN);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 908 "number.c"
}


gboolean number_is_zero (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->priv->_re_num;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = mpfr_zero_p (&_tmp1_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 925 "number.c"
		__mpfr_struct _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = self->priv->_im_num;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = mpfr_zero_p (&_tmp3_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp4_;
#line 934 "number.c"
	} else {
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 938 "number.c"
	}
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 944 "number.c"
}


gboolean number_is_negative (Number* self) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	gint _tmp1_ = 0;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = mpfr_sgn (&_tmp0_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_ < 0;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 962 "number.c"
}


gboolean number_is_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct _tmp1_ = {0};
	gint _tmp2_ = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = FALSE;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 981 "number.c"
	}
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->priv->_re_num;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = mpfr_integer_p (&_tmp1_);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp2_ != 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 991 "number.c"
}


gboolean number_is_positive_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = FALSE;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 1008 "number.c"
	} else {
		gboolean _tmp1_ = FALSE;
		__mpfr_struct _tmp2_ = {0};
		gint _tmp3_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->priv->_re_num;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = mpfr_sgn (&_tmp2_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp3_ >= 0) {
#line 1019 "number.c"
			gboolean _tmp4_ = FALSE;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_is_integer (self);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _tmp4_;
#line 1025 "number.c"
		} else {
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = FALSE;
#line 1029 "number.c"
		}
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 1035 "number.c"
	}
}


gboolean number_is_natural (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = FALSE;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 1053 "number.c"
	} else {
		gboolean _tmp1_ = FALSE;
		__mpfr_struct _tmp2_ = {0};
		gint _tmp3_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = self->priv->_re_num;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = mpfr_sgn (&_tmp2_);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp3_ > 0) {
#line 1064 "number.c"
			gboolean _tmp4_ = FALSE;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_is_integer (self);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _tmp4_;
#line 1070 "number.c"
		} else {
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = FALSE;
#line 1074 "number.c"
		}
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 1080 "number.c"
	}
}


gboolean number_is_complex (Number* self) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_im_num;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = mpfr_zero_p (&_tmp0_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = !_tmp1_;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1099 "number.c"
}


void number_check_flags (void) {
	gint _tmp0_ = 0;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = mpfr_underflow_p ();
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_ != 0) {
#line 1109 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_get_error ();
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Underflow error");
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp3_);
#line 1121 "number.c"
	} else {
		gint _tmp4_ = 0;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = mpfr_overflow_p ();
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp4_ != 0) {
#line 1128 "number.c"
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = number_get_error ();
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = _tmp5_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = _ ("Overflow error");
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			number_set_error (_tmp7_);
#line 1140 "number.c"
		}
	}
}


gboolean number_equals (Number* self, Number* y) {
	gboolean result = FALSE;
	__mpfr_struct _tmp0_ = {0};
	Number* _tmp1_ = NULL;
	__mpfr_struct _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, FALSE);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = y;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_->priv->_re_num;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = mpfr_equal_p (&_tmp0_, &_tmp2_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp3_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1168 "number.c"
}


gint number_compare (Number* self, Number* y) {
	gint result = 0;
	__mpfr_struct _tmp0_ = {0};
	Number* _tmp1_ = NULL;
	__mpfr_struct _tmp2_ = {0};
	gint _tmp3_ = 0;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, 0);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = y;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_->priv->_re_num;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = mpfr_cmp (&_tmp0_, &_tmp2_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp3_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1194 "number.c"
}


Number* number_sgn (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	__mpfr_struct _tmp0_ = {0};
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = mpfr_sgn (&_tmp0_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_new_integer ((gint64) _tmp1_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp2_;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1218 "number.c"
}


Number* number_invert_sign (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	__mpfr_struct tmp_im = {0};
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct _tmp6_ = {0};
	__mpfr_struct _tmp7_ = {0};
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_neg (&tmp, &_tmp2_, MPFR_RNDN);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = z->priv->_im_num;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp_im = _tmp5_;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = self->priv->_im_num;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_neg (&tmp_im, &_tmp6_, MPFR_RNDN);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = tmp_im;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (z, &_tmp7_);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1269 "number.c"
}


Number* number_abs (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 1282 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* z = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp1_;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp2_;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = x_real;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = x_real;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp5_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = x_im;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = x_im;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp8_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = x_real;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = x_im;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_add (_tmp9_, _tmp10_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp11_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = z;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_sqrt (_tmp12_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 1349 "number.c"
	} else {
		__mpfr_struct tmp = {0};
		gulong _tmp14_ = 0UL;
		gulong _tmp15_ = 0UL;
		__mpfr_struct _tmp16_ = {0};
		Number* z = NULL;
		__mpfr_struct _tmp17_ = {0};
		Number* _tmp18_ = NULL;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_get_precision ();
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = _tmp14_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mpfr_init2 (&tmp, (mpfr_prec_t) _tmp15_);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = self->priv->_re_num;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mpfr_abs (&tmp, &_tmp16_, MPFR_RNDN);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = tmp;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_new_mpfloat (&_tmp17_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp18_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 1378 "number.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self ? g_object_ref (self) : NULL;
#line 1386 "number.c"
}


Number* number_arg (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* x_real = NULL;
	Number* _tmp5_ = NULL;
	Number* x_im = NULL;
	Number* _tmp6_ = NULL;
	Number* pi = NULL;
	Number* _tmp7_ = NULL;
	Number* z = NULL;
	Number* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	Number* _tmp43_ = NULL;
	AngleUnit _tmp44_ = 0;
	Number* _tmp45_ = NULL;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 1411 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_get_error ();
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Argument not defined for zero");
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp3_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 1430 "number.c"
	}
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_real_component (self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_real = _tmp5_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_imaginary_component (self);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_im = _tmp6_;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_new_pi ();
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	pi = _tmp7_;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = x_im;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_is_zero (_tmp8_);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_) {
#line 1450 "number.c"
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = x_real;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_is_negative (_tmp10_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp11_) {
#line 1459 "number.c"
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = pi;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			z = _tmp13_;
#line 1470 "number.c"
		} else {
			Number* _tmp14_ = NULL;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp14_ = number_new_integer ((gint64) 0);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp14_;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (pi);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_im);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (x_real);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 1487 "number.c"
		}
	} else {
		Number* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = x_real;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_is_zero (_tmp15_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp16_) {
#line 1498 "number.c"
			Number* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp17_ = x_im;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = number_is_negative (_tmp17_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp18_) {
#line 1507 "number.c"
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp19_ = pi;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp20_ = number_divide_integer (_tmp19_, (gint64) (-2));
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp20_;
#line 1518 "number.c"
			} else {
				Number* _tmp21_ = NULL;
				Number* _tmp22_ = NULL;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp21_ = pi;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = number_divide_integer (_tmp21_, (gint64) 2);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp22_;
#line 1530 "number.c"
			}
		} else {
			Number* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = x_real;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = number_is_negative (_tmp23_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp24_) {
#line 1541 "number.c"
				Number* _tmp25_ = NULL;
				Number* _tmp26_ = NULL;
				Number* _tmp27_ = NULL;
				Number* _tmp28_ = NULL;
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = x_im;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = x_real;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = number_divide (_tmp25_, _tmp26_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp27_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_ = z;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp29_ = number_atan (_tmp28_, ANGLE_UNIT_RADIANS);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp29_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp30_ = x_im;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp31_ = number_is_negative (_tmp30_);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (_tmp31_) {
#line 1573 "number.c"
					Number* _tmp32_ = NULL;
					Number* _tmp33_ = NULL;
					Number* _tmp34_ = NULL;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp32_ = z;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp33_ = pi;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp34_ = number_subtract (_tmp32_, _tmp33_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					z = _tmp34_;
#line 1587 "number.c"
				} else {
					Number* _tmp35_ = NULL;
					Number* _tmp36_ = NULL;
					Number* _tmp37_ = NULL;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp35_ = z;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp36_ = pi;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp37_ = number_add (_tmp35_, _tmp36_);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_g_object_unref0 (z);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					z = _tmp37_;
#line 1602 "number.c"
				}
			} else {
				Number* _tmp38_ = NULL;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp38_ = x_im;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp39_ = x_real;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp40_ = number_divide (_tmp38_, _tmp39_);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp40_;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp41_ = z;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp42_ = number_atan (_tmp41_, ANGLE_UNIT_RADIANS);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp42_;
#line 1628 "number.c"
			}
		}
	}
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp43_ = z;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp44_ = unit;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp45_ = number_from_radians (_tmp43_, _tmp44_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp45_;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (pi);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_im);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_real);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1650 "number.c"
}


Number* number_conjugate (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	Number* _tmp3_ = NULL;
	__mpfr_struct tmp2 = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_im_num;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_neg (&tmp, &_tmp2_, MPFR_RNDN);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_copy (self);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp3_;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = z->priv->_im_num;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp2 = _tmp4_;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&tmp2);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (z, &_tmp5_);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1695 "number.c"
}


Number* number_real_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->priv->_im_num;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp = _tmp1_;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&tmp);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_get_precision ();
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp3_);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = tmp;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (z, &_tmp4_);
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1736 "number.c"
}


Number* number_imaginary_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp = _tmp1_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&tmp);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = z->priv->_im_num;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (z, &_tmp2_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_get_precision ();
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp4_);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp, (gulong) 0, MPFR_RNDN);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (z, &_tmp5_);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1782 "number.c"
}


Number* number_integer_component (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_trunc (&tmp, &_tmp2_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1817 "number.c"
}


Number* number_fractional_component (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_frac (&tmp, &_tmp2_, MPFR_RNDN);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1852 "number.c"
}


Number* number_fractional_part (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_floor (self);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_subtract (self, _tmp1_);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp3_;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1878 "number.c"
}


Number* number_floor (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_floor (&tmp, &_tmp2_);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1913 "number.c"
}


Number* number_ceiling (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_ceil (&tmp, &_tmp2_);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1948 "number.c"
}


Number* number_round (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_round (&tmp, &_tmp2_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 1983 "number.c"
}


Number* number_reciprocal (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 1996 "number.c"
		Number* real_x = NULL;
		Number* _tmp1_ = NULL;
		Number* im_x = NULL;
		Number* _tmp2_ = NULL;
		Number* t1 = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* t2 = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* z = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_x = _tmp1_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_x = _tmp2_;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = real_x;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = real_x;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp5_;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = im_x;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = im_x;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp8_;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = t1;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = t2;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_add (_tmp9_, _tmp10_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp11_;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = t1;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_reciprocal_real (_tmp12_);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp13_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_conjugate (self);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = _tmp14_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = number_multiply (_tmp15_, _tmp16_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = _tmp17_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp15_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp18_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_x);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_x);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2086 "number.c"
	} else {
		Number* _tmp19_ = NULL;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_reciprocal_real (self);
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp19_;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2095 "number.c"
	}
}


Number* number_epowy (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 2110 "number.c"
		Number* _tmp1_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2118 "number.c"
	}
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_complex (self);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 2124 "number.c"
		Number* x_real = NULL;
		Number* _tmp3_ = NULL;
		Number* theta = NULL;
		Number* _tmp4_ = NULL;
		Number* r = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_real_component (self);
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp3_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_imaginary_component (self);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		theta = _tmp4_;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = x_real;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_epowy_real (_tmp5_);
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		r = _tmp6_;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = r;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = theta;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_new_polar (_tmp7_, _tmp8_, ANGLE_UNIT_RADIANS);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp9_;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (r);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (theta);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2165 "number.c"
	} else {
		Number* _tmp10_ = NULL;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_epowy_real (self);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp10_;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2174 "number.c"
	}
}


Number* number_xpowy (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	Number* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	Number* t = NULL;
	Number* t2 = NULL;
	Number* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp35_ = 0UL;
	gulong _tmp36_ = 0UL;
	Number* _tmp37_ = NULL;
	__mpfr_struct _tmp38_ = {0};
	Number* _tmp39_ = NULL;
	__mpfr_struct _tmp40_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp41_ = {0};
	Number* _tmp42_ = NULL;
	__mpfr_struct tmp2 = {0};
	Number* _tmp43_ = NULL;
	__mpfr_struct _tmp44_ = {0};
	gulong _tmp45_ = 0UL;
	gulong _tmp46_ = 0UL;
	Number* _tmp47_ = NULL;
	__mpfr_struct _tmp48_ = {0};
	Number* _tmp49_ = NULL;
	__mpfr_struct _tmp50_ = {0};
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_zero (self);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 2218 "number.c"
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_negative (_tmp2_);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp3_;
#line 2227 "number.c"
	} else {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 2231 "number.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 2235 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_get_error ();
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _ ("The power of zero is undefined for a negative exponent");
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp6_);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_new_integer ((gint64) 0);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp7_;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2254 "number.c"
	}
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_is_zero (self);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_) {
#line 2260 "number.c"
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = y;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_is_zero (_tmp10_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _tmp11_;
#line 2269 "number.c"
	} else {
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = FALSE;
#line 2273 "number.c"
	}
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp8_) {
#line 2277 "number.c"
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_get_error ();
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = _tmp12_;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = _ ("Zero raised to zero is undefined");
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp14_);
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_new_integer ((gint64) 0);
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp15_;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2296 "number.c"
	}
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = y;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = number_is_integer (_tmp16_);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp17_) {
#line 2304 "number.c"
		Number* reciprocal = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = y;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_reciprocal (_tmp18_);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		reciprocal = _tmp19_;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = reciprocal;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_is_integer (_tmp20_);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp21_) {
#line 2322 "number.c"
			Number* _tmp22_ = NULL;
			gint64 _tmp23_ = 0LL;
			Number* _tmp24_ = NULL;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = reciprocal;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = number_to_integer (_tmp22_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = number_root (self, _tmp23_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp24_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (reciprocal);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 2338 "number.c"
		} else {
			Number* _tmp25_ = NULL;
			Number* _tmp26_ = NULL;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = y;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp26_ = number_pwr (self, _tmp25_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp26_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (reciprocal);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 2352 "number.c"
		}
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (reciprocal);
#line 2356 "number.c"
	}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = y;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = number_is_negative (_tmp27_);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp28_) {
#line 2364 "number.c"
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_reciprocal (self);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp29_;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = y;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = number_invert_sign (_tmp30_);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp31_;
#line 2382 "number.c"
	} else {
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = _g_object_ref0 (self);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp32_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = y;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = _g_object_ref0 (_tmp33_);
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp34_;
#line 2401 "number.c"
	}
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_ = number_get_precision ();
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp36_ = _tmp35_;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp36_);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = t;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_ = _tmp37_->priv->_re_num;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp39_ = t2;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp40_ = _tmp39_->priv->_re_num;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_pow (&tmp, &_tmp38_, &_tmp40_, MPFR_RNDN);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = tmp;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp42_ = number_new_mpfloat (&_tmp41_);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp42_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp43_ = z;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp44_ = _tmp43_->priv->_im_num;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp2 = _tmp44_;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&tmp2);
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp45_ = number_get_precision ();
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp46_ = _tmp45_;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp46_);
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp47_ = t;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp48_ = _tmp47_->priv->_im_num;
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set (&tmp, &_tmp48_, MPFR_RNDN);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp49_ = z;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp50_ = tmp;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (_tmp49_, &_tmp50_);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2459 "number.c"
}


Number* number_xpowy_integer (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	Number* t = NULL;
	gint64 _tmp14_ = 0LL;
	__mpfr_struct tmp = {0};
	gulong _tmp18_ = 0UL;
	gulong _tmp19_ = 0UL;
	Number* _tmp20_ = NULL;
	__mpfr_struct _tmp21_ = {0};
	gint64 _tmp22_ = 0LL;
	Number* z = NULL;
	__mpfr_struct _tmp23_ = {0};
	Number* _tmp24_ = NULL;
	__mpfr_struct tmp2 = {0};
	Number* _tmp25_ = NULL;
	__mpfr_struct _tmp26_ = {0};
	gulong _tmp27_ = 0UL;
	gulong _tmp28_ = 0UL;
	Number* _tmp29_ = NULL;
	__mpfr_struct _tmp30_ = {0};
	Number* _tmp31_ = NULL;
	__mpfr_struct _tmp32_ = {0};
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_zero (self);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 2495 "number.c"
		gint64 _tmp2_ = 0LL;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = n;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ < ((gint64) 0);
#line 2501 "number.c"
	} else {
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 2505 "number.c"
	}
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 2509 "number.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_get_error ();
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _tmp3_;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _ ("The power of zero is undefined for a negative exponent");
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp5_);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_new_integer ((gint64) 0);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp6_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2528 "number.c"
	}
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_is_zero (self);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp8_) {
#line 2534 "number.c"
		gint64 _tmp9_ = 0LL;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = n;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = _tmp9_ == ((gint64) 0);
#line 2540 "number.c"
	} else {
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = FALSE;
#line 2544 "number.c"
	}
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_) {
#line 2548 "number.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_get_error ();
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = _tmp10_;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = _ ("Zero raised to zero is undefined");
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp12_);
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_new_integer ((gint64) 0);
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp13_;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2567 "number.c"
	}
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = n;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp14_ < ((gint64) 0)) {
#line 2573 "number.c"
		Number* _tmp15_ = NULL;
		gint64 _tmp16_ = 0LL;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_reciprocal (self);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp15_;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = n;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		n = -_tmp16_;
#line 2586 "number.c"
	} else {
		Number* _tmp17_ = NULL;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = _g_object_ref0 (self);
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp17_;
#line 2595 "number.c"
	}
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = number_get_precision ();
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = _tmp18_;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp19_);
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = t;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = _tmp20_->priv->_re_num;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = n;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_pow_si (&tmp, &_tmp21_, (glong) _tmp22_, MPFR_RNDN);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = tmp;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = number_new_mpfloat (&_tmp23_);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp24_;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp25_ = z;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = _tmp25_->priv->_im_num;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp2 = _tmp26_;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&tmp2);
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = number_get_precision ();
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = _tmp27_;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp28_);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp29_ = t;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp30_ = _tmp29_->priv->_im_num;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set (&tmp, &_tmp30_, MPFR_RNDN);
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp31_ = z;
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp32_ = tmp;
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (_tmp31_, &_tmp32_);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2649 "number.c"
}


static Number* number_pwr (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 2673 "number.c"
		Number* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		Number* _tmp6_ = NULL;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = y;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_is_negative (_tmp1_);
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp2_) {
#line 2683 "number.c"
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = number_get_error ();
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = _tmp3_;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = _ ("The power of zero is undefined for a negative exponent");
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			number_set_error (_tmp5_);
#line 2695 "number.c"
		}
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_new_integer ((gint64) 0);
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp6_;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2703 "number.c"
	}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = y;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_is_zero (_tmp7_);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp8_) {
#line 2711 "number.c"
		Number* _tmp9_ = NULL;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_new_integer ((gint64) 1);
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp9_;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2719 "number.c"
	}
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = y;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_ln (self);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = _tmp11_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = number_multiply (_tmp10_, _tmp12_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = _tmp13_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = number_epowy (_tmp14_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = _tmp15_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp14_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp12_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp16_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2743 "number.c"
}


Number* number_root (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_complex (self);
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp2_) {
#line 2758 "number.c"
		gboolean _tmp3_ = FALSE;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_negative (self);
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = _tmp3_;
#line 2764 "number.c"
	} else {
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = FALSE;
#line 2768 "number.c"
	}
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 2772 "number.c"
		gint64 _tmp4_ = 0LL;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = n;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = (_tmp4_ % 2) == ((gint64) 1);
#line 2778 "number.c"
	} else {
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 2782 "number.c"
	}
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 2786 "number.c"
		Number* z = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_abs (self);
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp5_;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = z;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = n;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_root_real (_tmp6_, _tmp7_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp8_;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = z;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_invert_sign (_tmp9_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp10_;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2820 "number.c"
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_is_complex (self);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp12_) {
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = TRUE;
#line 2830 "number.c"
		} else {
			gboolean _tmp13_ = FALSE;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = number_is_negative (self);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp13_;
#line 2837 "number.c"
		}
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp11_) {
#line 2841 "number.c"
			Number* r = NULL;
			Number* _tmp14_ = NULL;
			Number* theta = NULL;
			Number* _tmp15_ = NULL;
			Number* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp14_ = number_abs (self);
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			r = _tmp14_;
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = number_arg (self, ANGLE_UNIT_RADIANS);
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			theta = _tmp15_;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp16_ = r;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp17_ = n;
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = number_root_real (_tmp16_, _tmp17_);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (r);
#line 615 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			r = _tmp18_;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp19_ = theta;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = n;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = number_divide_integer (_tmp19_, _tmp20_);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (theta);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			theta = _tmp21_;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = r;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = theta;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = number_new_polar (_tmp22_, _tmp23_, ANGLE_UNIT_RADIANS);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp24_;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (theta);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (r);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 2897 "number.c"
		} else {
			gint64 _tmp25_ = 0LL;
			Number* _tmp26_ = NULL;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = n;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp26_ = number_root_real (self, _tmp25_);
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp26_;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 2909 "number.c"
		}
	}
}


Number* number_sqrt (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_sqrt (&tmp, &_tmp2_, MPFR_RNDN);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 2946 "number.c"
}


Number* number_ln (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 636 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 2961 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_get_error ();
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Logarithm of zero is undefined");
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp3_);
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 2980 "number.c"
	}
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_is_complex (self);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp6_) {
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = TRUE;
#line 2988 "number.c"
	} else {
		gboolean _tmp7_ = FALSE;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_is_negative (self);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp7_;
#line 2995 "number.c"
	}
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_) {
#line 2999 "number.c"
		Number* r = NULL;
		Number* _tmp8_ = NULL;
		Number* theta = NULL;
		Number* _tmp9_ = NULL;
		Number* z_real = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_abs (self);
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		r = _tmp8_;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_arg (self, ANGLE_UNIT_RADIANS);
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		theta = _tmp9_;
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = r;
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_ln_real (_tmp10_);
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp11_;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = z_real;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = theta;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_new_complex (_tmp12_, _tmp13_);
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp14_;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (theta);
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (r);
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3040 "number.c"
	} else {
		Number* _tmp15_ = NULL;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_ln_real (self);
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp15_;
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3049 "number.c"
	}
}


Number* number_logarithm (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	gint64 _tmp5_ = 0LL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 3073 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_get_error ();
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Logarithm of zero is undefined");
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp3_);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3092 "number.c"
	}
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = n;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_new_integer (_tmp5_);
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp6_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_ln (self);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = t1;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = number_ln (_tmp9_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = number_divide (_tmp8_, _tmp11_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp11_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp13_;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3124 "number.c"
}


Number* number_factorial (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint64 value = 0LL;
	gint64 _tmp20_ = 0LL;
	Number* z = NULL;
	Number* _tmp21_ = NULL;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 3142 "number.c"
		Number* _tmp1_ = NULL;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_new_integer ((gint64) 1);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp1_;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3150 "number.c"
	}
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_natural (self);
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp2_) {
#line 3156 "number.c"
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		Number* tmp = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		__mpfr_struct tmp2 = {0};
		gulong _tmp14_ = 0UL;
		gulong _tmp15_ = 0UL;
		Number* _tmp16_ = NULL;
		__mpfr_struct _tmp17_ = {0};
		__mpfr_struct _tmp18_ = {0};
		Number* _tmp19_ = NULL;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_is_negative (self);
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp4_) {
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 3177 "number.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = number_is_complex (self);
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = _tmp5_;
#line 3184 "number.c"
		}
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp3_) {
#line 3188 "number.c"
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = number_get_error ();
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = _tmp6_;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = _ ("Factorial is only defined for non-negative real numbers");
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			number_set_error (_tmp8_);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = number_new_integer ((gint64) 0);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp9_;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 3207 "number.c"
		}
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_new_integer ((gint64) 1);
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = _tmp10_;
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_add (self, _tmp11_);
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = _tmp12_;
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp11_);
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp13_;
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = number_get_precision ();
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = _tmp14_;
#line 699 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp15_);
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = tmp;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = _tmp16_->priv->_re_num;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		mpfr_gamma (&tmp2, &_tmp17_, MPFR_RNDN);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = tmp2;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_new_mpfloat (&_tmp18_);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp19_;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3243 "number.c"
	}
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = number_to_integer (self);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	value = _tmp20_;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = _g_object_ref0 (self);
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp21_;
#line 3253 "number.c"
	{
		gint i = 0;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = 2;
#line 3258 "number.c"
		{
			gboolean _tmp22_ = FALSE;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = TRUE;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 3265 "number.c"
				gint _tmp24_ = 0;
				gint64 _tmp25_ = 0LL;
				Number* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				Number* _tmp28_ = NULL;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp22_) {
#line 3273 "number.c"
					gint _tmp23_ = 0;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp23_ = i;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					i = _tmp23_ + 1;
#line 3279 "number.c"
				}
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp22_ = FALSE;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp24_ = i;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp25_ = value;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(((gint64) _tmp24_) < _tmp25_)) {
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 3291 "number.c"
				}
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp26_ = z;
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp27_ = i;
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp28_ = number_multiply_integer (_tmp26_, (gint64) _tmp27_);
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_g_object_unref0 (z);
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				z = _tmp28_;
#line 3303 "number.c"
			}
		}
	}
#line 713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3311 "number.c"
}


Number* number_add (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_complex (self);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 3329 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_complex (_tmp2_);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp3_;
#line 3339 "number.c"
	}
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 3343 "number.c"
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_real_component (self);
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_x = _tmp4_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_imaginary_component (self);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_x = _tmp5_;
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = y;
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_real_component (_tmp6_);
#line 725 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_y = _tmp7_;
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = y;
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_imaginary_component (_tmp8_);
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_y = _tmp9_;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = real_x;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = real_y;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_add_real (_tmp10_, _tmp11_);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_z = _tmp12_;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = im_x;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = im_y;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_add_real (_tmp13_, _tmp14_);
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_z = _tmp15_;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = real_z;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = im_z;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_new_complex (_tmp16_, _tmp17_);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp18_;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_y);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_y);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_x);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_x);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3427 "number.c"
	} else {
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = y;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_add_real (self, _tmp19_);
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp20_;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3439 "number.c"
	}
}


Number* number_add_real (Number* self, Number* y) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* _tmp3_ = NULL;
	__mpfr_struct _tmp4_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp5_ = {0};
	Number* _tmp6_ = NULL;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 739 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = y;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_->priv->_re_num;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_add (&tmp, &_tmp2_, &_tmp4_, MPFR_RNDN);
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp;
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_new_mpfloat (&_tmp5_);
#line 741 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp6_;
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3483 "number.c"
}


Number* number_subtract (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_invert_sign (_tmp0_);
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_add (self, _tmp2_);
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp4_;
#line 748 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3514 "number.c"
}


Number* number_multiply (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 752 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_complex (self);
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 3532 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_complex (_tmp2_);
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp3_;
#line 3542 "number.c"
	}
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 3546 "number.c"
		Number* t1 = NULL;
		Number* t2 = NULL;
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_real_component (self);
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_x = _tmp4_;
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_imaginary_component (self);
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_x = _tmp5_;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = y;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_real_component (_tmp6_);
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_y = _tmp7_;
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = y;
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_imaginary_component (_tmp8_);
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_y = _tmp9_;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = real_x;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = real_y;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_multiply_real (_tmp10_, _tmp11_);
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp12_;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = im_x;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = im_y;
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_multiply_real (_tmp13_, _tmp14_);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp15_;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = t1;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = t2;
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_subtract (_tmp16_, _tmp17_);
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 765 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		real_z = _tmp18_;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = real_x;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = im_y;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_multiply_real (_tmp19_, _tmp20_);
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t1 = _tmp21_;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = im_x;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = real_y;
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_multiply_real (_tmp22_, _tmp23_);
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 768 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t2 = _tmp24_;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = t1;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = t2;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = number_add (_tmp25_, _tmp26_);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		im_z = _tmp27_;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = real_z;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = im_z;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = number_new_complex (_tmp28_, _tmp29_);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp30_;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_y);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_y);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_x);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_x);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (im_z);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (real_z);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t2);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t1);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3688 "number.c"
	} else {
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = y;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = number_multiply_real (self, _tmp31_);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp32_;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3700 "number.c"
	}
}


Number* number_multiply_real (Number* self, Number* y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	Number* _tmp3_ = NULL;
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp = _tmp1_;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = y;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_->priv->_re_num;
#line 781 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_mul (&tmp, &_tmp2_, &_tmp4_, MPFR_RNDN);
#line 782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp;
#line 782 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (z, &_tmp5_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3743 "number.c"
}


Number* number_multiply_integer (Number* self, gint64 y) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	__mpfr_struct _tmp4_ = {0};
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp = _tmp1_;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = y;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_mul_si (&tmp, &_tmp2_, (glong) _tmp3_, MPFR_RNDN);
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = tmp;
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (z, &_tmp4_);
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 3780 "number.c"
}


Number* number_divide (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp52_ = 0UL;
	gulong _tmp53_ = 0UL;
	__mpfr_struct _tmp54_ = {0};
	Number* _tmp55_ = NULL;
	__mpfr_struct _tmp56_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp57_ = {0};
	Number* _tmp58_ = NULL;
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_zero (_tmp0_);
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_) {
#line 3809 "number.c"
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_get_error ();
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _tmp2_;
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _ ("Division by zero is undefined");
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp4_);
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_new_integer ((gint64) 0);
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp5_;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 3828 "number.c"
	}
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_is_complex (self);
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_) {
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = TRUE;
#line 3836 "number.c"
	} else {
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = y;
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = number_is_complex (_tmp8_);
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _tmp9_;
#line 3846 "number.c"
	}
#line 806 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp6_) {
#line 3850 "number.c"
		Number* a = NULL;
		Number* _tmp10_ = NULL;
		Number* b = NULL;
		Number* _tmp11_ = NULL;
		Number* c = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* d = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* tmp = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* tmp_2 = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* z_1 = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		Number* _tmp42_ = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* z_2 = NULL;
		Number* _tmp46_ = NULL;
		Number* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		Number* z = NULL;
		Number* _tmp49_ = NULL;
		Number* _tmp50_ = NULL;
		Number* _tmp51_ = NULL;
#line 808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_real_component (self);
#line 808 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		a = _tmp10_;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_imaginary_component (self);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		b = _tmp11_;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = y;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_real_component (_tmp12_);
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp13_;
#line 811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = y;
#line 811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_imaginary_component (_tmp14_);
#line 811 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		d = _tmp15_;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = a;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = c;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = _tmp18_;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = b;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = d;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = number_multiply (_tmp20_, _tmp21_);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = _tmp22_;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = number_add (_tmp19_, _tmp23_);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = _tmp24_;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp23_);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp19_);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp25_;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = c;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = number_xpowy_integer (_tmp26_, (gint64) 2);
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = _tmp27_;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = d;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = number_xpowy_integer (_tmp29_, (gint64) 2);
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = _tmp30_;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = number_add (_tmp28_, _tmp31_);
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = _tmp32_;
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp31_);
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp28_);
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp_2 = _tmp33_;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = tmp;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = tmp_2;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = number_divide (_tmp34_, _tmp35_);
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_1 = _tmp36_;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = b;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = c;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = number_multiply (_tmp37_, _tmp38_);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = _tmp39_;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = a;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = d;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = number_multiply (_tmp41_, _tmp42_);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = _tmp43_;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_ = number_subtract (_tmp40_, _tmp44_);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp45_;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp44_);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp40_);
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = tmp;
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = tmp_2;
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp48_ = number_divide (_tmp46_, _tmp47_);
#line 818 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_2 = _tmp48_;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp49_ = z_1;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50_ = z_2;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp51_ = number_new_complex (_tmp49_, _tmp50_);
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp51_;
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = z;
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_2);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_1);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp_2);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (d);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (c);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (b);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (a);
#line 821 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4040 "number.c"
	}
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp52_ = number_get_precision ();
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp53_ = _tmp52_;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp53_);
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = self->priv->_re_num;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp55_ = y;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp56_ = _tmp55_->priv->_re_num;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_div (&tmp, &_tmp54_, &_tmp56_, MPFR_RNDN);
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp57_ = tmp;
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp58_ = number_new_mpfloat (&_tmp57_);
#line 826 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp58_;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4066 "number.c"
}


Number* number_divide_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gint64 _tmp0_ = 0LL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
#line 831 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = y;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_new_integer (_tmp0_);
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_divide (self, _tmp2_);
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp4_;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4095 "number.c"
}


Number* number_modulus_divide (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* t2 = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* z = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	gint _tmp23_ = 0;
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_integer (self);
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 4132 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_integer (_tmp2_);
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 4142 "number.c"
	}
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4146 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_get_error ();
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_;
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _ ("Modulus division is only defined for integers");
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp6_);
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_new_integer ((gint64) 0);
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp7_;
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4165 "number.c"
	}
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = y;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_divide (self, _tmp8_);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = _tmp9_;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_floor (_tmp10_);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = _tmp11_;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp10_);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp12_;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = t1;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = y;
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = number_multiply (_tmp13_, _tmp14_);
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp15_;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = t2;
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = number_subtract (self, _tmp16_);
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp17_;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = number_new_integer ((gint64) 0);
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t1 = _tmp18_;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = y;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = t1;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = number_compare (_tmp21_, _tmp22_);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp23_ < 0) {
#line 4209 "number.c"
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		gint _tmp26_ = 0;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = z;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = t1;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_compare (_tmp24_, _tmp25_);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = _tmp26_ > 0;
#line 4221 "number.c"
	} else {
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = FALSE;
#line 4225 "number.c"
	}
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp20_) {
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = TRUE;
#line 4231 "number.c"
	} else {
		gboolean _tmp27_ = FALSE;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		gint _tmp30_ = 0;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = y;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = t1;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = number_compare (_tmp28_, _tmp29_);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp30_ > 0) {
#line 4245 "number.c"
			Number* _tmp31_ = NULL;
			Number* _tmp32_ = NULL;
			gint _tmp33_ = 0;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp31_ = z;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp32_ = t1;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp33_ = number_compare (_tmp31_, _tmp32_);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp27_ = _tmp33_ < 0;
#line 4257 "number.c"
		} else {
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp27_ = FALSE;
#line 4261 "number.c"
		}
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = _tmp27_;
#line 4265 "number.c"
	}
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp19_) {
#line 4269 "number.c"
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp34_ = z;
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = y;
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp36_ = number_add (_tmp34_, _tmp35_);
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp36_;
#line 4283 "number.c"
	}
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t1);
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4293 "number.c"
}


Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod) {
	Number* result = NULL;
	Number* base_value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* exp_value = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* ans = NULL;
	Number* _tmp7_ = NULL;
	Number* two = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp34_ = NULL;
	Number* _tmp35_ = NULL;
	Number* _tmp36_ = NULL;
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (exp != NULL, NULL);
#line 858 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (mod != NULL, NULL);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	base_value = _tmp0_;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = exp;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_negative (_tmp1_);
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 4329 "number.c"
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = base_value;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_reciprocal (_tmp3_);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (base_value);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_value = _tmp4_;
#line 4340 "number.c"
	}
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = exp;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_abs (_tmp5_);
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	exp_value = _tmp6_;
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_new_integer ((gint64) 1);
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	ans = _tmp7_;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_new_integer ((gint64) 2);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	two = _tmp8_;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 4358 "number.c"
		Number* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean is_even = FALSE;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = exp_value;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_is_zero (_tmp9_);
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(!_tmp10_)) {
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 4387 "number.c"
		}
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = exp_value;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = two;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_modulus_divide (_tmp11_, _tmp12_);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = _tmp13_;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_is_zero (_tmp14_);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp15_;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp14_);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		is_even = _tmp16_;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = is_even;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp17_) {
#line 4409 "number.c"
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			Number* _tmp20_ = NULL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = ans;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp19_ = base_value;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp20_ = number_multiply (_tmp18_, _tmp19_);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (ans);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			ans = _tmp20_;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = ans;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = mod;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = number_modulus_divide (_tmp21_, _tmp22_);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (ans);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			ans = _tmp23_;
#line 4436 "number.c"
		}
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = base_value;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = base_value;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp26_ = number_multiply (_tmp24_, _tmp25_);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (base_value);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_value = _tmp26_;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp27_ = base_value;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = mod;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = number_modulus_divide (_tmp27_, _tmp28_);
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (base_value);
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_value = _tmp29_;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = exp_value;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = _tmp31_;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp33_ = number_floor (_tmp32_);
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (exp_value);
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		exp_value = _tmp33_;
#line 876 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp32_);
#line 4472 "number.c"
	}
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = ans;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_ = mod;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp36_ = number_modulus_divide (_tmp34_, _tmp35_);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp36_;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (two);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (ans);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (exp_value);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (base_value);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4492 "number.c"
}


Number* number_sin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 882 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4505 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp1_;
#line 887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp2_;
#line 889 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = x_real;
#line 889 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = unit;
#line 889 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_sin_real (_tmp3_, _tmp4_);
#line 889 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp5_;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = x_im;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_cosh (_tmp6_);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp7_;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = z_real;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = t;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp10_;
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = x_real;
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = unit;
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_cos_real (_tmp11_, _tmp12_);
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp13_;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = x_im;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_sinh (_tmp14_);
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp15_;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z_im;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = t;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp18_;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = z_real;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = z_im;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_new_complex (_tmp19_, _tmp20_);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp21_;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4610 "number.c"
	} else {
		AngleUnit _tmp22_ = 0;
		Number* _tmp23_ = NULL;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = unit;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = number_sin_real (self, _tmp22_);
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp23_;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4622 "number.c"
	}
}


Number* number_cos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_complex (self);
#line 906 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4636 "number.c"
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_real_component (self);
#line 908 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_real = _tmp1_;
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_imaginary_component (self);
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		x_im = _tmp2_;
#line 911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = x_real;
#line 911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = unit;
#line 911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_cos_real (_tmp3_, _tmp4_);
#line 911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp5_;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = x_im;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_cosh (_tmp6_);
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp7_;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = z_real;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = t;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_real = _tmp10_;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = x_real;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = unit;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = number_sin_real (_tmp11_, _tmp12_);
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp13_;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp14_ = x_im;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_sinh (_tmp14_);
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		t = _tmp15_;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = z_im;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = t;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp18_;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = z_im;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_invert_sign (_tmp19_);
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z_im = _tmp20_;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = z_real;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = z_im;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = number_new_complex (_tmp21_, _tmp22_);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp23_;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_im);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z_real);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_im);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_real);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4751 "number.c"
	} else {
		AngleUnit _tmp24_ = 0;
		Number* _tmp25_ = NULL;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = unit;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = number_cos_real (self, _tmp24_);
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp25_;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4763 "number.c"
	}
}


Number* number_tan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* check = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp19_ = 0UL;
	gulong _tmp20_ = 0UL;
	Number* _tmp21_ = NULL;
	__mpfr_struct _tmp22_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp23_ = {0};
	Number* _tmp24_ = NULL;
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_to_radians (self, _tmp0_);
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_radians = _tmp1_;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = x_radians;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_new_pi ();
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_divide_integer (_tmp4_, (gint64) 2);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_subtract (_tmp2_, _tmp6_);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_new_pi ();
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = _tmp9_;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_divide (_tmp8_, _tmp10_);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = _tmp11_;
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp10_);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp8_);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp6_);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp4_);
#line 931 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	check = _tmp12_;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = check;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = number_is_integer (_tmp13_);
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp14_) {
#line 4841 "number.c"
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = number_get_error ();
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp15_;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp17_ = _ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)");
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp17_);
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = number_new_integer ((gint64) 0);
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp18_;
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (check);
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (x_radians);
#line 937 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4864 "number.c"
	}
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = number_get_precision ();
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = _tmp19_;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp20_);
#line 941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = x_radians;
#line 941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = _tmp21_->priv->_re_num;
#line 941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_tan (&tmp, &_tmp22_, MPFR_RNDN);
#line 942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = tmp;
#line 942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = number_new_mpfloat (&_tmp23_);
#line 942 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp24_;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (check);
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_radians);
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4892 "number.c"
}


Number* number_asin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	AngleUnit _tmp18_ = 0;
	Number* _tmp19_ = NULL;
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_compare (self, _tmp2_);
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_ > 0;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 4929 "number.c"
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_new_integer ((gint64) (-1));
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _tmp5_;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp7_ < 0;
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp6_);
#line 4944 "number.c"
	}
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 4948 "number.c"
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_get_error ();
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = _tmp8_;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _ ("Inverse sine is undefined for values outside [-1, 1]");
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp10_);
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_new_integer ((gint64) 0);
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp11_;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 4967 "number.c"
	}
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = number_get_precision ();
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
#line 957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = self->priv->_re_num;
#line 957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_asin (&tmp, &_tmp14_, MPFR_RNDN);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = tmp;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = number_new_mpfloat (&_tmp15_);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp16_;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = z;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = unit;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = number_from_radians (_tmp17_, _tmp18_);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp19_;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 4997 "number.c"
}


Number* number_acos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	AngleUnit _tmp18_ = 0;
	Number* _tmp19_ = NULL;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_compare (self, _tmp2_);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_ > 0;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 5034 "number.c"
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_new_integer ((gint64) (-1));
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _tmp5_;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp7_ < 0;
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp6_);
#line 5049 "number.c"
	}
#line 965 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5053 "number.c"
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_get_error ();
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = _tmp8_;
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _ ("Inverse cosine is undefined for values outside [-1, 1]");
#line 968 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp10_);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_new_integer ((gint64) 0);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp11_;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5072 "number.c"
	}
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = number_get_precision ();
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_;
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = self->priv->_re_num;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_acos (&tmp, &_tmp14_, MPFR_RNDN);
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = tmp;
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = number_new_mpfloat (&_tmp15_);
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp16_;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = z;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = unit;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = number_from_radians (_tmp17_, _tmp18_);
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp19_;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5102 "number.c"
}


Number* number_atan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
	AngleUnit _tmp5_ = 0;
	Number* _tmp6_ = NULL;
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_atan (&tmp, &_tmp2_, MPFR_RNDN);
#line 983 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 983 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 983 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = unit;
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_from_radians (z, _tmp5_);
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_;
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (z);
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5145 "number.c"
}


Number* number_sinh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_sinh (&tmp, &_tmp2_, MPFR_RNDN);
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 992 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5180 "number.c"
}


Number* number_cosh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 997 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 999 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_cosh (&tmp, &_tmp2_, MPFR_RNDN);
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1001 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 1002 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1002 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5215 "number.c"
}


Number* number_tanh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 1006 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1009 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_tanh (&tmp, &_tmp2_, MPFR_RNDN);
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 1011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1011 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5250 "number.c"
}


Number* number_asinh (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 1015 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 1017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 1017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1018 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_asinh (&tmp, &_tmp2_, MPFR_RNDN);
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 1020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1020 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5285 "number.c"
}


Number* number_acosh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	__mpfr_struct tmp = {0};
	gulong _tmp7_ = 0UL;
	gulong _tmp8_ = 0UL;
	__mpfr_struct _tmp9_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp10_ = {0};
	Number* _tmp11_ = NULL;
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 1);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t = _tmp0_;
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = t;
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_compare (self, _tmp1_);
#line 1028 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ < 0) {
#line 5314 "number.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_get_error ();
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _tmp3_;
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _ ("Inverse hyperbolic cosine is undefined for values less than one");
#line 1031 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp5_);
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = number_new_integer ((gint64) 0);
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp6_;
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (t);
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5335 "number.c"
	}
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_get_precision ();
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp8_);
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = self->priv->_re_num;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_acosh (&tmp, &_tmp9_, MPFR_RNDN);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = tmp;
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = number_new_mpfloat (&_tmp10_);
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp11_;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t);
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5359 "number.c"
}


Number* number_atanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp12_ = 0UL;
	gulong _tmp13_ = 0UL;
	__mpfr_struct _tmp14_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp15_ = {0};
	Number* _tmp16_ = NULL;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_new_integer ((gint64) 1);
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_compare (self, _tmp2_);
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_ >= 0;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 5393 "number.c"
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = number_new_integer ((gint64) (-1));
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _tmp5_;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = number_compare (self, _tmp6_);
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp7_ <= 0;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp6_);
#line 5408 "number.c"
	}
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5412 "number.c"
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
#line 1048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = number_get_error ();
#line 1048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = _tmp8_;
#line 1048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]");
#line 1048 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp10_);
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = number_new_integer ((gint64) 0);
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp11_;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 5431 "number.c"
	}
#line 1052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = number_get_precision ();
#line 1052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = _tmp12_;
#line 1052 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp13_);
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = self->priv->_re_num;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_atanh (&tmp, &_tmp14_, MPFR_RNDN);
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = tmp;
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = number_new_mpfloat (&_tmp15_);
#line 1054 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp16_;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5453 "number.c"
}


static gint __lambda4_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ & _tmp1_;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5469 "number.c"
}


static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5478 "number.c"
}


Number* number_and (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 5498 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 5508 "number.c"
	}
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5512 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_get_error ();
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _ ("Boolean AND is only defined for positive integers");
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp6_);
#line 5524 "number.c"
	}
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = y;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda4__bitwise_func, self, 0);
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp8_;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5534 "number.c"
}


static gint __lambda5_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ | _tmp1_;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5550 "number.c"
}


static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5559 "number.c"
}


Number* number_or (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1072 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 5579 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 5589 "number.c"
	}
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5593 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_get_error ();
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _ ("Boolean OR is only defined for positive integers");
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp6_);
#line 5605 "number.c"
	}
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = y;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda5__bitwise_func, self, 0);
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp8_;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5615 "number.c"
}


static gint __lambda6_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ ^ _tmp1_;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5631 "number.c"
}


static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5640 "number.c"
}


Number* number_xor (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_is_positive_integer (self);
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = TRUE;
#line 5660 "number.c"
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = y;
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = number_is_positive_integer (_tmp2_);
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = !_tmp3_;
#line 5670 "number.c"
	}
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 5674 "number.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_get_error ();
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp5_ = _tmp4_;
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = _ ("Boolean XOR is only defined for positive integers");
#line 1089 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp6_);
#line 5686 "number.c"
	}
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = y;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_bitwise (self, _tmp7_, ___lambda6__bitwise_func, self, 0);
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp8_;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5696 "number.c"
}


static gint __lambda7_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ ^ 0xF;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5709 "number.c"
}


static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5718 "number.c"
}


Number* number_not (Number* self, gint wordlen) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_positive_integer (self);
#line 1098 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp0_) {
#line 5736 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 1101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_get_error ();
#line 1101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 1101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Boolean NOT is only defined for positive integers");
#line 1101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp3_);
#line 5748 "number.c"
	}
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_integer ((gint64) 0);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = wordlen;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = number_bitwise (self, _tmp5_, ___lambda7__bitwise_func, self, _tmp6_);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp5_);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp8_;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 5766 "number.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 5789 "number.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 5797 "number.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 5809 "number.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 5833 "number.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 5839 "number.c"
	} else {
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 5843 "number.c"
	}
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 5847 "number.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 5859 "number.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 5869 "number.c"
	}
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 5875 "number.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 5889 "number.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 5899 "number.c"
	}
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 5905 "number.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 5914 "number.c"
	}
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 5934 "number.c"
}


Number* number_mask (Number* self, Number* x, gint wordlen) {
	Number* result = NULL;
	gchar* text = NULL;
	Number* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint offset = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 1111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = x;
#line 1111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_to_hex_string (_tmp0_);
#line 1111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text = _tmp1_;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = text;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = strlen (_tmp2_);
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	len = _tmp4_;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = wordlen;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset = _tmp5_ / 4;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = len;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = offset;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp7_ > _tmp8_) {
#line 5986 "number.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp9_ = len;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = offset;
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = ((gint) _tmp9_) - _tmp10_;
#line 5995 "number.c"
	} else {
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = 0;
#line 5999 "number.c"
	}
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset = _tmp6_;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = text;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = offset;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = string_substring (_tmp11_, (glong) _tmp12_, (glong) (-1));
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = _tmp13_;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = mp_set_from_string (_tmp14_, 16);
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = _tmp15_;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp14_);
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp16_;
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (text);
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6023 "number.c"
}


Number* number_shift (Number* self, gint count) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp5_ = 0;
#line 1119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_integer (self);
#line 1121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp0_) {
#line 6037 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_get_error ();
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Shift is only possible on integer values");
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp3_);
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6056 "number.c"
	}
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = count;
#line 1128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_ >= 0) {
#line 6062 "number.c"
		gint multiplier = 0;
		gint _tmp11_ = 0;
		Number* _tmp12_ = NULL;
#line 1130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		multiplier = 1;
#line 6068 "number.c"
		{
			gint i = 0;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 6073 "number.c"
			{
				gboolean _tmp6_ = FALSE;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = TRUE;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 6080 "number.c"
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp6_) {
#line 6086 "number.c"
						gint _tmp7_ = 0;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp7_ = i;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp7_ + 1;
#line 6092 "number.c"
					}
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp6_ = FALSE;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = i;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp9_ = count;
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp8_ < _tmp9_)) {
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 6104 "number.c"
					}
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = multiplier;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					multiplier = _tmp10_ * 2;
#line 6110 "number.c"
				}
			}
		}
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = multiplier;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = number_multiply_integer (self, (gint64) _tmp11_);
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp12_;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6122 "number.c"
	} else {
		gint multiplier = 0;
		gint _tmp18_ = 0;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
#line 1137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		multiplier = 1;
#line 6132 "number.c"
		{
			gint i = 0;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 6137 "number.c"
			{
				gboolean _tmp13_ = FALSE;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp13_ = TRUE;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 6144 "number.c"
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp13_) {
#line 6150 "number.c"
						gint _tmp14_ = 0;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp14_ = i;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp14_ + 1;
#line 6156 "number.c"
					}
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = FALSE;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = i;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = count;
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp15_ < (-_tmp16_))) {
#line 1138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 6168 "number.c"
					}
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp17_ = multiplier;
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					multiplier = _tmp17_ * 2;
#line 6174 "number.c"
				}
			}
		}
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = multiplier;
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = number_divide_integer (self, (gint64) _tmp18_);
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = _tmp19_;
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_floor (_tmp20_);
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = _tmp21_;
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp20_);
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp22_;
#line 1140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6194 "number.c"
	}
}


static gint __lambda8_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = v1;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = v2;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_ ^ _tmp1_;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6211 "number.c"
}


static gint ___lambda8__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6220 "number.c"
}


Number* number_ones_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
#line 1145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 0);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = wordlen;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_bitwise (self, _tmp1_, ___lambda8__bitwise_func, self, _tmp2_);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = wordlen;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_not (_tmp4_, _tmp5_);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = _tmp6_;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp4_);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp7_;
#line 1147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6260 "number.c"
}


Number* number_twos_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	gint _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = wordlen;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_ones_complement (self, _tmp0_);
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_new_integer ((gint64) 1);
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_add (_tmp2_, _tmp4_);
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp4_);
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp2_);
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_;
#line 1153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6297 "number.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 6304 "number.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_list_free (self);
#line 6313 "number.c"
}


GList* number_factorize (Number* self) {
	GList* result = NULL;
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	guint64 num = 0ULL;
	guint64 _tmp11_ = 0ULL;
	guint64 _tmp12_ = 0ULL;
	guint64 _tmp13_ = 0ULL;
	Number* int_max = NULL;
	guint64 _tmp14_ = 0ULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	Number* divisor = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp37_ = NULL;
	Number* root = NULL;
	Number* _tmp38_ = NULL;
	Number* _tmp39_ = NULL;
	Number* _tmp60_ = NULL;
	Number* _tmp61_ = NULL;
	Number* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp67_ = FALSE;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	factors = NULL;
#line 1161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_abs (self);
#line 1161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	value = _tmp0_;
#line 1163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = value;
#line 1163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_is_zero (_tmp1_);
#line 1163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_) {
#line 6365 "number.c"
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = value;
#line 1165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp4_);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = factors;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (value);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6380 "number.c"
	}
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = value;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_new_integer ((gint64) 1);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = _tmp6_;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = number_equals (_tmp5_, _tmp7_);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = _tmp8_;
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp7_);
#line 1169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_) {
#line 6396 "number.c"
		Number* _tmp10_ = NULL;
#line 1171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = _g_object_ref0 (self);
#line 1171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp10_);
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = factors;
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (value);
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6408 "number.c"
	}
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	num = (guint64) 1;
#line 1178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = num;
#line 1178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	num = _tmp11_ << 63;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = num;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = num;
#line 1179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	num = _tmp12_ + (_tmp13_ - 1);
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = num;
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = number_new_unsigned_integer (_tmp14_);
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	int_max = _tmp15_;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = value;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = int_max;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = number_compare (_tmp16_, _tmp17_);
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp18_ <= 0) {
#line 6436 "number.c"
		GList* factors_int64 = NULL;
		Number* _tmp19_ = NULL;
		guint64 _tmp20_ = 0ULL;
		GList* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = value;
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_to_unsigned_integer (_tmp19_);
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = number_factorize_uint64 (self, _tmp20_);
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors_int64 = _tmp21_;
#line 1185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = number_is_negative (self);
#line 1185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp22_) {
#line 6454 "number.c"
			GList* _tmp23_ = NULL;
			GList* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			Number* _tmp26_ = NULL;
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_ = factors_int64;
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp24_ = factors_int64;
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp25_ = _tmp24_->data;
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp26_ = number_invert_sign ((Number*) _tmp25_);
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp23_->data);
#line 1186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp23_->data = _tmp26_;
#line 6471 "number.c"
		}
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = factors_int64;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (int_max);
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (value);
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		__g_list_free__g_object_unref0_0 (factors);
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 6483 "number.c"
	}
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = number_new_integer ((gint64) 2);
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	divisor = _tmp27_;
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 6491 "number.c"
		Number* tmp = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = value;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = divisor;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = number_divide (_tmp28_, _tmp29_);
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp30_;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = tmp;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp32_ = number_is_integer (_tmp31_);
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp32_) {
#line 6512 "number.c"
			Number* _tmp33_ = NULL;
			Number* _tmp34_ = NULL;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp33_ = tmp;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp34_ = _g_object_ref0 (_tmp33_);
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (value);
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			value = _tmp34_;
#line 1197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp35_ = divisor;
#line 1197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 1197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			factors = g_list_append (factors, _tmp36_);
#line 6531 "number.c"
		} else {
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (tmp);
#line 1200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 6537 "number.c"
		}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp);
#line 6541 "number.c"
	}
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = number_new_integer ((gint64) 3);
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (divisor);
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	divisor = _tmp37_;
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_ = value;
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp39_ = number_sqrt (_tmp38_);
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	root = _tmp39_;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 6557 "number.c"
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		Number* tmp = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = divisor;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = root;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = number_compare (_tmp40_, _tmp41_);
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!(_tmp42_ <= 0)) {
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 6577 "number.c"
		}
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = value;
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp44_ = divisor;
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp45_ = number_divide (_tmp43_, _tmp44_);
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		tmp = _tmp45_;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = tmp;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = number_is_integer (_tmp46_);
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp47_) {
#line 6593 "number.c"
			Number* _tmp48_ = NULL;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
#line 1210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp48_ = tmp;
#line 1210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp49_ = _g_object_ref0 (_tmp48_);
#line 1210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (value);
#line 1210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			value = _tmp49_;
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp50_ = value;
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp51_ = number_sqrt (_tmp50_);
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (root);
#line 1211 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			root = _tmp51_;
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp52_ = divisor;
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			factors = g_list_append (factors, _tmp53_);
#line 6622 "number.c"
		} else {
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
			Number* _tmp58_ = NULL;
			Number* _tmp59_ = NULL;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp54_ = divisor;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp55_ = number_new_integer ((gint64) 2);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp56_ = _tmp55_;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp57_ = number_add (_tmp54_, _tmp56_);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (tmp);
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			tmp = _tmp57_;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp56_);
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp58_ = tmp;
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp59_ = _g_object_ref0 (_tmp58_);
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (divisor);
#line 1217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			divisor = _tmp59_;
#line 6652 "number.c"
		}
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (tmp);
#line 6656 "number.c"
	}
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp60_ = value;
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp61_ = number_new_integer ((gint64) 1);
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp62_ = _tmp61_;
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp63_ = number_compare (_tmp60_, _tmp62_);
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp64_ = _tmp63_ > 0;
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp62_);
#line 1221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp64_) {
#line 6672 "number.c"
		Number* _tmp65_ = NULL;
		Number* _tmp66_ = NULL;
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp65_ = value;
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp66_ = _g_object_ref0 (_tmp65_);
#line 1222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp66_);
#line 6681 "number.c"
	}
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp67_ = number_is_negative (self);
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp67_) {
#line 6687 "number.c"
		GList* _tmp68_ = NULL;
		GList* _tmp69_ = NULL;
		gconstpointer _tmp70_ = NULL;
		Number* _tmp71_ = NULL;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp68_ = factors;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp69_ = factors;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp70_ = _tmp69_->data;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp71_ = number_invert_sign ((Number*) _tmp70_);
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp68_->data);
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp68_->data = _tmp71_;
#line 6704 "number.c"
	}
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = factors;
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (root);
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (divisor);
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (int_max);
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (value);
#line 1227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6718 "number.c"
}


GList* number_factorize_uint64 (Number* self, guint64 n) {
	GList* result = NULL;
	GList* factors = NULL;
	guint64 _tmp14_ = 0ULL;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	factors = NULL;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 6732 "number.c"
		guint64 _tmp0_ = 0ULL;
		guint64 _tmp1_ = 0ULL;
		Number* _tmp2_ = NULL;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = n;
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!((_tmp0_ % 2) == ((guint64) 0))) {
#line 1233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 6742 "number.c"
		}
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = n;
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		n = _tmp1_ / 2;
#line 1236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = number_new_unsigned_integer ((guint64) 2);
#line 1236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp2_);
#line 6752 "number.c"
	}
	{
		guint64 divisor = 0ULL;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		divisor = (guint64) 3;
#line 6758 "number.c"
		{
			gboolean _tmp3_ = FALSE;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = TRUE;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			while (TRUE) {
#line 6765 "number.c"
				guint64 _tmp5_ = 0ULL;
				guint64 _tmp6_ = 0ULL;
				guint64 _tmp7_ = 0ULL;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!_tmp3_) {
#line 6771 "number.c"
					guint64 _tmp4_ = 0ULL;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp4_ = divisor;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					divisor = _tmp4_ + 2;
#line 6777 "number.c"
				}
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp3_ = FALSE;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp5_ = divisor;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp6_ = n;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp7_ = divisor;
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				if (!(_tmp5_ <= (_tmp6_ / _tmp7_))) {
#line 1239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					break;
#line 6791 "number.c"
				}
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 6795 "number.c"
					guint64 _tmp8_ = 0ULL;
					guint64 _tmp9_ = 0ULL;
					guint64 _tmp10_ = 0ULL;
					guint64 _tmp11_ = 0ULL;
					guint64 _tmp12_ = 0ULL;
					Number* _tmp13_ = NULL;
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp8_ = n;
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp9_ = divisor;
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!((_tmp8_ % _tmp9_) == ((guint64) 0))) {
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 6810 "number.c"
					}
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp10_ = n;
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = divisor;
#line 1243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					n = _tmp10_ / _tmp11_;
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp12_ = divisor;
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = number_new_unsigned_integer (_tmp12_);
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					factors = g_list_append (factors, _tmp13_);
#line 6824 "number.c"
				}
			}
		}
	}
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = n;
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp14_ > ((guint64) 1)) {
#line 6833 "number.c"
		guint64 _tmp15_ = 0ULL;
		Number* _tmp16_ = NULL;
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp15_ = n;
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = number_new_unsigned_integer (_tmp15_);
#line 1249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		factors = g_list_append (factors, _tmp16_);
#line 6842 "number.c"
	}
#line 1250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = factors;
#line 1250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6848 "number.c"
}


static Number* number_copy (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp1_ = 0UL;
	gulong _tmp2_ = 0UL;
	__mpfr_struct tmp2 = {0};
	gulong _tmp3_ = 0UL;
	gulong _tmp4_ = 0UL;
	__mpfr_struct _tmp5_ = {0};
	__mpfr_struct _tmp6_ = {0};
	__mpfr_struct _tmp7_ = {0};
	__mpfr_struct _tmp8_ = {0};
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new ();
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_get_precision ();
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = _tmp1_;
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp2_);
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_get_precision ();
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp2, (mpfr_prec_t) _tmp4_);
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = self->priv->_re_num;
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set (&tmp, &_tmp5_, MPFR_RNDN);
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = self->priv->_im_num;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set (&tmp2, &_tmp6_, MPFR_RNDN);
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = tmp;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (z, &_tmp7_);
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = tmp2;
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_im_num (z, &_tmp8_);
#line 1262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6904 "number.c"
}


static Number* number_epowy_real (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	__mpfr_struct _tmp3_ = {0};
#line 1265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp = _tmp1_;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_exp (&tmp, &_tmp2_, MPFR_RNDN);
#line 1270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 1270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (z, &_tmp3_);
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6938 "number.c"
}


static Number* number_root_real (Number* self, gint64 n) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp1_ = {0};
	__mpfr_struct _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	__mpfr_struct _tmp4_ = {0};
#line 1274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_copy (self);
#line 1276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp0_;
#line 1277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = z->priv->_re_num;
#line 1277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp = _tmp1_;
#line 1278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = n;
#line 1278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_root (&tmp, &_tmp2_, (gulong) _tmp3_, MPFR_RNDN);
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = tmp;
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (z, &_tmp4_);
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 6975 "number.c"
}


static Number* number_ln_real (Number* self) {
	Number* result = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
	__mpfr_struct _tmp2_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp3_ = {0};
	Number* _tmp4_ = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_get_precision ();
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp1_);
#line 1286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = self->priv->_re_num;
#line 1286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_log (&tmp, &_tmp2_, MPFR_RNDN);
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = tmp;
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = number_new_mpfloat (&_tmp3_);
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp4_;
#line 1288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7010 "number.c"
}


static Number* number_reciprocal_real (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	__mpfr_struct tmp = {0};
	gulong _tmp5_ = 0UL;
	gulong _tmp6_ = 0UL;
	__mpfr_struct _tmp7_ = {0};
	__mpfr_struct _tmp8_ = {0};
	Number* z = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	__mpfr_struct _tmp11_ = {0};
	Number* _tmp12_ = NULL;
	__mpfr_struct _tmp13_ = {0};
#line 1291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_is_zero (self);
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 7034 "number.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp1_ = number_get_error ();
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = _tmp1_;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = _ ("Reciprocal of zero is undefined");
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error (_tmp3_);
#line 1297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 1297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp4_;
#line 1297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7053 "number.c"
	}
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_get_precision ();
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp6_);
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_set_ui (&tmp, (gulong) 1, MPFR_RNDN);
#line 1302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = tmp;
#line 1302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = self->priv->_re_num;
#line 1302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_div (&tmp, &_tmp7_, &_tmp8_, MPFR_RNDN);
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = number_copy (self);
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp9_;
#line 1304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = z;
#line 1304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = _tmp10_->priv->_re_num;
#line 1304 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&_tmp11_);
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp12_ = z;
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = tmp;
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (_tmp12_, &_tmp13_);
#line 1306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7089 "number.c"
}


static Number* number_from_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
#line 1310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	switch (_tmp0_) {
#line 7102 "number.c"
		default:
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_RADIANS:
#line 7106 "number.c"
		{
			Number* _tmp1_ = NULL;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _g_object_ref0 (self);
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp1_;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 7115 "number.c"
		}
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_DEGREES:
#line 7119 "number.c"
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp2_ = number_multiply_integer (self, (gint64) 180);
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = _tmp2_;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_new_pi ();
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = _tmp4_;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = number_divide (_tmp3_, _tmp5_);
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = _tmp6_;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp5_);
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp3_);
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp7_;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 7147 "number.c"
		}
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_GRADIANS:
#line 7151 "number.c"
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = number_multiply_integer (self, (gint64) 200);
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = _tmp8_;
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = number_new_pi ();
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp10_;
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = number_divide (_tmp9_, _tmp11_);
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = _tmp12_;
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp11_);
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp9_);
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp13_;
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 7179 "number.c"
		}
	}
}


static Number* number_to_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	switch (_tmp0_) {
#line 7194 "number.c"
		default:
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_RADIANS:
#line 7198 "number.c"
		{
			Number* _tmp1_ = NULL;
#line 1333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp1_ = _g_object_ref0 (self);
#line 1333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp1_;
#line 1333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 7207 "number.c"
		}
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_DEGREES:
#line 7211 "number.c"
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp2_ = number_new_pi ();
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp3_ = _tmp2_;
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp4_ = number_multiply (self, _tmp3_);
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp5_ = _tmp4_;
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp6_ = number_divide_integer (_tmp5_, (gint64) 180);
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp7_ = _tmp6_;
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp5_);
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp3_);
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp7_;
#line 1336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 7239 "number.c"
		}
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		case ANGLE_UNIT_GRADIANS:
#line 7243 "number.c"
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp8_ = number_new_pi ();
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp9_ = _tmp8_;
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp10_ = number_multiply (self, _tmp9_);
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp10_;
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp12_ = number_divide_integer (_tmp11_, (gint64) 200);
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp13_ = _tmp12_;
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp11_);
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp9_);
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = _tmp13_;
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 7271 "number.c"
		}
	}
}


static Number* number_sin_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* z = NULL;
	Number* _tmp2_ = NULL;
	__mpfr_struct tmp = {0};
	__mpfr_struct _tmp3_ = {0};
	__mpfr_struct _tmp4_ = {0};
	__mpfr_struct _tmp5_ = {0};
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_to_radians (self, _tmp0_);
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_radians = _tmp1_;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_new_integer ((gint64) 0);
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp2_;
#line 1347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = z->priv->_re_num;
#line 1347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	tmp = _tmp3_;
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = x_radians->priv->_re_num;
#line 1348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_sin (&tmp, &_tmp4_, MPFR_RNDN);
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp;
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_set_re_num (z, &_tmp5_);
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_radians);
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7318 "number.c"
}


static Number* number_cos_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* x_radians = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	__mpfr_struct tmp = {0};
	gulong _tmp2_ = 0UL;
	gulong _tmp3_ = 0UL;
	__mpfr_struct _tmp4_ = {0};
	Number* z = NULL;
	__mpfr_struct _tmp5_ = {0};
	Number* _tmp6_ = NULL;
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = unit;
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = number_to_radians (self, _tmp0_);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	x_radians = _tmp1_;
#line 1356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_get_precision ();
#line 1356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = _tmp2_;
#line 1356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_init2 (&tmp, (mpfr_prec_t) _tmp3_);
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = x_radians->priv->_re_num;
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_cos (&tmp, &_tmp4_, MPFR_RNDN);
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = tmp;
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_new_mpfloat (&_tmp5_);
#line 1358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp6_;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (x_radians);
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7364 "number.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 7382 "number.c"
}


static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen) {
	Number* result = NULL;
	gchar* text1 = NULL;
	gchar* _tmp0_ = NULL;
	gchar* text2 = NULL;
	Number* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint offset1 = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint offset2 = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint offset_out = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gchar* text_out = NULL;
	gint _tmp26_ = 0;
	gchar* _tmp27_ = NULL;
	gint text_out_length1 = 0;
	gint _text_out_size_ = 0;
	gchar* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	Number* _tmp55_ = NULL;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (y != NULL, NULL);
#line 1364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_to_hex_string (self);
#line 1364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text1 = _tmp0_;
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = y;
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = number_to_hex_string (_tmp1_);
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text2 = _tmp2_;
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = text1;
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = strlen (_tmp3_);
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = _tmp4_;
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset1 = _tmp5_ - 1;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = text2;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = strlen (_tmp6_);
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset2 = _tmp8_ - 1;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = wordlen;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	offset_out = (_tmp9_ / 4) - 1;
#line 1369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = offset_out;
#line 1369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp10_ <= 0) {
#line 7452 "number.c"
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp12_ = offset1;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp13_ = offset2;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp12_ > _tmp13_) {
#line 7462 "number.c"
			gint _tmp14_ = 0;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp14_ = offset1;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp14_;
#line 7468 "number.c"
		} else {
			gint _tmp15_ = 0;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp15_ = offset2;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp11_ = _tmp15_;
#line 7475 "number.c"
		}
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		offset_out = _tmp11_;
#line 7479 "number.c"
	}
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = offset_out;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp17_ > 0) {
#line 7485 "number.c"
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = offset_out;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = offset1;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp19_ < _tmp20_) {
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = TRUE;
#line 7497 "number.c"
		} else {
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp21_ = offset_out;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp22_ = offset2;
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp18_ = _tmp21_ < _tmp22_;
#line 7507 "number.c"
		}
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = _tmp18_;
#line 7511 "number.c"
	} else {
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp16_ = FALSE;
#line 7515 "number.c"
	}
#line 1371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp16_) {
#line 7519 "number.c"
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = number_get_error ();
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp24_ = _tmp23_;
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_set_error ("Overflow. Try a bigger word size");
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = number_new_integer ((gint64) 0);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp25_;
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_free0 (text2);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_free0 (text1);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7539 "number.c"
	}
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = offset_out;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = g_new0 (gchar, _tmp26_ + 1);
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text_out = _tmp27_;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text_out_length1 = _tmp26_ + 1;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_text_out_size_ = text_out_length1;
#line 7551 "number.c"
	{
		gchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gchar _tmp30_ = '\0';
		gboolean _tmp31_ = FALSE;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_ = text_out;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28__length1 = text_out_length1;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp29_ = offset_out;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp28_[_tmp29_ + 1] = '\0';
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = _tmp28_[_tmp29_ + 1];
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp31_ = TRUE;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 7572 "number.c"
			gint _tmp33_ = 0;
			gint v1 = 0;
			gint v2 = 0;
#line 1383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
#line 7578 "number.c"
			gint _tmp34_ = 0;
			gint _tmp40_ = 0;
			gchar* _tmp46_ = NULL;
			gint _tmp46__length1 = 0;
			gint _tmp47_ = 0;
			BitwiseFunc _tmp48_ = NULL;
			void* _tmp48__target = NULL;
			gint _tmp49_ = 0;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			gchar _tmp52_ = '\0';
			gchar _tmp53_ = '\0';
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp31_) {
#line 7593 "number.c"
				gint _tmp32_ = 0;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp32_ = offset_out;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				offset_out = _tmp32_ - 1;
#line 7599 "number.c"
			}
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp31_ = FALSE;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp33_ = offset_out;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!(_tmp33_ >= 0)) {
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 7609 "number.c"
			}
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			v1 = 0;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			v2 = 0;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp34_ = offset1;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp34_ >= 0) {
#line 7619 "number.c"
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp35_ = text1;
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp36_ = offset1;
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp38_ = number_hex_to_int (self, _tmp37_);
#line 1387 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				v1 = _tmp38_;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp39_ = offset1;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				offset1 = _tmp39_ - 1;
#line 7639 "number.c"
			}
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp40_ = offset2;
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp40_ >= 0) {
#line 7645 "number.c"
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gchar _tmp43_ = '\0';
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp41_ = text2;
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp42_ = offset2;
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp43_ = string_get (_tmp41_, (glong) _tmp42_);
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp44_ = number_hex_to_int (self, _tmp43_);
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				v2 = _tmp44_;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp45_ = offset2;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				offset2 = _tmp45_ - 1;
#line 7665 "number.c"
			}
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp46_ = text_out;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp46__length1 = text_out_length1;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp47_ = offset_out;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp48_ = bitwise_operator;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp48__target = bitwise_operator_target;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp49_ = v1;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp50_ = v2;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp51_ = _tmp48_ (_tmp49_, _tmp50_, _tmp48__target);
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp52_ = digits[_tmp51_];
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp46_[_tmp47_] = _tmp52_;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp53_ = _tmp46_[_tmp47_];
#line 7689 "number.c"
		}
	}
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = text_out;
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54__length1 = text_out_length1;
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp55_ = mp_set_from_string ((const gchar*) _tmp54_, 16);
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp55_;
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	text_out = (g_free (text_out), NULL);
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (text2);
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (text1);
#line 1398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7708 "number.c"
}


static gint number_hex_to_int (Number* self, gchar digit) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	gboolean _tmp4_ = FALSE;
	gchar _tmp5_ = '\0';
	gboolean _tmp8_ = FALSE;
	gchar _tmp9_ = '\0';
#line 1401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = digit;
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ >= '0') {
#line 7726 "number.c"
		gchar _tmp2_ = '\0';
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = digit;
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = _tmp2_ <= '9';
#line 7732 "number.c"
	} else {
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp0_ = FALSE;
#line 7736 "number.c"
	}
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp0_) {
#line 7740 "number.c"
		gchar _tmp3_ = '\0';
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = digit;
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (gint) (_tmp3_ - '0');
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7748 "number.c"
	}
#line 1405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = digit;
#line 1405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp5_ >= 'A') {
#line 7754 "number.c"
		gchar _tmp6_ = '\0';
#line 1405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = digit;
#line 1405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = _tmp6_ <= 'F';
#line 7760 "number.c"
	} else {
#line 1405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = FALSE;
#line 7764 "number.c"
	}
#line 1405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_) {
#line 7768 "number.c"
		gchar _tmp7_ = '\0';
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp7_ = digit;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (_tmp7_ - 'A') + 10;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7776 "number.c"
	}
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = digit;
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_ >= 'a') {
#line 7782 "number.c"
		gchar _tmp10_ = '\0';
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = digit;
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = _tmp10_ <= 'f';
#line 7788 "number.c"
	} else {
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = FALSE;
#line 7792 "number.c"
	}
#line 1407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp8_) {
#line 7796 "number.c"
		gchar _tmp11_ = '\0';
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp11_ = digit;
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = (_tmp11_ - 'a') + 10;
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 7804 "number.c"
	}
#line 1409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = 0;
#line 1409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7810 "number.c"
}


static gchar* number_to_hex_string (Number* self) {
	gchar* result = NULL;
	Serializer* serializer = NULL;
	Serializer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
#line 1414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	serializer = _tmp0_;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = serializer_to_string (serializer, self);
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp1_;
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (serializer);
#line 1415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7833 "number.c"
}


Number* number_construct (GType object_type) {
	Number * self = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = (Number*) g_object_new (object_type, NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return self;
#line 7843 "number.c"
}


Number* number_new (void) {
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return number_construct (TYPE_NUMBER);
#line 7850 "number.c"
}


static void number_get_re_num (Number* self, __mpfr_struct* result) {
	__mpfr_struct _tmp0_ = {0};
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	*result = _tmp0_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return;
#line 7864 "number.c"
}


static void number_set_re_num (Number* self, __mpfr_struct* value) {
	__mpfr_struct _tmp0_ = {0};
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = *value;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->priv->_re_num = _tmp0_;
#line 7876 "number.c"
}


static void number_get_im_num (Number* self, __mpfr_struct* result) {
	__mpfr_struct _tmp0_ = {0};
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_im_num;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	*result = _tmp0_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return;
#line 7890 "number.c"
}


static void number_set_im_num (Number* self, __mpfr_struct* value) {
	__mpfr_struct _tmp0_ = {0};
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = *value;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->priv->_im_num = _tmp0_;
#line 7902 "number.c"
}


gulong number_get_precision (void) {
	gulong result;
	gulong _tmp0_ = 0UL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number__precision;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7915 "number.c"
}


void number_set_precision (gulong value) {
	gulong _tmp0_ = 0UL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = value;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number__precision = _tmp0_;
#line 7925 "number.c"
}


const gchar* number_get_error (void) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number__error;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp0_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 7938 "number.c"
}


void number_set_error (const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = value;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (number__error);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number__error = _tmp1_;
#line 7953 "number.c"
}


static void number_class_init (NumberClass * klass) {
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_type_class_add_private (klass, sizeof (NumberPrivate));
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_number_get_property;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_number_set_property;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
#line 7968 "number.c"
}


static void number_instance_init (Number * self) {
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self->priv = NUMBER_GET_PRIVATE (self);
#line 7975 "number.c"
}


static void number_finalize (GObject* obj) {
	Number * self;
	__mpfr_struct _tmp0_ = {0};
	__mpfr_struct _tmp1_ = {0};
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = self->priv->_re_num;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&_tmp0_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = self->priv->_im_num;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	mpfr_clear (&_tmp1_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
#line 7995 "number.c"
}


GType number_get_type (void) {
	static volatile gsize number_type_id__volatile = 0;
	if (g_once_init_enter (&number_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
		GType number_type_id;
		number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
		g_once_init_leave (&number_type_id__volatile, number_type_id);
	}
	return number_type_id__volatile;
}


static void _vala_number_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	switch (property_id) {
#line 8016 "number.c"
		default:
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		break;
#line 8022 "number.c"
	}
}


static void _vala_number_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	switch (property_id) {
#line 8032 "number.c"
		default:
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		break;
#line 8038 "number.c"
	}
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 8064 "number.c"
		gchar* _tmp4_ = NULL;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 8072 "number.c"
	} else {
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 8078 "number.c"
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 8101 "number.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8116 "number.c"
		}
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 8120 "number.c"
	} else {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8128 "number.c"
		}
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 8132 "number.c"
	}
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (c) {
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 8138 "number.c"
	}
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1055 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1055 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (0 < _tmp0_) {
#line 8153 "number.c"
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = *index;
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp2_ - ((gchar*) self));
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_vala_c = _tmp4_;
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8176 "number.c"
		}
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 8180 "number.c"
	} else {
#line 1060 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (c) {
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 8190 "number.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 8194 "number.c"
	}
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (c) {
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 8200 "number.c"
	}
}


Number* mp_set_from_string (const gchar* str, gint default_base) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 1430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gunichar base_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
#line 8211 "number.c"
	gint index = 0;
	gunichar c = 0U;
	gint end = 0;
	gint _tmp7_ = 0;
	gint number_base = 0;
	gint base_multiplier = 0;
	gint _tmp24_ = 0;
	gboolean negate = FALSE;
	const gchar* _tmp26_ = NULL;
	gunichar _tmp27_ = 0U;
	gunichar _tmp28_ = 0U;
	Number* z = NULL;
	Number* _tmp34_ = NULL;
#line 1487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gunichar fractions[] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
#line 1488 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gint numerators[] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
#line 1489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	static const gint denominators[] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
#line 8231 "number.c"
	gboolean has_fraction = FALSE;
	const gchar* _tmp54_ = NULL;
	gunichar _tmp55_ = 0U;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gboolean _tmp108_ = FALSE;
#line 1424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = str;
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp1_ >= 0) {
#line 8248 "number.c"
		const gchar* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
#line 1427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp2_ = str;
#line 1427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp3_ = set_from_sexagesimal (_tmp2_);
#line 1427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = _tmp3_;
#line 1427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8259 "number.c"
	}
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	index = 0;
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 8265 "number.c"
		const gchar* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp4_ = str;
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp5_;
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp6_) {
#line 1433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 8279 "number.c"
		}
	}
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = index;
#line 1434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	end = _tmp7_;
#line 1435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	number_base = 0;
#line 1436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	base_multiplier = 1;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 8292 "number.c"
		const gchar* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gint value = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp8_ = str;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp10_ = string_get_prev_char (_tmp8_, &index, &_tmp9_);
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp9_;
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp10_) {
#line 1437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 8313 "number.c"
		}
#line 1439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		value = -1;
#line 8317 "number.c"
		{
			gint i = 0;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 8322 "number.c"
			{
				gboolean _tmp11_ = FALSE;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp11_ = TRUE;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 8329 "number.c"
					gint _tmp13_ = 0;
					gunichar _tmp14_ = 0U;
					gint _tmp15_ = 0;
					gunichar _tmp16_ = 0U;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp11_) {
#line 8336 "number.c"
						gint _tmp12_ = 0;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp12_ = i;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp12_ + 1;
#line 8342 "number.c"
					}
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp11_ = FALSE;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp13_ = i;
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp13_ < G_N_ELEMENTS (base_digits))) {
#line 1440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 8352 "number.c"
					}
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp14_ = c;
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp15_ = i;
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp16_ = base_digits[_tmp15_];
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp14_ == _tmp16_) {
#line 8362 "number.c"
						gint _tmp17_ = 0;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp17_ = i;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						value = _tmp17_;
#line 1445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 8370 "number.c"
					}
				}
			}
		}
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp18_ = value;
#line 1448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp18_ < 0) {
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 8381 "number.c"
		}
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp19_ = index;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		end = _tmp19_;
#line 1452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp20_ = number_base;
#line 1452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp21_ = value;
#line 1452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp22_ = base_multiplier;
#line 1452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_base = _tmp20_ + (_tmp21_ * _tmp22_);
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp23_ = base_multiplier;
#line 1453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		base_multiplier = _tmp23_ * 10;
#line 8399 "number.c"
	}
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = base_multiplier;
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp24_ == 1) {
#line 8405 "number.c"
		gint _tmp25_ = 0;
#line 1456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp25_ = default_base;
#line 1456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		number_base = _tmp25_;
#line 8411 "number.c"
	}
#line 1459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	negate = FALSE;
#line 1460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	index = 0;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = str;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp26_, &index, &_tmp27_);
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp27_;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = c;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp28_ == ((gunichar) '+')) {
#line 1463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		negate = FALSE;
#line 8429 "number.c"
	} else {
		gboolean _tmp29_ = FALSE;
		gunichar _tmp30_ = 0U;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp30_ = c;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp30_ == ((gunichar) '-')) {
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp29_ = TRUE;
#line 8439 "number.c"
		} else {
			gunichar _tmp31_ = 0U;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp31_ = c;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp29_ = _tmp31_ == 8722U;
#line 8446 "number.c"
		}
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp29_) {
#line 1465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			negate = TRUE;
#line 8452 "number.c"
		} else {
			const gchar* _tmp32_ = NULL;
			gunichar _tmp33_ = 0U;
#line 1467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp32_ = str;
#line 1467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			string_get_prev_char (_tmp32_, &index, &_tmp33_);
#line 1467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp33_;
#line 8462 "number.c"
		}
	}
#line 1470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = number_new_integer ((gint64) 0);
#line 1470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	z = _tmp34_;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	while (TRUE) {
#line 8471 "number.c"
		const gchar* _tmp35_ = NULL;
		gunichar _tmp36_ = 0U;
		gboolean _tmp37_ = FALSE;
		gint i = 0;
		gunichar _tmp38_ = 0U;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Number* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		Number* _tmp51_ = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp35_ = str;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp37_ = string_get_next_char (_tmp35_, &index, &_tmp36_);
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		c = _tmp36_;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (!_tmp37_) {
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 8500 "number.c"
		}
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp38_ = c;
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp39_ = number_base;
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp40_ = char_val (_tmp38_, _tmp39_);
#line 1474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		i = _tmp40_;
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp41_ = i;
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp42_ = number_base;
#line 1475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp41_ > _tmp42_) {
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			result = NULL;
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (z);
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			return result;
#line 8522 "number.c"
		}
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp43_ = i;
#line 1477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp43_ < 0) {
#line 8528 "number.c"
			const gchar* _tmp44_ = NULL;
			gunichar _tmp45_ = 0U;
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp44_ = str;
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			string_get_prev_char (_tmp44_, &index, &_tmp45_);
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp45_;
#line 1480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			break;
#line 8539 "number.c"
		}
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp46_ = z;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp47_ = number_base;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp48_ = number_multiply_integer (_tmp46_, (gint64) _tmp47_);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp49_ = _tmp48_;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp50_ = i;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp51_ = number_new_integer ((gint64) _tmp50_);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp52_ = _tmp51_;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp53_ = number_add (_tmp49_, _tmp52_);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp53_;
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp52_);
#line 1483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (_tmp49_);
#line 8565 "number.c"
	}
#line 1490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	has_fraction = FALSE;
#line 1491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = str;
#line 1491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp56_ = string_get_next_char (_tmp54_, &index, &_tmp55_);
#line 1491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp55_;
#line 1491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp56_) {
#line 8577 "number.c"
		gunichar _tmp74_ = 0U;
		{
			gint i = 0;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = 0;
#line 8583 "number.c"
			{
				gboolean _tmp57_ = FALSE;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp57_ = TRUE;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				while (TRUE) {
#line 8590 "number.c"
					gint _tmp59_ = 0;
					gunichar _tmp60_ = 0U;
					gint _tmp61_ = 0;
					gunichar _tmp62_ = 0U;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!_tmp57_) {
#line 8597 "number.c"
						gint _tmp58_ = 0;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp58_ = i;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						i = _tmp58_ + 1;
#line 8603 "number.c"
					}
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp57_ = FALSE;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp59_ = i;
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (!(_tmp59_ < G_N_ELEMENTS (fractions))) {
#line 1493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						break;
#line 8613 "number.c"
					}
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp60_ = c;
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp61_ = i;
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					_tmp62_ = fractions[_tmp61_];
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
					if (_tmp60_ == _tmp62_) {
#line 8623 "number.c"
						Number* fraction = NULL;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
						Number* _tmp67_ = NULL;
						Number* _tmp68_ = NULL;
						Number* _tmp69_ = NULL;
						Number* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gunichar _tmp72_ = 0U;
						gboolean _tmp73_ = FALSE;
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp63_ = i;
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp64_ = numerators[_tmp63_];
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp65_ = i;
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp66_ = denominators[_tmp65_];
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp67_ = number_new_fraction ((gint64) _tmp64_, (gint64) _tmp66_);
#line 1497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						fraction = _tmp67_;
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp68_ = z;
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp69_ = fraction;
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp70_ = number_add (_tmp68_, _tmp69_);
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (z);
#line 1498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						z = _tmp70_;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp71_ = str;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_tmp73_ = string_get_next_char (_tmp71_, &index, &_tmp72_);
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						c = _tmp72_;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						if (!_tmp73_) {
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							result = z;
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (fraction);
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							return result;
#line 8672 "number.c"
						} else {
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							result = NULL;
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (fraction);
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							_g_object_unref0 (z);
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
							return result;
#line 8682 "number.c"
						}
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
						_g_object_unref0 (fraction);
#line 8686 "number.c"
					}
				}
			}
		}
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp74_ = c;
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		if (_tmp74_ == ((gunichar) '.')) {
#line 1510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			has_fraction = TRUE;
#line 8697 "number.c"
		} else {
			const gchar* _tmp75_ = NULL;
			gunichar _tmp76_ = 0U;
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp75_ = str;
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			string_get_prev_char (_tmp75_, &index, &_tmp76_);
#line 1512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp76_;
#line 8707 "number.c"
		}
	}
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp77_ = has_fraction;
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp77_) {
#line 8714 "number.c"
		Number* numerator = NULL;
		Number* _tmp78_ = NULL;
		Number* denominator = NULL;
		Number* _tmp79_ = NULL;
		Number* _tmp100_ = NULL;
		Number* _tmp101_ = NULL;
		Number* _tmp102_ = NULL;
		Number* _tmp103_ = NULL;
		Number* _tmp104_ = NULL;
		Number* _tmp105_ = NULL;
#line 1518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp78_ = number_new_integer ((gint64) 0);
#line 1518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		numerator = _tmp78_;
#line 1519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp79_ = number_new_integer ((gint64) 1);
#line 1519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		denominator = _tmp79_;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		while (TRUE) {
#line 8735 "number.c"
			const gchar* _tmp80_ = NULL;
			gunichar _tmp81_ = 0U;
			gboolean _tmp82_ = FALSE;
			gint i = 0;
			gunichar _tmp83_ = 0U;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			Number* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			Number* _tmp91_ = NULL;
			Number* _tmp92_ = NULL;
			gint _tmp93_ = 0;
			Number* _tmp94_ = NULL;
			Number* _tmp95_ = NULL;
			gint _tmp96_ = 0;
			Number* _tmp97_ = NULL;
			Number* _tmp98_ = NULL;
			Number* _tmp99_ = NULL;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp80_ = str;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp82_ = string_get_next_char (_tmp80_, &index, &_tmp81_);
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			c = _tmp81_;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (!_tmp82_) {
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 8765 "number.c"
			}
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp83_ = c;
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp84_ = number_base;
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp85_ = char_val (_tmp83_, _tmp84_);
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			i = _tmp85_;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp86_ = i;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			if (_tmp86_ < 0) {
#line 8779 "number.c"
				const gchar* _tmp87_ = NULL;
				gunichar _tmp88_ = 0U;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				_tmp87_ = str;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				string_get_prev_char (_tmp87_, &index, &_tmp88_);
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				c = _tmp88_;
#line 1527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
				break;
#line 8790 "number.c"
			}
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp89_ = denominator;
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp90_ = number_base;
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp91_ = number_multiply_integer (_tmp89_, (gint64) _tmp90_);
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (denominator);
#line 1530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			denominator = _tmp91_;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp92_ = numerator;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp93_ = number_base;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp94_ = number_multiply_integer (_tmp92_, (gint64) _tmp93_);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (numerator);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			numerator = _tmp94_;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp95_ = numerator;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp96_ = i;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp97_ = number_new_integer ((gint64) _tmp96_);
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp98_ = _tmp97_;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_tmp99_ = number_add (_tmp95_, _tmp98_);
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (numerator);
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			numerator = _tmp99_;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
			_g_object_unref0 (_tmp98_);
#line 8828 "number.c"
		}
#line 1535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp100_ = numerator;
#line 1535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp101_ = denominator;
#line 1535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp102_ = number_divide (_tmp100_, _tmp101_);
#line 1535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (numerator);
#line 1535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		numerator = _tmp102_;
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp103_ = z;
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp104_ = numerator;
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp105_ = number_add (_tmp103_, _tmp104_);
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp105_;
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (denominator);
#line 1516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (numerator);
#line 8854 "number.c"
	}
#line 1539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp106_ = index;
#line 1539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp107_ = end;
#line 1539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp106_ != _tmp107_) {
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8868 "number.c"
	}
#line 1542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp108_ = negate;
#line 1542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp108_) {
#line 8874 "number.c"
		Number* _tmp109_ = NULL;
		Number* _tmp110_ = NULL;
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp109_ = z;
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_tmp110_ = number_invert_sign (_tmp109_);
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (z);
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		z = _tmp110_;
#line 8885 "number.c"
	}
#line 1545 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = z;
#line 1545 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8891 "number.c"
}


gint char_val (gunichar c, gint number_base) {
	gint result = 0;
	gunichar _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gint value = 0;
	gunichar _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = c;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = g_unichar_isxdigit (_tmp0_);
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (!_tmp1_) {
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = -1;
#line 1551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8914 "number.c"
	}
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = c;
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = g_unichar_xdigit_value (_tmp2_);
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	value = _tmp3_;
#line 1555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = value;
#line 1555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = number_base;
#line 1555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp4_ >= _tmp5_) {
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = -1;
#line 1556 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 8932 "number.c"
	}
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = value;
#line 1558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 8938 "number.c"
}


Number* set_from_sexagesimal (const gchar* str) {
	Number* result = NULL;
	gint degree_index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Number* degrees = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint minute_start = 0;
	gint _tmp10_ = 0;
	gunichar c = 0U;
	const gchar* _tmp11_ = NULL;
	gunichar _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar _tmp15_ = '\0';
	gint minute_index = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Number* minutes = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	Number* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp28_ = NULL;
	Number* _tmp29_ = NULL;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
	gint second_start = 0;
	gint _tmp34_ = 0;
	const gchar* _tmp35_ = NULL;
	gunichar _tmp36_ = 0U;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar _tmp39_ = '\0';
	gint second_index = 0;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	Number* seconds = NULL;
	const gchar* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	Number* _tmp50_ = NULL;
	Number* _tmp51_ = NULL;
	Number* _tmp52_ = NULL;
	Number* _tmp53_ = NULL;
	Number* _tmp54_ = NULL;
	Number* _tmp55_ = NULL;
	Number* _tmp56_ = NULL;
	Number* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	gunichar _tmp59_ = 0U;
	const gchar* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gchar _tmp62_ = '\0';
#line 1561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = str;
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degree_index = _tmp1_;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = degree_index;
#line 1564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp2_ < 0) {
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1565 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9032 "number.c"
	}
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = str;
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = degree_index;
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) _tmp4_);
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = _tmp5_;
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp7_ = mp_set_from_string (_tmp6_, 10);
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp8_ = _tmp7_;
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp6_);
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degrees = _tmp8_;
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp9_ = degrees;
#line 1567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp9_ == NULL) {
#line 1568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 1568 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9060 "number.c"
	}
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp10_ = degree_index;
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	minute_start = _tmp10_;
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp11_ = str;
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp11_, &minute_start, &_tmp12_);
#line 1571 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp12_;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp13_ = str;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp14_ = minute_start;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp15_ == '\0') {
#line 1574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = degrees;
#line 1574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9084 "number.c"
	}
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp16_ = str;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp17_ = minute_start;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp18_ = string_index_of_char (_tmp16_, (gunichar) '\'', _tmp17_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	minute_index = _tmp18_;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp19_ = minute_index;
#line 1576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp19_ < 0) {
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9104 "number.c"
	}
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp20_ = str;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp21_ = minute_start;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp22_ = minute_index;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp23_ = minute_start;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp24_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp25_ = _tmp24_;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp26_ = mp_set_from_string (_tmp25_, 10);
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp27_ = _tmp26_;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp25_);
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	minutes = _tmp27_;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp28_ = minutes;
#line 1579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp28_ == NULL) {
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9138 "number.c"
	}
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp29_ = degrees;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp30_ = minutes;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 60);
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp32_ = _tmp31_;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp33_ = number_add (_tmp29_, _tmp32_);
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (degrees);
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degrees = _tmp33_;
#line 1581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp32_);
#line 1582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp34_ = minute_index;
#line 1582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	second_start = _tmp34_;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp35_ = str;
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp35_, &second_start, &_tmp36_);
#line 1583 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp36_;
#line 1585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp37_ = str;
#line 1585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp38_ = second_start;
#line 1585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp39_ = string_get (_tmp37_, (glong) _tmp38_);
#line 1585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp39_ == '\0') {
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = degrees;
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 1586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9180 "number.c"
	}
#line 1587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp40_ = str;
#line 1587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp41_ = second_start;
#line 1587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp42_ = string_index_of_char (_tmp40_, (gunichar) '"', _tmp41_);
#line 1587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	second_index = _tmp42_;
#line 1588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp43_ = second_index;
#line 1588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp43_ < 0) {
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 1589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9202 "number.c"
	}
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp44_ = str;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp45_ = second_start;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp46_ = second_index;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp47_ = second_start;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp48_ = string_substring (_tmp44_, (glong) _tmp45_, (glong) (_tmp46_ - _tmp47_));
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp49_ = _tmp48_;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp50_ = mp_set_from_string (_tmp49_, 10);
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp51_ = _tmp50_;
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_free0 (_tmp49_);
#line 1590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	seconds = _tmp51_;
#line 1591 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp52_ = seconds;
#line 1591 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp52_ == NULL) {
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (seconds);
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9238 "number.c"
	}
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp53_ = degrees;
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp54_ = seconds;
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp55_ = number_divide_integer (_tmp54_, (gint64) 3600);
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp56_ = _tmp55_;
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp57_ = number_add (_tmp53_, _tmp56_);
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (degrees);
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	degrees = _tmp57_;
#line 1593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp56_);
#line 1594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp58_ = str;
#line 1594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	string_get_next_char (_tmp58_, &second_index, &_tmp59_);
#line 1594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	c = _tmp59_;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp60_ = str;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp61_ = second_index;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp62_ = string_get (_tmp60_, (glong) _tmp61_);
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	if (_tmp62_ == '\0') {
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = degrees;
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (seconds);
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9278 "number.c"
	} else {
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		result = NULL;
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (seconds);
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (minutes);
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		_g_object_unref0 (degrees);
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
		return result;
#line 9290 "number.c"
	}
#line 1561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (seconds);
#line 1561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (minutes);
#line 1561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (degrees);
#line 9298 "number.c"
}


gboolean mp_is_overflow (Number* x, gint wordlen) {
	gboolean result = FALSE;
	Number* t2 = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	g_return_val_if_fail (x != NULL, FALSE);
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp0_ = number_new_integer ((gint64) 2);
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp1_ = _tmp0_;
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp2_ = wordlen;
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp3_ = number_xpowy_integer (_tmp1_, (gint64) _tmp2_);
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp4_ = _tmp3_;
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (_tmp1_);
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	t2 = _tmp4_;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp5_ = x;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_tmp6_ = number_compare (t2, _tmp5_);
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	result = _tmp6_ > 0;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	_g_object_unref0 (t2);
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/number.vala"
	return result;
#line 9338 "number.c"
}



