# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.hybridkubernetes import ConnectedKubernetesClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hybridkubernetes
# USAGE
    python delete_cluster_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ConnectedKubernetesClient(
        credential=DefaultAzureCredential(),
        subscription_id="1bfbb5d0-917e-4346-9026-1d3b344417f5",
    )

    response = client.connected_cluster.begin_delete(
        resource_group_name="k8sc-rg",
        cluster_name="testCluster",
    ).result()
    print(response)


# x-ms-original-file: specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/DeleteClusterExample.json
if __name__ == "__main__":
    main()
