/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.DisposalCallback;
import org.apache.hc.core5.pool.FakeConnection;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.pool.RouteSegmentedConnPool;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteSegmentedConnPoolTest {
    private static <R, C extends ModalCloseable> RouteSegmentedConnPool<R, C> newPool(int defPerRoute, int maxTotal, TimeValue ttl, PoolReusePolicy reuse, DisposalCallback<C> disposal) {
        return new RouteSegmentedConnPool(defPerRoute, maxTotal, ttl, reuse, disposal);
    }

    @Test
    void basicLeaseReleaseAndHandoff() throws Exception {
        DisposalCallback disposal = FakeConnection::close;
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(2, 2, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, disposal);
        PoolEntry e1 = (PoolEntry)pool.lease((Object)"r1", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)e1);
        Assertions.assertEquals((Object)"r1", (Object)e1.getRoute());
        Assertions.assertFalse((boolean)e1.hasConnection());
        e1.assignConnection((ModalCloseable)new FakeConnection());
        e1.updateState((Object)"A");
        e1.updateExpiry(TimeValue.ofSeconds((long)30L));
        pool.release(e1, true);
        Future f2 = pool.lease((Object)"r1", (Object)"A", Timeout.ofSeconds((long)1L), null);
        PoolEntry e2 = (PoolEntry)f2.get(1L, TimeUnit.SECONDS);
        Assertions.assertSame((Object)e1, (Object)e2, (String)"Should receive same entry via direct hand-off");
        pool.release(e2, true);
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void perRouteAndTotalLimits() throws Exception {
        DisposalCallback disposal = FakeConnection::close;
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(1, 2, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, disposal);
        PoolEntry r1a = (PoolEntry)pool.lease((Object)"r1", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        PoolEntry r2a = (PoolEntry)pool.lease((Object)"r2", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Future blocked = pool.lease((Object)"r1", null, Timeout.ofMilliseconds((long)150L), null);
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            PoolEntry cfr_ignored_0 = (PoolEntry)blocked.get(400L, TimeUnit.MILLISECONDS);
        });
        Assertions.assertInstanceOf(TimeoutException.class, (Object)ex.getCause());
        Assertions.assertEquals((Object)"Lease timed out", (Object)ex.getCause().getMessage());
        r1a.assignConnection((ModalCloseable)new FakeConnection());
        r1a.updateExpiry(TimeValue.ofSeconds((long)5L));
        pool.release(r1a, true);
        PoolEntry r1b = (PoolEntry)pool.lease((Object)"r1", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)r1b);
        pool.release(r2a, false);
        pool.release(r1b, false);
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void stateCompatibilityNullMatchesAnything() throws Exception {
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(1, 1, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, FakeConnection::close);
        PoolEntry e = (PoolEntry)pool.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        e.assignConnection((ModalCloseable)new FakeConnection());
        e.updateState((Object)"X");
        e.updateExpiry(TimeValue.ofSeconds((long)30L));
        pool.release(e, true);
        PoolEntry got = (PoolEntry)pool.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Assertions.assertSame((Object)e, (Object)got);
        pool.release(got, false);
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void closeIdleRemovesStaleAvailable() throws Exception {
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(2, 2, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, FakeConnection::close);
        PoolEntry e = (PoolEntry)pool.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        e.assignConnection((ModalCloseable)new FakeConnection());
        e.updateExpiry(TimeValue.ofSeconds((long)30L));
        pool.release(e, true);
        Thread.sleep(120L);
        pool.closeIdle(TimeValue.ofMilliseconds((long)50L));
        PoolStats stats = pool.getStats((Object)"r");
        Assertions.assertEquals((int)0, (int)stats.getAvailable());
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void closeExpiredHonorsEntryExpiryOrTtl() throws Exception {
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(1, 1, TimeValue.ofMilliseconds((long)100L), PoolReusePolicy.LIFO, FakeConnection::close);
        PoolEntry e = (PoolEntry)pool.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        e.assignConnection((ModalCloseable)new FakeConnection());
        e.updateExpiry(TimeValue.ofSeconds((long)10L));
        pool.release(e, true);
        Thread.sleep(150L);
        pool.closeExpired();
        PoolStats stats = pool.getStats((Object)"r");
        Assertions.assertEquals((int)0, (int)stats.getAvailable(), (String)"Expired/TTL entry should be gone");
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void waiterTimesOutAndIsFailed() throws Exception {
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(1, 1, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, FakeConnection::close);
        PoolEntry e = (PoolEntry)pool.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Future waiter = pool.lease((Object)"r", null, Timeout.ofMilliseconds((long)150L), null);
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            PoolEntry cfr_ignored_0 = (PoolEntry)waiter.get(500L, TimeUnit.MILLISECONDS);
        });
        Assertions.assertInstanceOf(TimeoutException.class, (Object)ex.getCause());
        Assertions.assertEquals((Object)"Lease timed out", (Object)ex.getCause().getMessage());
        pool.release(e, false);
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void poolCloseCancelsWaitersAndDrainsAvailable() throws Exception {
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(1, 1, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, FakeConnection::close);
        Future first = pool.lease((Object)"r", null, Timeout.ofSeconds((long)5L), null);
        first.get();
        Future waiter = pool.lease((Object)"r", null, Timeout.ofSeconds((long)5L), null);
        pool.close(CloseMode.IMMEDIATE);
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, waiter::get);
        Assertions.assertInstanceOf(TimeoutException.class, (Object)ex.getCause());
        Assertions.assertEquals((Object)"Pool closed", (Object)ex.getCause().getMessage());
    }

    @Test
    void reusePolicyLifoVsFifoIsObservable() throws Exception {
        RouteSegmentedConnPool lifo = RouteSegmentedConnPoolTest.newPool(2, 2, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, FakeConnection::close);
        PoolEntry a = (PoolEntry)lifo.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        PoolEntry b = (PoolEntry)lifo.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        a.assignConnection((ModalCloseable)new FakeConnection());
        a.updateExpiry(TimeValue.ofSeconds((long)10L));
        lifo.release(a, true);
        b.assignConnection((ModalCloseable)new FakeConnection());
        b.updateExpiry(TimeValue.ofSeconds((long)10L));
        lifo.release(b, true);
        PoolEntry firstLifo = (PoolEntry)lifo.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Assertions.assertSame((Object)b, (Object)firstLifo, (String)"LIFO should return last released");
        lifo.release(firstLifo, false);
        lifo.close(CloseMode.IMMEDIATE);
        RouteSegmentedConnPool fifo = RouteSegmentedConnPoolTest.newPool(2, 2, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.FIFO, FakeConnection::close);
        PoolEntry a2 = (PoolEntry)fifo.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        PoolEntry b2 = (PoolEntry)fifo.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        a2.assignConnection((ModalCloseable)new FakeConnection());
        a2.updateExpiry(TimeValue.ofSeconds((long)10L));
        fifo.release(a2, true);
        b2.assignConnection((ModalCloseable)new FakeConnection());
        b2.updateExpiry(TimeValue.ofSeconds((long)10L));
        fifo.release(b2, true);
        PoolEntry firstFifo = (PoolEntry)fifo.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Assertions.assertSame((Object)a2, (Object)firstFifo, (String)"FIFO should return first released");
        fifo.release(firstFifo, false);
        fifo.close(CloseMode.IMMEDIATE);
    }

    @Test
    void disposalIsCalledOnDiscard() throws Exception {
        ArrayList closed = new ArrayList();
        DisposalCallback disposal = (c, m) -> {
            c.close(m);
            closed.add(c);
        };
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(1, 1, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, disposal);
        PoolEntry e = (PoolEntry)pool.lease((Object)"r", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        FakeConnection conn = new FakeConnection();
        e.assignConnection((ModalCloseable)conn);
        pool.release(e, false);
        Assertions.assertEquals((int)1, (int)closed.size());
        Assertions.assertEquals((int)1, (int)((FakeConnection)closed.get(0)).closeCount());
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void slowDisposalDoesNotBlockOtherRoutes() throws Exception {
        DisposalCallback disposal = FakeConnection::close;
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(2, 2, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, disposal);
        PoolEntry e1 = (PoolEntry)pool.lease((Object)"r1", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        e1.assignConnection((ModalCloseable)new FakeConnection(600L));
        long startDiscard = System.nanoTime();
        pool.release(e1, false);
        long t0 = System.nanoTime();
        PoolEntry e2 = (PoolEntry)pool.lease((Object)"r2", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        long tLeaseMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0);
        Assertions.assertTrue((tLeaseMs < 200L ? 1 : 0) != 0, (String)("Other route lease blocked by disposal: " + tLeaseMs + "ms"));
        pool.release(e2, false);
        long discardMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startDiscard);
        Assertions.assertTrue((discardMs >= 600L ? 1 : 0) != 0, (String)"Discard should reflect slow close path");
        pool.close(CloseMode.IMMEDIATE);
    }

    @Test
    void getRoutesCoversAllocatedAvailableAndWaiters() throws Exception {
        RouteSegmentedConnPool pool = RouteSegmentedConnPoolTest.newPool(1, 1, TimeValue.NEG_ONE_MILLISECOND, PoolReusePolicy.LIFO, FakeConnection::close);
        Assertions.assertTrue((boolean)pool.getRoutes().isEmpty(), (String)"Initially there should be no routes");
        PoolEntry a = (PoolEntry)pool.lease((Object)"rA", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        Assertions.assertEquals(new HashSet<String>(Collections.singletonList("rA")), (Object)pool.getRoutes(), (String)"rA must be listed because it is leased (allocated > 0)");
        a.assignConnection((ModalCloseable)new FakeConnection());
        a.updateExpiry(TimeValue.ofSeconds((long)30L));
        pool.release(a, true);
        Assertions.assertEquals(new HashSet<String>(Collections.singletonList("rA")), (Object)pool.getRoutes(), (String)"rA must be listed because it has AVAILABLE entries");
        Future waiterB = pool.lease((Object)"rB", null, Timeout.ofMilliseconds((long)300L), null);
        Set routesNow = pool.getRoutes();
        Assertions.assertTrue((routesNow.contains("rA") && routesNow.contains("rB") ? 1 : 0) != 0, (String)"Both rA (available) and rB (waiter) must be listed");
        PoolEntry a2 = (PoolEntry)pool.lease((Object)"rA", null, Timeout.ofSeconds((long)1L), null).get(1L, TimeUnit.SECONDS);
        pool.release(a2, false);
        Set afterDropA = pool.getRoutes();
        Assertions.assertFalse((boolean)afterDropA.contains("rA"), (String)"rA segment should be cleaned up");
        Assertions.assertTrue((boolean)afterDropA.contains("rB"), (String)"rB (waiter) should remain listed");
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            PoolEntry cfr_ignored_0 = (PoolEntry)waiterB.get(600L, TimeUnit.MILLISECONDS);
        });
        Assertions.assertInstanceOf(TimeoutException.class, (Object)ex.getCause());
        Assertions.assertEquals((Object)"Lease timed out", (Object)ex.getCause().getMessage());
        pool.close(CloseMode.IMMEDIATE);
        Assertions.assertTrue((boolean)pool.getRoutes().isEmpty(), (String)"All routes must be gone after close()");
    }
}

