/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.decorate;

import java.awt.Component;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.eclipse.wb.internal.swing.databinding.Activator;
import org.eclipse.wb.internal.swing.databinding.model.decorate.BeanDecorationInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DecorationUtils {
    private static final Map<String, BeanDecorationInfo> DECORATIONS = new HashMap<String, BeanDecorationInfo>();
    private static boolean m_loadDecorations;

    public static BeanDecorationInfo getDecorationInfo(Class<?> beanClass) throws Exception {
        if (Component.class.isAssignableFrom(beanClass)) {
            DecorationUtils.loadDecorations();
            while (beanClass != null) {
                BeanDecorationInfo decorationInfo = DECORATIONS.get(beanClass.getName());
                if (decorationInfo != null) {
                    return decorationInfo;
                }
                beanClass = beanClass.getSuperclass();
            }
        }
        return null;
    }

    private static void loadDecorations() throws Exception {
        if (m_loadDecorations) {
            return;
        }
        m_loadDecorations = true;
        InputStream stream = Activator.getFile("templates/Decorations.xml");
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(stream, new DefaultHandler(){
            BeanDecorationInfo m_lastDecoration;

            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                if (name.equals("decoration")) {
                    BeanDecorationInfo parent = DECORATIONS.get(attributes.getValue("parent"));
                    this.m_lastDecoration = new BeanDecorationInfo(parent);
                    DECORATIONS.put(attributes.getValue("class"), this.m_lastDecoration);
                } else if (name.equals("preferred")) {
                    this.m_lastDecoration.setPreferredProperties(DecorationUtils.getProperties(attributes));
                } else if (name.equals("advanced")) {
                    this.m_lastDecoration.setAdvancedProperties(DecorationUtils.getProperties(attributes));
                } else if (name.equals("hidden")) {
                    this.m_lastDecoration.setHiddenProperties(DecorationUtils.getProperties(attributes));
                }
            }
        });
        IOUtils.closeQuietly((InputStream)stream);
    }

    private static String[] getProperties(Attributes attributes) {
        return attributes.getValue("properties").split(" ");
    }
}

