/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.util.Map;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.AbstractListPropertyEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class StringListPropertyEditor
extends AbstractListPropertyEditor {
    private boolean m_ignoreCase;
    private String[] m_strings;

    @Override
    protected void toPropertyEx_simpleProperty(Property property, CCombo3 combo, int index) throws Exception {
        property.setValue((Object)this.m_strings[index]);
    }

    @Override
    protected int getCount() {
        return this.m_strings.length;
    }

    @Override
    protected int getValueIndex(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            int i = 0;
            while (i < this.getCount()) {
                if (this.m_ignoreCase ? string.equalsIgnoreCase(this.m_strings[i]) : string.equals(this.m_strings[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    protected String getTitle(int index) {
        return this.m_strings[index];
    }

    @Override
    protected String getExpression(int index) throws Exception {
        return StringConverter.INSTANCE.toJavaSource(null, this.m_strings[index]);
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        this.m_strings = StringListPropertyEditor.getParameterAsArray(parameters, "strings");
        this.m_ignoreCase = "true".equals(parameters.get("ignoreCase"));
    }

    public void configure(String[] strings) {
        this.m_strings = strings;
    }
}

