/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.commons;

import java.util.ArrayList;
import java.util.List;

public class FixedSizeQueue<T> {
    private T[] buffer;
    private int index;

    public FixedSizeQueue(int capacity) {
        this.buffer = new Object[capacity];
        this.index = 0;
    }

    public void put(T element) {
        if (this.index == this.buffer.length) {
            System.arraycopy(this.buffer, 1, this.buffer, 0, this.buffer.length - 1);
            this.buffer[this.index - 1] = element;
        } else {
            this.buffer[this.index++] = element;
        }
    }

    public List<T> getValues() {
        ArrayList<T> list = new ArrayList<T>(this.index);
        int i = 0;
        while (i < this.index) {
            if (this.buffer[i] != null) {
                list.add(this.buffer[i]);
            }
            ++i;
        }
        return list;
    }

    public int getSize() {
        return this.index;
    }

    public void resizeTo(int newSize) {
        if (newSize < 0) {
            newSize = 1;
        }
        if (newSize == this.buffer.length) {
            return;
        }
        Object[] resizedBuffer = new Object[newSize];
        if (newSize > this.buffer.length) {
            System.arraycopy(this.buffer, 0, resizedBuffer, 0, this.buffer.length);
        } else {
            int startPos = Math.max(0, this.index - newSize);
            System.arraycopy(this.buffer, startPos, resizedBuffer, 0, newSize);
            this.index = newSize;
        }
        this.buffer = resizedBuffer;
    }
}

