/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.swt.model.property.converter.PointConverter;
import org.eclipse.wb.internal.swt.model.property.converter.RectangleConverter;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConvertersTest
extends RcpModelTest {
    private CompositeInfo shell;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.shell = null;
        super.tearDown();
    }

    @Test
    public void test_RectangleConverter() throws Exception {
        ExpressionConverter converter = RectangleConverter.INSTANCE;
        ConvertersTest.assertEquals((Object)"(org.eclipse.swt.graphics.Rectangle) null", (Object)converter.toJavaSource((JavaInfo)this.shell, null));
        ConvertersTest.assertEquals((Object)"new org.eclipse.swt.graphics.Rectangle(1, 2, 3, 4)", (Object)converter.toJavaSource((JavaInfo)this.shell, (Object)new Rectangle(1, 2, 3, 4)));
    }

    @Test
    public void test_PointConverter() throws Exception {
        ExpressionConverter converter = PointConverter.INSTANCE;
        ConvertersTest.assertEquals((Object)"(org.eclipse.swt.graphics.Point) null", (Object)converter.toJavaSource((JavaInfo)this.shell, null));
        ConvertersTest.assertEquals((Object)"new org.eclipse.swt.graphics.Point(1, 2)", (Object)converter.toJavaSource((JavaInfo)this.shell, (Object)new Point(1, 2)));
    }
}

