/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.rcp.model.rcp.PdeUtils;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractPdeTest
extends RcpModelTest {
    protected PdeUtils m_utils;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.setFileContentSrc("testplugin/Activator.java", AbstractPdeTest.getSourceDQ("package testplugin;", "import org.eclipse.ui.plugin.AbstractUIPlugin;", "public class Activator extends AbstractUIPlugin {", "  public Activator() {", "  }", "  public static Activator getDefault() {", "    return null;", "  }", "}"));
        AbstractPdeTest.waitForAutoBuild();
        this.m_utils = PdeUtils.get((IProject)m_project);
        this.m_utils.ensureSingleton();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        m_project = null;
        this.m_utils = null;
        AbstractPdeTest.do_projectDispose();
        super.tearDown();
    }

    public static String getManifest() throws Exception {
        return AbstractJavaProjectTest.getFileContent("META-INF/MANIFEST.MF");
    }

    public static void setManifest(String content) throws Exception {
        IFile resource = AbstractJavaProjectTest.getFile("META-INF/MANIFEST.MF");
        IOUtils2.setFileContents((IFile)resource, (InputStream)new ByteArrayInputStream(content.getBytes()));
    }

    public static String getPluginXML() throws Exception {
        return AbstractJavaProjectTest.getFileContent("plugin.xml");
    }

    public static void createPluginXML(String ... lines) throws Exception {
        PdeUtils.get((IProject)m_project).ensureSingleton();
        AbstractJavaProjectTest.setFileContent("plugin.xml", AbstractPdeTest.getPluginSource(lines));
        TestProject.waitForAutoBuild();
    }

    public static void assertPluginXML(String[] expectedLines) throws Exception {
        AbstractPdeTest.assertEquals((Object)AbstractPdeTest.getPluginSource(expectedLines), (Object)AbstractPdeTest.getPluginXML());
    }

    private static String getPluginSource(String[] lines) {
        String source = AbstractPdeTest.getSource(lines);
        source = source.replace('\'', '\"');
        return source;
    }

    public static void assertId(String expectedId, IPluginElement element) {
        AbstractPdeTest.assertEquals((Object)expectedId, (Object)element.getAttribute("id").getValue());
    }
}

