/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import java.util.Locale;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.FlagImagesRepository;
import org.eclipse.wb.internal.core.nls.ui.LocaleUtils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class LocaleUtilsTest
extends DesignerTestCase {
    @Test
    public void test_getImage_default() throws Exception {
        LocaleUtilsTest.assertSame((Object)FlagImagesRepository.getEmptyFlagImage(), (Object)LocaleUtils.getImage((LocaleInfo)LocaleInfo.DEFAULT));
    }

    @Test
    public void test_getImage_fr() throws Exception {
        Locale locale = Locale.FRENCH;
        LocaleInfo localeInfo = new LocaleInfo(locale);
        LocaleUtilsTest.assertSame((Object)FlagImagesRepository.getFlagImage((Locale)locale), (Object)LocaleUtils.getImage((LocaleInfo)localeInfo));
    }

    @Test
    public void test_sortByTitle() throws Exception {
        LocaleInfo[] locales = new LocaleInfo[]{new LocaleInfo(Locale.of("en")), new LocaleInfo(Locale.of("ar")), new LocaleInfo(Locale.of("ru"))};
        LocaleUtilsTest.assertEquals((Object)"en", (Object)locales[0].getTitle());
        LocaleUtilsTest.assertEquals((Object)"ar", (Object)locales[1].getTitle());
        LocaleUtilsTest.assertEquals((Object)"ru", (Object)locales[2].getTitle());
        LocaleUtils.sortByTitle((LocaleInfo[])locales);
        LocaleUtilsTest.assertEquals((Object)"ar", (Object)locales[0].getTitle());
        LocaleUtilsTest.assertEquals((Object)"en", (Object)locales[1].getTitle());
        LocaleUtilsTest.assertEquals((Object)"ru", (Object)locales[2].getTitle());
    }
}

