/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.PropertyManager;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProvider;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProviders;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.tests.common.PropertyWithTitle;
import org.junit.jupiter.api.Test;

public class PropertyCategoryProvidersTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_fromProperty() throws Exception {
        PropertyCategoryProvider provider = PropertyCategoryProviders.fromProperty();
        PropertyWithTitle property = new PropertyWithTitle("title");
        PropertyCategory category = PropertyCategory.ADVANCED;
        property.setCategory(category);
        PropertyCategoryProvidersTest.assertSame((Object)category, (Object)provider.getCategory((Property)property));
        category = PropertyCategory.PREFERRED;
        property.setCategory(category);
        PropertyCategoryProvidersTest.assertSame((Object)category, (Object)provider.getCategory((Property)property));
    }

    @Test
    public void test_forcedByUser() throws Exception {
        PropertyCategoryProvider provider = PropertyCategoryProviders.forcedByUser();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("background");
        PropertyCategoryProvidersTest.assertSame(null, (Object)provider.getCategory(property));
        try {
            PropertyCategory category = PropertyCategory.PREFERRED;
            PropertyManager.setCategory((Property)property, (PropertyCategory)category);
            PropertyCategoryProvidersTest.assertSame((Object)category, (Object)provider.getCategory(property));
        }
        finally {
            PropertyManager.setCategory((Property)property, null);
        }
        PropertyCategoryProvidersTest.assertSame(null, (Object)provider.getCategory(property));
    }

    @Test
    public void test_combine_empty() throws Exception {
        PropertyCategoryProvider provider = PropertyCategoryProviders.combine((PropertyCategoryProvider[])new PropertyCategoryProvider[0]);
        PropertyWithTitle property = new PropertyWithTitle("title");
        try {
            provider.getCategory((Property)property);
            PropertyCategoryProvidersTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_combine_atLeastNormal() throws Exception {
        PropertyCategoryProvider atLeastNormal = new PropertyCategoryProvider(){

            public PropertyCategory getCategory(Property property) {
                if (property.getCategory() == PropertyCategory.ADVANCED) {
                    return PropertyCategory.NORMAL;
                }
                return null;
            }
        };
        PropertyCategoryProvider provider = PropertyCategoryProviders.combine((PropertyCategoryProvider[])new PropertyCategoryProvider[]{atLeastNormal, PropertyCategoryProviders.fromProperty()});
        PropertyWithTitle property = new PropertyWithTitle("title");
        PropertyCategory category = PropertyCategory.NORMAL;
        property.setCategory(category);
        PropertyCategoryProvidersTest.assertSame((Object)category, (Object)property.getCategory());
        PropertyCategoryProvidersTest.assertSame((Object)category, (Object)provider.getCategory((Property)property));
        category = PropertyCategory.ADVANCED;
        property.setCategory(category);
        PropertyCategoryProvidersTest.assertSame((Object)category, (Object)property.getCategory());
        PropertyCategoryProvidersTest.assertSame((Object)PropertyCategory.NORMAL, (Object)provider.getCategory((Property)property));
        category = PropertyCategory.PREFERRED;
        property.setCategory(category);
        PropertyCategoryProvidersTest.assertSame((Object)category, (Object)property.getCategory());
        PropertyCategoryProvidersTest.assertSame((Object)category, (Object)provider.getCategory((Property)property));
    }

    @Test
    public void test_def() throws Exception {
        PropertyCategoryProvider provider = PropertyCategoryProviders.def();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("background");
        PropertyCategoryProvidersTest.assertSame((Object)PropertyCategory.NORMAL, (Object)provider.getCategory(property));
        try {
            PropertyCategory category = PropertyCategory.PREFERRED;
            PropertyManager.setCategory((Property)property, (PropertyCategory)category);
            PropertyCategoryProvidersTest.assertSame((Object)category, (Object)provider.getCategory(property));
        }
        finally {
            PropertyManager.setCategory((Property)property, null);
        }
        PropertyCategoryProvidersTest.assertSame((Object)PropertyCategory.NORMAL, (Object)provider.getCategory(property));
    }
}

