/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FactoryDescriptionHelperTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isFactoryMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", this.getTestSource("public class Test {", "  /**", "  * @wbp.factory", "  */", "  public static JButton createButton() {", "    return new JButton();", "  }", "  public static JButton createButton2() {", "    return new JButton();", "  }", "}"));
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        FactoryDescriptionHelperTest.assertTrue((boolean)FactoryDescriptionHelper.isFactoryMethod((MethodDeclaration)methods[0]));
        FactoryDescriptionHelperTest.assertFalse((boolean)FactoryDescriptionHelper.isFactoryMethod((MethodDeclaration)methods[1]));
    }

    @Test
    public void test_descriptions_javaDoc() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  /**", "  * @wbp.factory", "  */", "  public static JButton create_static_withFactory(String text) {", "    return new JButton(text);", "  }", "  public static JButton create_static_noFactory(String text) {", "    return new JButton(text);", "  }", "  /**", "  * @wbp.factory", "  */", "  public JButton create_notStatic_withFactory(String text) {", "    return new JButton(text);", "  }", "  /**", "  * @wbp.factory", "  */", "  private static JButton create_static_private_withFactory(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.StaticFactory_", true);
        Assertions.assertThat(descriptionsMap).hasSize(1);
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_static_withFactory(java.lang.String)"));
        FactoryMethodDescription description = descriptionsMap.values().iterator().next();
        FactoryDescriptionHelperTest.assertEquals((Object)"text", (Object)description.getParameter(0).getName());
    }

    @Test
    public void test_descriptions_javaDoc_defaultSource() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'my text'", "  */", "  public static JButton create_1(String text) {", "    return new JButton(text);", "  }", "  public static JButton create_2(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.StaticFactory", true);
        Assertions.assertThat(descriptionsMap).hasSize(2);
        FactoryMethodDescription description = descriptionsMap.get("create_1(java.lang.String)");
        FactoryDescriptionHelperTest.assertEquals((Object)"text", (Object)description.getParameter(0).getName());
        FactoryDescriptionHelperTest.assertEquals((Object)"\"my text\"", (Object)description.getParameter(0).getDefaultSource());
        description = descriptionsMap.get("create_2(java.lang.String)");
        FactoryDescriptionHelperTest.assertEquals((Object)"text", (Object)description.getParameter(0).getName());
        FactoryDescriptionHelperTest.assertEquals((Object)"(java.lang.String) null", (Object)description.getParameter(0).getDefaultSource());
    }

    @Test
    public void test_descriptions_javaDoc_parent() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(Container parent) {", "    JButton button = new JButton();", "    parent.add(button);", "    return button;", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton(java.awt.Container)", true);
        ParameterDescription parameter = description.getParameter(0);
        FactoryDescriptionHelperTest.assertEquals((Object)"parent", (Object)parameter.getName());
        FactoryDescriptionHelperTest.assertTrue((boolean)parameter.isParent());
    }

    @Test
    public void test_descriptions_suffixFactory() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton create_1(String text) {", "    return new JButton(text);", "  }", "  public static JButton create_2(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.StaticFactory", true);
        Assertions.assertThat(descriptionsMap).hasSize(2);
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_1(java.lang.String)"));
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_2(java.lang.String)"));
    }

    @Test
    public void test_descriptions_javaDoc_forClass() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("/**", "* @wbp.factory", "*/", "public final class StaticFactory_ {", "  public static JButton create_1(String text) {", "    return new JButton(text);", "  }", "  public static JButton create_2(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.StaticFactory_", true);
        Assertions.assertThat(descriptionsMap).hasSize(2);
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_1(java.lang.String)"));
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_2(java.lang.String)"));
    }

    @Test
    public void test_descriptions_javaDoc_forClass_withSetters() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static void setText(String text) {", "  }", "  public static String getText() {", "    return null;", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.StaticFactory", true);
        Assertions.assertThat(descriptionsMap).isEmpty();
    }

    @Test
    public void test_descriptions_javaDoc_autoBinding() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String text, Icon icon, int noSuchProperty) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton(java.lang.String,javax.swing.Icon,int)", true);
        FactoryDescriptionHelperTest.assertEquals((Object)"setText(java.lang.String)", (Object)description.getParameter(0).getProperty());
        FactoryDescriptionHelperTest.assertEquals((Object)"setIcon(javax.swing.Icon)", (Object)description.getParameter(1).getProperty());
        FactoryDescriptionHelperTest.assertNull((Object)description.getParameter(2).getProperty());
    }

    @Test
    public void test_descriptions_javaDoc_noBinding() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameters.noBinding", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton(java.lang.String)", true);
        FactoryDescriptionHelperTest.assertNull((Object)description.getParameter(0).getProperty());
    }

    @Test
    public void test_descriptions_XML() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton create_xml(String text) {", "    return new JButton(text);", "  }", "  public static JButton create_noFactory(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='create_xml'>", "    <parameter type='java.lang.String' property='setText(java.lang.String)'/>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.StaticFactory_", true);
        Assertions.assertThat(descriptionsMap).hasSize(1);
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_xml(java.lang.String)"));
        FactoryMethodDescription description = descriptionsMap.values().iterator().next();
        FactoryDescriptionHelperTest.assertEquals((Object)"text", (Object)description.getParameter(0).getName());
    }

    @Test
    public void test_descriptions_XML_instanceMethods_askStatic() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/InstanceFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'/>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.InstanceFactory", true);
        Assertions.assertThat(descriptionsMap).isEmpty();
    }

    @Test
    public void test_descriptions_XML_staticMethods_askInstance() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'/>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.StaticFactory", false);
        Assertions.assertThat(descriptionsMap).isEmpty();
    }

    @Test
    public void test_descriptions_XML_instanceFactory_inheritance() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/SuperToolkit.java", this.getTestSource("public class SuperToolkit {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/SuperToolkit.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'/>", "</factory>"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/SubToolkit.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class SubToolkit extends SuperToolkit {", "  // filler", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.SubToolkit", false);
        Assertions.assertThat(descriptionsMap).hasSize(1);
        Assertions.assertThat(descriptionsMap.keySet()).contains((Object[])new String[]{"createButton()"});
    }

    @Test
    public void test_descriptions_XML_textualDescription_plainText() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <description>Some textual description of method.</description>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton()", true);
        FactoryDescriptionHelperTest.assertEquals((Object)"Some textual description of method.", (Object)description.getDescription());
    }

    @Test
    public void test_descriptions_XML_textualDescription_HTML_1() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <description>Some &lt;b&gt;HTML&lt;/b&gt; description.</description>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton()", true);
        FactoryDescriptionHelperTest.assertEquals((Object)"Some <b>HTML</b> description.", (Object)description.getDescription());
    }

    @Test
    public void test_descriptions_XML_textualDescription_HTML_2() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <description>First. &lt;p attr='value'/&gt; Second.</description>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton()", true);
        FactoryDescriptionHelperTest.assertEquals((Object)"First. <p attr='value'/> Second.", (Object)description.getDescription());
    }

    @Test
    public void test_descriptions_XML_textualDescription_HTML_3() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <description>&#48;&#x31;</description>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton()", true);
        FactoryDescriptionHelperTest.assertEquals((Object)"01", (Object)description.getDescription());
    }

    @Test
    public void test_descriptions_XML_presentationName() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <name>Some name.</name>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton()", true);
        FactoryDescriptionHelperTest.assertEquals((Object)"Some name.", (Object)description.getPresentationName());
    }

    @Test
    public void test_descriptions_XML_parameters() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <parameters>", "      <parameter name='parameter.1'>some value</parameter>", "    </parameters>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription description = this.getDescription("test.StaticFactory", "createButton()", true);
        FactoryDescriptionHelperTest.assertEquals((Object)"some value", (Object)description.getParameter("parameter.1"));
        FactoryDescriptionHelperTest.assertNull((Object)description.getParameter("noSuchParameter"));
    }

    @Test
    public void test_descriptions_cached() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    add(StaticFactory.createButton('button 1'));", "    add(StaticFactory.createButton('button 2'));", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).hasSize(2);
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        StaticFactoryCreationSupport creation_1 = (StaticFactoryCreationSupport)button_1.getCreationSupport();
        StaticFactoryCreationSupport creation_2 = (StaticFactoryCreationSupport)button_2.getCreationSupport();
        FactoryDescriptionHelperTest.assertSame((Object)creation_1.getDescription(), (Object)creation_2.getDescription());
    }

    @Disabled
    @Test
    public void test_descriptions_memberClass() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/SomeObject.java", this.getTestSource("public class SomeObject {", "  SomeObject() {", "  }", "  public static class StaticFactory {", "    public static JButton createButton() {", "      return new JButton();", "    }", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap("test.SomeObject$StaticFactory", true);
        Assertions.assertThat(descriptionsMap).isEmpty();
    }

    @Test
    public void test_descriptions_exceptionInJavaInternals() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/NoSuchClass.java", FactoryDescriptionHelperTest.getSourceDQ("package test;", "public class NoSuchClass {", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/MyFactory.java", FactoryDescriptionHelperTest.getSourceDQ("package test;", "public class MyFactory {", "  public static NoSuchClass getBad() {", "    return null;", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        FactoryDescriptionHelperTest.getFile("bin/test/NoSuchClass.class").delete(true, null);
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        this.parseContainer(lines);
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap0("test.MyFactory", true);
        Assertions.assertThat(descriptionsMap).isEmpty();
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        EditorWarning warning = (EditorWarning)warnings.get(0);
        Throwable exception = warning.getException();
        Throwable rootException = DesignerExceptionUtils.getRootCause((Throwable)exception);
        Assertions.assertThat((Throwable)rootException).isExactlyInstanceOf(ClassNotFoundException.class);
    }

    @Test
    public void test_descriptions_bindByIndex() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameters.noBinding", "  * @wbp.factory.parameter.property 0 text", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  Test() {", "    add(StaticFactory.createButton(null));", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).hasSize(1);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryMethodDescription description = ((StaticFactoryCreationSupport)button.getCreationSupport()).getDescription();
        FactoryDescriptionHelperTest.assertEquals((Object)"setText(java.lang.String)", (Object)description.getParameter(0).getProperty());
    }

    @Test
    public void test_descriptions_bindByIndex_invalid() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.property -1 text", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("public final class Test extends JPanel {", "  Test() {", "    add(StaticFactory.createButton(null));", "  }", "}");
        FactoryDescriptionHelperTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(StaticFactory.createButton(null))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_descriptions_bindByName_invalid() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.property noSuchParameter text", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("public final class Test extends JPanel {", "  Test() {", "    add(StaticFactory.createButton(null));", "  }", "}");
        FactoryDescriptionHelperTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(StaticFactory.createButton(null))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    @Disabled
    public void test_descriptionsInstanceStatic() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public static JButton create_static(String text) {", "    return new JButton(text);", "  }", "  public JButton create_instance(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        String factoryClassName = "test.InstanceFactory";
        Map<String, FactoryMethodDescription> descriptionsMap = this.getDescriptionsMap(factoryClassName, false);
        Assertions.assertThat(descriptionsMap).hasSize(2);
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_static(java.lang.String)"));
        FactoryDescriptionHelperTest.assertTrue((boolean)descriptionsMap.containsKey("create_instance(java.lang.String)"));
        FactoryMethodDescription description = this.getDescription(factoryClassName, "create_instance(java.lang.String)", true);
        FactoryDescriptionHelperTest.assertNull((Object)description);
    }

    @Test
    public void test_descriptions_icon() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        IFile iconFile = FactoryDescriptionHelperTest.getFileSrc("test", "StaticFactory.createButton_java.lang.String_.png");
        iconFile.create(Activator.getFile("icons/test.png"), true, null);
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
        Class<?> factoryClass = this.m_lastLoader.loadClass("test.StaticFactory");
        FactoryMethodDescription factoryDescription = this.getDescription("test.StaticFactory", "createButton()", true);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
        FactoryDescriptionHelperTest.assertSame(factoryClass, (Object)factoryDescription.getDeclaringClass());
        FactoryDescriptionHelperTest.assertSame(JButton.class, (Object)factoryDescription.getReturnClass());
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription.getIcon());
        FactoryMethodDescription factoryDescription2 = this.getDescription("test.StaticFactory", "createButton(java.lang.String)", true);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription2.isFactory());
        FactoryDescriptionHelperTest.assertSame(factoryClass, (Object)factoryDescription2.getDeclaringClass());
        FactoryDescriptionHelperTest.assertSame(JButton.class, (Object)factoryDescription2.getReturnClass());
        ImageDescriptor factoryMethodIcon = factoryDescription2.getIcon();
        FactoryDescriptionHelperTest.assertNotNull((Object)factoryMethodIcon);
        FactoryDescriptionHelperTest.assertTrue((boolean)UiUtils.equals((ImageDescriptor)factoryMethodIcon, (ImageDescriptor)Activator.getImageDescriptor("test.png")));
    }

    @Test
    public void test_descriptions_getInvocations() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <invocation signature='setText(java.lang.String)'><![CDATA['Static Button']]></invocation>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription factoryDescription = this.getDescription("test.StaticFactory", "createButton()", true);
        List invocations = factoryDescription.getInvocations();
        Assertions.assertThat((List)invocations).hasSize(1);
        CreationInvocationDescription invocationDescription = (CreationInvocationDescription)invocations.get(0);
        FactoryDescriptionHelperTest.assertEquals((Object)"setText(java.lang.String)", (Object)invocationDescription.getSignature());
        FactoryDescriptionHelperTest.assertEquals((Object)"\"Static Button\"", (Object)invocationDescription.getArguments());
    }

    private ICompilationUnit getFactoryUnit(JavaInfo component) throws Exception {
        List<ICompilationUnit> factoryUnits = this.getFactoryUnits();
        return !factoryUnits.isEmpty() ? factoryUnits.get(0) : null;
    }

    private List<ICompilationUnit> getFactoryUnits() throws Exception {
        IPackageFragment currentPackage = (IPackageFragment)this.m_lastEditor.getModelUnit().getParent();
        return FactoryDescriptionHelper.getFactoryUnits((AstEditor)this.m_lastEditor, (IPackageFragment)currentPackage);
    }

    @Test
    public void test_getFactoryUnits_noUnits() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertNull((Object)this.getFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_getFactoryUnits_noPrimaryType() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/NoPrimaryType.java", FactoryDescriptionHelperTest.getSourceDQ("package test;", "class Foo {", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Assertions.assertThat(this.getFactoryUnits()).isEmpty();
    }

    @Test
    public void test_getFactoryUnits_noTagOrDescription_notFactorySuffix() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertFalse((boolean)FactoryDescriptionHelper.isFactoryClass((AstEditor)this.m_lastEditor, (String)"test.StaticFactory_"));
        FactoryDescriptionHelperTest.assertNull((Object)this.getFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_getFactoryUnits_noTagOrDescription_hasFactorySuffix() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertTrue((boolean)FactoryDescriptionHelper.isFactoryClass((AstEditor)this.m_lastEditor, (String)"test.StaticFactory"));
        FactoryDescriptionHelperTest.assertEquals((Object)factoryUnit, (Object)this.getFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_getFactoryUnits_tag() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  /**", "  * @wbp.factory", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertTrue((boolean)FactoryDescriptionHelper.isFactoryClass((AstEditor)this.m_lastEditor, (String)"test.StaticFactory_"));
        FactoryDescriptionHelperTest.assertEquals((Object)factoryUnit, (Object)this.getFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_getFactoryUnits_tagInComment() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    // @wbp.factory  -  here this tag means nothing", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertFalse((boolean)FactoryDescriptionHelper.isFactoryClass((AstEditor)this.m_lastEditor, (String)"test.StaticFactory_"));
        FactoryDescriptionHelperTest.assertNull((Object)this.getFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_getFactoryUnits_description() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <parameter type='java.lang.String'/>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertTrue((boolean)FactoryDescriptionHelper.isFactoryClass((AstEditor)this.m_lastEditor, (String)"test.StaticFactory_"));
        FactoryDescriptionHelperTest.assertEquals((Object)factoryUnit, (Object)this.getFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_getFactoryUnits_descriptionNoMethods() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory_.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertFalse((boolean)FactoryDescriptionHelper.isFactoryClass((AstEditor)this.m_lastEditor, (String)"test.StaticFactory_"));
        FactoryDescriptionHelperTest.assertNull((Object)this.getFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_isFactoryInvocation_static() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("/**", "* @wbp.factory", "*/", "public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("public final class Test extends JPanel {", "  public Test() {", "    System.out.println(-1);", "    add(StaticFactory.createButton());", "  }", "}");
        MethodInvocation invocation = (MethodInvocation)this.m_lastEditor.getEnclosingNode(".println");
        FactoryDescriptionHelperTest.assertFalse((boolean)FactoryDescriptionHelper.isFactoryInvocation((AstEditor)this.m_lastEditor, (MethodInvocation)invocation));
        invocation = (MethodInvocation)this.m_lastEditor.getEnclosingNode(".createButton");
        FactoryDescriptionHelperTest.assertTrue((boolean)FactoryDescriptionHelper.isFactoryInvocation((AstEditor)this.m_lastEditor, (MethodInvocation)invocation));
    }

    @Test
    public void test_isFactoryInvocation_instance() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("/**", "* @wbp.factory", "*/", "public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("public final class Test extends JPanel {", "  private final InstanceFactory factory = new InstanceFactory();", "  public Test() {", "    System.out.println(-1);", "    add(factory.createButton());", "  }", "}");
        MethodInvocation invocation = (MethodInvocation)this.m_lastEditor.getEnclosingNode(".println");
        FactoryDescriptionHelperTest.assertFalse((boolean)FactoryDescriptionHelper.isFactoryInvocation((AstEditor)this.m_lastEditor, (MethodInvocation)invocation));
        invocation = (MethodInvocation)this.m_lastEditor.getEnclosingNode(".createButton");
        FactoryDescriptionHelperTest.assertTrue((boolean)FactoryDescriptionHelper.isFactoryInvocation((AstEditor)this.m_lastEditor, (MethodInvocation)invocation));
    }

    @Test
    public void test_isFactory_descriptions_default_1() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.java", this.getTestSource("public final class TestFactory {", "  public static TestFactory create() {", "    return new TestFactory();", "  }", "  public JButton createButton() {", "    return new JButton();", "  }", "  public Object createNo(Object value) {", "    return value;", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryDescriptionHelperTest.assertEquals((int)this.getDescriptionsMap("test.TestFactory", true).size(), (int)1);
        FactoryDescriptionHelperTest.assertEquals((int)this.getDescriptionsMap("test.TestFactory", false).size(), (int)2);
        FactoryMethodDescription factoryDescription = this.getDescription("test.TestFactory", "create()", true);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
        factoryDescription = this.getDescription("test.TestFactory", "createButton()", false);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
        factoryDescription = this.getDescription("test.TestFactory", "createNo(java.lang.Object)", false);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
    }

    @Test
    public void test_isFactory_descriptions_default_2() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory_.java", this.getTestSource("public final class TestFactory_ {", "  public static TestFactory_ create() {", "    return new TestFactory_();", "  }", "  public JButton createButton() {", "    return new JButton();", "  }", "  public Object createNo(Object value) {", "    return value;", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory_.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription factoryDescription = this.getDescription("test.TestFactory_", "create()", true);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
        factoryDescription = this.getDescription("test.TestFactory_", "createButton()", false);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
        factoryDescription = this.getDescription("test.TestFactory_", "createNo(java.lang.Object)", false);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
    }

    @Test
    public void test_isFactory_descriptions_1() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.java", this.getTestSource("public final class TestFactory {", "  public static TestFactory create() {", "    return new TestFactory();", "  }", "  public JButton createButton() {", "    return new JButton();", "  }", "  public Object createNo(Object value) {", "    return value;", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createNo' factory='false'>", "    <parameter type='java.lang.Object'/>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription factoryDescription = this.getDescription("test.TestFactory", "create()", true);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
        factoryDescription = this.getDescription("test.TestFactory", "createButton()", false);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
        factoryDescription = this.getDescription("test.TestFactory", "createNo(java.lang.Object)", false);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
    }

    @Test
    public void test_isFactory_descriptions_2() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.java", this.getTestSource("public final class TestFactory {", "  public static TestFactory create() {", "    return new TestFactory();", "  }", "  public JButton createButton() {", "    return new JButton();", "  }", "  public Object createNo(Object value) {", "    return value;", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <allMethodsAreFactories>false</allMethodsAreFactories>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription factoryDescription = this.getDescription("test.TestFactory", "create()", true);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
        factoryDescription = this.getDescription("test.TestFactory", "createButton()", false);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
        factoryDescription = this.getDescription("test.TestFactory", "createNo(java.lang.Object)", false);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
    }

    @Test
    public void test_isFactory_descriptions_mixed() throws Exception {
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.java", this.getTestSource("public final class TestFactory {", "  public static TestFactory create() {", "    return new TestFactory();", "  }", "  public JButton createButton() {", "    return new JButton();", "  }", "  public Object createNo(Object value) {", "    return value;", "  }", "}"));
        FactoryDescriptionHelperTest.setFileContentSrc("test/TestFactory.wbp-factory.xml", FactoryDescriptionHelperTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <allMethodsAreFactories>false</allMethodsAreFactories>", "  <method name='create' factory='true'>", "  </method>", "  <method name='createButton' factory='true'>", "  </method>", "</factory>"));
        FactoryDescriptionHelperTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryMethodDescription factoryDescription = this.getDescription("test.TestFactory", "create()", true);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
        factoryDescription = this.getDescription("test.TestFactory", "createButton()", false);
        FactoryDescriptionHelperTest.assertTrue((boolean)factoryDescription.isFactory());
        factoryDescription = this.getDescription("test.TestFactory", "createNo(java.lang.Object)", false);
        FactoryDescriptionHelperTest.assertNull((Object)factoryDescription);
    }

    public Map<String, FactoryMethodDescription> getDescriptionsMap(String factoryClassName, boolean forStatic) throws Exception {
        Map<String, FactoryMethodDescription> descriptions = this.getDescriptionsMap0(factoryClassName, forStatic);
        FactoryDescriptionHelperTest.assertNoErrors(this.m_lastParseInfo);
        return descriptions;
    }

    private Map<String, FactoryMethodDescription> getDescriptionsMap0(String factoryClassName, boolean forStatic) throws Exception {
        Class<?> factoryClass = this.m_lastLoader.loadClass(factoryClassName);
        return FactoryDescriptionHelper.getDescriptionsMap((AstEditor)this.m_lastEditor, factoryClass, (boolean)forStatic);
    }

    private FactoryMethodDescription getDescription(String factoryClassName, String signature, boolean forStatic) throws Exception {
        Class<?> factoryClass = this.m_lastLoader.loadClass(factoryClassName);
        return FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, factoryClass, (String)signature, (boolean)forStatic);
    }
}

