/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.internal.core.UiMessages;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.preferences.bind.AbstractBindingPreferencesPage;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.IDataProvider;
import org.eclipse.wb.internal.core.utils.binding.providers.StringPreferenceProvider;
import org.eclipse.wb.internal.core.utils.ui.AbstractBindingComposite;
import org.osgi.service.prefs.BackingStoreException;

public abstract class LayoutsPreferencePage
extends AbstractBindingPreferencesPage {
    private final IEclipsePreferences m_layoutPreferences = InstanceScope.INSTANCE.getNode("layout.available");

    public LayoutsPreferencePage(ToolkitDescription toolkit) {
        super(toolkit);
    }

    protected AbstractBindingComposite createBindingComposite(Composite parent) {
        return new ContentsComposite(parent, this.m_bindManager, this.m_preferences);
    }

    public boolean performOk() {
        try {
            this.m_layoutPreferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    protected class ContentsComposite
    extends AbstractBindingComposite {
        private final CheckboxTableViewer m_table;
        private final ComboViewer m_layoutCombo;

        public ContentsComposite(Composite parent, DataBindManager bindManager, IPreferenceStore preferences) {
            super(parent, bindManager, preferences);
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
            StructuredSelection implicitLayoutSelection = new StructuredSelection((Object)UiMessages.LayoutsPreferencePage_implicitLayout);
            List layouts = LayoutDescriptionHelper.get((ToolkitDescription)LayoutsPreferencePage.this.m_toolkit);
            Collections.sort(layouts, Comparator.comparing(LayoutDescription::getName));
            Label layoutText = new Label((Composite)this, 0);
            layoutText.setText(UiMessages.LayoutsPreferencePage_defaultLayout);
            layoutText.setLayoutData((Object)new GridData(4, 4, false, false));
            this.m_layoutCombo = new ComboViewer((Composite)this, 8);
            this.m_layoutCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.m_layoutCombo.setLabelProvider((IBaseLabelProvider)ColumnLabelProvider.createTextProvider(o -> {
                if (o instanceof LayoutDescription) {
                    LayoutDescription layout = (LayoutDescription)o;
                    return layout.getName();
                }
                return (String)o;
            }));
            this.m_layoutCombo.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_layoutCombo.getCombo().setVisibleItemCount(15);
            this.m_layoutCombo.add((Object)UiMessages.LayoutsPreferencePage_implicitLayout);
            for (LayoutDescription layoutDescription : layouts) {
                this.m_layoutCombo.add((Object)layoutDescription.getName());
            }
            Label tableText = new Label((Composite)this, 0);
            tableText.setText(UiMessages.LayoutsPreferencePage_availableLayouts);
            tableText.setLayoutData((Object)new GridData(4, 4, false, false));
            this.m_table = CheckboxTableViewer.newCheckList((Composite)this, (int)2816);
            this.m_table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.m_table.setLabelProvider((IBaseLabelProvider)ColumnLabelProvider.createTextProvider(o -> ((LayoutDescription)o).getName()));
            this.m_table.setCheckStateProvider(new ICheckStateProvider(){

                public boolean isChecked(Object element) {
                    return ((ContentsComposite)ContentsComposite.this).LayoutsPreferencePage.this.m_layoutPreferences.getBoolean(((LayoutDescription)element).getLayoutClassName(), true);
                }

                public boolean isGrayed(Object element) {
                    return false;
                }
            });
            this.m_table.setInput((Object)layouts);
            this.m_table.addCheckStateListener(arg_0 -> this.lambda$3((ISelection)implicitLayoutSelection, arg_0));
            this.m_table.getTable().setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.checkButton((Composite)this, 2, UiMessages.LayoutsPreferencePage_inheritLayout, "layout.inheritLayoutOfParent");
            this.m_layoutCombo.setInput(this.getLayoutItems());
            this.m_bindManager.bind(new IDataEditor((ISelection)implicitLayoutSelection, layouts){
                private final /* synthetic */ ISelection val$implicitLayoutSelection;
                private final /* synthetic */ List val$layouts;
                {
                    this.val$implicitLayoutSelection = iSelection;
                    this.val$layouts = list;
                }

                public void setValue(Object value) {
                    String id = (String)value;
                    if (StringUtils.isEmpty((CharSequence)id)) {
                        ContentsComposite.this.m_layoutCombo.setSelection(this.val$implicitLayoutSelection);
                        return;
                    }
                    int index = 0;
                    while (index < this.val$layouts.size()) {
                        LayoutDescription layout = (LayoutDescription)this.val$layouts.get(index);
                        if (layout.getId().equals(id)) {
                            ContentsComposite.this.m_layoutCombo.setSelection((ISelection)new StructuredSelection((Object)layout));
                        }
                        ++index;
                    }
                }

                public Object getValue() {
                    Object object = ContentsComposite.this.m_layoutCombo.getStructuredSelection().getFirstElement();
                    if (object instanceof LayoutDescription) {
                        LayoutDescription layout = (LayoutDescription)object;
                        return layout.getId();
                    }
                    return "";
                }
            }, (IDataProvider)new StringPreferenceProvider(this.m_preferences, "layout.default"), true);
        }

        private List<Object> getLayoutItems() {
            ArrayList<Object> layoutItems = new ArrayList<Object>();
            layoutItems.add(UiMessages.LayoutsPreferencePage_implicitLayout);
            layoutItems.addAll(List.of(this.m_table.getCheckedElements()));
            return Collections.unmodifiableList(layoutItems);
        }

        private /* synthetic */ void lambda$3(ISelection iSelection, CheckStateChangedEvent event) {
            LayoutDescription layout = (LayoutDescription)event.getElement();
            LayoutsPreferencePage.this.m_layoutPreferences.putBoolean(layout.getLayoutClassName(), event.getChecked());
            List<Object> input = this.getLayoutItems();
            IStructuredSelection selection = this.m_layoutCombo.getStructuredSelection();
            this.m_layoutCombo.setInput(input);
            if (!input.contains(selection.getFirstElement())) {
                this.m_layoutCombo.setSelection(iSelection);
            } else {
                this.m_layoutCombo.setSelection((ISelection)selection);
            }
        }
    }
}

