/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model.ui;

import com.jgoodies.forms.layout.FormSpecs;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.ColumnEditDialog;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.DimensionsDialog;

public final class ColumnsDialog
extends DimensionsDialog<FormColumnInfo> {
    public ColumnsDialog(Shell parentShell, FormLayoutInfo layout) {
        super(parentShell, layout, ColumnsDialog.createColumnsCopy(layout), layout.getMinimumSize().width);
    }

    private static List<FormColumnInfo> createColumnsCopy(final FormLayoutInfo layout) {
        final ArrayList<FormColumnInfo> columns = new ArrayList<FormColumnInfo>();
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                for (FormColumnInfo column : layout.getColumns()) {
                    columns.add(column.copy());
                }
            }
        });
        return columns;
    }

    @Override
    protected void updateLayoutInfo(List<FormColumnInfo> dimensions) throws Exception {
        this.m_layout.setColumns(dimensions);
    }

    @Override
    protected String getDialogTitle() {
        return ModelMessages.ColumnsDialog_dialogTitle;
    }

    @Override
    protected String getDialogMessage() {
        return ModelMessages.ColumnsDialog_dialogMessage;
    }

    @Override
    protected String getViewerTitle() {
        return ModelMessages.ColumnsDialog_viewerTitle;
    }

    @Override
    protected String getMinimalErrorMessage(int minimumDimensions) {
        return MessageFormat.format(ModelMessages.ColumnsDialog_minimalErrorMessage, minimumDimensions);
    }

    @Override
    protected boolean editSelectedDimension(List<FormColumnInfo> dimensions, FormColumnInfo column) {
        return new ColumnEditDialog(this.getShell(), dimensions, column).open() == 0;
    }

    @Override
    protected FormColumnInfo createNewDimension() throws Exception {
        return new FormColumnInfo(FormSpecs.DEFAULT_COLSPEC);
    }
}

