/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ButtonInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class AbsoluteLayoutTest
extends RcpModelTest {
    private static final IPreferenceStore preferences = RcpToolkitDescription.INSTANCE.getPreferences();

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        preferences.setValue("P_CREATION_FLOW", false);
        preferences.setToDefault("absoluteLayout.autoSize.onTextImage");
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_invalidAbsoluteLayoutToolkit() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  /**", "  * @wbp.nonvisual location=571,523", "  */", "  private static final Object myStaticBean = new java.util.ArrayList<Object>();", "  protected Shell shell;", "  public static void main(String[] args) {", "    Test window = new Test();", "    window.open();", "  }", "  public void open() {", "    shell = new Shell(SWT.NONE);", "    Button button_1 = new Button(shell, SWT.NONE);", "    button_1.setBounds(42, 118, 81, 20);", "  }", "}");
        shell.refresh();
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)shell.getLayout();
        AbsoluteLayoutTest.assertSame((Object)ToolkitProvider.DESCRIPTION, (Object)layout.getDescription().getToolkit());
    }

    @Test
    public void test_parse() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(null);", "  }", "}");
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)shellInfo.getLayout();
        ComponentDescription description = layout.getDescription();
        AbsoluteLayoutTest.assertSame((Object)ToolkitProvider.DESCRIPTION, (Object)description.getToolkit());
        AbsoluteLayoutTest.assertNotNull((Object)description.getIcon());
        CreationSupport creationSupport = layout.getCreationSupport();
        AbsoluteLayoutTest.assertEquals((Object)"null", (Object)creationSupport.toString());
        MethodInvocation setLayoutInvocation = shellInfo.getMethodInvocation("setLayout(org.eclipse.swt.widgets.Layout)");
        AbsoluteLayoutTest.assertEquals(DomGenerics.arguments((MethodInvocation)setLayoutInvocation).get(0), (Object)creationSupport.getNode());
        AbsoluteLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)layout.getAssociation());
        AbsoluteLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)layout));
    }

    @Test
    public void test_setLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        LayoutInfo layout = shell.getLayout();
        AbsoluteLayoutTest.assertInstanceOf(FillLayoutInfo.class, (Object)layout);
        final AbsoluteLayoutInfo absoluteLayout = AbsoluteLayoutInfo.createExplicit((CompositeInfo)shell);
        shell.setLayout((LayoutInfo)absoluteLayout);
        AbsoluteLayoutTest.assertSame((Object)absoluteLayout, (Object)shell.getLayout());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "  }", "}");
        final boolean[] absoluteLayout_objectSet = new boolean[1];
        shell.addBroadcastListener((Object)new JavaInfoSetObjectAfter(){

            public void invoke(JavaInfo target, Object o) throws Exception {
                if (target == absoluteLayout) {
                    AbsoluteLayoutTest.assertNull((Object)o);
                    absoluteLayout_objectSet[0] = true;
                }
            }
        });
        shell.refresh();
        AbsoluteLayoutTest.assertTrue((boolean)absoluteLayout_objectSet[0]);
    }

    @Test
    public void test_onSet() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new RowData(200, 100));", "    }", "  }", "}");
        shell.refresh();
        AbsoluteLayoutInfo absoluteLayout = new AbsoluteLayoutInfo(this.m_lastEditor, (ToolkitDescription)shell.getDescription().getToolkit(), (CreationSupport)new AbsoluteLayoutCreationSupport());
        shell.setLayout((LayoutInfo)absoluteLayout);
        ButtonInfo button = (ButtonInfo)shell.getChildren(ButtonInfo.class).get(0);
        Rectangle bounds = button.getBounds();
        AbsoluteLayoutTest.assertSame((Object)absoluteLayout, (Object)shell.getLayout());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(3, 3, " + bounds.width + ", " + bounds.height + ");", "    }", "  }", "}");
    }

    @Test
    public void test_onSetLayout_forChild_keepAbsolute() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      inner.setBounds(10, 20, 200, 100);", "    }", "  }", "}");
        this.refresh();
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                CompositeInfo inner = (CompositeInfo)AbsoluteLayoutTest.getJavaInfoByName("inner");
                LayoutInfo rowLayout = (LayoutInfo)AbsoluteLayoutTest.createJavaInfo("org.eclipse.swt.layout.RowLayout");
                inner.setLayout(rowLayout);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Confirm").bot();
                shell.button("No, keep 'null' layout").click();
            }
        });
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      inner.setBounds(10, 20, 200, 100);", "      inner.setLayout(new RowLayout(SWT.HORIZONTAL));", "    }", "  }", "}");
    }

    @Test
    public void test_onSetLayout_forChild_useFormLayout() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      inner.setBounds(10, 20, 200, 100);", "    }", "  }", "}");
        this.refresh();
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                CompositeInfo inner = (CompositeInfo)AbsoluteLayoutTest.getJavaInfoByName("inner");
                LayoutInfo rowLayout = (LayoutInfo)AbsoluteLayoutTest.createJavaInfo("org.eclipse.swt.layout.RowLayout");
                inner.setLayout(rowLayout);
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Confirm").bot();
                shell.button("Yes, use FormLayout").click();
            }
        });
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.bottom = new FormAttachment(0, 120);", "        formData.right = new FormAttachment(0, 210);", "        formData.top = new FormAttachment(0, 20);", "        formData.left = new FormAttachment(0, 10);", "        inner.setLayoutData(formData);", "      }", "      inner.setLayout(new RowLayout(SWT.HORIZONTAL));", "    }", "  }", "}");
    }

    @Test
    public void test_delete() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "      button.setLocation(0, 0);", "      button.setLocation(new Point(0, 0));", "      button.setSize(0, 0);", "      button.setSize(new Point(0, 0));", "      button.setBounds(0, 0, 0, 0);", "      button.setBounds(new Rectangle(0, 0, 0, 0));", "    }", "  }", "}");
        AbsoluteLayoutInfo absoluteLayout = (AbsoluteLayoutInfo)shell.getLayout();
        AbsoluteLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)absoluteLayout.getAssociation());
        AbsoluteLayoutTest.assertTrue((boolean)absoluteLayout.canDelete());
        LayoutInfo rowLayout = BTestUtils.createLayout("org.eclipse.swt.layout.RowLayout");
        shell.setLayout(rowLayout);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout(SWT.HORIZONTAL));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_create() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "  }", "}");
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)shell.getLayout();
        ControlInfo button = BTestUtils.createButton();
        layout.commandCreate(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_create_withReference() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)shell.getLayout();
        ControlInfo referenceControl = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        layout.commandCreate(button, referenceControl);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "    }", "  }", "}");
    }

    private void check_changeBounds(String[] initial, String[] expected, Point location, Dimension size) throws Exception {
        Object[] initialCode = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    Button button = new Button(this, SWT.NONE);", "    button.setText(\"test\");", "  }", "}"};
        Object[] initialLines = (String[])ArrayUtils.clone((Object[])initialCode);
        int i = 0;
        while (i < initial.length) {
            if (!StringUtils.isEmpty((CharSequence)initial[i])) {
                initialLines = (String[])ArrayUtils.insert((int)(4 + i), (Object[])initialLines, (Object[])new String[]{initial[i]});
            }
            ++i;
        }
        Object[] expectedLines = (String[])ArrayUtils.clone((Object[])initialCode);
        int i2 = 0;
        while (i2 < expected.length) {
            if (!StringUtils.isEmpty((CharSequence)expected[i2])) {
                expectedLines = (String[])ArrayUtils.insert((int)(4 + i2), (Object[])expectedLines, (Object[])new String[]{expected[i2]});
            }
            ++i2;
        }
        CompositeInfo shellInfo = this.parseComposite((String[])initialLines);
        shellInfo.refresh();
        ControlInfo buttonInfo = (ControlInfo)shellInfo.getChildrenControls().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)shellInfo.getLayout();
        layoutInfo.commandChangeBounds(buttonInfo, location, size);
        this.assertEditor((String[])expectedLines);
    }

    @Test
    public void test_command_changeBounds_set_location_only() throws Exception {
        this.check_changeBounds(new String[]{""}, new String[]{"    button.setLocation(10, 10);"}, new Point(10, 10), null);
    }

    @Test
    public void test_command_changeBounds_set_size_after_location() throws Exception {
        this.check_changeBounds(new String[]{"    button.setLocation(10, 10);"}, new String[]{"    button.setSize(25, 60);", "    button.setLocation(10, 10);"}, new Point(10, 10), new Dimension(25, 60));
    }

    @Test
    public void test_command_changeBounds_set_size_only() throws Exception {
        this.check_changeBounds(new String[]{"    button.setSize(25, 60);", "    button.setLocation(20, 20);"}, new String[]{"    button.setSize(30, 100);", "    button.setLocation(20, 20);"}, null, new Dimension(30, 100));
    }

    @Test
    public void test_command_changeBounds_set_location_and_size() throws Exception {
        this.check_changeBounds(new String[]{""}, new String[]{"    button.setBounds(10, 10, 25, 70);"}, new Point(10, 10), new Dimension(25, 70));
    }

    @Test
    public void test_command_changeBounds_set_location_only_after_setBounds_set() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(10, 10, 25, 70);"}, new String[]{"    button.setBounds(30, 30, 25, 70);"}, new Point(30, 30), null);
    }

    @Test
    public void test_command_changeBounds_set_size_only_after_setBounds_set() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(30, 30, 25, 70);"}, new String[]{"    button.setBounds(30, 30, 100, 100);"}, null, new Dimension(100, 100));
    }

    @Test
    public void test_command_changeBounds_set_location_and_size_after_setBounds_set() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(30, 30, 100, 100);"}, new String[]{"    button.setBounds(10, 10, 25, 70);"}, new Point(10, 10), new Dimension(25, 70));
    }

    @Test
    public void test_command_changeBounds_set_location_only_as_Rectangle() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(new Rectangle(10, 10, 25, 80));"}, new String[]{"    button.setBounds(new Rectangle(0, 0, 25, 80));"}, new Point(0, 0), null);
    }

    @Test
    public void test_command_changeBounds_set_size_only_as_Rectangle() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(new Rectangle(0, 0, 25, 80));"}, new String[]{"    button.setBounds(new Rectangle(0, 0, 20, 60));"}, null, new Dimension(20, 60));
    }

    @Test
    public void test_command_changeBounds_set_location_and_size_as_Rectangle() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(new Rectangle(0, 0, 20, 60));"}, new String[]{"    button.setBounds(new Rectangle(10, 10, 25, 80));"}, new Point(10, 10), new Dimension(25, 80));
    }

    @Test
    public void test_command_changeBounds_set_location_only_as_Point() throws Exception {
        this.check_changeBounds(new String[]{"    button.setLocation(new Point(10, 10));"}, new String[]{"    button.setLocation(new Point(0, 0));"}, new Point(0, 0), null);
    }

    @Test
    public void test_command_changeBounds_set_size_only_as_Point() throws Exception {
        this.check_changeBounds(new String[]{"    button.setSize(new Point(20, 50));"}, new String[]{"    button.setSize(new Point(25, 40));"}, null, new Dimension(25, 40));
    }

    @Test
    public void test_command_changeBounds_setBoundsInts_removeUnused() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(10, 20, 100, 50);", "    button.setLocation(10, 20);", "    button.setSize(100, 50);", "    button.setLocation(new Point(10, 20));", "    button.setSize(new Point(100, 50));"}, new String[]{"    button.setBounds(1, 2, 25, 40);"}, new Point(1, 2), new Dimension(25, 40));
    }

    @Test
    public void test_command_changeBounds_setBoundsRectangle_removeUnused() throws Exception {
        this.check_changeBounds(new String[]{"    button.setBounds(new Rectangle(10, 20, 100, 50));", "    button.setLocation(10, 20);", "    button.setSize(100, 50);", "    button.setLocation(new Point(10, 20));", "    button.setSize(new Point(100, 50));"}, new String[]{"    button.setBounds(new Rectangle(1, 2, 25, 40));"}, new Point(1, 2), new Dimension(25, 40));
    }

    @Test
    public void test_autoSize_otherProperty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(0, 0, 10, 10);", "    }", "  }", "}");
        preferences.setValue("absoluteLayout.autoSize.onTextImage", true);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Property enabledProperty = button.getPropertyByTitle("enabled");
        enabledProperty.setValue((Object)Boolean.FALSE);
        AbsoluteLayoutTest.waitEventLoop(1);
        Rectangle bounds = button.getBounds();
        AbsoluteLayoutTest.assertEquals((int)10, (int)bounds.width);
        AbsoluteLayoutTest.assertEquals((int)10, (int)bounds.height);
    }

    @Test
    public void test_autoSize_textProperty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New');", "      button.setBounds(0, 0, 10, 10);", "    }", "  }", "}");
        preferences.setValue("absoluteLayout.autoSize.onTextImage", true);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Property textProperty = button.getPropertyByTitle("text");
        textProperty.setValue((Object)"Very long text");
        AbsoluteLayoutTest.waitEventLoop(1);
        Rectangle bounds = button.getBounds();
        AbsoluteLayoutTest.assertTrue((bounds.width > 10 ? 1 : 0) != 0);
        AbsoluteLayoutTest.assertTrue((bounds.height > 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_autoSize_imageProperty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(0, 0, 10, 10);", "    }", "  }", "}");
        preferences.setValue("absoluteLayout.autoSize.onTextImage", true);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        GenericProperty imageProperty = (GenericProperty)button.getPropertyByTitle("image");
        imageProperty.setExpression("new org.eclipse.swt.graphics.Image(null, Object.class.getClassLoader().getResourceAsStream(\"/javax/swing/plaf/basic/icons/JavaCup16.png\"))", (Object)imageProperty);
        AbsoluteLayoutTest.waitEventLoop(1);
        Rectangle bounds = button.getBounds();
        AbsoluteLayoutTest.assertTrue((bounds.width > 10 ? 1 : 0) != 0);
        AbsoluteLayoutTest.assertTrue((bounds.height > 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_autoSize_textProperty_notEnabled() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New');", "      button.setBounds(0, 0, 10, 10);", "    }", "  }", "}");
        preferences.setValue("absoluteLayout.autoSize.onTextImage", false);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Property textProperty = button.getPropertyByTitle("text");
        textProperty.setValue((Object)"Very long text");
        AbsoluteLayoutTest.waitEventLoop(1);
        Rectangle bounds = button.getBounds();
        AbsoluteLayoutTest.assertEquals((int)10, (int)bounds.width);
        AbsoluteLayoutTest.assertEquals((int)10, (int)bounds.height);
    }

    @Test
    public void test_autoSizeAction_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New');", "      button.setBounds(10, 20, 10, 10);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        Dimension buttonPrefSize = button.getPreferredSize();
        MenuManager manager = AbsoluteLayoutTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(Collections.singletonList(button), (ObjectInfo)button, (IMenuManager)manager);
        IAction autoSizeAction = AbsoluteLayoutTest.findChildAction((IContributionManager)manager, "Autosize control");
        AbsoluteLayoutTest.assertNotNull((Object)autoSizeAction);
        autoSizeAction.run();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New');", "      button.setBounds(10, 20, " + buttonPrefSize.width + ", " + buttonPrefSize.height + ");", "    }", "  }", "}");
    }

    @Test
    public void test_autoSizeAction_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    {", "      Button button = new Button(shell, SWT.NONE);", "      button.setText('New');", "      button.setBounds(10, 20, 10, 10);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        MenuManager manager = AbsoluteLayoutTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(Collections.singletonList(button), (ObjectInfo)button, (IMenuManager)manager);
        IAction autoSizeAction = AbsoluteLayoutTest.findChildAction((IContributionManager)manager, "Autosize control");
        AbsoluteLayoutTest.assertNotNull((Object)autoSizeAction);
    }

    private Property prepareBoundsProperty() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 30, 100, 200);", "    }", "  }", "}");
        shell.refresh();
        Property boundsProperty = ((ControlInfo)shell.getChildrenControls().get(0)).getPropertyByTitle("Bounds");
        return boundsProperty;
    }

    private Property getBoundsPropertySubProperty(String title) throws Exception {
        ComplexProperty boundsProperty = (ComplexProperty)this.prepareBoundsProperty();
        Property[] subProperties = boundsProperty.getProperties();
        return AbsoluteLayoutTest.getPropertyByTitle(subProperties, title);
    }

    @Test
    public void test_BoundsProperty() throws Exception {
        Property boundsProperty = this.prepareBoundsProperty();
        AbsoluteLayoutTest.assertNotNull((Object)boundsProperty);
        AbsoluteLayoutTest.assertTrue((boolean)(boundsProperty instanceof ComplexProperty));
        AbsoluteLayoutTest.assertTrue((boolean)boundsProperty.isModified());
        ComplexProperty boundsComplexProperty = (ComplexProperty)boundsProperty;
        Property[] subProperties = boundsComplexProperty.getProperties();
        AbsoluteLayoutTest.assertEquals((int)subProperties.length, (int)4);
        String actualText = AbsoluteLayoutTest.getPropertyText(boundsProperty);
        AbsoluteLayoutTest.assertEquals((Object)"(10, 30, 100, 200)", (Object)actualText);
    }

    @Test
    public void test_BoundsProperty_set_x() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("x");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(0, 30, 100, 200);", "    }", "  }", "}");
    }

    @Test
    public void test_BoundsProperty_get_x() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("x");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)10, (int)((Integer)value));
    }

    @Test
    public void test_BoundsProperty_set_y() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("y");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)5);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 5, 100, 200);", "    }", "  }", "}");
    }

    @Test
    public void test_BoundsProperty_get_y() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("y");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)30, (int)((Integer)value));
    }

    @Test
    public void test_BoundsProperty_set_width() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("width");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)150);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 30, 150, 200);", "    }", "  }", "}");
    }

    @Test
    public void test_BoundsProperty_get_width() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("width");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)100, (int)((Integer)value));
    }

    @Test
    public void test_BoundsProperty_set_height() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("height");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)220);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 30, 100, 220);", "    }", "  }", "}");
    }

    @Test
    public void test_BoundsProperty_get_height() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("height");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)200, (int)((Integer)value));
    }

    @Test
    public void test_changeBounds_CreationFlow() throws Exception {
        preferences.setValue("P_CREATION_FLOW", true);
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(5, 5, 100, 30);", "    }", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setBounds(50, 50, 100, 30);", "    }", "  }", "}");
        shell.refresh();
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)AbsoluteLayoutTest.getJavaInfoByName("button");
        layout.commandChangeBounds(button, new Point(100, 100), null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Text text = new Text(this, SWT.BORDER);", "      text.setBounds(50, 50, 100, 30);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(100, 100, 100, 30);", "    }", "  }", "}");
    }

    @Test
    public void test_clipboard() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(10, 20, 100, 50);", "      }", "    }", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)composite);
        composite = (CompositeInfo)memento.create((JavaInfo)shell);
        fillLayout.command_CREATE((ControlInfo)composite, null);
        memento.apply();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(10, 20, 100, 50);", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(10, 20, 100, 50);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_canMove() throws Exception {
        AbsoluteLayoutTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public class MyShell extends Shell {", "  private Button m_button;", "  public MyShell() {", "    setLayout(null);", "    m_button = new Button(this, SWT.NONE);", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        AbsoluteLayoutTest.waitForAutoBuild();
        CompositeInfo panel = this.parseComposite("// filler filler filler", "public class Test extends MyShell {", "  public Test() {", "  }", "}");
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)panel.getLayout());
        ControlInfo button = (ControlInfo)panel.getChildrenControls().get(0);
        AbsoluteLayoutTest.assertFalse((boolean)button.getCreationSupport().canReorder());
        AbsoluteLayoutTest.assertFalse((boolean)button.getCreationSupport().canReparent());
        AbsoluteLayoutTest.assertTrue((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        AbsoluteLayoutTest.assertFalse((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
    }
}

